(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["main"],{

/***/ 57958:
/*!*********************************************!*\
  !*** ./src/app/animations/nav-animation.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   pageAnimation: () => (/* binding */ pageAnimation)
/* harmony export */ });
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ionic/angular */ 21507);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */

const pageAnimation = (baseEL, opts) => {
  const DURATION = 300;
  const EASING = 'cubic-bezier(.3,.8,.5,1)';
  const animationCtrl = new _ionic_angular__WEBPACK_IMPORTED_MODULE_0__.AnimationController();
  if (opts.direction === 'forward') {
    const rootAnimation = animationCtrl.create().addElement(opts.enteringEl).duration(DURATION).easing(EASING).keyframes([{
      offset: 0,
      opacity: 1,
      transform: 'translateX(100%)'
    }, {
      offset: 1,
      opacity: 1,
      transform: 'translateX(0%)'
    }]);
    const leavingAnimation = animationCtrl.create().addElement(opts.leavingEl).duration(DURATION).easing(EASING).keyframes([{
      offset: 0,
      opacity: 1,
      transform: 'translateX(0%)'
    }, {
      offset: 1,
      opacity: 1,
      transform: 'translateX(-20%)'
    }]);
    return animationCtrl.create().addAnimation([rootAnimation, leavingAnimation]);
  } else {
    const rootAnimation = animationCtrl.create().addElement(opts.enteringEl).duration(DURATION).easing(EASING).keyframes([{
      offset: 0,
      opacity: 1,
      transform: 'translateX(-30%)'
    }, {
      offset: 1,
      opacity: 1,
      transform: 'translateX(0%)'
    }]);
    const leavingAnimation = animationCtrl.create().addElement(opts.leavingEl).duration(DURATION).easing(EASING).keyframes([{
      offset: 0,
      opacity: 1,
      transform: 'translateX(0%)'
    }, {
      offset: 1,
      opacity: 1,
      transform: 'translateX(100%)'
    }]);
    return animationCtrl.create().addAnimation([rootAnimation, leavingAnimation]);
  }
};

/***/ }),

/***/ 6366:
/*!**************************************************!*\
  !*** ./src/app/animations/pin-code-animation.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   enterPinCodeAnimation: () => (/* binding */ enterPinCodeAnimation),
/* harmony export */   leavePinCodeAnimation: () => (/* binding */ leavePinCodeAnimation)
/* harmony export */ });
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ionic/angular */ 21507);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */

const enterPinCodeAnimation = baseEl => {
  const modalPage = baseEl.shadowRoot;
  const animationCtrl = new _ionic_angular__WEBPACK_IMPORTED_MODULE_0__.AnimationController();
  const backdropAnimation = animationCtrl.create().addElement(modalPage.querySelector('ion-backdrop')).fromTo('opacity', '0', 'var(--backdrop-opacity)');
  const wrapperAnimation = animationCtrl.create().addElement(modalPage.querySelector('.modal-wrapper')).easing('ease-out').duration(300).keyframes([{
    offset: 0,
    opacity: '0',
    transform: 'scale(1.2)'
  }, {
    offset: 1,
    opacity: '1',
    transform: 'scale(1)'
  }]);
  return animationCtrl.create().addAnimation([wrapperAnimation]);
};
const leavePinCodeAnimation = baseEl => enterPinCodeAnimation(baseEl).direction('reverse');

/***/ }),

/***/ 94114:
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppRoutingModule: () => (/* binding */ AppRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _guards_auto_login_guard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./guards/auto-login.guard */ 32869);
/* harmony import */ var _guards_auth_guard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./guards/auth.guard */ 61620);
/* harmony import */ var _guards_pin_code_guard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./guards/pin-code.guard */ 23829);
/* harmony import */ var _guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./guards/forbidden.guard */ 55887);
/* harmony import */ var _guards_divo_guard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./guards/divo.guard */ 61377);
/* harmony import */ var _guards_divo_org_not_selected_guard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./guards/divo-org-not-selected.guard */ 39309);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */









const routes = [{
  path: '',
  redirectTo: '/login',
  pathMatch: 'full'
}, {
  path: 'login',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_login_login_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/login/login.module */ 29370)).then(m => m.LoginPageModule),
  canLoad: [_guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_3__.ForbiddenGuard, _guards_divo_org_not_selected_guard__WEBPACK_IMPORTED_MODULE_5__.DivoOrgNotSelectedGuard, _guards_auto_login_guard__WEBPACK_IMPORTED_MODULE_0__.AutoLoginGuard]
}, {
  path: 'tabs',
  children: [{
    path: '',
    loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_tabs_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/tabs/tabs.module */ 69660)).then(m => m.TabsPageModule),
    canLoad: [_guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_3__.ForbiddenGuard, _guards_divo_org_not_selected_guard__WEBPACK_IMPORTED_MODULE_5__.DivoOrgNotSelectedGuard, _guards_auth_guard__WEBPACK_IMPORTED_MODULE_1__.AuthGuard, _guards_pin_code_guard__WEBPACK_IMPORTED_MODULE_2__.PinCodeGuard],
    canActivate: []
  }]
}, {
  path: 'auth',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_auth_auth_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/auth/auth.module */ 18472)).then(m => m.AuthPageModule),
  canLoad: [_guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_3__.ForbiddenGuard, _guards_divo_org_not_selected_guard__WEBPACK_IMPORTED_MODULE_5__.DivoOrgNotSelectedGuard, _guards_auto_login_guard__WEBPACK_IMPORTED_MODULE_0__.AutoLoginGuard]
}, {
  path: 'info',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/info/info.module */ 72236)).then(m => m.InfoPageModule)
}, {
  path: 'message',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/message/message.module */ 91286)).then(m => m.MessagePageModule)
}, {
  path: 'technical-works',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/technical-works/technical-works.module */ 14494)).then(m => m.TechnicalWorksPageModule)
}, {
  path: 'update-app',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/update-app/update-app.module */ 77574)).then(m => m.UpdateAppPageModule)
}, {
  path: 'chat',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_appeals_applications-form_chat_chat_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/tabs/appeals/applications-form/chat/chat.module */ 59873)).then(m => m.ChatPageModule)
}, {
  path: 'select-org',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_select-org_select-org_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/select-org/select-org.module */ 39334)).then(m => m.SelectOrgPageModule),
  canLoad: [_guards_divo_guard__WEBPACK_IMPORTED_MODULE_4__.DivoGuard]
}];
let AppRoutingModule = class AppRoutingModule {};
AppRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterModule.forRoot(routes, {
    preloadingStrategy: _angular_router__WEBPACK_IMPORTED_MODULE_8__.PreloadAllModules
  })],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_8__.RouterModule]
})], AppRoutingModule);


/***/ }),

/***/ 20092:
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppComponent: () => (/* binding */ AppComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app.component.html?ngResource */ 61584);
/* harmony import */ var _app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app.component.scss?ngResource */ 37282);
/* harmony import */ var _app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/splash-screen/ngx */ 28293);
/* harmony import */ var _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/keyboard/ngx */ 18532);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! rxjs/operators */ 98764);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _awesome_cordova_plugins_network_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @awesome-cordova-plugins/network/ngx */ 46937);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _services_swipe_to_back_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./services/swipe-to-back.service */ 81314);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../environments/storage */ 12960);
/* harmony import */ var _services_status_bar_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./services/status-bar.service */ 48080);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./services/request.service */ 80931);
/* harmony import */ var ionic_cache__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ionic-cache */ 65503);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./services/app-theme.service */ 43017);
/* harmony import */ var _services_android_safe_area_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./services/android-safe-area.service */ 42341);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./services/helper.service */ 54102);
/* harmony import */ var _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./pages/add-code-modal/add-code-modal.page */ 10297);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../environments/connection */ 48129);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../environments/settings */ 79308);
/* harmony import */ var _services_push_service__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./services/push.service */ 62802);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
var AppComponent_1;
























let AppComponent = class AppComponent {
  static {
    AppComponent_1 = this;
  }
  static {
    this.networkConnect = new rxjs__WEBPACK_IMPORTED_MODULE_18__.BehaviorSubject(true);
  }
  constructor(platform, splashScreen, alertCtrl, statusBar, keyboard, network, request, cacheService, appTheme, helper, modalCtrl, translate, push) {
    this.platform = platform;
    this.splashScreen = splashScreen;
    this.alertCtrl = alertCtrl;
    this.statusBar = statusBar;
    this.keyboard = keyboard;
    this.network = network;
    this.request = request;
    this.cacheService = cacheService;
    this.appTheme = appTheme;
    this.helper = helper;
    this.modalCtrl = modalCtrl;
    this.translate = translate;
    this.push = push;
    this.loadingIsStarting = false;
    this.loading = {
      controller: null,
      timeout1: null,
      timeout2: null,
      timeout3: null
    };
    this.push.init();
  }
  ngOnInit() {
    var _this = this;
    document.addEventListener('handleOpenURL', data => {
      setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        const arr = data.detail.url.split('://')[1].split('/');
        if (arr[0] === 'app') {
          arr.shift();
        }
        if (arr[0] === 'account') {
          const ls = arr[1];
          if (arr[2] === 'payment' && arr[4] === 'page') {
            if (arr[5].split('?')[0] === 'success') {
              _this.helper.closeSafari().catch(err => {});
              _this.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("TEXT_STRING.SUCCESS_PAYMENT_HEADER")),
                subHeader: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("PAYMENT.LS", {
                  value: ls
                })),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("TEXT_STRING.SUCCESS_PAYMENT_TEXT")),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
              }).then(alert => alert.present());
            } else if (arr[5].split('?')[0] === 'failed') {
              _this.helper.closeSafari().catch(err => {});
              _this.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("TEXT_STRING.FAILED_PAYMENT_HEADER")),
                subHeader: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("PAYMENT.LS", {
                  value: ls
                })),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("TEXT_STRING.FAILED_PAYMENT_TEXT")),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
              }).then(/*#__PURE__*/function () {
                var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                  return alert.present();
                });
                return function (_x) {
                  return _ref2.apply(this, arguments);
                };
              }());
            }
          }
        }
      }), 0);
    });
    this.initializeApp();
  }
  initializeApp() {
    var _this2 = this;
    this.platform.ready().then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      new _services_swipe_to_back_service__WEBPACK_IMPORTED_MODULE_7__.SwipeToBackService();
      if (_this2.platform.is('android')) {
        new _services_android_safe_area_service__WEBPACK_IMPORTED_MODULE_12__.AndroidSafeAreaService();
      }
      if (_environments_settings__WEBPACK_IMPORTED_MODULE_16__.DIVO) {
        _this2.setDivoColors();
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.DIVO_SELECTED_ORG
        }).then(data => {
          try {
            const value = JSON.parse(data.value);
            if (value) {
              _this2.request.setApiUrl(value.api_url);
            } else {
              _this2.request.setApiUrl(_environments_connection__WEBPACK_IMPORTED_MODULE_15__.DIVO_ORGS_URL);
            }
          } catch (e) {
            console.error(e);
            _this2.request.setApiUrl(_environments_connection__WEBPACK_IMPORTED_MODULE_15__.DIVO_ORGS_URL);
          }
        });
      } else {
        _this2.request.setApiUrl((0,_environments_connection__WEBPACK_IMPORTED_MODULE_15__.GET_URL)());
      }
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.APPLICATION_LANG
      }).then(data => {
        if (data.value == null) {
          data.value = _this2.translate.getDefaultLang();
        }
        _this2.translate.use(data.value);
      });
      _this2.cacheService.setDefaultTTL(_environments_settings__WEBPACK_IMPORTED_MODULE_16__.CACHE_TTL);
      _this2.cacheService.setOfflineInvalidate(false);
      const splashScreenTimeout = (0,_ionic_angular__WEBPACK_IMPORTED_MODULE_20__.isPlatform)('android') ? 2000 : 200;
      if (!(0,_ionic_angular__WEBPACK_IMPORTED_MODULE_20__.isPlatform)('android')) {
        _this2.statusBar.overlaysWebView(true);
        _this2.appTheme.appThemeInit();
      }
      setTimeout(() => {
        _this2.statusBar.overlaysWebView(true);
        if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_20__.isPlatform)('android')) {
          _this2.appTheme.appThemeInit();
        }
      }, 1000);
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_PAY
      }).then(data => {
        _this2.helper.availablePayment.next(data.value === '1');
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_PAY_DATE
      }).then(data => {
        _this2.helper.availablePaymentDate.next(JSON.parse(data.value));
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_READINGS
      }).then(data => {
        _this2.helper.availableReadings.next(data.value === '1');
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_APPEALS
      }).then(data => {
        _this2.helper.availableAppeals.next(data.value === '1');
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AUTH_BY_PHONE
      }).then(data => {
        _this2.helper.authByPhone.next(data.value === '1');
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_QUALITY
      }).then(data => {
        _this2.helper.availableQuality.next(data.value === '1');
      });
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_8__.AVAILABLE_RECORDING
      }).then(data => {
        _this2.helper.availableRecording.next(data.value === '1');
      });
      setTimeout(() => {
        _this2.splashScreen.hide();
        // if (CODE_PUSH) {
        //   this.codePush.sync({
        //     updateDialog: false,
        //     installMode: InstallMode.IMMEDIATE
        //   }).subscribe({
        //     next: data => {
        //       //
        //     },
        //     error: err => {
        //       console.error('Code push error: ' + err);
        //     }
        //   })
        // }
      }, splashScreenTimeout);
      yield _this2.request.init();
      if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_20__.isPlatform)('ipad')) {
        const test = setInterval(() => {
          if (document.querySelector('ion-tabs').querySelector('ion-router-outlet')) {
            clearInterval(test);
            _this2.modalCtrl.create({
              component: _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_14__.AddCodeModalPage,
              presentingElement: document.querySelector('ion-tabs').querySelector('ion-router-outlet'),
              cssClass: 'test-modal'
            }).then(/*#__PURE__*/function () {
              var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (modal) {
                yield modal.present();
              });
              return function (_x2) {
                return _ref4.apply(this, arguments);
              };
            }());
          }
        }, 200);
      }
    }));
    this.network.onDisconnect().subscribe(() => {
      AppComponent_1.networkConnect.next(false);
    });
    this.network.onConnect().subscribe(() => {
      AppComponent_1.networkConnect.next(true);
    });
    this.keyboard.onKeyboardWillShow().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_21__.tap)(data => {
      Object.keys(document.querySelectorAll('.content-page')).map(key => {
        document.querySelectorAll('.content-page')[key].style.borderBottom = data.keyboardHeight + 'px solid transparent';
      });
    })).subscribe();
    this.keyboard.onKeyboardWillHide().pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_21__.tap)(() => {
      Object.keys(document.querySelectorAll('.content-page')).map(key => {
        document.querySelectorAll('.content-page')[key].style.borderBottom = 0 + 'px solid transparent';
      });
    })).subscribe();
  }
  setDivoColors() {
    document.body.style.cssText += '--ion-color-primary: #00A3D3';
    document.body.style.cssText += '--ion-color-primary-rgb: 0, 163, 211';
    document.body.style.cssText += '--ion-color-primary-contrast: #ffffff';
    document.body.style.cssText += '--ion-color-primary-contrast-rgb: 255, 255, 255';
    document.body.style.cssText += '--ion-color-primary-shade: #007FB5';
    document.body.style.cssText += '--ion-color-primary-tint: #39CAE4';
    document.body.style.cssText += '--ion-color-primary-lighten-1: #39CAE4';
    document.body.style.cssText += '--ion-color-primary-lighten-2: #60E5F1';
    document.body.style.cssText += '--ion-color-primary-lighten-3: #96F9FA';
    document.body.style.cssText += '--ion-color-primary-lighten-4: #CAFCF9';
    document.body.style.cssText += '--ion-color-primary-lighten-5: #D8FFFD';
    document.body.style.cssText += '--ion-color-primary-darken-1: #007FB5';
    document.body.style.cssText += '--ion-color-primary-darken-2: #005F97';
    document.body.style.cssText += '--ion-color-primary-darken-3: #00437A';
    document.body.style.cssText += '--ion-color-primary-darken-4: #003065';
  }
  getNetworkStatus() {
    return AppComponent_1.networkConnect.value;
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_22__.Platform
    }, {
      type: _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_3__.SplashScreen
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_23__.AlertController
    }, {
      type: _services_status_bar_service__WEBPACK_IMPORTED_MODULE_9__.StatusBarService
    }, {
      type: _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_4__.Keyboard
    }, {
      type: _awesome_cordova_plugins_network_ngx__WEBPACK_IMPORTED_MODULE_6__.Network
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_10__.RequestService
    }, {
      type: ionic_cache__WEBPACK_IMPORTED_MODULE_24__.CacheService
    }, {
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_11__.AppThemeService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_13__.HelperService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_23__.ModalController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_25__.TranslateService
    }, {
      type: _services_push_service__WEBPACK_IMPORTED_MODULE_17__.PushService
    }];
  }
};
AppComponent = AppComponent_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_26__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_27__.Component)({
  selector: 'app-root',
  template: _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AppComponent);


/***/ }),

/***/ 50635:
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppModule: () => (/* binding */ AppModule),
/* harmony export */   createTranslateLoader: () => (/* binding */ createTranslateLoader)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! @angular/platform-browser */ 80436);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _ionic_storage_angular__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! @ionic/storage-angular */ 26817);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _awesome_cordova_plugins_ionic_webview_ngx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @awesome-cordova-plugins/ionic-webview/ngx */ 235);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app.component */ 20092);
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app-routing.module */ 94114);
/* harmony import */ var _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/splash-screen/ngx */ 28293);
/* harmony import */ var _interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./interceptors/jwt.interceptor */ 69339);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @awesome-cordova-plugins/status-bar/ngx */ 61203);
/* harmony import */ var _awesome_cordova_plugins_screen_orientation_ngx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @awesome-cordova-plugins/screen-orientation/ngx */ 51242);
/* harmony import */ var _pages_pin_code_pin_code_module__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./pages/pin-code/pin-code.module */ 73862);
/* harmony import */ var _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @awesome-cordova-plugins/keyboard/ngx */ 18532);
/* harmony import */ var _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./pipes/pipes.module */ 41683);
/* harmony import */ var _awesome_cordova_plugins_android_full_screen_ngx__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @awesome-cordova-plugins/android-full-screen/ngx */ 70925);
/* harmony import */ var _awesome_cordova_plugins_network_ngx__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @awesome-cordova-plugins/network/ngx */ 46937);
/* harmony import */ var ionic_cache__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ionic-cache */ 65503);
/* harmony import */ var _pages_tabs_main_bind_ls_bind_ls_module__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./pages/tabs/main/bind-ls/bind-ls.module */ 45491);
/* harmony import */ var _pages_tabs_main_ls_info_ls_info_module__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./pages/tabs/main/ls-info/ls-info.module */ 47195);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! swiper/angular */ 72443);
/* harmony import */ var _pages_add_code_modal_add_code_modal_module__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./pages/add-code-modal/add-code-modal.module */ 20806);
/* harmony import */ var _pages_bio_modal_bio_modal_module__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./pages/bio-modal/bio-modal.module */ 59734);
/* harmony import */ var _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @awesome-cordova-plugins/app-version/ngx */ 24297);
/* harmony import */ var _awesome_cordova_plugins_safari_view_controller_ngx__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @awesome-cordova-plugins/safari-view-controller/ngx */ 85628);
/* harmony import */ var _pages_auth_recovery_password_recovery_password_module__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./pages/auth/recovery-password/recovery-password.module */ 22521);
/* harmony import */ var _pages_code_verification_code_verification_module__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./pages/code-verification/code-verification.module */ 50374);
/* harmony import */ var _pages_account_verified_account_verified_module__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./pages/account-verified/account-verified.module */ 96476);
/* harmony import */ var _pages_change_data_modal_change_data_modal_module__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./pages/change-data-modal/change-data-modal.module */ 33510);
/* harmony import */ var _pages_tabs_more_ls_all_modal_ls_all_modal_module__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./pages/tabs/more/ls-all-modal/ls-all-modal.module */ 88615);
/* harmony import */ var _pages_tabs_more_settings_code_modal_code_modal_module__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./pages/tabs/more/settings/code-modal/code-modal.module */ 49827);
/* harmony import */ var _animations_nav_animation__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./animations/nav-animation */ 57958);
/* harmony import */ var _pages_tabs_payment_help_help_module__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./pages/tabs/payment/help/help.module */ 93608);
/* harmony import */ var _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @awesome-cordova-plugins/in-app-browser/ngx */ 80197);
/* harmony import */ var _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @awesome-cordova-plugins/touch-id/ngx */ 76098);
/* harmony import */ var _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @awesome-cordova-plugins/native-storage/ngx */ 76558);
/* harmony import */ var _pages_tabs_payment_pay_receipt_pay_modal_pay_modal_module__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./pages/tabs/payment/pay-receipt/pay-modal/pay-modal.module */ 98916);
/* harmony import */ var _pages_info_info_module__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./pages/info/info.module */ 72236);
/* harmony import */ var _pages_message_message_module__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./pages/message/message.module */ 91286);
/* harmony import */ var _pages_technical_works_technical_works_module__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./pages/technical-works/technical-works.module */ 14494);
/* harmony import */ var _pages_update_app_update_app_module__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./pages/update-app/update-app.module */ 77574);
/* harmony import */ var _pages_tabs_appeals_applications_form_create_modal_create_modal_module__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./pages/tabs/appeals/applications-form/create-modal/create-modal.module */ 8937);
/* harmony import */ var _interceptors_error_interceptor__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./interceptors/error.interceptor */ 28036);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! @ngx-translate/http-loader */ 15101);
/* harmony import */ var _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! @awesome-cordova-plugins/fingerprint-aio/ngx */ 61649);
/* harmony import */ var _pages_choose_data_choose_data_module__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./pages/choose-data/choose-data.module */ 41930);
/* harmony import */ var _pages_tabs_appeals_surveys_surveys_module__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./pages/tabs/appeals/surveys/surveys.module */ 59466);
/* harmony import */ var _pages_tabs_appeals_appointment_appointment_module__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./pages/tabs/appeals/appointment/appointment.module */ 86966);
/* harmony import */ var _pages_tabs_more_settings_email_mailing_modal_email_mailing_modal_module__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./pages/tabs/more/settings/email-mailing-modal/email-mailing-modal.module */ 37447);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../environments/settings */ 79308);
/* harmony import */ var _swimlane_ngx_charts__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! @swimlane/ngx-charts */ 24825);
/* harmony import */ var _angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! @angular/platform-browser/animations */ 43835);
/* harmony import */ var _awesome_cordova_plugins_clipboard_ngx__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! @awesome-cordova-plugins/clipboard/ngx */ 96969);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */













































// import { CodePush } from "@awesome-cordova-plugins/code-push/ngx";













const getConfig = () => {
  let config = {
    backButtonText: 'Назад',
    mode: 'ios',
    sanitizerEnabled: true
  };
  if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_44__.isPlatform)('android')) {
    config = {
      ...config,
      // mode: 'md',
      swipeBackEnabled: false,
      navAnimation: _animations_nav_animation__WEBPACK_IMPORTED_MODULE_25__.pageAnimation
    };
  }
  return config;
};
function createTranslateLoader(httpBackend) {
  let http = new _angular_common_http__WEBPACK_IMPORTED_MODULE_45__.HttpClient(httpBackend);
  return new _ngx_translate_http_loader__WEBPACK_IMPORTED_MODULE_46__.TranslateHttpLoader(http, './assets/i18n/', '.json');
}
let AppModule = class AppModule {};
AppModule = (0,tslib__WEBPACK_IMPORTED_MODULE_47__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_48__.NgModule)({
  declarations: [_app_component__WEBPACK_IMPORTED_MODULE_1__.AppComponent],
  bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_1__.AppComponent],
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_49__.CommonModule, _angular_platform_browser__WEBPACK_IMPORTED_MODULE_50__.BrowserModule, _angular_common_http__WEBPACK_IMPORTED_MODULE_45__.HttpClientModule, ionic_cache__WEBPACK_IMPORTED_MODULE_51__.CacheModule.forRoot({
    keyPrefix: 'my-app-cache'
  }), _ionic_angular__WEBPACK_IMPORTED_MODULE_52__.IonicModule.forRoot(getConfig()), _ngx_translate_core__WEBPACK_IMPORTED_MODULE_53__.TranslateModule.forRoot({
    loader: {
      provide: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_53__.TranslateLoader,
      useFactory: createTranslateLoader,
      deps: [_angular_common_http__WEBPACK_IMPORTED_MODULE_45__.HttpBackend]
    },
    defaultLanguage: _environments_settings__WEBPACK_IMPORTED_MODULE_42__.APP_LANG_DEFAULT,
    useDefaultLang: true
  }), _app_routing_module__WEBPACK_IMPORTED_MODULE_2__.AppRoutingModule, _ionic_storage_angular__WEBPACK_IMPORTED_MODULE_54__.IonicStorageModule.forRoot(), _pages_pin_code_pin_code_module__WEBPACK_IMPORTED_MODULE_8__.PinCodePageModule, _pages_tabs_main_bind_ls_bind_ls_module__WEBPACK_IMPORTED_MODULE_13__.BindLsPageModule, _pages_tabs_main_ls_info_ls_info_module__WEBPACK_IMPORTED_MODULE_14__.LsInfoPageModule, _pages_add_code_modal_add_code_modal_module__WEBPACK_IMPORTED_MODULE_15__.AddCodeModalPageModule, _pages_bio_modal_bio_modal_module__WEBPACK_IMPORTED_MODULE_16__.BioModalPageModule, _pages_auth_recovery_password_recovery_password_module__WEBPACK_IMPORTED_MODULE_19__.RecoveryPasswordPageModule, _pages_code_verification_code_verification_module__WEBPACK_IMPORTED_MODULE_20__.CodeVerificationPageModule, _pages_account_verified_account_verified_module__WEBPACK_IMPORTED_MODULE_21__.AccountVerifiedPageModule, _pages_change_data_modal_change_data_modal_module__WEBPACK_IMPORTED_MODULE_22__.ChangeDataModalPageModule, _pages_tabs_more_ls_all_modal_ls_all_modal_module__WEBPACK_IMPORTED_MODULE_23__.LsAllModalPageModule, _pages_tabs_more_settings_code_modal_code_modal_module__WEBPACK_IMPORTED_MODULE_24__.CodeModalPageModule, _pages_tabs_more_settings_email_mailing_modal_email_mailing_modal_module__WEBPACK_IMPORTED_MODULE_41__.EmailMailingModalPageModule, _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_10__.PipesModule, swiper_angular__WEBPACK_IMPORTED_MODULE_55__.SwiperModule, _pages_tabs_payment_help_help_module__WEBPACK_IMPORTED_MODULE_26__.HelpPageModule, _pages_tabs_payment_pay_receipt_pay_modal_pay_modal_module__WEBPACK_IMPORTED_MODULE_30__.PayModalPageModule, _pages_info_info_module__WEBPACK_IMPORTED_MODULE_31__.InfoPageModule, _pages_message_message_module__WEBPACK_IMPORTED_MODULE_32__.MessagePageModule, _pages_technical_works_technical_works_module__WEBPACK_IMPORTED_MODULE_33__.TechnicalWorksPageModule, _pages_update_app_update_app_module__WEBPACK_IMPORTED_MODULE_34__.UpdateAppPageModule, _pages_tabs_appeals_applications_form_create_modal_create_modal_module__WEBPACK_IMPORTED_MODULE_35__.CreateModalPageModule, _pages_choose_data_choose_data_module__WEBPACK_IMPORTED_MODULE_38__.ChooseDataPageModule, _pages_tabs_appeals_surveys_surveys_module__WEBPACK_IMPORTED_MODULE_39__.SurveysPageModule, _pages_tabs_appeals_appointment_appointment_module__WEBPACK_IMPORTED_MODULE_40__.AppointmentPageModule, _swimlane_ngx_charts__WEBPACK_IMPORTED_MODULE_56__.NgxChartsModule],
  providers: [{
    provide: _angular_router__WEBPACK_IMPORTED_MODULE_57__.RouteReuseStrategy,
    useClass: _ionic_angular__WEBPACK_IMPORTED_MODULE_58__.IonicRouteStrategy
  }, {
    provide: _angular_common_http__WEBPACK_IMPORTED_MODULE_45__.HTTP_INTERCEPTORS,
    useClass: _interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_4__.JwtInterceptor,
    multi: true
  }, {
    provide: _angular_core__WEBPACK_IMPORTED_MODULE_48__.ErrorHandler,
    useClass: _interceptors_error_interceptor__WEBPACK_IMPORTED_MODULE_36__.ErrorInterceptor,
    multi: false
  }, _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_3__.SplashScreen, _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_5__.Device, _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_37__.FingerprintAIO, _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_28__.TouchID, _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_6__.StatusBar, _awesome_cordova_plugins_screen_orientation_ngx__WEBPACK_IMPORTED_MODULE_7__.ScreenOrientation, _awesome_cordova_plugins_ionic_webview_ngx__WEBPACK_IMPORTED_MODULE_0__.WebView, _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_9__.Keyboard, _app_component__WEBPACK_IMPORTED_MODULE_1__.AppComponent, _awesome_cordova_plugins_android_full_screen_ngx__WEBPACK_IMPORTED_MODULE_11__.AndroidFullScreen, _awesome_cordova_plugins_network_ngx__WEBPACK_IMPORTED_MODULE_12__.Network, _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_17__.AppVersion, _awesome_cordova_plugins_safari_view_controller_ngx__WEBPACK_IMPORTED_MODULE_18__.SafariViewController, _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_27__.InAppBrowser, _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_29__.NativeStorage, _awesome_cordova_plugins_clipboard_ngx__WEBPACK_IMPORTED_MODULE_43__.Clipboard, (0,_angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_59__.provideAnimations)(), (0,_angular_common_http__WEBPACK_IMPORTED_MODULE_45__.provideHttpClient)((0,_angular_common_http__WEBPACK_IMPORTED_MODULE_45__.withInterceptorsFromDi)())
  // DebugService
  // CodePush
  ]
})], AppModule);


/***/ }),

/***/ 65075:
/*!***************************************************************!*\
  !*** ./src/app/components/card-block/card-block.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CardBlockComponent: () => (/* binding */ CardBlockComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _card_block_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./card-block.component.html?ngResource */ 84469);
/* harmony import */ var _card_block_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./card-block.component.scss?ngResource */ 9109);
/* harmony import */ var _card_block_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_card_block_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);





let CardBlockComponent = class CardBlockComponent {
  constructor() {
    this.title = '';
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      title: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }]
    };
  }
};
CardBlockComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Component)({
  selector: 'app-card-block',
  template: _card_block_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_2__.ViewEncapsulation.None,
  standalone: true,
  imports: [_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule],
  styles: [(_card_block_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], CardBlockComponent);


/***/ }),

/***/ 73133:
/*!*****************************************************************!*\
  !*** ./src/app/components/custom-item/custom-item.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomItemComponent: () => (/* binding */ CustomItemComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _custom_item_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./custom-item.component.html?ngResource */ 77207);
/* harmony import */ var _custom_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./custom-item.component.scss?ngResource */ 7);
/* harmony import */ var _custom_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_custom_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);




let CustomItemComponent = class CustomItemComponent {
  constructor() {
    this.lines = 'full';
    this.disabled = false;
    this.class = 'el-anim-tap';
  }
  ngOnInit() {}
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      lines: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      class: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }]
    };
  }
};
CustomItemComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Component)({
  selector: 'app-custom-item',
  template: _custom_item_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_custom_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], CustomItemComponent);


/***/ }),

/***/ 93389:
/*!*****************************************************************************!*\
  !*** ./src/app/components/date-button-field/date-button-field.component.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DateButtonFieldComponent: () => (/* binding */ DateButtonFieldComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _date_button_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./date-button-field.component.html?ngResource */ 17719);
/* harmony import */ var _date_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./date-button-field.component.scss?ngResource */ 10407);
/* harmony import */ var _date_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_date_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ngx-translate/core */ 597);






let DateButtonFieldComponent = class DateButtonFieldComponent {
  constructor(translate) {
    this.translate = translate;
    this.presentation = 'date-time';
    this.preferWheel = false;
    this.showDefaultButtons = false;
    this.period = false;
    this.multiple = false;
    this.id = 'datetime';
    this.id += '_' + Math.round(Math.random() * 1000);
    //fixme pls
    if (this.period) {
      setTimeout(() => {
        const html = '' + '.calendar-day-wrapper {' + '   height: 32px !important;' + '}' + '.selected-date-start, .selected-date-end {' + '   background: var(--ion-color-primary) !important;' + '   color: var(--ion-color-primary-contrast) !important;' + '}' + '.selected-date-start::before {' + '   border-top-left-radius: 24px !important;' + '   border-bottom-left-radius: 24px !important;' +
        // '   background: var(--ion-color-primary) !important;' +
        '   left: 0 !important;' + '}' + '.selected-date-end::before {' + '   border-top-right-radius: 24px !important;' + '   border-bottom-right-radius: 24px !important;' +
        // '   background: var(--ion-color-primary) !important;' +
        '   right: 0 !important;' + '}';
        const el = document.createElement('style');
        el.innerHTML = html;
        this.datetime.el.shadowRoot.appendChild(el);
      }, 0);
    }
  }
  ngOnInit() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.period) {
        _this.presentation = 'date';
      }
    })();
  }
  handle(ev) {
    if (!ev.detail.value) {
      let localDate = new Date(Date.now());
      localDate.setMinutes(localDate.getMinutes() - localDate.getTimezoneOffset());
      this.value = localDate.toJSON();
    } else {
      this.value = ev.detail.value;
    }
  }
  close(state) {
    if (state) {
      this.datetime.confirm(false).then(() => {
        this.modal.dismiss(this.value);
      });
    } else {
      this.datetime.cancel(false).then(() => {
        this.datetime.reset(this.value);
        this.modal.dismiss(false);
      });
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_3__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      presentation: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      preferWheel: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      showDefaultButtons: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      period: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      multiple: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      datetime: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.ViewChild,
        args: ['datetime']
      }]
    };
  }
};
DateButtonFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-date-button-field',
  template: _date_button_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_date_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], DateButtonFieldComponent);


/***/ }),

/***/ 16929:
/*!*************************************************************************************!*\
  !*** ./src/app/components/datetime-button-field/datetime-button-field.component.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DatetimeButtonFieldComponent: () => (/* binding */ DatetimeButtonFieldComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _datetime_button_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./datetime-button-field.component.html?ngResource */ 22579);
/* harmony import */ var _datetime_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./datetime-button-field.component.scss?ngResource */ 92611);
/* harmony import */ var _datetime_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_datetime_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/helper.service */ 54102);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 75797);








let DatetimeButtonFieldComponent = class DatetimeButtonFieldComponent {
  constructor(translate, helper) {
    this.translate = translate;
    this.helper = helper;
    this.header = '';
    this.placeholder = this.translate.instant('COMPONENTS.DATETIME_BUTTON_FIELD.PLACEHOLDER_DATE_DEFAULT');
    this.presentation = 'date-time';
    this.preferWheel = false;
    this.showDefaultButtons = true;
    this.period = false;
    this.multiple = false;
    this.required = false;
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_4__.BehaviorSubject(null);
    this.id = 'datetime';
    this.openedYearMonthSelected = false;
    this.elPeriodStyling = 'background: aqua; margin: -14px 0 -14px 0; padding: 16px 0 16px 0;';
    this.highlightedItems = [];
    // protected test2 = (selectedDates: string[]) => {
    //   console.log(selectedDates)
    //   return 'qwerty';
    // }
    this.handlePeriod = isoString => {
      // const date = new Date(isoString);
      // console.log(date.toJSON());
      // console.log(this.firstDate == date)
      // console.log(date)
      // if (!this.firstDate && !this.secondDate) {
      //   this.firstDate = date;
      // } else if (
      //   !!this.firstDate &&
      //   !this.secondDate &&
      //   Math.floor(this.firstDate.getDate() - date.getDate()) != 0
      // ) {
      //   this.secondDate = date
      // }
      // if (isoString == '2024-06-04' || isoString == '2024-06-05' || isoString == '2024-06-06') {
      //   // console.log(isoString)
      //   return {
      //     backgroundColor: '#ffc0cb',
      //     borderRadius: 0
      //   };
      // }
      return undefined;
    };
    this.id += '_' + Math.round(Math.random() * 1000);
    if (this.period) {
      setTimeout(() => {
        const html = '' + '.calendar-day-wrapper {' + '   height: 32px !important;' + '}' + '.selected-date-start, .selected-date-end {' + '   background: var(--ion-color-primary) !important;' + '   color: var(--ion-color-primary-contrast) !important;' + '}' + '.selected-date-start::before {' + '   border-top-left-radius: 24px !important;' + '   border-bottom-left-radius: 24px !important;' +
        // '   background: var(--ion-color-primary) !important;' +
        '   left: 0 !important;' + '}' + '.selected-date-end::before {' + '   border-top-right-radius: 24px !important;' + '   border-bottom-right-radius: 24px !important;' +
        // '   background: var(--ion-color-primary) !important;' +
        '   right: 0 !important;' + '}';
        const el = document.createElement('style');
        el.innerHTML = html;
        this.datetime.el.shadowRoot.appendChild(el);
      }, 0);
    }
  }
  ngOnInit() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.period) {
        _this.presentation = 'date';
      }
    })();
  }
  // test(ev) {
  //   if (this.period) {
  //     const arrBefore = this.datetime.el.shadowRoot.querySelectorAll<HTMLElement>('.calendar-day-active')
  //
  //     if (this.datetime.el.classList.contains('month-year-picker-open')) {
  //       this.openedYearMonthSelected = true;
  //     } else {
  //       this.openedYearMonthSelected = false;
  //     }
  //
  //     setTimeout(async () => {
  //       const arr = this.datetime.el.shadowRoot.querySelectorAll<HTMLElement>('.calendar-day-active')
  //
  //       if (this.datetime.el.classList.contains('month-year-picker-open') || this.openedYearMonthSelected) {
  //         this.openedYearMonthSelected = true;
  //       } else {
  //         this.openedYearMonthSelected = false;
  //       }
  //
  //       if (this.openedYearMonthSelected) {
  //         console.log('this.openedYearMonthSelected', this.openedYearMonthSelected)
  //         console.log(this.value)
  //       } else {
  //         console.log(this.datetime.el, arrBefore, arr);
  //       }
  //
  //       console.log(this.value)
  //
  //       return;
  //
  //       console.log('IDSHFIHSDFKHSDKFLHSDLKFHSKL')
  //
  //       if (arr.length == 0 && arrBefore.length != arr.length) {
  //         // Убрано выделение
  //         console.log('-----------------0-----------------')
  //
  //         // if (this.datetime.el.shadowRoot.querySelectorAll('.calendar-day-active').length > 0) {
  //         this.unHighlightPeriod()
  //         // }
  //       } else if (arr.length == 1) {
  //         // Выбран один элемент
  //         console.log('-----------------1-----------------')
  //         console.log(this.firstDateEl, arr[0])
  //         this.firstDateEl = {
  //           year: arr[0].dataset.year,
  //           month: arr[0].dataset.month,
  //           day: arr[0].dataset.day
  //         };
  //
  //         // if (this.datetime.el.shadowRoot.querySelectorAll('.selected-date').length > 0) {
  //         this.unHighlightPeriod()
  //         // }
  //       } else if (arr.length == 2) {
  //         // Выбрано два элемента
  //         console.log('-----------------2-----------------')
  //
  //         console.log(arr[0])
  //         console.log(arr[1])
  //         if (
  //           this.firstDateEl.year != arr[0].dataset.year &&
  //           this.firstDateEl.month != arr[0].dataset.month &&
  //           this.firstDateEl.day != arr[0].dataset.day
  //         ) {
  //           this.secondDateEl = this.firstDateEl;
  //           this.firstDateEl = {
  //             year: arr[0].dataset.year,
  //             month: arr[0].dataset.month,
  //             day: arr[0].dataset.day
  //           };
  //         } else {
  //           this.secondDateEl = {
  //             year: arr[1].dataset.year,
  //             month: arr[1].dataset.month,
  //             day: arr[1].dataset.day
  //           };
  //         }
  //
  //         console.log(this.firstDateEl)
  //         console.log(this.secondDateEl)
  //
  //         setTimeout(() => {
  //           console.log(this.firstDateEl)
  //           console.log(this.secondDateEl)
  //         }, 1000)
  //
  //         this.highlightPeriod()
  //       } else {
  //         // Выбран третий элемент - сбрасываем выделение и начинаем заново с этого
  //         console.log('-----------------3-----------------')
  //         let selectEl: HTMLElement
  //
  //         if (arr.length > arrBefore.length) {
  //           // Выбрана дата извне
  //           // @ts-ignore
  //           selectEl = [...arr].filter(x => ![...arrBefore].includes(x))[0];
  //           console.log(selectEl)
  //         } else if (arr.length < arrBefore.length) {
  //           // Выбрана дата внутри
  //           // @ts-ignore
  //           selectEl = [...arrBefore].filter(x => ![...arr].includes(x))[0];
  //           console.log(selectEl)
  //         } else {
  //           // await this.datetime.reset()
  //           return;
  //         }
  //
  //         const date = selectEl.dataset.year+'-'+
  //           this.helper.numberFormatted(selectEl.dataset.month, 'dd')+'-'+
  //           this.helper.numberFormatted(selectEl.dataset.day, 'dd')
  //
  //         this.unHighlightPeriod(date)
  //
  //         // this.unHighlightPeriod()
  //         // selectEl.click()
  //         // await this.datetime.reset().then(selectEl.click())
  //         // this.firstDateEl = null;
  //         // this.secondDateEl = null;
  //         // this.firstDate = null;
  //         // this.secondDate = null;
  //       }
  //
  //
  //     }, 50)
  //   }
  // }
  // highlightPeriod() {
  //   return ;
  //   const arrAll = this.datetime.el.shadowRoot.querySelectorAll('.calendar-day')
  //
  //   // this.firstDateEl.classList.add('selected-date-start');
  //   // this.secondDateEl.classList.add('selected-date-end');
  //
  //   // this.helper.numberFormatted(this.firstDateEl.dataset.month, 'dd')
  //   const yearStart = +this.firstDateEl.year
  //   const yearEnd = +this.secondDateEl.year
  //   const monthStart = +this.firstDateEl.month
  //   const monthEnd = +this.secondDateEl.month
  //   const dayStart = +this.firstDateEl.day
  //   const dayEnd = +this.secondDateEl.day
  //
  //   let arrSelected: string[] = [];
  //
  //   for (let year = yearStart; year <= yearEnd; year++) {
  //     for (let month = monthStart; month <= monthEnd; month++) {
  //       for (let day = 1; day <= 31; day++) {
  //
  //         const date = year+'-'+this.helper.numberFormatted(month, 'dd')+'-'+this.helper.numberFormatted(day, 'dd')
  //
  //         if ( // в разных месяцах
  //           (yearStart !== yearEnd) ||
  //           (monthStart !== monthEnd)
  //         ) {
  //           console.log('в разных месяцах', year, month)
  //           if ( // первый месяц
  //             (year === yearStart && month === monthStart) &&
  //             (year !== yearEnd || month !== monthEnd)
  //           ) {
  //             if (day >= dayStart) {
  //               console.log('первый месяц', date)
  //               arrSelected.push(date)
  //             }
  //           } else if ( // последний месяц
  //             (year !== yearStart || month !== monthStart) &&
  //             (year === yearEnd && month === monthEnd)
  //           ) {
  //             if (day <= dayEnd) {
  //               console.log('последний месяц', date)
  //               arrSelected.push(date)
  //             }
  //           } else {
  //             console.log('---else---', date)
  //             console.log(
  //               (year !== yearStart || month !== monthStart),
  //               (year === yearEnd && month === monthEnd),
  //               year === yearEnd,
  //               month === monthEnd,
  //               year,
  //               yearEnd,
  //               month,
  //               monthEnd
  //             )
  //             arrSelected.push(date)
  //           }
  //         } else { // в одном месяце
  //           if (day >= dayStart && day <= dayEnd) {
  //             arrSelected.push(date)
  //           }
  //         }
  //       }
  //     }
  //   }
  //
  //   console.log(arrSelected)
  //
  //   this.value = arrSelected
  //
  //   const html = '' +
  //     '.calendar-day-active {' +
  //     '   background: none !important;' +
  //     '}' +
  //     '.calendar-day-active::before, .selected-date-start::after, .selected-date-end::after {' +
  //     '   content: "";' +
  //     '}'
  //
  //   const el = document.createElement('style')
  //
  //   el.innerHTML = html
  //
  //   this.datetime.el.shadowRoot.appendChild(el)
  //
  // }
  //
  // unHighlightPeriod(val?: string) {
  //   return ;
  //   console.log('unHighlightPeriod')
  //   // const arrAll = this.highlightedItems
  //
  //   const styleTags = this.datetime.el.shadowRoot.querySelectorAll('style');
  //
  //   if (styleTags.length > 3) {
  //     this.datetime.el.shadowRoot.removeChild(styleTags[styleTags.length-1])
  //
  //     // this.firstDateEl.classList.remove('selected-date-start');
  //     // this.secondDateEl.classList.remove('selected-date-end');
  //
  //     // if (val) {
  //       this.value = [val]
  //     // } else {
  //     //   this.value = []
  //     // }
  //   }
  // }
  handle(ev) {
    if (!ev.detail.value) {
      let localDate = new Date(Date.now());
      localDate.setMinutes(localDate.getMinutes() - localDate.getTimezoneOffset());
      this.value.next(localDate.toJSON());
    } else {
      this.value.next(ev.detail.value);
    }
  }
  close(state) {
    if (state) {
      this.datetime.confirm(false).then(() => {
        setTimeout(() => {
          this.modal.dismiss();
        }, 200);
      });
    } else {
      this.datetime.cancel(false).then(() => {
        setTimeout(() => {
          this.modal.dismiss().then(() => {
            this.datetime.reset(this.value.value);
          });
        }, 200);
      });
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__.TranslateService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      presentation: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      preferWheel: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      showDefaultButtons: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      period: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      multiple: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      datetime: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: ['datetime']
      }],
      modal: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: ['modal']
      }]
    };
  }
};
DatetimeButtonFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-datetime-button-field',
  template: _datetime_button_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_datetime_button_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], DatetimeButtonFieldComponent);


/***/ }),

/***/ 78665:
/*!***************************************************************!*\
  !*** ./src/app/components/file-field/file-field.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileFieldComponent: () => (/* binding */ FileFieldComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _file_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./file-field.component.html?ngResource */ 2267);
/* harmony import */ var _file_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./file-field.component.scss?ngResource */ 93415);
/* harmony import */ var _file_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_file_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../environments/settings */ 79308);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/camera/ngx */ 68782);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/helper.service */ 54102);











let FileFieldComponent = class FileFieldComponent {
  constructor(alertCtrl, actionSheetCtrl, translate, camera, helper) {
    this.alertCtrl = alertCtrl;
    this.actionSheetCtrl = actionSheetCtrl;
    this.translate = translate;
    this.camera = camera;
    this.helper = helper;
    this.placeholder = '';
    this.required = false;
    this.disabled = false;
    this.iconLeft = '/assets/icons/File.svg';
    this.iconRight = '/assets/icons/Chevron_Right.svg';
    this.loading = false;
    this.allowedExtFiles = [..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_IMG.name, ..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_FILE.name].map(item => "." + item).join(",");
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_6__.BehaviorSubject(null);
    this.validate = value => true;
  }
  ngOnInit() {}
  openAddFile() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!(0,_ionic_angular__WEBPACK_IMPORTED_MODULE_7__.isPlatform)("android")) {
        _this.inputFile.nativeElement.click();
      } else {
        _this.actionSheetCtrl.create({
          buttons: [{
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.CAMERA")),
            icon: "camera",
            handler: () => {
              _this.camera.getPicture({
                quality: 20,
                destinationType: _this.camera.DestinationType.DATA_URL,
                encodingType: _this.camera.EncodingType.PNG,
                mediaType: _this.camera.MediaType.PICTURE,
                sourceType: _this.camera.PictureSourceType.CAMERA
              }).then(data => {
                _this.value.next({
                  name: "ph_" + Math.round(Math.random() * 1000) + ".png",
                  mimeType: "image/png",
                  size: data.length / 4 * 3,
                  base64: "data:image/png;base64," + data,
                  preview: "img"
                });
              }).catch(err => {});
            }
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.IMAGE")),
            icon: "images",
            handler: () => _this.inputImage.nativeElement.click()
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.FILE")),
            icon: "document",
            handler: () => _this.inputFile.nativeElement.click()
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this.translate.get("BUTTONS.CANCEL")),
            role: "cancel"
          }]
        }).then(actionSheet => {
          actionSheet.present();
        });
      }
    })();
  }
  fileEvent(ev) {
    var _this2 = this;
    const files = ev.target.files;
    const reader = new FileReader();
    reader.onerror = /*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_HEADER")),
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_GET_FILE")),
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
      }).then(/*#__PURE__*/function () {
        var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
          yield alert.present();
        });
        return function (_x) {
          return _ref2.apply(this, arguments);
        };
      }());
    });
    reader.onloadend = /*#__PURE__*/function () {
      var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (evt) {
        let fileMimeType = null;
        let fileSize = 0;
        let fileBase64 = "";
        fileBase64 = evt.target["result"];
        if (typeof fileBase64 === "string") {
          fileMimeType = fileBase64.split(";")[0].split(":")[1];
        }
        if (fileMimeType == null || fileBase64 == "") {
          _this2.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.FILE_IS_BROKEN")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
          }).then(/*#__PURE__*/function () {
            var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
              yield alert.present();
            });
            return function (_x3) {
              return _ref4.apply(this, arguments);
            };
          }());
        } else if ([..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_IMG.value, ..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_FILE.value].indexOf(fileMimeType) < 0) {
          _this2.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.MIME_TYPE_FILE_FAIL"))) + "\n" + (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.MIME_TYPE_FILE"))) + [..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_IMG.name, ..._environments_settings__WEBPACK_IMPORTED_MODULE_3__.ALLOWED_EXTENSIONS_FILE.name].join(", "),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
          }).then(/*#__PURE__*/function () {
            var _ref5 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
              yield alert.present();
            });
            return function (_x4) {
              return _ref5.apply(this, arguments);
            };
          }());
        } else {
          fileSize = files[0].size;
          if (fileSize > _environments_settings__WEBPACK_IMPORTED_MODULE_3__.MAX_FILE_SIZE_UPLOAD) {
            _this2.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.MAX_FILESIZE_FAIL", {
                value: _environments_settings__WEBPACK_IMPORTED_MODULE_3__.MAX_FILE_SIZE_UPLOAD / 1024 / 1024 + "Mb"
              })),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
            }).then(/*#__PURE__*/function () {
              var _ref6 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                yield alert.present();
              });
              return function (_x5) {
                return _ref6.apply(this, arguments);
              };
            }());
          } else {
            _this2.value.next({
              name: files[0].name,
              mimeType: fileMimeType,
              size: fileSize,
              base64: fileBase64,
              preview: "img"
            });
          }
        }
        _this2.inputFile.nativeElement.value = "";
        _this2.inputImage.nativeElement.value = "";
      });
      return function (_x2) {
        return _ref3.apply(this, arguments);
      };
    }();
    reader.readAsDataURL(files[0]);
  }
  removeFile(ev) {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.alertCtrl.create({
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this3.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILE_REMOVE")),
        buttons: [{
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this3.translate.get("BUTTONS.NO")),
          role: "cancel",
          handler: () => {
            ev.target.closest('ion-list').closeSlidingItems();
          }
        }, {
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this3.translate.get("BUTTONS.YES")),
          handler: () => {
            _this3.value.next(null);
            ev.target.closest('ion-list').closeSlidingItems();
          }
        }]
      }).then(alert => {
        alert.present();
      });
      ev.stopPropagation();
    })();
  }
  previewError() {
    const val = this.value.value;
    val.preview = "file";
    this.value.next(val);
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.AlertController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.ActionSheetController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__.TranslateService
    }, {
      type: _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_4__.Camera
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_5__.HelperService
    }];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      iconLeft: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      iconRight: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      loading: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      allowedExtFiles: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      validate: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['input', {
          static: true
        }]
      }],
      inputFile: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['inputFile', {
          static: true
        }]
      }],
      inputImage: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['inputImage', {
          static: true
        }]
      }],
      option: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['option', {
          static: true
        }]
      }]
    };
  }
};
FileFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-file-field',
  template: _file_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_file_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], FileFieldComponent);


/***/ }),

/***/ 44529:
/*!*****************************************************************!*\
  !*** ./src/app/components/input-field/input-field.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InputFieldComponent: () => (/* binding */ InputFieldComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _input_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./input-field.component.html?ngResource */ 57315);
/* harmony import */ var _input_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./input-field.component.scss?ngResource */ 45139);
/* harmony import */ var _input_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_input_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _maskito_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @maskito/core */ 76746);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var _maskito_kit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @maskito/kit */ 45869);








let InputFieldComponent = class InputFieldComponent {
  constructor() {
    this.header = '';
    this.placeholder = '';
    this.errorText = ' ';
    this.type = 'text';
    this.required = false;
    this.disabled = false;
    this.handlerInput = () => {};
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject(null);
    this.parseNum = false;
    this.validate = value => true;
    this.maskPredicate = /*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (el) {
        if ((yield el.getInputElement()).type == 'email') {
          return el;
        } else {
          return el.getInputElement();
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
  }
  ngOnInit() {
    if (!!this.initValue && !this.value.value) {
      this.value.next((0,_maskito_core__WEBPACK_IMPORTED_MODULE_3__.maskitoTransform)(this.initValue, this.maskitoOptions));
      this.setValue({
        detail: {
          value: this.value.value
        }
      });
    }
  }
  setValue(ev) {
    if (this.parseNum) {
      this.value.next((0,_maskito_kit__WEBPACK_IMPORTED_MODULE_4__.maskitoParseNumber)(ev.detail.value, ',').toString());
    } else {
      this.value.next(ev.detail.value.toString());
    }
  }
  validateHandler() {
    this.validate(this.value.value) && this.requiredIsValid() ? this.markAsValid() : this.markAsInvalid();
  }
  requiredIsValid() {
    return this.required && !!this.value.value || !this.required;
  }
  markAsInvalid() {
    setTimeout(() => {
      this.input.el.classList.remove('ion-valid');
      this.input.el.classList.add('ion-invalid');
    }, 0);
  }
  markAsValid() {
    setTimeout(() => {
      this.input.el.classList.remove('ion-invalid');
      this.input.el.classList.add('ion-valid');
    }, 0);
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      errorText: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      type: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      maskitoOptions: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      handlerInput: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      initValue: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      parseNum: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      validate: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: ['input', {
          static: false
        }]
      }]
    };
  }
};
InputFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: "app-input-field",
  template: _input_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_input_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], InputFieldComponent);


/***/ }),

/***/ 23853:
/*!*************************************************************!*\
  !*** ./src/app/components/menu-item/menu-item.component.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MenuItemComponent: () => (/* binding */ MenuItemComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _menu_item_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./menu-item.component.html?ngResource */ 42711);
/* harmony import */ var _menu_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./menu-item.component.scss?ngResource */ 65487);
/* harmony import */ var _menu_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_menu_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);






let MenuItemComponent = class MenuItemComponent {
  constructor() {
    this.title = '';
    this.description = '';
    this.value = '';
    this.icon = 'Chevron_Right';
    this.anim = true;
    this.color = null;
    this.disabled = false;
  }
  ngOnInit() {}
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      title: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      description: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      icon: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      anim: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      color: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_2__.Input
      }]
    };
  }
};
MenuItemComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Component)({
  selector: 'app-menu-item',
  template: _menu_item_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  standalone: true,
  imports: [_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicModule, _angular_common__WEBPACK_IMPORTED_MODULE_5__.NgClass],
  styles: [(_menu_item_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], MenuItemComponent);


/***/ }),

/***/ 66433:
/*!*******************************************************************!*\
  !*** ./src/app/components/select-field/select-field.component.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectFieldComponent: () => (/* binding */ SelectFieldComponent)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _select_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./select-field.component.html?ngResource */ 20211);
/* harmony import */ var _select_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./select-field.component.scss?ngResource */ 62843);
/* harmony import */ var _select_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_select_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var _pages_tabs_appeals_applications_form_create_modal_select_modal_select_modal_page_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../pages/tabs/appeals/applications-form/create-modal/select-modal/select-modal-page.component */ 20629);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/modal.service */ 5455);








let SelectFieldComponent = class SelectFieldComponent {
  constructor(modalService) {
    this.modalService = modalService;
    this.placeholder = '';
    this.multiply = false;
    this.multiplyCount = null;
    this.customItem = false;
    this.customValue = '';
    this.required = true;
    this.disabled = false;
    this.iconLeft = null;
    this.iconRight = '/assets/icons/Chevron_Right.svg';
    this.loading = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject(false);
    this.modalTitle = '';
    this.items = null;
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject(null);
    this.validate = () => true;
  }
  ngOnInit() {}
  openSelect() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this.loading.value) {
        _this.modalService.openModal({
          component: _pages_tabs_appeals_applications_form_create_modal_select_modal_select_modal_page_component__WEBPACK_IMPORTED_MODULE_3__.SelectModalPage,
          presentingElement: yield _this.modalService.modalCtrl.getTop(),
          type: "card",
          canDismiss: true,
          componentProps: {
            title: _this.modalTitle,
            required: _this.required,
            multiply: _this.multiply,
            multiplyCount: _this.multiplyCount,
            customItem: _this.customItem,
            customValue: _this.customValue,
            customCheckbox: !!_this.customValue,
            items: _this.items,
            displayField: _this.displayField,
            loading: _this.loading,
            value: _this.value.value
          }
        }).then(modal => {
          modal.onWillDismiss().then(data => {
            if (data.data || data.data === null) {
              _this.value.next(data.data);
              if (data.data !== null) {
                _this.customValue = data.data.customValue ?? '';
              }
            }
          });
        });
      }
    })();
  }
  validateHandler() {
    this.validate() ? this.markAsValid() : this.markAsInvalid();
  }
  markAsInvalid() {
    setTimeout(() => {
      this.input.el.classList.remove('ion-valid');
      this.input.el.classList.add('ion-invalid');
    }, 0);
  }
  markAsValid() {
    setTimeout(() => {
      this.input.el.classList.remove('ion-invalid');
      this.input.el.classList.add('ion-valid');
    }, 0);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      multiply: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      multiplyCount: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      customItem: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      customValue: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      iconLeft: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      iconRight: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      loading: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      modalTitle: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      displayField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      items: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      validate: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: ['input', {
          static: true
        }]
      }]
    };
  }
};
SelectFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-select-field',
  template: _select_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_select_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SelectFieldComponent);


/***/ }),

/***/ 10035:
/*!***************************************************************!*\
  !*** ./src/app/components/text-field/text-field.component.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextFieldComponent: () => (/* binding */ TextFieldComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _text_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./text-field.component.html?ngResource */ 93565);
/* harmony import */ var _text_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text-field.component.scss?ngResource */ 51785);
/* harmony import */ var _text_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_text_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 75797);





let TextFieldComponent = class TextFieldComponent {
  constructor() {
    this.header = '';
    this.placeholder = '';
    this.errorText = ' ';
    this.required = false;
    this.disabled = false;
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject('');
    this.validate = value => true;
  }
  ngOnInit() {
    if (!!this.initValue && !this.value) {
      this.value.next(this.initValue);
    }
  }
  setValue(ev) {
    this.value.next(ev.detail.value.toString());
  }
  validateHandler() {
    this.validate(this.value.value) && this.requiredIsValid() ? this.markAsValid() : this.markAsInvalid();
  }
  requiredIsValid() {
    return this.required && !!this.value || !this.required;
  }
  markAsInvalid() {
    setTimeout(() => {
      this.textarea.el.classList.remove('ion-valid');
      this.textarea.el.classList.add('ion-invalid');
    }, 0);
  }
  markAsValid() {
    setTimeout(() => {
      this.textarea.el.classList.remove('ion-invalid');
      this.textarea.el.classList.add('ion-valid');
    }, 0);
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      errorText: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      initValue: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      validate: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      textarea: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.ViewChild,
        args: ['textarea', {
          static: true
        }]
      }]
    };
  }
};
TextFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Component)({
  selector: "app-text-field",
  template: _text_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_text_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], TextFieldComponent);


/***/ }),

/***/ 32413:
/*!*******************************************************************!*\
  !*** ./src/app/components/toggle-field/toggle-field.component.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToggleFieldComponent: () => (/* binding */ ToggleFieldComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _toggle_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./toggle-field.component.html?ngResource */ 78247);
/* harmony import */ var _toggle_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./toggle-field.component.scss?ngResource */ 2139);
/* harmony import */ var _toggle_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_toggle_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 75797);





let ToggleFieldComponent = class ToggleFieldComponent {
  constructor() {
    this.header = '';
    this.placeholder = '';
    this.required = false;
    this.disabled = false;
    this.value = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject(false);
  }
  ngOnInit() {}
  validateHandler() {
    // todo
    // this.requiredIsValid() ? this.markAsValid() : this.markAsInvalid()
  }
  requiredIsValid() {
    return this.required && !!this.value.value || !this.required;
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      placeholder: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      disabled: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      item: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.ViewChild,
        args: ['item', {
          static: true
        }]
      }]
    };
  }
};
ToggleFieldComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Component)({
  selector: 'app-toggle-field',
  template: _toggle_field_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_toggle_field_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], ToggleFieldComponent);


/***/ }),

/***/ 61620:
/*!**************************************!*\
  !*** ./src/app/guards/auth.guard.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthGuard: () => (/* binding */ AuthGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/authentication.service */ 9214);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */





let AuthGuard = class AuthGuard {
  constructor(authService, router) {
    this.authService = authService;
    this.router = router;
  }
  canLoad() {
    return _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__.isAuth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_1__.filter)(val => val !== null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(isAuth => {
      if (isAuth) {
        return true;
      } else {
        this.router.navigateByUrl('/login').then(() => {});
        return false;
      }
    }));
  }
  static {
    this.ctorParameters = () => [{
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__.AuthenticationService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_3__.Router
    }];
  }
};
AuthGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], AuthGuard);


/***/ }),

/***/ 32869:
/*!********************************************!*\
  !*** ./src/app/guards/auto-login.guard.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutoLoginGuard: () => (/* binding */ AutoLoginGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/authentication.service */ 9214);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs/operators */ 70271);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */





let AutoLoginGuard = class AutoLoginGuard {
  constructor(authService, router) {
    this.authService = authService;
    this.router = router;
  }
  canLoad() {
    return _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__.isAuth.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_1__.filter)(val => val !== null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_2__.map)(isAuth => {
      if (isAuth) {
        this.router.navigateByUrl('/tabs/main', {
          replaceUrl: true
        }).then(() => {});
      } else {
        return true;
      }
    }));
  }
  static {
    this.ctorParameters = () => [{
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__.AuthenticationService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_3__.Router
    }];
  }
};
AutoLoginGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], AutoLoginGuard);


/***/ }),

/***/ 39309:
/*!*******************************************************!*\
  !*** ./src/app/guards/divo-org-not-selected.guard.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DivoOrgNotSelectedGuard: () => (/* binding */ DivoOrgNotSelectedGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/settings */ 79308);






let DivoOrgNotSelectedGuard = class DivoOrgNotSelectedGuard {
  constructor(router) {
    this.router = router;
  }
  canLoad() {
    if (!_environments_settings__WEBPACK_IMPORTED_MODULE_2__.DIVO) return new Promise(resolve => resolve(true)).then(() => true);
    return _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.DIVO_SELECTED_ORG
    }).then(data => {
      if (data.value) {
        return true;
      } else {
        this.router.navigateByUrl('/select-org', {
          replaceUrl: true
        }).then(() => {});
      }
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_router__WEBPACK_IMPORTED_MODULE_3__.Router
    }];
  }
};
DivoOrgNotSelectedGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], DivoOrgNotSelectedGuard);


/***/ }),

/***/ 61377:
/*!**************************************!*\
  !*** ./src/app/guards/divo.guard.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DivoGuard: () => (/* binding */ DivoGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../environments/settings */ 79308);




let DivoGuard = class DivoGuard {
  constructor(router) {
    this.router = router;
  }
  canLoad(route) {
    if (_environments_settings__WEBPACK_IMPORTED_MODULE_0__.DIVO) {
      return true;
    } else {
      this.router.navigateByUrl('/tabs/main', {
        replaceUrl: true
      }).then(() => {});
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_router__WEBPACK_IMPORTED_MODULE_1__.Router
    }];
  }
};
DivoGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
  providedIn: 'root'
})], DivoGuard);


/***/ }),

/***/ 55887:
/*!*******************************************!*\
  !*** ./src/app/guards/forbidden.guard.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ForbiddenGuard: () => (/* binding */ ForbiddenGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../services/modal.service */ 5455);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/helper.service */ 54102);
/* harmony import */ var _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/app-version/ngx */ 24297);
/* harmony import */ var _services_app_init_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/app-init.service */ 32310);









let ForbiddenGuard = class ForbiddenGuard {
  constructor(modalService, navCtrl, helper, appInit, appVersion, platform) {
    this.modalService = modalService;
    this.navCtrl = navCtrl;
    this.helper = helper;
    this.appInit = appInit;
    this.appVersion = appVersion;
    this.platform = platform;
  }
  canLoad() {
    return _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_TECHNICAL_WORKS
    }).then(data => {
      if (data.value) {
        this.navCtrl.navigateRoot('/technical-works').catch(() => {});
        this.appInit.sendAppInit(_environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_TECHNICAL_WORKS);
        return new Promise(resolve => resolve(false)).then(() => false);
      } else {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP
        }).then(data2 => {
          if (data2.value) {
            this.platform.ready().then(() => {
              this.appVersion.getVersionNumber().then(appVersion => {
                if (this.helper.checkNeedToUpdate(appVersion, JSON.parse(data2.value).appVersion)) {
                  this.helper.needToUpdate.next(true);
                  this.navCtrl.navigateRoot('/update-app', {
                    queryParams: {
                      params: data2.value
                    }
                  }).catch(() => {});
                  this.appInit.sendAppInit(_environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP);
                  return new Promise(resolve => resolve(false)).then(() => false);
                } else {
                  this.appInit.sendAppInit(_environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP);
                  _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.remove({
                    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP
                  });
                  return new Promise(resolve => resolve(true)).then(() => true);
                }
              }).catch(err => {
                console.error(err);
                this.appInit.sendAppInit();
                return new Promise(resolve => resolve(true)).then(() => true);
              });
            }).catch(() => {
              this.appInit.sendAppInit();
              return new Promise(resolve => resolve(true)).then(() => true);
            });
          } else {
            _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.get({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE
            }).then(data => {
              if (data.value) {
                this.navCtrl.navigateRoot('/message', {
                  queryParams: {
                    params: data.value
                  }
                }).catch(() => {});
                this.appInit.sendAppInit(_environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE);
                return new Promise(resolve => resolve(false)).then(() => false);
              } else {
                this.appInit.sendAppInit();
                return new Promise(resolve => resolve(true)).then(() => true);
              }
            });
          }
        });
      }
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_2__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.NavController
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }, {
      type: _services_app_init_service__WEBPACK_IMPORTED_MODULE_5__.AppInitService
    }, {
      type: _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_4__.AppVersion
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.Platform
    }];
  }
};
ForbiddenGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Injectable)({
  providedIn: 'root'
})], ForbiddenGuard);


/***/ }),

/***/ 23829:
/*!******************************************!*\
  !*** ./src/app/guards/pin-code.guard.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PinCodeGuard: () => (/* binding */ PinCodeGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/authentication.service */ 9214);
/* harmony import */ var _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/in-app-auth.service */ 70604);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _capacitor_app__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @capacitor/app */ 59326);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */






let PinCodeGuard = class PinCodeGuard {
  constructor(authService, iaas, platform) {
    this.authService = authService;
    this.iaas = iaas;
    this.platform = platform;
    this.platformPause$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.signal)(false);
  }
  canLoad() {
    this.platform.ready().then(() => {
      this.platform.pause.subscribe(val => {
        this.platformPause$.set(true);
      });
      _capacitor_app__WEBPACK_IMPORTED_MODULE_2__.App.addListener('appStateChange', appState => {
        if (!appState.isActive && this.iaas.isPin.value && this.iaas.pinInst.value && this.platformPause$()) {
          this.iaas.isPin.next(false);
          this.iaas.presentModal().then(result => {
            result.onDidDismiss().then(value => {
              if (value.data) {
                this.iaas.isPin.next(value.data);
              }
            });
          });
        } else if (appState.isActive) {
          this.platformPause$.set(false);
        }
      });
    });
    if (this.iaas.isPin.value) {
      return new Promise(resolve => resolve(true)).then(() => true);
    } else {
      return this.iaas.auth().then(_ => _).catch(() => false);
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_0__.AuthenticationService
    }, {
      type: _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_1__.InAppAuthService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.Platform
    }];
  }
};
PinCodeGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
  providedIn: 'root'
})], PinCodeGuard);


/***/ }),

/***/ 28036:
/*!***************************************************!*\
  !*** ./src/app/interceptors/error.interceptor.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ErrorInterceptor: () => (/* binding */ ErrorInterceptor)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */


let ErrorInterceptor = class ErrorInterceptor {
  constructor() {}
  handleError(error) {
    let err = new Error(error);
    if (err.message.indexOf('cordova_not_available') != -1) {
      console.warn('[cordova_not_available]: Работа плагинов не поддерживается в браузере');
    } else {
      console.error(error);
    }
    return error;
  }
  static {
    this.ctorParameters = () => [];
  }
};
ErrorInterceptor = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable)()], ErrorInterceptor);


/***/ }),

/***/ 69339:
/*!*************************************************!*\
  !*** ./src/app/interceptors/jwt.interceptor.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BACKGROUND: () => (/* binding */ BACKGROUND),
/* harmony export */   JwtInterceptor: () => (/* binding */ JwtInterceptor),
/* harmony export */   UPDATE_TOKEN: () => (/* binding */ UPDATE_TOKEN)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 77919);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../services/authentication.service */ 9214);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ 36647);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../animations/pin-code-animation */ 6366);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../services/modal.service */ 5455);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _services_app_init_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../services/app-init.service */ 32310);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../services/request.service */ 80931);
/* harmony import */ var _pages_technical_works_technical_works_page__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../pages/technical-works/technical-works.page */ 5601);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_token_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../services/token.service */ 2091);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _services_http_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../services/http.service */ 56722);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../environments/connection */ 48129);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../services/debug.service */ 33925);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
var JwtInterceptor_1;




















const BACKGROUND = new _angular_common_http__WEBPACK_IMPORTED_MODULE_14__.HttpContextToken(() => false);
const UPDATE_TOKEN = new _angular_common_http__WEBPACK_IMPORTED_MODULE_14__.HttpContextToken(() => false);
let JwtInterceptor = class JwtInterceptor {
  static {
    JwtInterceptor_1 = this;
  }
  constructor(authService, toastCtrl, alertCtrl, modalService, appInit, request, translate, device, http, debug) {
    this.authService = authService;
    this.toastCtrl = toastCtrl;
    this.alertCtrl = alertCtrl;
    this.modalService = modalService;
    this.appInit = appInit;
    this.request = request;
    this.translate = translate;
    this.device = device;
    this.http = http;
    this.debug = debug;
    this.isRefreshingToken = false;
  }
  static isInBlockedList(url) {
    // API адреса, в которые не нужно добавлять заголовок с токеном
    const apiUrl = (0,_environments_connection__WEBPACK_IMPORTED_MODULE_12__.GET_URL)();
    return url === apiUrl + '/appInit' || url === apiUrl + '/auth/checkLogin' || url === apiUrl + '/auth/refresh' || url === apiUrl + '/auth' || url === apiUrl + '/registration' || url === apiUrl + '/sendresetlink' || url === apiUrl + '/checkLogin' || url === apiUrl + '/checkVerificationCode' || url === apiUrl + '/auth/refresh' || url === apiUrl + '/auth/reset' || url === apiUrl + '/verify/email/resend' || url === apiUrl + '/auth/logout';
  }
  // Перехватываем HTTP запросы
  intercept(request, next) {
    if (JwtInterceptor_1.isInBlockedList(request.url)) {
      return this.nextHandler(request, next, false, false);
    } else {
      return this.nextHandler(request, next);
    }
  }
  nextHandler(request, next, repeated = false, addToken = true) {
    return next.handle(this.addToken(request, addToken)).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.catchError)(err => {
      if (err instanceof _angular_common_http__WEBPACK_IMPORTED_MODULE_14__.HttpErrorResponse) {
        switch (err.status) {
          case 418:
          case 503:
            return this.handle503Error(request, err, next);
          case 401:
            return this.handle401Error(request, err, next, repeated);
          case 0:
          case 400:
          case 403:
          case 500:
          case 520:
          default:
            return this.handleError(request, err, next, true);
        }
      } else {
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
      }
    }));
  }
  addToken(request, addToken) {
    if (_services_token_service__WEBPACK_IMPORTED_MODULE_9__["default"].value && addToken) {
      return request.clone({
        headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_14__.HttpHeaders((0,_services_token_service__WEBPACK_IMPORTED_MODULE_9__.authHeader)())
      });
    } else {
      return request;
    }
  }
  handleError(request, err, next, errorHeader = false) {
    // Обработчик ошибок
    const header = errorHeader ? this.translate.instant("ERROR_STRING.ERROR_HEADER") : this.translate.instant("ERROR_STRING.ATTENTION_HEADER");
    if (err.status === undefined) {
      err.status = 0;
    }
    if (!request.context.get(BACKGROUND)) {
      if (!this.showAlert) {
        this.showAlert = true;
        this.alertCtrl.create({
          header,
          message: this.translate.instant("ERROR_STRING.HTTP_ERROR_MESSAGES." + err.status.toString()) || this.translate.instant("ERROR_STRING.HTTP_ERROR_MESSAGES.0"),
          buttons: [this.translate.instant("BUTTONS.OK")]
        }).then(alert => {
          alert.onDidDismiss().then(() => {
            this.showAlert = false;
          });
          alert.present().then(() => {});
        });
      }
    }
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
  }
  handle401Error(request, err, next, repeated = false) {
    var _this = this;
    // Обработка ошибки 401 Unauthorized (Клиент не авторизован)
    // При запросе сервер не подтвердил корректность ключа доступа (токена)
    // будет выполнена повторная авторизация с использованием refresh токена
    // затем изначальный запрос будет отправлен повторно
    if (request.context.get(UPDATE_TOKEN)) {
      if (!this.showAlertLogout) {
        this.showAlertLogout = true;
        this.alertCtrl.create({
          header: this.translate.instant("ERROR_STRING.ATTENTION_HEADER"),
          message: err.error.message || this.translate.instant("ERROR_STRING.HTTP_ERROR_MESSAGES.401"),
          buttons: [this.translate.instant("BUTTONS.OK")]
        }).then(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
            yield data.present();
            data.onDidDismiss().then(() => {
              _this.showAlertLogout = false;
              _this.authService.logout();
            });
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }());
      }
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
    }
    if (repeated) {
      // Обработка ошибки 401 Unauthorized (Клиент не авторизован)
      // После того как токен был обновлен, но ошибка сохранилась
      if (!this.showAlertLogout) {
        this.showAlertLogout = true;
        this.alertCtrl.create({
          header: this.translate.instant("ERROR_STRING.ATTENTION_HEADER"),
          message: this.translate.instant("ERROR_STRING.HTTP_ERROR_MESSAGES.401"),
          buttons: [this.translate.instant("BUTTONS.OK")]
        }).then(/*#__PURE__*/function () {
          var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
            yield data.present();
            data.onDidDismiss().then(() => {
              _this.showAlertLogout = false;
              _this.authService.logout();
            });
          });
          return function (_x2) {
            return _ref2.apply(this, arguments);
          };
        }());
      }
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
    }
    // Проверяем не идет ли обновление токена в данный момент
    if (_services_token_service__WEBPACK_IMPORTED_MODULE_9__["default"].value != null) {
      // Получаем новую пару токенов
      return (0,_services_token_service__WEBPACK_IMPORTED_MODULE_9__.updateToken)(this.device.uuid || this.debug.deviceUUID, this.http).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_15__.catchError)(error => {
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(error);
      }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.switchMap)(data => {
        if (data) {
          // Сохраняем новые токены в хранилище
          return (0,_services_token_service__WEBPACK_IMPORTED_MODULE_9__.storeTokens)(data).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.switchMap)(_ => {
            // Повторяем первоначальный запрос с новым токеном
            return this.nextHandler(request, next, true);
          }));
        } else if (data === null) {
          // в локальном хранилище нет refresh токена
          return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
        } else {
          // Не удалось получить новый токен
          return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
        }
      }));
    } else {
      // Ставим в "очередь" другие вызовы, пока токены не будут обновлены
      return _services_token_service__WEBPACK_IMPORTED_MODULE_9__["default"].pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.filter)(token => token !== null), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.switchMap)(token =>
      // Выполняем накопленные запросы после того как токен был получен
      this.nextHandler(request, next, true)));
    }
  }
  handle503Error(request, err, next) {
    if (document.querySelector('app-technical-works') === null) {
      this.modalService.openModal({
        component: _pages_technical_works_technical_works_page__WEBPACK_IMPORTED_MODULE_7__.TechnicalWorksPage,
        cssClass: 'fullscreen-modal',
        backdropDismiss: false,
        swipeToClose: false,
        enterAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__.enterPinCodeAnimation,
        leaveAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__.leavePinCodeAnimation,
        name: 'TechnicalWorksPage',
        type: 'fullscreen'
      }).then(() => {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_8__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PAGE_TECHNICAL_WORKS,
          value: '1'
        }).then(() => {});
      });
    }
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.throwError)(err);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_1__.AuthenticationService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_19__.ToastController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_19__.AlertController
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_3__.ModalService
    }, {
      type: _services_app_init_service__WEBPACK_IMPORTED_MODULE_5__.AppInitService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_6__.RequestService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__.TranslateService
    }, {
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_10__.Device
    }, {
      type: _services_http_service__WEBPACK_IMPORTED_MODULE_11__.HttpService
    }, {
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_13__.DebugService
    }];
  }
};
JwtInterceptor = JwtInterceptor_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_21__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_22__.Injectable)()], JwtInterceptor);


/***/ }),

/***/ 56981:
/*!***************************************************************************!*\
  !*** ./src/app/pages/account-verified/account-verified-routing.module.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountVerifiedPageRoutingModule: () => (/* binding */ AccountVerifiedPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _account_verified_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account-verified.page */ 4439);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _account_verified_page__WEBPACK_IMPORTED_MODULE_0__.AccountVerifiedPage
}];
let AccountVerifiedPageRoutingModule = class AccountVerifiedPageRoutingModule {};
AccountVerifiedPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AccountVerifiedPageRoutingModule);


/***/ }),

/***/ 96476:
/*!*******************************************************************!*\
  !*** ./src/app/pages/account-verified/account-verified.module.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountVerifiedPageModule: () => (/* binding */ AccountVerifiedPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _account_verified_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account-verified-routing.module */ 56981);
/* harmony import */ var _account_verified_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account-verified.page */ 4439);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let AccountVerifiedPageModule = class AccountVerifiedPageModule {};
AccountVerifiedPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _account_verified_routing_module__WEBPACK_IMPORTED_MODULE_0__.AccountVerifiedPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_account_verified_page__WEBPACK_IMPORTED_MODULE_1__.AccountVerifiedPage]
})], AccountVerifiedPageModule);


/***/ }),

/***/ 4439:
/*!*****************************************************************!*\
  !*** ./src/app/pages/account-verified/account-verified.page.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountVerifiedPage: () => (/* binding */ AccountVerifiedPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _account_verified_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account-verified.page.html?ngResource */ 56793);
/* harmony import */ var _account_verified_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./account-verified.page.scss?ngResource */ 57457);
/* harmony import */ var _account_verified_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_account_verified_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */





let AccountVerifiedPage = class AccountVerifiedPage {
  constructor(appTheme) {
    this.appTheme = appTheme;
  }
  ngOnInit() {}
  auth() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.modal.dismiss();
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__.AppThemeService
    }];
  }
  static {
    this.propDecorators = {
      loginType: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      authData: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }]
    };
  }
};
AccountVerifiedPage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-account-verified',
  template: _account_verified_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_account_verified_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AccountVerifiedPage);


/***/ }),

/***/ 30199:
/*!***********************************************************************!*\
  !*** ./src/app/pages/add-code-modal/add-code-modal-routing.module.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddCodeModalPageRoutingModule: () => (/* binding */ AddCodeModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _add_code_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./add-code-modal.page */ 10297);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _add_code_modal_page__WEBPACK_IMPORTED_MODULE_0__.AddCodeModalPage
}];
let AddCodeModalPageRoutingModule = class AddCodeModalPageRoutingModule {};
AddCodeModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AddCodeModalPageRoutingModule);


/***/ }),

/***/ 20806:
/*!***************************************************************!*\
  !*** ./src/app/pages/add-code-modal/add-code-modal.module.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddCodeModalPageModule: () => (/* binding */ AddCodeModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _add_code_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./add-code-modal-routing.module */ 30199);
/* harmony import */ var _add_code_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-code-modal.page */ 10297);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let AddCodeModalPageModule = class AddCodeModalPageModule {};
AddCodeModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _add_code_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.AddCodeModalPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_add_code_modal_page__WEBPACK_IMPORTED_MODULE_1__.AddCodeModalPage]
})], AddCodeModalPageModule);


/***/ }),

/***/ 10297:
/*!*************************************************************!*\
  !*** ./src/app/pages/add-code-modal/add-code-modal.page.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddCodeModalPage: () => (/* binding */ AddCodeModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _add_code_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-code-modal.page.html?ngResource */ 24283);
/* harmony import */ var _add_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-code-modal.page.scss?ngResource */ 5639);
/* harmony import */ var _add_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_add_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../pin-code/pin-code.page */ 47033);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/modal.service */ 5455);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */







let AddCodeModalPage = class AddCodeModalPage {
  constructor(modalService, appTheme) {
    this.modalService = modalService;
    this.appTheme = appTheme;
    this.openSettings = false;
    this.swipeToClose = false;
  }
  ngOnInit() {}
  codeInit() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.modalService.openModal({
        component: _pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_3__.PinCodePage,
        cssClass: 'fullscreen-modal top-modal',
        backdropDismiss: false,
        swipeToClose: false,
        componentProps: {
          type: 'setCode',
          openSettings: _this.openSettings,
          swipeToClose: _this.swipeToClose
        }
      }).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        yield _this.modal.dismiss({
          _modalName: 'code_invite'
        });
      }));
    })();
  }
  back() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.modal.dismiss(false).then(() => {});
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }, {
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_5__.AppThemeService
    }];
  }
  static {
    this.propDecorators = {
      routerOutlet: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      openSettings: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      swipeToClose: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }]
    };
  }
};
AddCodeModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-add-code-modal',
  template: _add_code_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_add_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AddCodeModalPage);


/***/ }),

/***/ 27208:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/auth/recovery-password/recovery-password-routing.module.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RecoveryPasswordPageRoutingModule: () => (/* binding */ RecoveryPasswordPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _recovery_password_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./recovery-password.page */ 29634);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _recovery_password_page__WEBPACK_IMPORTED_MODULE_0__.RecoveryPasswordPage
}];
let RecoveryPasswordPageRoutingModule = class RecoveryPasswordPageRoutingModule {};
RecoveryPasswordPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], RecoveryPasswordPageRoutingModule);


/***/ }),

/***/ 22521:
/*!**************************************************************************!*\
  !*** ./src/app/pages/auth/recovery-password/recovery-password.module.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RecoveryPasswordPageModule: () => (/* binding */ RecoveryPasswordPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _recovery_password_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./recovery-password-routing.module */ 27208);
/* harmony import */ var _recovery_password_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./recovery-password.page */ 29634);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let RecoveryPasswordPageModule = class RecoveryPasswordPageModule {};
RecoveryPasswordPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _recovery_password_routing_module__WEBPACK_IMPORTED_MODULE_0__.RecoveryPasswordPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_recovery_password_page__WEBPACK_IMPORTED_MODULE_1__.RecoveryPasswordPage]
})], RecoveryPasswordPageModule);


/***/ }),

/***/ 29634:
/*!************************************************************************!*\
  !*** ./src/app/pages/auth/recovery-password/recovery-password.page.ts ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RecoveryPasswordPage: () => (/* binding */ RecoveryPasswordPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _recovery_password_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./recovery-password.page.html?ngResource */ 80394);
/* harmony import */ var _recovery_password_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./recovery-password.page.scss?ngResource */ 37440);
/* harmony import */ var _recovery_password_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_recovery_password_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/authentication.service */ 9214);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/request.service */ 80931);
/* harmony import */ var ts_md5__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ts-md5 */ 96466);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 56196);
/* harmony import */ var _services_token_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../services/token.service */ 2091);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../services/debug.service */ 33925);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */















let RecoveryPasswordPage = class RecoveryPasswordPage {
  constructor(fb, activeRoute, alertController, authService, navCtrl, loadingController, alertCtrl, request, device, translate, debug) {
    this.fb = fb;
    this.activeRoute = activeRoute;
    this.alertController = alertController;
    this.authService = authService;
    this.navCtrl = navCtrl;
    this.loadingController = loadingController;
    this.alertCtrl = alertCtrl;
    this.request = request;
    this.device = device;
    this.translate = translate;
    this.debug = debug;
    this.inputPasswordType = 'password';
    this.login = this.activeRoute.snapshot.queryParamMap.get('login') || '';
    this.loginType = this.activeRoute.snapshot.queryParamMap.get('loginType') || '';
  }
  ngOnInit() {
    this.credentials = this.fb.group({
      login: this.login,
      loginType: this.loginType,
      password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.minLength(6)]],
      passwordConfirm: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.minLength(6), this.equalTo('password')]]
    });
  }
  equalTo(fieldName) {
    return control => {
      const input = control.value;
      const isValid = control.root.value[fieldName] === input;
      if (!isValid) {
        return {
          equalTo: {
            isValid
          }
        };
      } else {
        return null;
      }
    };
  }
  recoveryPass() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.credentials.controls.password.status === 'INVALID') {
        const alert = yield _this.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.PASSWORD_INVALID", {
            value: 6
          })),
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
        });
        yield alert.present();
      } else if (_this.credentials.controls.passwordConfirm.status === 'INVALID') {
        const alert = yield _this.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.PASSWORD_NOT_MATCH")),
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
        });
        yield alert.present();
      } else {
        _this.request.postRequest(_this.request.uri.resetPost(), {
          login: _this.credentials.value.login,
          loginType: _this.credentials.value.loginType,
          password: ts_md5__WEBPACK_IMPORTED_MODULE_5__.Md5.hashStr(_this.credentials.value.password),
          // eslint-disable-next-line @typescript-eslint/naming-convention
          device_uuid: _this.device.uuid || _this.debug.deviceUUID
        }, {
          useCache: false
        }).subscribe({
          next: function () {
            var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (response) {
              if (response.result) {
                _services_token_service__WEBPACK_IMPORTED_MODULE_7__["default"].next(response.access_token);
                yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.firstValueFrom)((0,_services_token_service__WEBPACK_IMPORTED_MODULE_7__.storeTokens)(response));
                _services_authentication_service__WEBPACK_IMPORTED_MODULE_3__.isAuth.next(true);
                const alert = yield _this.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                  message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("TEXT_STRING.PASSWORD_CHANGE_SUCCESS")),
                  buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
                });
                yield alert.present();
                yield _this.navCtrl.navigateRoot('/tabs/main', {
                  animated: true,
                  // animation: loginAnimation,
                  animationDirection: 'forward',
                  replaceUrl: true,
                  queryParams: {
                    needToUpdateBindings: false
                  }
                });
              } else {
                _services_authentication_service__WEBPACK_IMPORTED_MODULE_3__.isAuth.next(false);
                const alert = yield _this.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                  message: response.message,
                  buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
                });
                yield alert.present();
              }
            });
            return function next(_x) {
              return _ref.apply(this, arguments);
            };
          }(),
          error: () => {
            _services_authentication_service__WEBPACK_IMPORTED_MODULE_3__.isAuth.next(false);
          }
        });
      }
    })();
  }
  get email() {
    return this.credentials.get('login');
  }
  togglePassword() {
    if (this.inputPasswordType === 'password') {
      this.inputPasswordType = 'text';
    } else {
      this.inputPasswordType = 'password';
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_9__.UntypedFormBuilder
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_12__.ActivatedRoute
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.AlertController
    }, {
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_3__.AuthenticationService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.NavController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.LoadingController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.AlertController
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.RequestService
    }, {
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_6__.Device
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__.TranslateService
    }, {
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_8__.DebugService
    }];
  }
};
RecoveryPasswordPage = (0,tslib__WEBPACK_IMPORTED_MODULE_16__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_17__.Component)({
  selector: 'app-recovery-password',
  template: _recovery_password_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_recovery_password_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], RecoveryPasswordPage);


/***/ }),

/***/ 37415:
/*!*************************************************************!*\
  !*** ./src/app/pages/bio-modal/bio-modal-routing.module.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BioModalPageRoutingModule: () => (/* binding */ BioModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _bio_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bio-modal.page */ 5865);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _bio_modal_page__WEBPACK_IMPORTED_MODULE_0__.BioModalPage
}];
let BioModalPageRoutingModule = class BioModalPageRoutingModule {};
BioModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], BioModalPageRoutingModule);


/***/ }),

/***/ 59734:
/*!*****************************************************!*\
  !*** ./src/app/pages/bio-modal/bio-modal.module.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BioModalPageModule: () => (/* binding */ BioModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _bio_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bio-modal-routing.module */ 37415);
/* harmony import */ var _bio_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bio-modal.page */ 5865);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let BioModalPageModule = class BioModalPageModule {};
BioModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _bio_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.BioModalPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_bio_modal_page__WEBPACK_IMPORTED_MODULE_1__.BioModalPage]
})], BioModalPageModule);


/***/ }),

/***/ 5865:
/*!***************************************************!*\
  !*** ./src/app/pages/bio-modal/bio-modal.page.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BioModalPage: () => (/* binding */ BioModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _bio_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bio-modal.page.html?ngResource */ 3723);
/* harmony import */ var _bio_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bio-modal.page.scss?ngResource */ 43551);
/* harmony import */ var _bio_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_bio_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../environments/storage */ 12960);
/* harmony import */ var _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/touch-id/ngx */ 76098);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);
/* harmony import */ var _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../services/in-app-auth.service */ 70604);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/fingerprint-aio/ngx */ 61649);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */













let BioModalPage = class BioModalPage {
  constructor(faio, platform, touchId, alertCtrl, appTheme, inAppAuth, translate) {
    this.faio = faio;
    this.platform = platform;
    this.touchId = touchId;
    this.alertCtrl = alertCtrl;
    this.appTheme = appTheme;
    this.inAppAuth = inAppAuth;
    this.translate = translate;
    this.faioType = '';
  }
  ngOnInit() {
    var _this = this;
    this.faio.isAvailable({
      requireStrongBiometrics: false
    }).then(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (type) {
        _this.faioType = type;
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  faioInit() {
    var _this2 = this;
    this.faio.isAvailable({
      requireStrongBiometrics: false
    }).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.faio.show({
        disableBackup: true
      }).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED,
          value: '1'
        });
        _this2.inAppAuth.faioEnabled.next(true);
        yield _this2.dismiss(true);
      })).catch(/*#__PURE__*/function () {
        var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (err) {
          yield _this2.faioError();
        });
        return function (_x2) {
          return _ref4.apply(this, arguments);
        };
      }());
    })).catch(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.faioError();
    }));
  }
  faioError() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      let message;
      if (_this3.faioType === 'face') {
        message = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_FACEID"));
      } else if (_this3.faioType === 'finger') {
        message = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_TOUCHID"));
      } else {
        message = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_BIOMETRIC"));
      }
      const alert = yield _this3.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
        message,
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
      });
      yield alert.present();
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED,
        value: '0'
      });
      alert.onDidDismiss().then(() => {
        _this3.dismiss(false);
      });
    })();
  }
  back() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this4.dismiss(false);
    })();
  }
  dismiss(_value) {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this5.modal.dismiss(_value);
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_8__.FingerprintAIO
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.Platform
    }, {
      type: _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_5__.TouchID
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.AlertController
    }, {
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_6__.AppThemeService
    }, {
      type: _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_7__.InAppAuthService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__.TranslateService
    }];
  }
};
BioModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_13__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_14__.Component)({
  selector: 'app-bio-modal',
  template: _bio_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_bio_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], BioModalPage);


/***/ }),

/***/ 92439:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/change-data-modal/change-data-modal-routing.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChangeDataModalPageRoutingModule: () => (/* binding */ ChangeDataModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _change_data_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./change-data-modal.page */ 50553);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _change_data_modal_page__WEBPACK_IMPORTED_MODULE_0__.ChangeDataModalPage
}];
let ChangeDataModalPageRoutingModule = class ChangeDataModalPageRoutingModule {};
ChangeDataModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], ChangeDataModalPageRoutingModule);


/***/ }),

/***/ 33510:
/*!*********************************************************************!*\
  !*** ./src/app/pages/change-data-modal/change-data-modal.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChangeDataModalPageModule: () => (/* binding */ ChangeDataModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _change_data_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./change-data-modal-routing.module */ 92439);
/* harmony import */ var _change_data_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./change-data-modal.page */ 50553);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _tabs_appeals_applications_form_create_modal_create_modal_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../tabs/appeals/applications-form/create-modal/create-modal.module */ 8937);
/* harmony import */ var _maskito_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @maskito/angular */ 54483);
/* harmony import */ var _components_card_block_card_block_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components/card-block/card-block.component */ 65075);
/* harmony import */ var _components_menu_item_menu_item_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../components/menu-item/menu-item.component */ 23853);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */












let ChangeDataModalPageModule = class ChangeDataModalPageModule {};
ChangeDataModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.IonicModule, _change_data_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.ChangeDataModalPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__.TranslateModule, _tabs_appeals_applications_form_create_modal_create_modal_module__WEBPACK_IMPORTED_MODULE_2__.CreateModalPageModule, _maskito_angular__WEBPACK_IMPORTED_MODULE_11__.MaskitoModule, _components_card_block_card_block_component__WEBPACK_IMPORTED_MODULE_3__.CardBlockComponent, _components_menu_item_menu_item_component__WEBPACK_IMPORTED_MODULE_4__.MenuItemComponent],
  declarations: [_change_data_modal_page__WEBPACK_IMPORTED_MODULE_1__.ChangeDataModalPage]
})], ChangeDataModalPageModule);


/***/ }),

/***/ 50553:
/*!*******************************************************************!*\
  !*** ./src/app/pages/change-data-modal/change-data-modal.page.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChangeDataModalPage: () => (/* binding */ ChangeDataModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _change_data_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./change-data-modal.page.html?ngResource */ 66643);
/* harmony import */ var _change_data_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./change-data-modal.page.scss?ngResource */ 51727);
/* harmony import */ var _change_data_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_change_data_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/helper.service */ 54102);
/* harmony import */ var _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/keyboard/ngx */ 18532);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../services/modal.service */ 5455);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../services/phone-mask.service */ 10449);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _tabs_more_settings_email_mailing_modal_email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../tabs/more/settings/email-mailing-modal/email-mailing-modal.page */ 2688);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */














let ChangeDataModalPage = class ChangeDataModalPage {
  constructor(fb, request, helper, keyboard, modalService, alertCtrl, platform, translate) {
    this.fb = fb;
    this.request = request;
    this.helper = helper;
    this.keyboard = keyboard;
    this.modalService = modalService;
    this.alertCtrl = alertCtrl;
    this.platform = platform;
    this.translate = translate;
    this.title = '';
    this.inputType = 'string';
    this.checkboxes = {
      email: [],
      sms: [],
      handlerEmail: checkbox => false,
      handlerSMS: checkbox => {}
    };
    this.maskPredicate = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_7__.maskPredicate;
    this.maskPhone = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_7__.maskPhone;
  }
  ngOnInit() {
    if (this.inputType === 'tel') {
      this.credentials = this.fb.group({
        input: [this.helper.phoneFormat(this.value)]
      });
    } else if (this.inputType === 'email') {
      this.credentials = this.fb.group({
        input: [this.value, [_angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.email]]
      });
    } else if (this.inputType === 'password') {
      this.credentials = this.fb.group({
        input: [''],
        newPass: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.minLength(6)]],
        confirmNewPass: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_9__.Validators.minLength(6), this.equalTo('newPass')]]
      });
    } else {
      this.credentials = this.fb.group({
        input: [this.value]
      });
    }
  }
  ionViewDidEnter() {
    try {
      if (this.input) {
        this.input.setFocus();
      }
    } catch (e) {}
  }
  ionViewWillLeave() {
    this.keyboard.hide();
  }
  isEmailLogin() {
    return this.request.settingsEmail.value.useEmailAsLogin;
  }
  isPhoneLogin() {
    return this.request.settingsPhone.value.usePhoneAsLogin;
  }
  equalTo(field) {
    return control => {
      const input = control.value;
      const isValid = control.root.value[field] === input || input === '';
      if (!isValid) {
        return {
          equalTo: {
            isValid
          }
        };
      } else {
        return null;
      }
    };
  }
  inputPass() {
    this.credentials.get('confirmNewPass').setValue(this.credentials.get('confirmNewPass').value);
  }
  submit() {
    this.handler(this.credentials.value).then(value => {
      this.modal.dismiss(value);
    });
  }
  dismiss(value = false) {
    this.modal.dismiss(value);
  }
  openChangeSubscriptionModal(object) {
    this.modalService.openModal({
      component: _tabs_more_settings_email_mailing_modal_email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_8__.EmailMailingModalPage,
      componentProps: {
        item: object
      }
    }).then(modal => {
      modal.onDidDismiss().then(data => {
        if (data.data === false) {
          object.value = false;
          object.label = '';
        } else if (data.data !== undefined) {
          object.value = true;
          object.label = data.data;
        }
      });
    });
  }
  toggleMailing(checkbox) {
    var _this = this;
    const body = {
      type: checkbox.type,
      value: !checkbox.value,
      rowId: checkbox.rowId || undefined
    };
    this.request.postRequest(this.request.uri.settingsMailingsPost(), body, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (responce) {
        if (responce.result) {
          const mailing = _this.request.settingsMailings.value[_this.request.activeLs.value];
          mailing.parameter[checkbox.id].value = !checkbox.value;
          yield _this.request.cache(_this.request.uri.settingsMailingsGet(), mailing, true);
          if (checkbox.type === 'send_kvit') {
            _this.checkboxes.email[_this.checkboxes.email.indexOf(checkbox)].value = !checkbox.value;
          } else {
            _this.checkboxes.sms[_this.checkboxes.sms.indexOf(checkbox)].value = !checkbox.value;
          }
          // await this.request.loadSettingsMailingsCallback()({}); //todo
        } else {
          yield (yield _this.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: responce.message || (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("MORE.SETTINGS_PAGE.PERSONAL_ACCOUNT.MAILING.CHANGE_ERROR")))
          })).present();
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  isEmail(email) {
    return email.includes('@');
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_9__.UntypedFormBuilder
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__.Keyboard
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_6__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.AlertController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_12__.Platform
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_13__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.ViewChild,
        args: ['input']
      }],
      emailLabel: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.ViewChild,
        args: ['emailLabel']
      }],
      title: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.Input
      }],
      inputType: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.Input
      }],
      handler: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.Input
      }],
      checkboxes: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_14__.Input
      }]
    };
  }
};
ChangeDataModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_14__.Component)({
  selector: 'app-change-data-modal',
  template: _change_data_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_change_data_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ChangeDataModalPage);


/***/ }),

/***/ 33131:
/*!*****************************************************************!*\
  !*** ./src/app/pages/choose-data/choose-data-routing.module.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChooseDataPageRoutingModule: () => (/* binding */ ChooseDataPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _choose_data_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./choose-data.page */ 77853);




const routes = [{
  path: '',
  component: _choose_data_page__WEBPACK_IMPORTED_MODULE_0__.ChooseDataPage
}];
let ChooseDataPageRoutingModule = class ChooseDataPageRoutingModule {};
ChooseDataPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], ChooseDataPageRoutingModule);


/***/ }),

/***/ 41930:
/*!*********************************************************!*\
  !*** ./src/app/pages/choose-data/choose-data.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChooseDataPageModule: () => (/* binding */ ChooseDataPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _choose_data_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./choose-data-routing.module */ 33131);
/* harmony import */ var _choose_data_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./choose-data.page */ 77853);







let ChooseDataPageModule = class ChooseDataPageModule {};
ChooseDataPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _choose_data_routing_module__WEBPACK_IMPORTED_MODULE_0__.ChooseDataPageRoutingModule],
  declarations: [_choose_data_page__WEBPACK_IMPORTED_MODULE_1__.ChooseDataPage]
})], ChooseDataPageModule);


/***/ }),

/***/ 77853:
/*!*******************************************************!*\
  !*** ./src/app/pages/choose-data/choose-data.page.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChooseDataPage: () => (/* binding */ ChooseDataPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _choose_data_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./choose-data.page.html?ngResource */ 39751);
/* harmony import */ var _choose_data_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./choose-data.page.scss?ngResource */ 9411);
/* harmony import */ var _choose_data_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_choose_data_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/request.service */ 80931);





let ChooseDataPage = class ChooseDataPage {
  constructor(request) {
    this.request = request;
  }
  ngOnInit() {}
  dismiss(data = null) {
    this.modal.dismiss(data);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_2__.RequestService
    }];
  }
  static {
    this.propDecorators = {
      data: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }],
      title: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_3__.Input
      }]
    };
  }
};
ChooseDataPage = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Component)({
  selector: 'app-choose-data',
  template: _choose_data_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_choose_data_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], ChooseDataPage);


/***/ }),

/***/ 91959:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/code-verification/code-verification-routing.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeVerificationPageRoutingModule: () => (/* binding */ CodeVerificationPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _code_verification_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code-verification.page */ 79769);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _code_verification_page__WEBPACK_IMPORTED_MODULE_0__.CodeVerificationPage
}];
let CodeVerificationPageRoutingModule = class CodeVerificationPageRoutingModule {};
CodeVerificationPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], CodeVerificationPageRoutingModule);


/***/ }),

/***/ 50374:
/*!*********************************************************************!*\
  !*** ./src/app/pages/code-verification/code-verification.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeVerificationPageModule: () => (/* binding */ CodeVerificationPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _code_verification_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code-verification-routing.module */ 91959);
/* harmony import */ var _code_verification_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code-verification.page */ 79769);
/* harmony import */ var _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../pipes/pipes.module */ 41683);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */









let CodeVerificationPageModule = class CodeVerificationPageModule {};
CodeVerificationPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _code_verification_routing_module__WEBPACK_IMPORTED_MODULE_0__.CodeVerificationPageRoutingModule, _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_2__.PipesModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__.TranslateModule],
  declarations: [_code_verification_page__WEBPACK_IMPORTED_MODULE_1__.CodeVerificationPage]
})], CodeVerificationPageModule);


/***/ }),

/***/ 79769:
/*!*******************************************************************!*\
  !*** ./src/app/pages/code-verification/code-verification.page.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeVerificationPage: () => (/* binding */ CodeVerificationPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _code_verification_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code-verification.page.html?ngResource */ 30139);
/* harmony import */ var _code_verification_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./code-verification.page.scss?ngResource */ 93087);
/* harmony import */ var _code_verification_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_code_verification_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _services_global_loading_service_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/global-loading-service.service */ 81854);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 5342);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */









let CodeVerificationPage = class CodeVerificationPage {
  constructor(modalCtrl, request, globalLoadingService, alertCtrl, translate) {
    this.modalCtrl = modalCtrl;
    this.request = request;
    this.globalLoadingService = globalLoadingService;
    this.alertCtrl = alertCtrl;
    this.translate = translate;
    this.recovery = false;
    this.code = '';
  }
  ngOnInit() {
    this.timeout = +this.authData.timeout;
    this.timer = setInterval(() => {
      this.timeout--;
      if (this.timeout <= 0) {
        clearInterval(this.timer);
      }
    }, 1000);
  }
  ionViewDidEnter() {
    this.input.setFocus();
  }
  inputCode() {
    var _this = this;
    if (this.code.length === 4) {
      const body = {
        code: this.code,
        login: this.login,
        loginType: this.loginType,
        password: this.password,
        device_uuid: this.device_uuid,
        accountId: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.accountId.value
      };
      this.request.postRequest(this.request.uri.checkVerificationCodePost(), body, {
        useCache: false
      }).subscribe({
        next: function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
            if (data) {
              if (data.result) {
                yield _this.modal.dismiss(true);
              } else {
                const alert = yield _this.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                  message: data.message || (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("MODAL_PAGES.CODE_VERIFICATION.INVALID_CODE"))),
                  buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
                });
                yield alert.present();
                alert.onDidDismiss().then(() => {
                  _this.code = '';
                  _this.ionViewDidEnter();
                });
              }
            }
          });
          return function next(_x) {
            return _ref.apply(this, arguments);
          };
        }(),
        error: error => {
          this.code = '';
          this.ionViewDidEnter();
        }
      });
    }
  }
  resendCode() {
    var _this2 = this;
    let url;
    let body;
    if (this.recovery) {
      body = {
        login: this.login,
        loginType: this.loginType
      };
      url = this.request.uri.resetLinkPost();
    } else if (this.password != null) {
      body = {
        login: this.login,
        loginType: this.loginType,
        password: this.password,
        device_uuid: this.device_uuid
      };
      url = this.request.uri.registrationPost();
    } else {
      body = {
        email: this.login
      };
      url = this.request.uri.sendCodePost();
    }
    this.request.postRequest(url, body, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (data.result) {
          _this2.timeout = data.timeout;
          _this2.timer = setInterval(() => {
            _this2.timeout--;
            if (_this2.timeout <= 0) {
              clearInterval(_this2.timer);
            }
          }, 1000);
        }
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  dismiss() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.modalCtrl.dismiss();
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.RequestService
    }, {
      type: _services_global_loading_service_service__WEBPACK_IMPORTED_MODULE_3__.GlobalLoadingService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      loginType: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      login: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      password: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      device_uuid: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      authData: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      recovery: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.Input
      }],
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ViewChild,
        args: ['input']
      }]
    };
  }
};
CodeVerificationPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-code-verification',
  template: _code_verification_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_code_verification_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CodeVerificationPage);


/***/ }),

/***/ 28325:
/*!***************************************************!*\
  !*** ./src/app/pages/info/info-routing.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InfoPageRoutingModule: () => (/* binding */ InfoPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _info_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./info.page */ 40871);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _info_page__WEBPACK_IMPORTED_MODULE_0__.InfoPage
}];
let InfoPageRoutingModule = class InfoPageRoutingModule {};
InfoPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], InfoPageRoutingModule);


/***/ }),

/***/ 72236:
/*!*******************************************!*\
  !*** ./src/app/pages/info/info.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InfoPageModule: () => (/* binding */ InfoPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _info_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./info-routing.module */ 28325);
/* harmony import */ var _info_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./info.page */ 40871);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */







let InfoPageModule = class InfoPageModule {};
InfoPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _info_routing_module__WEBPACK_IMPORTED_MODULE_0__.InfoPageRoutingModule],
  declarations: [_info_page__WEBPACK_IMPORTED_MODULE_1__.InfoPage]
})], InfoPageModule);


/***/ }),

/***/ 40871:
/*!*****************************************!*\
  !*** ./src/app/pages/info/info.page.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InfoPage: () => (/* binding */ InfoPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _info_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./info.page.html?ngResource */ 89289);
/* harmony import */ var _info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./info.page.scss?ngResource */ 30969);
/* harmony import */ var _info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);
/* harmony import */ var _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/taptic-engine/ngx */ 8287);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */






let InfoPage = class InfoPage {
  constructor(appTheme, tapticEngine) {
    this.appTheme = appTheme;
    this.tapticEngine = tapticEngine;
    this.textBtn = 'Продолжить';
  }
  ngOnInit() {}
  ionViewWillEnter() {
    if (this.taptic) {
      this.tapticEngine.notification({
        type: this.taptic
      }).catch(() => {});
    }
  }
  next() {
    this.modal.dismiss().then(() => {});
  }
  static {
    this.ctorParameters = () => [{
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_2__.AppThemeService
    }, {
      type: _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_3__.TapticEngine
    }];
  }
  static {
    this.propDecorators = {
      icon: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      description: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      textBtn: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }],
      taptic: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }]
    };
  }
};
InfoPage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-info',
  template: _info_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  providers: [_awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_3__.TapticEngine],
  styles: [(_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], InfoPage);


/***/ }),

/***/ 88455:
/*!*********************************************************!*\
  !*** ./src/app/pages/message/message-routing.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessagePageRoutingModule: () => (/* binding */ MessagePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _message_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./message.page */ 99849);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _message_page__WEBPACK_IMPORTED_MODULE_0__.MessagePage
}];
let MessagePageRoutingModule = class MessagePageRoutingModule {};
MessagePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], MessagePageRoutingModule);


/***/ }),

/***/ 91286:
/*!*************************************************!*\
  !*** ./src/app/pages/message/message.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessagePageModule: () => (/* binding */ MessagePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _message_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./message-routing.module */ 88455);
/* harmony import */ var _message_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message.page */ 99849);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */







let MessagePageModule = class MessagePageModule {};
MessagePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _message_routing_module__WEBPACK_IMPORTED_MODULE_0__.MessagePageRoutingModule],
  declarations: [_message_page__WEBPACK_IMPORTED_MODULE_1__.MessagePage]
})], MessagePageModule);


/***/ }),

/***/ 99849:
/*!***********************************************!*\
  !*** ./src/app/pages/message/message.page.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MessagePage: () => (/* binding */ MessagePage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _message_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./message.page.html?ngResource */ 64443);
/* harmony import */ var _message_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./message.page.scss?ngResource */ 17455);
/* harmony import */ var _message_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_message_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/helper.service */ 54102);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../environments/storage */ 12960);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 51567);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */











let MessagePage = class MessagePage {
  constructor(appTheme, helper, activeRoute, navCtrl) {
    this.appTheme = appTheme;
    this.helper = helper;
    this.activeRoute = activeRoute;
    this.navCtrl = navCtrl;
    this.overscroll = true;
    this.imageLight = '';
    this.imageDark = '';
    this.header = '';
    this.subHeader = '';
    this.message = '';
    this.buttons = [];
    this.canDismiss = true;
    this.save = false;
    this.saveKey = _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAGE_MESSAGE;
    this.saveClosed = false;
    this.appVersion = null;
    this.id = 0;
    this.type = 'message';
    this.name = 'message';
    if (this.activeRoute.snapshot.queryParamMap.get('params') !== null) {
      this.overscroll = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).overscroll;
      this.imageLight = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).imageLight;
      this.imageDark = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).imageDark;
      this.header = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).header;
      this.subHeader = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).subHeader;
      this.message = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).message;
      this.buttons = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).buttons;
      this.canDismiss = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).canDismiss;
      this.saveClosed = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).saveClosed;
      this.id = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).id;
    }
  }
  ngOnInit() {
    this.helper.needToUpdate.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.filter)(value => value !== null)).subscribe(value => {
      if (!value) {
        this.closeWindow('update');
      }
    });
  }
  handler(button) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (button.linkIos !== undefined && (0,_ionic_angular__WEBPACK_IMPORTED_MODULE_8__.isPlatform)('ios') || button.linkAndroid && (0,_ionic_angular__WEBPACK_IMPORTED_MODULE_8__.isPlatform)('android')) {
        _this.helper.openUrl((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_8__.isPlatform)('ios') ? button.linkIos : button.linkAndroid, button.target);
      } else if (button.handler) {
        button.handler().then(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (key) {
            yield _this.closeWindow('message');
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }());
      } else {
        yield _this.closeWindow('message');
      }
    })();
  }
  closeWindow(key) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.saveClosed) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAGE_MESSAGE_CLOSED,
          value: _this2.id.toString()
        });
      }
      if (key == 'update') {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAGE_UPDATE_APP
        });
      } else {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAGE_MESSAGE
        });
      }
      if (_this2.activeRoute.snapshot.queryParamMap.get('params') !== null) {
        _this2.navCtrl.navigateRoot('/login').catch(() => {});
      } else {
        _this2.modal.dismiss();
      }
    })();
  }
  imageError() {}
  static {
    this.ctorParameters = () => [{
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__.AppThemeService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.ActivatedRoute
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.NavController
    }];
  }
  static {
    this.propDecorators = {
      overscroll: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      imageLight: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      imageDark: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      header: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      subHeader: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      message: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      buttons: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      canDismiss: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      save: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      saveKey: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      saveClosed: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      appVersion: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      id: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      type: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }],
      name: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }]
    };
  }
};
MessagePage = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-message',
  template: _message_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_message_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], MessagePage);


/***/ }),

/***/ 96695:
/*!***********************************************************!*\
  !*** ./src/app/pages/pin-code/pin-code-routing.module.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PinCodePageRoutingModule: () => (/* binding */ PinCodePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _pin_code_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pin-code.page */ 47033);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _pin_code_page__WEBPACK_IMPORTED_MODULE_0__.PinCodePage
}];
let PinCodePageRoutingModule = class PinCodePageRoutingModule {};
PinCodePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], PinCodePageRoutingModule);


/***/ }),

/***/ 73862:
/*!***************************************************!*\
  !*** ./src/app/pages/pin-code/pin-code.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PinCodePageModule: () => (/* binding */ PinCodePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _pin_code_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pin-code-routing.module */ 96695);
/* harmony import */ var _pin_code_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pin-code.page */ 47033);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let PinCodePageModule = class PinCodePageModule {};
PinCodePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _pin_code_routing_module__WEBPACK_IMPORTED_MODULE_0__.PinCodePageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_pin_code_page__WEBPACK_IMPORTED_MODULE_1__.PinCodePage]
})], PinCodePageModule);


/***/ }),

/***/ 47033:
/*!*************************************************!*\
  !*** ./src/app/pages/pin-code/pin-code.page.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PinCodePage: () => (/* binding */ PinCodePage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _pin_code_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pin-code.page.html?ngResource */ 88123);
/* harmony import */ var _pin_code_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pin-code.page.scss?ngResource */ 76935);
/* harmony import */ var _pin_code_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_pin_code_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../environments/storage */ 12960);
/* harmony import */ var _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/taptic-engine/ngx */ 8287);
/* harmony import */ var _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @awesome-cordova-plugins/touch-id/ngx */ 76098);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../services/authentication.service */ 9214);
/* harmony import */ var _services_status_bar_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../services/status-bar.service */ 48080);
/* harmony import */ var _bio_modal_bio_modal_page__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../bio-modal/bio-modal.page */ 5865);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../services/modal.service */ 5455);
/* harmony import */ var _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../services/in-app-auth.service */ 70604);
/* harmony import */ var _tabs_more_settings_code_modal_code_modal_page__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../tabs/more/settings/code-modal/code-modal.page */ 66092);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../animations/pin-code-animation */ 6366);
/* harmony import */ var _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @awesome-cordova-plugins/native-storage/ngx */ 76558);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @awesome-cordova-plugins/fingerprint-aio/ngx */ 61649);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */





















let PinCodePage = class PinCodePage {
  constructor(faio, taptic, platform, animCtrl, touchId, alertCtrl, authService, statusBar, modalService, inAppAuth, router, navCtrl, nativeStorage, translate) {
    this.faio = faio;
    this.taptic = taptic;
    this.platform = platform;
    this.animCtrl = animCtrl;
    this.touchId = touchId;
    this.alertCtrl = alertCtrl;
    this.authService = authService;
    this.statusBar = statusBar;
    this.modalService = modalService;
    this.inAppAuth = inAppAuth;
    this.router = router;
    this.navCtrl = navCtrl;
    this.nativeStorage = nativeStorage;
    this.translate = translate;
    this.type = 'enterCode';
    this.openSettings = false;
    this.ipad = false;
    this.step = 0;
    this.codeFromFirstStep = '';
    this.pinCode = '';
    if (this.platform.is('ipad') || this.platform.is('tablet')) {
      this.ipad = true;
    }
  }
  ngOnInit() {
    var _this = this;
    this.faio.isAvailable({
      requireStrongBiometrics: false
    }).then(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (type) {
        _this.inAppAuth.faioType.next(type);
        _this.inAppAuth.faioAvailable.next(true);
        if ((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED
        })).value === '1') {
          _this.inAppAuth.faioChanged.next(true);
        } else {
          _this.inAppAuth.faioChanged.next(false);
        }
        _this.inAppAuth.faioErrorCode.next(null);
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }()).catch(err => {
      this.inAppAuth.faioErrorCode.next(err.code);
    });
    if (this.type === 'setCode') {
      // если окно открыто для того, чтобы установить новый код
      this.step = 1;
    } else if (this.type === 'enterCode') {
      // если окно открыто для того, чтобы проверить код
      this.faio.isAvailable({
        requireStrongBiometrics: false
      }).then(/*#__PURE__*/function () {
        var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (type) {
          if ((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED
          })).value === '1') {
            _this.inAppAuth.faioType.next(type);
            _this.inAppAuth.faioAvailable.next(true);
            if ((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED
            })).value === '1') {
              _this.inAppAuth.faioChanged.next(true);
            } else {
              _this.inAppAuth.faioChanged.next(false);
            }
            _this.faioInit();
            _this.inAppAuth.faioErrorCode.next(null);
          }
        });
        return function (_x2) {
          return _ref2.apply(this, arguments);
        };
      }()).catch(err => {
        this.inAppAuth.faioErrorCode.next(err.code);
      });
    }
  }
  dismiss(_value) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.modal !== undefined) {
        yield _this2.modal.dismiss(_value);
      } else {
        _this2.navCtrl.back({
          animated: true,
          animation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_13__.leavePinCodeAnimation,
          animationDirection: 'forward'
        });
      }
    })();
  }
  faioClick() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.taptic.impact({
        style: 'light'
      }).catch(() => {});
      _this3.faioInit();
    })();
  }
  // инициируем биометрические датчики
  faioInit() {
    var _this4 = this;
    if (this.platform.is('ios')) {
      // если платформа ios, то сначала проверяем не была ли изменена биометрия на устройстве
      this.touchId.didFingerprintDatabaseChange().then(/*#__PURE__*/function () {
        var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (changed) {
          if (!changed && !_this4.inAppAuth.faioChanged.value) {
            // инициируем сканирование
            _this4.faioScan();
          } else {
            // устанавливаем флаг о том что биометрия была изменена и пока пользователь не введет код-пароль сканирование невозможно
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED,
              value: '1'
            });
            _this4.inAppAuth.faioChanged.next(true);
            const alert = yield _this4.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: _this4.inAppAuth.faioType.value === 'face' ? yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get("ERROR_STRING.ERROR_FACEID_CHANGED")) : yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get("ERROR_STRING.ERROR_TOUCHID_CHANGED")),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get("BUTTONS.OK"))]
            });
            _this4.taptic.notification({
              type: 'warning'
            }).catch(() => {});
            yield alert.present();
          }
        });
        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      }()).catch(() => {});
    } else {
      // если платформа андроид, то просто инициируем сканирование
      this.faioScan();
    }
  }
  // запуск сканирования биометрии
  faioScan() {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this5.faio.show({
        description: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("TEXT_STRING.AUTH")),
        disableBackup: true
      }).then(() => _this5.pinSuccess(false).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED,
          value: '0'
        });
        setTimeout(() => {
          _this5.dismiss(true);
        }, 100);
      }))).catch(err => {
        _this5.faio.isAvailable({
          requireStrongBiometrics: false
        }).then().catch(() => {
          _this5.inAppAuth.faioAvailable.next(false);
        });
      });
    })();
  }
  // обработка ввода код-пароля
  input(_value) {
    var _this6 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // тактильная отдача на iphone7 и новее
      yield _this6.taptic.impact({
        style: 'light'
      }).catch(() => {});
      _this6.pinCode += _value;
      // если код-пароль длинной в 4 символа, то начинаем проверку
      if (_this6.pinCode.length >= 4) {
        // считываем установленный код на приложение
        const truePin = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE
        });
        if (_this6.type === 'setCode') {
          // если страница открыта для установки нового кода
          if (_this6.step === 0) {
            // если 1 этап, проверка текущего кода доступа
            if (truePin.value === _this6.pinCode) {
              // если правильно, то сбрасываем введенный код и переходим ко 2 этапу
              setTimeout(() => {
                _this6.pinSuccess().then(() => {
                  _this6.step = 1;
                  _this6.textSwitch(_this6.text0, _this6.text1);
                  _this6.pinInit();
                });
              }, 300);
            } else {
              setTimeout(() => {
                _this6.pinFailed();
              }, 500);
            }
          } else if (_this6.step === 1) {
            // если 2 этап, ввод нового кода
            _this6.codeFromFirstStep = _this6.pinCode; // запоминаем введенный код
            setTimeout(() => {
              _this6.pinRetry(); // стираем введенный код и переходим к 3 этапу
            }, 300);
          } else {
            // если 3 этап, повтор нового кода
            if (_this6.codeFromFirstStep === _this6.pinCode) {
              // если коды совпадают, то записываем новый код в хранилище
              yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE,
                value: _this6.codeFromFirstStep
              });
              yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE_ENABLED,
                value: '1'
              });
              _this6.nativeStorage.setItem('blurPrivacyScreen', true).catch(err => console.error(err));
              _this6.inAppAuth.pinInst.next(true);
              setTimeout(() => {
                _this6.pinSuccess().then(() => {
                  setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                    if (_this6.openSettings) {
                      yield _this6.modalService.openModal({
                        component: _tabs_more_settings_code_modal_code_modal_page__WEBPACK_IMPORTED_MODULE_12__.CodeModalPage
                      });
                    }
                    _this6.openFaioModal().then(() => {
                      _this6.dismiss(true);
                    });
                  }), 100);
                });
              }, 300);
            } else {
              // если коды не совпадают, то возвращаемся к этапу 2, создание нового кода
              setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                yield _this6.pinFailed();
                _this6.textSwitch(_this6.text2, _this6.text1, 'back').then();
              }), 500);
            }
          }
          return;
        }
        if (truePin.value === _this6.pinCode) {
          // Если введен верный код при входе в приложение
          setTimeout(() => {
            _this6.pinSuccess().then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
              yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED
              }); // сбрасываем флаг изменения биометрии, так как код подтвержден
              setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                if (_this6.openSettings) {
                  yield _this6.modalService.openModal({
                    component: _tabs_more_settings_code_modal_code_modal_page__WEBPACK_IMPORTED_MODULE_12__.CodeModalPage
                  });
                }
                yield _this6.dismiss(true);
              }), 100);
            }));
          }, 300);
        } else {
          // Если введен неверный код при входе в приложение
          setTimeout(() => {
            _this6.pinFailed();
          }, 500);
        }
      }
    })();
  }
  delete() {
    var _this7 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this7.taptic.impact({
        style: 'light'
      }).catch(() => {});
      _this7.pinCode = _this7.pinCode.slice(0, -1);
    })();
  }
  // анимация инициализации ввода
  pinInit() {
    var _this8 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const anim1 = _this8.animCtrl.create().addElement(_this8.circle1.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(57px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)'
      }]);
      const anim2 = _this8.animCtrl.create().addElement(_this8.circle2.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(19px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)'
      }]);
      const anim3 = _this8.animCtrl.create().addElement(_this8.circle3.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(-19px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)'
      }]);
      const anim4 = _this8.animCtrl.create().addElement(_this8.circle4.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(-57px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)'
      }]);
      anim1.play().catch(() => {});
      anim2.play().catch(() => {});
      anim3.play().catch(() => {});
      yield anim4.play();
      anim1.stop();
      anim2.stop();
      anim3.stop();
      yield anim4.stop();
      _this8.pinCode = '';
    })();
  }
  // анимация текста при установке нового кода
  textSwitch(_x4, _x5) {
    var _this9 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (leaveText, enterText, type = 'forward') {
      const leaveAnim = _this9.animCtrl.create().addElement(leaveText.nativeElement).easing('ease-out').duration(400);
      const enterAnim = _this9.animCtrl.create().addElement(enterText.nativeElement).easing('ease-out').duration(400);
      if (type === 'back') {
        leaveAnim.keyframes([{
          offset: 0,
          opacity: 1,
          transform: 'translateX(0px)'
        }, {
          offset: 0.7,
          opacity: 1
        }, {
          offset: 1,
          opacity: 0,
          transform: 'translateX(250px)'
        }]);
        enterAnim.keyframes([{
          offset: 0,
          opacity: 0,
          transform: 'translateX(-250px)'
        }, {
          offset: 0.3,
          opacity: 0
        }, {
          offset: 1,
          opacity: 1,
          transform: 'translateX(0px)'
        }]);
      } else {
        leaveAnim.keyframes([{
          offset: 0,
          opacity: 1,
          transform: 'translateX(0px)'
        }, {
          offset: 0.7,
          opacity: 1
        }, {
          offset: 1,
          opacity: 0,
          transform: 'translateX(-250px)'
        }]);
        enterAnim.keyframes([{
          offset: 0,
          opacity: 0,
          transform: 'translateX(250px)'
        }, {
          offset: 0.3,
          opacity: 0
        }, {
          offset: 1,
          opacity: 1,
          transform: 'translateX(0px)'
        }]);
      }
      leaveAnim.play().catch(() => {});
      yield enterAnim.play();
    }).apply(this, arguments);
  }
  // анимация перехода к 3 этапу при установке нового кода
  pinRetry() {
    var _this0 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const anim = _this0.animCtrl.create().addElement(_this0.circle1.nativeElement).addElement(_this0.circle2.nativeElement).addElement(_this0.circle3.nativeElement).addElement(_this0.circle4.nativeElement).easing('ease-out').duration(200).keyframes([{
        offset: 0,
        transform: 'scale(1.0, 1.0)'
      }, {
        offset: 1,
        transform: 'scale(1.7, 1.7)'
      }]);
      const anim1 = _this0.animCtrl.create().addElement(_this0.circle1.nativeElement).easing('ease-out').duration(300)
      // .delay(100)
      .keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(57px) scale(1.4, 1.4)'
      }]);
      const anim2 = _this0.animCtrl.create().addElement(_this0.circle2.nativeElement).easing('ease-out').duration(300)
      // .delay(100)
      .keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(19px) scale(1.4, 1.4)'
      }]);
      const anim3 = _this0.animCtrl.create().addElement(_this0.circle3.nativeElement).easing('ease-out').duration(300)
      // .delay(100)
      .keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(-19px) scale(1.4, 1.4)'
      }]);
      const anim4 = _this0.animCtrl.create().addElement(_this0.circle4.nativeElement).easing('ease-out').duration(300)
      // .delay(100)
      .keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)'
      }, {
        offset: 1,
        transform: 'translateX(-57px) scale(1.4, 1.4)'
      }]);
      const anim5 = _this0.animCtrl.create().addElement(_this0.circle1.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(57px) scale(1.4, 1.4)',
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)',
        background: 'var(--ion-color-medium)',
        color: 'var(--ion-color-medium)'
      }]);
      const anim6 = _this0.animCtrl.create().addElement(_this0.circle2.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(19px) scale(1.4, 1.4)',
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)',
        background: 'var(--ion-color-medium)',
        color: 'var(--ion-color-medium)'
      }]);
      const anim7 = _this0.animCtrl.create().addElement(_this0.circle3.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(-19px) scale(1.4, 1.4)',
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)',
        background: 'var(--ion-color-medium)',
        color: 'var(--ion-color-medium)'
      }]);
      const anim8 = _this0.animCtrl.create().addElement(_this0.circle4.nativeElement).easing('ease-out').duration(300).delay(50).keyframes([{
        offset: 0,
        transform: 'translateX(-57px) scale(1.4, 1.4)',
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)'
      }, {
        offset: 1,
        transform: 'translateX(0px) scale(1, 1)',
        background: 'var(--ion-color-medium)',
        color: 'var(--ion-color-medium)'
      }]);
      _this0.taptic.notification({
        type: 'success'
      }).catch(() => {});
      yield anim.play();
      anim1.play().catch(() => {});
      anim2.play().catch(() => {});
      anim3.play().catch(() => {});
      yield anim4.play();
      _this0.pinCode = '';
      _this0.step = 2;
      _this0.textSwitch(_this0.text1, _this0.text2).catch(() => {});
      anim5.play().catch(() => {});
      anim6.play().catch(() => {});
      anim7.play().catch(() => {});
      yield anim8.play();
      anim1.stop();
      anim2.stop();
      anim3.stop();
      anim4.stop();
      anim5.stop();
      anim6.stop();
      anim7.stop();
      yield anim8.stop();
    })();
  }
  // анимация при вводе неверного кода
  pinFailed() {
    var _this1 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const anim = _this1.animCtrl.create().addElement(_this1.circle1.nativeElement).addElement(_this1.circle2.nativeElement).addElement(_this1.circle3.nativeElement).addElement(_this1.circle4.nativeElement).easing('ease-out').duration(500).keyframes([{
        offset: 0,
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)',
        transform: 'scale(1.0, 1.0)'
      }, {
        offset: 0.6,
        background: 'var(--ion-color-danger)',
        color: 'var(--ion-color-danger)',
        transform: 'scale(1.7, 1.7)'
      }, {
        offset: 0.62,
        background: 'var(--ion-color-danger)',
        color: 'var(--ion-color-danger)',
        transform: 'scale(1.7, 1.7)'
      }, {
        offset: 1,
        background: 'var(--ion-color-medium)',
        color: 'var(--ion-color-medium)',
        transform: 'scale(1.0, 1.0)'
      }]);
      _this1.taptic.notification({
        type: 'error'
      }).catch(() => {});
      anim.play().then(() => {
        anim.stop();
      });
      _this1.pinCode = '';
      if (_this1.step === 2) {
        _this1.step = 1;
      }
    })();
  }
  // анимация при вводе правильного кода
  pinSuccess() {
    var _this10 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (taptic = true) {
      if (taptic) {
        _this10.taptic.notification({
          type: 'success'
        }).catch(() => {});
      }
      const anim = _this10.animCtrl.create().addElement(_this10.circle1.nativeElement).addElement(_this10.circle2.nativeElement).addElement(_this10.circle3.nativeElement).addElement(_this10.circle4.nativeElement).easing('ease-out').duration(200).keyframes([{
        offset: 0,
        background: 'var(--ion-color-primary)',
        color: 'var(--ion-color-primary)',
        transform: 'scale(1.0, 1.0)'
      }, {
        offset: 1,
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)',
        transform: 'scale(1.7, 1.7)'
      }]);
      yield anim.play();
      const anim1 = _this10.animCtrl.create().addElement(_this10.circle1.nativeElement).easing('ease-out').duration(300).keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 0.8,
        transform: 'translateX(45px) scale(1.2, 1.2)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 1,
        transform: 'translateX(57px) scale(1.2, 1.2)',
        background: 'transparent',
        color: 'var(--ion-color-success)'
      }]);
      anim1.play().catch(() => {});
      const anim2 = _this10.animCtrl.create().addElement(_this10.circle2.nativeElement).easing('ease-out').duration(300).keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 0.8,
        transform: 'translateX(15px) scale(1.2, 1.2)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 1,
        transform: 'translateX(19px) scale(1.2, 1.2)',
        background: 'transparent',
        color: 'var(--ion-color-success)'
      }]);
      anim2.play().catch(() => {});
      const anim3 = _this10.animCtrl.create().addElement(_this10.circle3.nativeElement).easing('ease-out').duration(300).keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 0.8,
        transform: 'translateX(-15px) scale(1.2, 1.2)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 1,
        transform: 'translateX(-19px) scale(1.2, 1.2)',
        background: 'transparent',
        color: 'var(--ion-color-success)'
      }]);
      anim3.play().catch(() => {});
      const anim4 = _this10.animCtrl.create().addElement(_this10.circle4.nativeElement).easing('ease-out').duration(300).keyframes([{
        offset: 0,
        transform: 'translateX(0px) scale(1.7, 1.7)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 0.8,
        transform: 'translateX(-45px) scale(1.2, 1.2)',
        background: 'var(--ion-color-success)',
        color: 'var(--ion-color-success)'
      }, {
        offset: 1,
        transform: 'translateX(-57px) scale(1.2, 1.2)',
        background: 'transparent',
        color: 'var(--ion-color-success)'
      }]);
      yield anim4.play().catch(() => {});
      if (_this10.type === 'setCode' && _this10.step === 0) {
        anim.stop();
        anim1.stop();
        anim2.stop();
        anim3.stop();
        yield anim4.stop();
      }
      _this10.pinCode = '';
    }).apply(this, arguments);
  }
  openFaioModal() {
    var _this11 = this;
    return new Promise(resolve => {
      this.faio.isAvailable({
        requireStrongBiometrics: false
      }).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        const touchId = (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED
        })).value;
        if (touchId === null) {
          yield _this11.modalService.openModal({
            component: _bio_modal_bio_modal_page__WEBPACK_IMPORTED_MODULE_9__.BioModalPage,
            swipeToClose: true,
            presentingElement: yield _this11.modalService.modalCtrl.getTop(),
            type: 'card'
          }).then(modal => {
            modal.onDidDismiss().then(data => {
              resolve(data);
            });
          });
        } else {
          resolve(true);
        }
      })).catch(() => {
        resolve(true);
      });
    });
  }
  back() {
    var _this12 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this12.dismiss();
    })();
  }
  logout() {
    this.authService.logout(true).then(() => this.dismiss(false)).catch();
  }
  static {
    this.ctorParameters = () => [{
      type: _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_15__.FingerprintAIO
    }, {
      type: _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_5__.TapticEngine
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_17__.Platform
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_18__.AnimationController
    }, {
      type: _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_6__.TouchID
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_18__.AlertController
    }, {
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_7__.AuthenticationService
    }, {
      type: _services_status_bar_service__WEBPACK_IMPORTED_MODULE_8__.StatusBarService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_10__.ModalService
    }, {
      type: _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_11__.InAppAuthService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_19__.Router
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_17__.NavController
    }, {
      type: _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_14__.NativeStorage
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      circle1: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['circle1']
      }],
      circle2: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['circle2']
      }],
      circle3: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['circle3']
      }],
      circle4: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['circle4']
      }],
      text0: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['text0']
      }],
      text1: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['text1']
      }],
      text2: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['text2']
      }],
      type: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }],
      openSettings: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }]
    };
  }
};
PinCodePage = (0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_21__.Component)({
  selector: 'app-pin-code',
  template: _pin_code_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  providers: [_awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_5__.TapticEngine],
  styles: [(_pin_code_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], PinCodePage);


/***/ }),

/***/ 91544:
/*!**************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/create-modal-routing.module.ts ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CreateModalPageRoutingModule: () => (/* binding */ CreateModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _create_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-modal.page */ 58770);




const routes = [{
  path: '',
  component: _create_modal_page__WEBPACK_IMPORTED_MODULE_0__.CreateModalPage
}, {
  path: 'select-theme-modal',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_appeals_applications-form_create-modal_select-modal_select-modal_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./select-modal/select-modal.module */ 36550)).then(m => m.SelectModalPageModule)
}];
let CreateModalPageRoutingModule = class CreateModalPageRoutingModule {};
CreateModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], CreateModalPageRoutingModule);


/***/ }),

/***/ 8937:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/create-modal.module.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CreateModalPageModule: () => (/* binding */ CreateModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _create_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-modal-routing.module */ 91544);
/* harmony import */ var _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @awesome-cordova-plugins/camera/ngx */ 68782);
/* harmony import */ var _awesome_cordova_plugins_file_opener_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/file-opener/ngx */ 15173);
/* harmony import */ var _awesome_cordova_plugins_file_transfer_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/file-transfer/ngx */ 35353);
/* harmony import */ var _awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/file/ngx */ 66411);
/* harmony import */ var _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/preview-any-file/ngx */ 34505);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _create_modal_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./create-modal.page */ 58770);
/* harmony import */ var _custom_fields_custom_fields_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./custom-fields/custom-fields.component */ 17517);
/* harmony import */ var _components_input_field_input_field_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../../components/input-field/input-field.component */ 44529);
/* harmony import */ var _components_text_field_text_field_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../../components/text-field/text-field.component */ 10035);
/* harmony import */ var _components_file_field_file_field_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../../components/file-field/file-field.component */ 78665);
/* harmony import */ var _components_select_field_select_field_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../../../components/select-field/select-field.component */ 66433);
/* harmony import */ var _components_custom_item_custom_item_component__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../../../components/custom-item/custom-item.component */ 73133);
/* harmony import */ var _components_toggle_field_toggle_field_component__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../../../components/toggle-field/toggle-field.component */ 32413);
/* harmony import */ var _components_datetime_button_field_datetime_button_field_component__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../../../components/datetime-button-field/datetime-button-field.component */ 16929);
/* harmony import */ var _maskito_angular__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @maskito/angular */ 54483);
/* harmony import */ var _components_date_button_field_date_button_field_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../../../components/date-button-field/date-button-field.component */ 93389);
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../../../services/file.service */ 24704);
























let CreateModalPageModule = class CreateModalPageModule {};
CreateModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_17__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_18__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_19__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_20__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_21__.IonicModule, _create_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.CreateModalPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_20__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_22__.TranslateModule, _maskito_angular__WEBPACK_IMPORTED_MODULE_23__.MaskitoModule],
  declarations: [_create_modal_page__WEBPACK_IMPORTED_MODULE_6__.CreateModalPage, _custom_fields_custom_fields_component__WEBPACK_IMPORTED_MODULE_7__.CustomFieldsComponent, _components_custom_item_custom_item_component__WEBPACK_IMPORTED_MODULE_12__.CustomItemComponent, _components_input_field_input_field_component__WEBPACK_IMPORTED_MODULE_8__.InputFieldComponent, _components_text_field_text_field_component__WEBPACK_IMPORTED_MODULE_9__.TextFieldComponent, _components_file_field_file_field_component__WEBPACK_IMPORTED_MODULE_10__.FileFieldComponent, _components_select_field_select_field_component__WEBPACK_IMPORTED_MODULE_11__.SelectFieldComponent, _components_toggle_field_toggle_field_component__WEBPACK_IMPORTED_MODULE_13__.ToggleFieldComponent, _components_datetime_button_field_datetime_button_field_component__WEBPACK_IMPORTED_MODULE_14__.DatetimeButtonFieldComponent, _components_date_button_field_date_button_field_component__WEBPACK_IMPORTED_MODULE_15__.DateButtonFieldComponent],
  providers: [_awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_4__.File, _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_5__.PreviewAnyFile, _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_1__.Camera, _awesome_cordova_plugins_file_opener_ngx__WEBPACK_IMPORTED_MODULE_2__.FileOpener, _awesome_cordova_plugins_file_transfer_ngx__WEBPACK_IMPORTED_MODULE_3__.FileTransfer, _services_file_service__WEBPACK_IMPORTED_MODULE_16__.FileService]
})], CreateModalPageModule);


/***/ }),

/***/ 58770:
/*!****************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/create-modal.page.ts ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CreateModalPage: () => (/* binding */ CreateModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _create_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./create-modal.page.html?ngResource */ 82922);
/* harmony import */ var _create_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./create-modal.page.scss?ngResource */ 89808);
/* harmony import */ var _create_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_create_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/camera/ngx */ 68782);
/* harmony import */ var _awesome_cordova_plugins_file_opener_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/file-opener/ngx */ 15173);
/* harmony import */ var _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/preview-any-file/ngx */ 34505);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../../environments/settings */ 79308);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../services/helper.service */ 54102);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../../services/modal.service */ 5455);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../../services/request.service */ 80931);
/* harmony import */ var _info_info_page__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../info/info.page */ 40871);
/* harmony import */ var _services_file_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../../../services/file.service */ 24704);



















let CreateModalPage = class CreateModalPage {
  constructor(fileService, request, helper, fb, fileOpener, alertCtrl, cdr, modalService, translate, previewFiles, actionSheetCtrl, camera, destroyRef) {
    this.fileService = fileService;
    this.request = request;
    this.helper = helper;
    this.fb = fb;
    this.fileOpener = fileOpener;
    this.alertCtrl = alertCtrl;
    this.cdr = cdr;
    this.modalService = modalService;
    this.translate = translate;
    this.previewFiles = previewFiles;
    this.actionSheetCtrl = actionSheetCtrl;
    this.camera = camera;
    this.destroyRef = destroyRef;
    this.scrollPosTop = 0;
    this.scrollPosBottom = 0;
    this.allowedExtFiles = [..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_IMG.name, ..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_FILE.name].map(item => "." + item).join(",");
    this.alertExtFile = false;
    this.alertBrokenFile = false;
    this.alertSizeFile = false;
    this.alertMaxCountFiles = false;
    this.maxCountFiles = _environments_settings__WEBPACK_IMPORTED_MODULE_6__.MAX_FILE_COUNT_UPLOAD;
    this.treeCategoriesLoading = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(false);
    this.customFieldsLoading = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(false);
    this.orgCodesLoading = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(false);
    this.treeCategories = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
    this.categoryFiles = [];
    this.orgCodes = [];
    // выбранный регион (для неавторизованных)
    this.orgCode = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
    // выбранная категория
    this.category = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
    // выбранный вид обращения
    this.type = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
    // выбранный вопрос
    this.question = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
    this.templateDownloading$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_13__.signal)(false);
    this.counterFiles = 0;
    this.templateFileEntry = null;
    this.customFields = [];
  }
  scroll(event) {
    const scrollPos = this.form.nativeElement.clientHeight - this.content.el.clientHeight - event.detail.scrollTop;
    if ((scrollPos <= 16 || this.scrollPosBottom < 16) && !!this.submitBtn) {
      this.scrollPosBottom = scrollPos <= 16 ? scrollPos : 16;
      this.submitBtn.nativeElement.setAttribute('style', 'box-shadow: 0 0 24px rgba(104, 122, 147, min(' + this.scrollPosBottom / 100 + ', .16)); background: rgba(var(--ion-tab-bar-background-color-alternative), min(' + this.scrollPosBottom / 25 + ', .64));');
    }
    if (event.detail.scrollTop <= 24 || this.scrollPosTop < 24) {
      this.scrollPosTop = event.detail.scrollTop <= 24 ? event.detail.scrollTop : 24;
      this.toolbar.el.setAttribute('style', 'box-shadow: 0 0 40px rgba(104, 122, 147, min(' + event.detail.scrollTop / 50 + ', .48))');
    }
  }
  ngOnInit() {
    var _this = this;
    this.request.getRequest(this.request.uri.settingsEmailGet(), {
      background: true,
      onlyCacheOrRequest: true,
      preloader: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        // Вызываем функцию коллбэк
        yield _this.request.loadSettingsEmailCallback()(result);
        _this.credentials.get("email").value.next(_this.request.settingsEmail.value.email);
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
    this.request.getRequest(this.request.uri.lsInfoGet(), {
      preloader: false,
      onlyCacheOrRequest: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (response) {
        yield _this.request.loadLsInfoCallback(response);
        _this.credentials.get("contact").value.next(_this.request.lsInfo.value[_this.request.activeLs.value].fio);
        console.log(_this.credentials.get("contact").value.value);
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
    this.credentials = this.fb.group({
      category: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      type: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      question: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      contact: [this.request.lsInfo.value[this.request.activeLs.value] ? new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(this.request.lsInfo.value[this.request.activeLs.value].fio) : new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(""), [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      email: [new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(this.request.settingsEmail.value.email), [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      text: [new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(""), [_angular_forms__WEBPACK_IMPORTED_MODULE_14__.Validators.required]],
      files: [{}],
      customFields: [[]],
      orgCode: [String, ""]
    });
    if (!this.request.activeLs.value) {
      this.loadOrgCodes();
    } else {
      this.loadTreeCategories();
    }
    this.orgCode.subscribe(orgCode => {
      if (orgCode) {
        if (this.credentials.get("orgCode").value && this.credentials.get("orgCode").value !== orgCode['$nomerZapisi']) {
          this.category.next(null);
          this.type.next(null);
          this.question.next(null);
        }
        this.credentials.get("orgCode").setValue(orgCode['$nomerZapisi']);
        this.loadTreeCategories();
      }
    });
    // обработка изменения категории
    this.category.subscribe(category => {
      if (category) {
        if (this.credentials.get("category").value && this.credentials.get("category").value["$nomerZapisi"] !== category["$nomerZapisi"]) {
          this.type.next(null);
          this.question.next(null);
        }
        this.credentials.get("category").setValue(category);
      }
    });
    // обработка изменения вида обращения
    this.type.subscribe(type => {
      if (type) {
        if (this.credentials.get("type").value && this.credentials.get("type").value["$nomerZapisi"] !== type["$nomerZapisi"]) {
          this.question.next(null);
        }
        // Очищаем список категорий
        this.categoryFiles = [];
        // Заполняем список категорий из вида обращения
        this.categoryFiles.push(...type["kategoriiFaylov"]);
        // Если в виде не указаны категории, то отображаем 0-ю категорию (т.е. без категории)
        if (type["kategoriiFaylov"].length == 0) {
          this.categoryFiles.push({
            $etoPapka: false,
            $nomerZapisi: -1,
            $papka: null,
            nazvanie: "",
            obraschenievid: null,
            obyazatelnaya: 0,
            priznaki: 0
          });
        }
        // Создаем массивы файлов по категориям
        let catFiles = this.credentials.get("files").value;
        this.categoryFiles.forEach(cat => {
          if (!catFiles[cat.$nomerZapisi]) {
            catFiles[cat.$nomerZapisi] = [];
          }
        });
        this.credentials.get("files").setValue(catFiles);
        // Считаем сколько можно максимум прикрепить файлов. По 5 файлов в каждой категории
        this.maxCountFiles = this.categoryFiles.length * _environments_settings__WEBPACK_IMPORTED_MODULE_6__.MAX_FILE_COUNT_UPLOAD;
        // Считаем сколько файлов уже прикреплено в доступных категориях
        this.countFiles();
        this.credentials.get("type").setValue(type);
        // Очищаем объект шаблона
        this.templateFileEntry = null;
        setTimeout(() => {
          this.loadCustomFields();
        }, 0);
      }
    });
    // обработка изменения вопроса
    this.question.subscribe(question => {
      if (question !== undefined) {
        this.credentials.get("question").setValue(question);
        this.templateFileEntry = null;
        setTimeout(() => {
          this.loadCustomFields();
        }, 0);
      }
    });
  }
  /**
   * Проверяет значение 7 бита, который отвечает за возможность создания обращения
   */
  availableCreateAppeal() {
    if (this.credentials.get("type").value && this.credentials.get("type").value["priznaki"]) {
      return !(+(this.credentials.get("type").value["priznaki"] & 64) !== 0);
    } else {
      return false;
    }
  }
  loadTreeCategories() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this2.treeCategoriesLoading.value) {
        _this2.treeCategoriesLoading.next(true);
        _this2.request.getRequest(_this2.request.uri.applicationsFormTreeCategoriesGet(_this2.credentials.get("orgCode").value), {
          onlyCacheOrRequest: true,
          preloader: false
        }).subscribe({
          next: response => {
            _this2.treeCategoriesLoading.next(false);
            if (response.result) {
              const {
                data
              } = response;
              _this2.treeCategories.next(data);
            } else {
              (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                _this2.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_HEADER")),
                  message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_APPEALS_DATA")),
                  buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
                }).then(/*#__PURE__*/function () {
                  var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                    yield alert.present();
                    _this2.dismiss({
                      result: false
                    });
                  });
                  return function (_x3) {
                    return _ref4.apply(this, arguments);
                  };
                }());
              })();
            }
          },
          error: e => {
            _this2.treeCategoriesLoading.next(false);
          }
        });
      }
    })();
  }
  openTemplate(template) {
    // todo Если файл уже скачан, сделать открытие без повторной загрузки
    if (this.templateDownloading$()) {
      return;
    }
    if (this.templateFileEntry == null) {
      const uri = this.request.uri.applicationsFormDownloadTemplateGet(template.type, template.id);
      this.fileService.getFileWithUri(template.name, uri, this.destroyRef);
    }
    this.templateFileEntry.file(file => {
      this.fileOpener.open(this.templateFileEntry.nativeURL, file.type);
    });
  }
  getCategories() {
    if (!!this.treeCategories.value) {
      return Object.values(this.treeCategories.value.categories).map(item => {
        item['value'] = item['$nomerZapisi'].toString();
        return item;
      });
    } else {
      return [];
    }
  }
  /**
   * Возвращает список доступных видов обращений
   */
  getTypes() {
    if (!!this.category.value) {
      return Object.values(this.category.value["vidy"]).map(item => {
        item['value'] = item['$nomerZapisi'].toString();
        return item;
      });
    } else if (!!this.treeCategories.value && !!this.treeCategories.value.types) {
      return Object.values(this.treeCategories.value.types).map(item => {
        item['value'] = item['$nomerZapisi'].toString();
        return item;
      });
    }
  }
  /**
   * Возвращает список доступных вопросов
   */
  getQuestions() {
    if (!!this.type.value) {
      return Object.values(this.type.value["voprosy"]).map(item => {
        item['value'] = item['$nomerZapisi'].toString();
        return item;
      }) || [];
    } else {
      return [];
    }
  }
  /**
   * Загрузка кастомных полей
   */
  loadCustomFields() {
    if (!this.customFieldsLoading.value) {
      const appealTypeId = !!this.credentials.get("type").value ? this.credentials.get("type").value["$nomerZapisi"] : null;
      const appealQuestionId = !!this.credentials.get("question").value ? this.credentials.get("question").value["$nomerZapisi"] : null;
      if (!!appealTypeId) {
        this.customFieldsLoading.next(true);
        this.request.getRequest(this.request.uri.applicationFormGetCustomFields(appealTypeId, appealQuestionId), {
          onlyCacheOrRequest: true,
          preloader: false,
          useCache: false
        }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.finalize)(() => {
          this.customFieldsLoading.next(false);
        })).subscribe(response => {
          if (response.result) {
            response.data;
            this.customFields = response.data.map(field => {
              field.value = new rxjs__WEBPACK_IMPORTED_MODULE_12__.BehaviorSubject(null);
              return field;
            });
          }
        });
      }
    }
  }
  /**
   * Загрузка кодов внешних организаций (регионов, для неавторизованных)
   */
  loadOrgCodes() {
    if (!this.orgCodesLoading.value && !this.request.activeLs.value) {
      this.request.getRequest(this.request.uri.appealsOrgCodes(), {
        onlyCacheOrRequest: true,
        preloader: false,
        useCache: false
      }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.finalize)(() => {
        this.orgCodesLoading.next(false);
      })).subscribe(response => {
        if (response.result) {
          response.data;
          this.orgCodes = response.data.map(field => {
            field.value = null;
            return field;
          });
        }
      });
    }
  }
  fileEvent(ev, _filesCat) {
    var _this3 = this;
    let files = ev.target.files;
    let reader = new FileReader();
    reader.onerror = /*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_HEADER")),
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_GET_FILE")),
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
      }).then(/*#__PURE__*/function () {
        var _ref6 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
          yield alert.present();
        });
        return function (_x4) {
          return _ref6.apply(this, arguments);
        };
      }());
    });
    let i = 0;
    reader.onloadend = /*#__PURE__*/function () {
      var _ref7 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (evt) {
        let fileMimeType = null;
        let fileSize = 0;
        let fileBase64 = "";
        fileBase64 = evt.target["result"];
        if (typeof fileBase64 === "string") {
          fileMimeType = fileBase64.split(";")[0].split(":")[1];
        }
        let allFiles = _this3.credentials.get("files").value;
        if (fileMimeType == null || fileBase64 == "") {
          if (!_this3.alertBrokenFile) {
            _this3.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.FILE_IS_BROKEN")),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
            }).then(/*#__PURE__*/function () {
              var _ref8 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                alert.onDidDismiss().then(() => {
                  _this3.alertBrokenFile = false;
                });
                yield alert.present();
                _this3.alertBrokenFile = true;
              });
              return function (_x6) {
                return _ref8.apply(this, arguments);
              };
            }());
          }
        } else if ([..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_IMG.value, ..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_FILE.value].indexOf(fileMimeType) < 0) {
          if (!_this3.alertExtFile) {
            _this3.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.MIME_TYPE_FILE_FAIL"))) + "\n" + (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.MIME_TYPE_FILE"))) + [..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_IMG.name, ..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_FILE.name].join(", "),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
            }).then(/*#__PURE__*/function () {
              var _ref9 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                alert.onDidDismiss().then(() => {
                  _this3.alertExtFile = false;
                });
                yield alert.present();
                _this3.alertExtFile = true;
              });
              return function (_x7) {
                return _ref9.apply(this, arguments);
              };
            }());
          }
        } else {
          fileSize = files[i].size;
          if (fileSize > _environments_settings__WEBPACK_IMPORTED_MODULE_6__.MAX_FILE_SIZE_UPLOAD) {
            if (!_this3.alertSizeFile) {
              _this3.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.MAX_FILESIZE_FAIL", {
                  value: _environments_settings__WEBPACK_IMPORTED_MODULE_6__.MAX_FILE_SIZE_UPLOAD / 1024 / 1024 + "МБ"
                })),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
              }).then(/*#__PURE__*/function () {
                var _ref0 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                  alert.onDidDismiss().then(() => {
                    _this3.alertSizeFile = false;
                  });
                  yield alert.present();
                  _this3.alertSizeFile = true;
                });
                return function (_x8) {
                  return _ref0.apply(this, arguments);
                };
              }());
            }
          } else {
            allFiles[_filesCat.$nomerZapisi].push({
              name: files[i].name,
              mimeType: fileMimeType,
              size: fileSize,
              base64: fileBase64,
              preview: "img"
            });
            _this3.credentials.get("files").setValue(allFiles);
            _this3.countFiles();
            _this3.cdr.detectChanges();
          }
        }
        i++;
        if (files[i] !== undefined) {
          if (_this3.counterFiles >= _this3.maxCountFiles) {
            if (!_this3.alertMaxCountFiles) {
              _this3.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("ERROR_STRING.MAX_COUNT_FILES", {
                  value: _environments_settings__WEBPACK_IMPORTED_MODULE_6__.MAX_FILE_COUNT_UPLOAD
                })),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
              }).then(/*#__PURE__*/function () {
                var _ref1 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                  alert.onDidDismiss().then(() => {
                    _this3.alertMaxCountFiles = false;
                  });
                  yield alert.present();
                  _this3.alertMaxCountFiles = true;
                });
                return function (_x9) {
                  return _ref1.apply(this, arguments);
                };
              }());
            }
            _this3.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-file")[0].value = "";
            _this3.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-image")[0].value = "";
          } else {
            reader.readAsDataURL(files[i]);
          }
        } else {
          _this3.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-file")[0].value = "";
          _this3.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-image")[0].value = "";
        }
      });
      return function (_x5) {
        return _ref7.apply(this, arguments);
      };
    }();
    reader.readAsDataURL(files[i]);
  }
  openAddFile(_filesCat) {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!(0,_ionic_angular__WEBPACK_IMPORTED_MODULE_17__.isPlatform)("android")) {
        _this4.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-file")[0].click();
      } else {
        _this4.actionSheetCtrl.create({
          buttons: [{
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this4.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.CAMERA")),
            icon: "camera",
            handler: () => {
              _this4.camera.getPicture({
                quality: 20,
                destinationType: _this4.camera.DestinationType.DATA_URL,
                encodingType: _this4.camera.EncodingType.PNG,
                mediaType: _this4.camera.MediaType.PICTURE,
                sourceType: _this4.camera.PictureSourceType.CAMERA
              }).then(data => {
                let allFiles = _this4.credentials.get("files").value;
                allFiles[_filesCat.$nomerZapisi].push({
                  name: "ph_" + Math.round(Math.random() * 1000) + ".png",
                  mimeType: "image/png",
                  size: data.length / 4 * 3,
                  base64: "data:image/png;base64," + data,
                  preview: "img"
                });
                _this4.credentials.get("files").setValue(allFiles);
                _this4.countFiles();
                _this4.cdr.detectChanges();
              }).catch(err => {});
            }
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this4.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.IMAGE")),
            icon: "images",
            handler: () => _this4.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-image")[0].click()
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this4.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_ADD_ACTION.FILE")),
            icon: "document",
            handler: () => _this4.attachments.nativeElement.getElementsByClassName("cat_" + _filesCat.$nomerZapisi)[0].getElementsByClassName("add-file")[0].click()
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this4.translate.get("BUTTONS.CANCEL")),
            role: "cancel"
          }]
        }).then(actionSheet => {
          actionSheet.present();
        });
      }
    })();
  }
  removeFile(ev, _filesCat, _file) {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this5.alertCtrl.create({
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this5.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILE_REMOVE")),
        buttons: [{
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this5.translate.get("BUTTONS.NO")),
          role: "cancel"
        }, {
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this5.translate.get("BUTTONS.YES")),
          handler: () => {
            let files = _this5.credentials.get("files").value[_filesCat.$nomerZapisi];
            files.splice(files.indexOf(_file), 1);
            _this5.countFiles();
          }
        }]
      }).then(alert => {
        alert.present();
      });
      ev.stopPropagation();
    })();
  }
  /**
   * Функция проводит валидацию полей и при необходимости отображает сообщение
   */
  validateForm() {
    var _this6 = this;
    if (!!this.credentials.get("category").value && this.credentials.get("category").value["$etoPapka"] == false && !this.credentials.get("type").value) {
      this.credentials.get("type").setValue(this.credentials.get("category").value);
    }
    return new Promise(/*#__PURE__*/function () {
      var _ref10 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve, reject) {
        if (!_this6.credentials.get("question").value && !!_this6.credentials.get("type").value["voprosy"] && Object.values(_this6.credentials.get("type").value["voprosy"]).length > 0) {
          _this6.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.QUESTION.PLACEHOLDER")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
          }).then(alert => {
            alert.present();
          });
          reject();
        } else if (_this6.credentials.get("contact").value.value == "") {
          _this6.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.CONTACT.ERROR")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
          }).then(alert => {
            alert.present();
          });
          reject();
        } else if (_this6.credentials.get("email").value.value == "" || !RegExp(/[\S]+\@[\S]+\.[\S]+/).test(_this6.credentials.get("email").value.value)) {
          _this6.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.EMAIL.ERROR")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
          }).then(alert => {
            alert.present();
          });
          reject();
        } else if (_this6.credentials.get("text").value.value == "") {
          _this6.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.TEXT.ERROR")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
          }).then(alert => {
            alert.present();
          });
          reject();
        } else {
          for (const cat of _this6.categoryFiles) {
            if (!!cat.obyazatelnaya && _this6.credentials.get("files").value[cat.$nomerZapisi].length == 0) {
              _this6.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.FILES_REQUIRED")),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
              }).then(alert => {
                alert.present();
              });
              reject();
              return;
            }
          }
          if (!_this6.validateCustomFields()) {
            _this6.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("ERROR_STRING.VALIDATE_ERROR")),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this6.translate.get("BUTTONS.OK"))]
            }).then(alert => {
              alert.present();
            });
            reject();
            return;
          }
          resolve();
        }
      });
      return function (_x0, _x1) {
        return _ref10.apply(this, arguments);
      };
    }());
  }
  validateCustomFields() {
    for (let i = 0; i < this.customFields.length; i++) {
      if (this.customFields[i].maska.length > 0) {
        if (!!this.customFields[i].obyazatelnoe || this.customFields[i].value.value != "" && this.customFields[i].value.value != null) {
          if (!RegExp(this.customFields[i].maska).test(this.customFields[i].value.value)) {
            return false;
          }
        }
      }
      if (!!this.customFields[i].obyazatelnoe && !this.customFields[i].value.value) {
        return false;
      }
    }
    return true;
  }
  createAppeal() {
    var _this7 = this;
    this.validateForm().then(() => {
      let messageFiles = {};
      this.categoryFiles.forEach(cat => {
        messageFiles[cat.$nomerZapisi] = [];
        this.credentials.get("files").value[cat.$nomerZapisi].forEach(file => {
          messageFiles[cat.$nomerZapisi].push({
            name: file.name,
            base64File: file.base64.split("base64,")[1]
          });
        });
      });
      let params = {};
      if (!!this.credentials.get("orgCode").value) params = {
        ...params,
        appealOrgCode: this.credentials.get('orgCode').value
      };
      if (!!this.credentials.get("category").value) params = {
        ...params,
        appealCategory: this.credentials.get("category").value["$nomerZapisi"]
      };
      if (!!this.credentials.get("type").value) params = {
        ...params,
        appealType: this.credentials.get("type").value["$nomerZapisi"]
      };
      if (!!this.credentials.get("question").value) params = {
        ...params,
        appealQuestion: this.credentials.get("question").value["$nomerZapisi"]
      };
      params = {
        ...params,
        appealFIO: this.credentials.get("contact").value.value,
        appealEmail: this.credentials.get("email").value.value,
        appealText: this.credentials.get("text").value.value,
        appealFiles: messageFiles,
        appealCustom: this.customFields,
        appealOrgCode: this.credentials.get("orgCode").value.value ?? ""
      };
      this.request.postRequest(this.request.uri.applicationsFormCreatePost(), params, {
        useCache: false,
        forceUpdateCache: true
      }).subscribe(response => {
        if (response.result) {
          let description = this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATED.DESCRIPTION");
          let textBtn = this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATED.BUTTON");
          if (!response.fileUpload && response.messageFiles) {
            description += `<p class='color-danger'>${response.messageFiles}</p>`;
            textBtn = this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATED.BUTTON_SHOW");
          }
          this.modalService.openModal({
            component: _info_info_page__WEBPACK_IMPORTED_MODULE_10__.InfoPage,
            componentProps: {
              icon: "ApplicationCreated",
              header: this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATED.HEADER"),
              description: description,
              textBtn: textBtn,
              taptic: "success"
            }
          }).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
            if (!response.fileUpload && response.messageFiles) _this7.dismiss({
              id: response.id,
              result: true
            });else _this7.dismiss({
              result: true
            });
            if (_this7.request.activeLs.value) {
              yield _this7.request.invalidateCacheGroup('surveys:' + _this7.request.activeLs.value);
              // Выполняем запрос на обновление опросов и кол-ва непрочитанных
              _this7.request.getRequest(_this7.request.uri.surveysGet(), {
                preloader: false,
                cacheGroup: 'surveys:' + _this7.request.activeLs.value,
                onlyCacheOrRequest: true
              }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_16__.finalize)(() => {})).subscribe(/*#__PURE__*/function () {
                var _ref12 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
                  yield _this7.request.loadSurveysCallback()(result);
                });
                return function (_x10) {
                  return _ref12.apply(this, arguments);
                };
              }());
            }
          }));
        } else {
          this.modalService.openModal({
            component: _info_info_page__WEBPACK_IMPORTED_MODULE_10__.InfoPage,
            componentProps: {
              icon: "ApplicationCreateFailed",
              header: this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATE_FAILED.HEADER"),
              description: response.message || this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATE_FAILED.DESCRIPTION"),
              textBtn: this.translate.instant("APPEALS.APPLICATIONS_FORM_PAGE.CREATE_PAGE.APPEAL_CREATE_FAILED.BUTTON"),
              taptic: "failed"
            }
          });
        }
      });
    }, () => {});
  }
  dismiss() {
    var _this8 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (value = {
      result: false
    }) {
      yield _this8.modal.dismiss(value);
    }).apply(this, arguments);
  }
  previewError(file) {
    file.preview = "file";
  }
  openPreview(file) {
    if (file.base64) {
      this.previewFiles.previewBase64(file.base64, {
        name: file.name.replaceAll(/\s/g, "_")
      }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_18__.catchError)(err => {
        console.error(err);
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_19__.of)(null);
      })).subscribe();
    }
  }
  /**
   * Подсчет количества прикрепленных файлов в доступных категориях
   */
  countFiles() {
    let countFiles = 0;
    this.categoryFiles.forEach(cat => {
      countFiles += this.credentials.get("files").value[cat.$nomerZapisi].length;
    });
    this.counterFiles = countFiles;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_file_service__WEBPACK_IMPORTED_MODULE_11__.FileService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_9__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_7__.HelperService
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_14__.UntypedFormBuilder
    }, {
      type: _awesome_cordova_plugins_file_opener_ngx__WEBPACK_IMPORTED_MODULE_4__.FileOpener
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_20__.AlertController
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ChangeDetectorRef
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_8__.ModalService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_21__.TranslateService
    }, {
      type: _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_5__.PreviewAnyFile
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_20__.ActionSheetController
    }, {
      type: _awesome_cordova_plugins_camera_ngx__WEBPACK_IMPORTED_MODULE_3__.Camera
    }, {
      type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.DestroyRef
    }];
  }
  static {
    this.propDecorators = {
      toolbar: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['toolbar']
      }],
      content: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['content']
      }],
      form: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['form']
      }],
      orgCodeField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['orgCodeField']
      }],
      categoryField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['categoryField']
      }],
      typeField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['typeField']
      }],
      questionField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['questionField']
      }],
      attachments: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ["attachments"]
      }],
      submitBtn: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['submitBtn']
      }]
    };
  }
};
CreateModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_13__.Component)({
  selector: "app-create-modal",
  template: _create_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_create_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CreateModalPage);


/***/ }),

/***/ 17517:
/*!************************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/custom-fields/custom-fields.component.ts ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomFieldsComponent: () => (/* binding */ CustomFieldsComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _custom_fields_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./custom-fields.component.html?ngResource */ 6559);
/* harmony import */ var _custom_fields_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./custom-fields.component.scss?ngResource */ 23017);
/* harmony import */ var _custom_fields_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_custom_fields_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _maskito_kit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @maskito/kit */ 45869);
/* harmony import */ var _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../../services/phone-mask.service */ 10449);






const postfix = ' ₽';
const getMaskitoOptions = decimalZeroPadding => (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_2__.maskitoNumberOptionsGenerator)({
  decimalZeroPadding,
  postfix,
  decimalSeparator: ',',
  min: 0,
  max: 999999.99,
  precision: 2
});
const {
  plugins,
  postprocessors,
  ...numberOptions
} = getMaskitoOptions(false);
let CustomFieldsComponent = class CustomFieldsComponent {
  constructor() {
    this.decimalZeroPadding = false;
    // Объединение собственных и генерируемых настроек маски
    this.maskitoOptions = {
      ...numberOptions,
      postprocessors: [...postprocessors, ({
        value,
        selection
      }, initialElementState) => {
        const [from, to] = selection;
        const noRepeatedLeadingZeroesValue = value.replace(/^0+/, '0');
        const removedCharacters = value.length - noRepeatedLeadingZeroesValue.length;
        return {
          value: noRepeatedLeadingZeroesValue,
          // User types "000000" => 0|
          selection: [Math.max(from - removedCharacters, 0), Math.max(to - removedCharacters, 0)]
        };
      }],
      plugins: [...plugins,
      // Forbids caret to be placed after postfix
      (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_2__.maskitoCaretGuard)(value => [0, value.length - ' ₽'.length]), (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_2__.maskitoEventHandler)('blur', element => {
        if (element.value === postfix) {
          element.value = `0${postfix}`;
        }
      })]
    };
    this.validateFunction = value => {
      if (this.params.maska.length > 0) {
        if (!!this.params.obyazatelnoe || value != "") {
          return RegExp(this.params.maska).test(value);
        } else {
          return true;
        }
      } else {
        return true;
      }
    };
    this.maskPhone = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_3__.maskPhone;
  }
  ngOnInit() {}
  /**
   * Обработчик, который удаляет или добавляет нули после запятой в зависимости от наличия запятой
   *
   * @param event
   * @param value
   * @protected
   */
  handleBeforeInput(event, value) {
    const {
      inputType,
      target,
      data
    } = event;
    const getNotEmptySelection = ([from, to], isForward) => {
      if (from !== to) {
        return [from, to];
      }
      return isForward ? [from, to + 1] : [Math.max(from - 1, 0), to];
    };
    if (inputType.includes('delete')) {
      const element = target;
      const [from, to] = getNotEmptySelection([element.selectionStart || 0, element.selectionEnd || 0], inputType.includes('Forward'));
      const dotWasRemoved = value.value.slice(from, to).includes(',');
      this.decimalZeroPadding = this.decimalZeroPadding && !dotWasRemoved;
      if (!this.decimalZeroPadding && dotWasRemoved && value.value.slice(to, to + 2) != '00') {
        this.decimalZeroPadding = true;
      }
      if (!this.decimalZeroPadding && dotWasRemoved) {
        element.value = value.value.slice(0, from);
      }
    } else {
      try {
        this.decimalZeroPadding = ['.', ',', 'б', 'ю'].some(sep => data?.includes(sep) || value.value.includes(sep));
      } catch (e) {}
    }
    const {
      plugins,
      postprocessors,
      ...numberOptions
    } = getMaskitoOptions(this.decimalZeroPadding);
    this.maskitoOptions = {
      ...numberOptions,
      postprocessors: [...postprocessors, ({
        value,
        selection
      }, initialElementState) => {
        const [from, to] = selection;
        const noRepeatedLeadingZeroesValue = value.replace(/^0+/, '0');
        const removedCharacters = value.length - noRepeatedLeadingZeroesValue.length;
        return {
          value: noRepeatedLeadingZeroesValue,
          // User types "000000" => 0|
          selection: [Math.max(from - removedCharacters, 0), Math.max(to - removedCharacters, 0)]
        };
      }],
      plugins: [...plugins,
      // Forbids caret to be placed after postfix
      (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_2__.maskitoCaretGuard)(value => [0, value.length - ' ₽'.length]), (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_2__.maskitoEventHandler)('blur', element => {
        if (element.value === postfix) {
          element.value = `0${postfix}`;
        }
      })]
    };
  }
  getItems() {
    return this.params.vozmozhnyeZnacheniya.split(';').map(name => {
      return {
        nazvanie: name,
        value: name
      };
    });
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      params: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
      }]
    };
  }
};
CustomFieldsComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-custom-fields',
  template: _custom_fields_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_custom_fields_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], CustomFieldsComponent);


/***/ }),

/***/ 20629:
/*!***************************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/select-modal/select-modal-page.component.ts ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectModalPage: () => (/* binding */ SelectModalPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _select_modal_page_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select-modal-page.component.html?ngResource */ 22503);
/* harmony import */ var _select_modal_page_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./select-modal-page.component.scss?ngResource */ 31763);
/* harmony import */ var _select_modal_page_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_select_modal_page_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_search_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../services/search.service */ 12186);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../../services/helper.service */ 54102);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 3920);







let SelectModalPage = class SelectModalPage {
  constructor(helper) {
    this.helper = helper;
    this.multiply = false;
    this.multiplyCount = null;
    this.customItem = false;
    this.customValue = '';
    this.customCheckbox = false;
    this.searchbar = false;
    this.required = false;
    this.value = '';
    this.filteredItems = [];
    this.workingSelectedItems = [];
  }
  ngOnInit() {
    this.filteredItems = [...this.items];
    this.workingSelectedItems = this.value && this.value[this.displayField] ? this.value[this.displayField].split('; ') : [];
    this.checkCountChecked();
  }
  search(_event) {
    const value = _event.target.value || '';
    if (value == '') {
      this.filteredItems = [...this.items];
    } else {
      const searchedNameByBigrams = _services_search_service__WEBPACK_IMPORTED_MODULE_2__.SearchService.searchBigrams(value, this.items, this.displayField, 0.2);
      const searchedNameByLevenshtein = _services_search_service__WEBPACK_IMPORTED_MODULE_2__.SearchService.searchLevenshtein(value, this.items, this.displayField, 0.2);
      const searchedNameByDefault = this.items.filter(item => {
        return item[this.displayField].toLowerCase().indexOf(value.toLowerCase()) > -1;
      });
      this.filteredItems = this.helper.arrayUnique([...searchedNameByBigrams, ...searchedNameByDefault, ...searchedNameByLevenshtein], 'value');
    }
  }
  trackItems(index, item) {
    return item.value;
  }
  selectItem(item) {
    this.modal.dismiss(item);
  }
  isChecked(value) {
    return this.workingSelectedItems.find(item => item === value);
  }
  handle(ev) {
    const {
      checked,
      value
    } = ev.detail;
    if (checked) {
      this.workingSelectedItems = [...this.workingSelectedItems, value];
    } else {
      this.workingSelectedItems = this.workingSelectedItems.filter(item => item != value);
    }
    this.checkCountChecked();
  }
  checkCountChecked() {
    setTimeout(() => {
      if (!!this.multiplyCount && (this.customCheckbox ? this.workingSelectedItems.length + 1 : this.workingSelectedItems.length) >= this.multiplyCount) {
        const checkboxes = this.content.el.querySelectorAll('ion-checkbox:not(.checkbox-checked)');
        checkboxes.forEach(checkbox => {
          checkbox.closest('ion-item').disabled = true;
        });
      } else {
        const ionItems = this.content.el.querySelectorAll('ion-item[aria-disabled=true]');
        if (ionItems.length > 0) {
          ionItems.forEach(ionItem => {
            ionItem.disabled = false;
          });
        }
      }
    }, 50);
  }
  handleCustomValueInput(ev) {
    if (!!ev.data && !this.customValue) {
      this.customCheckbox = true;
      this.checkCountChecked();
    }
  }
  handleCustomValueBlur() {
    if (!this.customValue) {
      this.customCheckbox = false;
      this.checkCountChecked();
    }
  }
  dismiss(state) {
    if (state !== null) {
      let response = {
        value: this.workingSelectedItems.join('; ')
      };
      if (this.customItem && !!this.customValue && !!this.customValue.trim() && this.customCheckbox) {
        response['customValue'] = new _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicSafeString(this.customValue.trim()).value;
      }
      this.modal.dismiss(response);
    } else {
      this.modal.dismiss();
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }];
  }
  static {
    this.propDecorators = {
      title: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      multiply: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      multiplyCount: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      customItem: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      customValue: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      customCheckbox: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      searchbar: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      items: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      displayField: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      required: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      value: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      content: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.ViewChild,
        args: ['content']
      }]
    };
  }
};
SelectModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
  selector: 'app-select-modal',
  template: _select_modal_page_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_select_modal_page_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], SelectModalPage);


/***/ }),

/***/ 55527:
/*!******************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/appointment-routing.module.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentPageRoutingModule: () => (/* binding */ AppointmentPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _appointment_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./appointment.page */ 81545);




const routes = [{
  path: '',
  component: _appointment_page__WEBPACK_IMPORTED_MODULE_0__.AppointmentPage
}, {
  path: 'choose-date',
  loadChildren: () => __webpack_require__.e(/*! import() */ "common").then(__webpack_require__.bind(__webpack_require__, /*! ./choose-date/choose-date.module */ 62256)).then(m => m.ChooseDatePageModule)
}, {
  path: 'choose-time',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_appeals_appointment_choose-time_choose-time_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./choose-time/choose-time.module */ 21724)).then(m => m.ChooseTimePageModule)
}];
let AppointmentPageRoutingModule = class AppointmentPageRoutingModule {};
AppointmentPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AppointmentPageRoutingModule);


/***/ }),

/***/ 86966:
/*!**********************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/appointment.module.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentPageModule: () => (/* binding */ AppointmentPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _appointment_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./appointment-routing.module */ 55527);
/* harmony import */ var _appointment_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./appointment.page */ 81545);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! swiper/angular */ 72443);
/* harmony import */ var _maskito_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @maskito/angular */ 54483);










let AppointmentPageModule = class AppointmentPageModule {};
AppointmentPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _appointment_routing_module__WEBPACK_IMPORTED_MODULE_0__.AppointmentPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule, swiper_angular__WEBPACK_IMPORTED_MODULE_8__.SwiperModule, _maskito_angular__WEBPACK_IMPORTED_MODULE_9__.MaskitoModule],
  declarations: [_appointment_page__WEBPACK_IMPORTED_MODULE_1__.AppointmentPage]
})], AppointmentPageModule);


/***/ }),

/***/ 81545:
/*!********************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/appointment.page.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentPage: () => (/* binding */ AppointmentPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _appointment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./appointment.page.html?ngResource */ 89875);
/* harmony import */ var _appointment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./appointment.page.scss?ngResource */ 8857);
/* harmony import */ var _appointment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_appointment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var swiper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! swiper */ 36705);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../services/modal.service */ 5455);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _choose_data_choose_data_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../choose-data/choose-data.page */ 77853);
/* harmony import */ var _choose_date_choose_date_page__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./choose-date/choose-date.page */ 65707);
/* harmony import */ var _choose_time_choose_time_page__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./choose-time/choose-time.page */ 65092);
/* harmony import */ var _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../services/phone-mask.service */ 10449);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../services/helper.service */ 54102);
/* harmony import */ var _info_info_page__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../info/info.page */ 40871);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 5342);

















swiper__WEBPACK_IMPORTED_MODULE_3__["default"].use([swiper__WEBPACK_IMPORTED_MODULE_3__.Pagination, _ionic_angular__WEBPACK_IMPORTED_MODULE_12__.IonicSlides]);
let AppointmentPage = class AppointmentPage {
  constructor(request, helper, alertCtrl, modalService, modalController, translate) {
    this.request = request;
    this.helper = helper;
    this.alertCtrl = alertCtrl;
    this.modalService = modalService;
    this.modalController = modalController;
    this.translate = translate;
    this.showPrevButton = false;
    this.showSendButton = false;
    this.maskPhone = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_9__.maskPhone;
    this.maskPredicate = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_9__.maskPredicate;
  }
  ionViewDidEnter() {
    var _this = this;
    this.ls.el.value = this.request.activeLs.value;
    this.fio.el.value = this.request.lsInfo.value[this.request.activeLs.value].fio;
    this.request.getRequest(this.request.uri.settingsEmailGet(), {
      preloader: false,
      onlyCacheOrRequest: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        // Вызываем функцию коллбэк
        yield _this.request.loadSettingsEmailCallback()(result);
        _this.email.el.value = _this.request.settingsEmail.value.email;
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
    this.request.getRequest(this.request.uri.settingsPhoneGet(), {
      preloader: false,
      onlyCacheOrRequest: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        // Вызываем функцию коллбэк
        yield _this.request.loadSettingsPhoneCallback()(result);
        _this.phone.el.value = _this.request.settingsPhone.value.phone;
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  dismiss() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.modal.dismiss();
    })();
  }
  setSwiperInstance(swiper) {
    this.swiper = swiper;
  }
  chooseSubdivisions() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.request.getRequest(_this3.request.uri.appointmentGetSubdivisions(), {
        onlyCacheOrRequest: true
      }).subscribe(/*#__PURE__*/function () {
        var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          if (result.result) {
            result.data.map(item => {
              item.name = item['название'];
              item.description = item['адрес'];
              return item;
            });
            const modal = yield _this3.modalService.openModal({
              component: _choose_data_choose_data_page__WEBPACK_IMPORTED_MODULE_6__.ChooseDataPage,
              cssClass: 'top-modal',
              type: 'card',
              componentProps: {
                title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this3.translate.get('APPEALS.APPOINTMENT_FORM_PAGE.SUBDIVISION.TITLE_MODAL')),
                data: result.data
              },
              presentingElement: yield _this3.modalController.getTop()
            });
            modal.onDidDismiss().then(data => {
              _this3.subdivision = data.data ?? _this3.subdivision;
            });
          }
        });
        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      }());
    })();
  }
  chooseTheme() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this4.request.getRequest(_this4.request.uri.appointmentGetTheme(), {
        onlyCacheOrRequest: true
      }).subscribe(/*#__PURE__*/function () {
        var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          if (result.result) {
            result.data.map(item => {
              item.name = item['название'];
              return item;
            });
            const modal = yield _this4.modalService.openModal({
              component: _choose_data_choose_data_page__WEBPACK_IMPORTED_MODULE_6__.ChooseDataPage,
              cssClass: 'top-modal',
              type: 'card',
              componentProps: {
                title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this4.translate.get('APPEALS.APPOINTMENT_FORM_PAGE.THEME.TITLE_MODAL')),
                data: result.data
              },
              presentingElement: yield _this4.modalController.getTop()
            });
            modal.onDidDismiss().then(data => {
              _this4.theme = data.data ?? _this4.theme;
            });
          }
        });
        return function (_x4) {
          return _ref4.apply(this, arguments);
        };
      }());
    })();
  }
  chooseDate() {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this5.request.getRequest(_this5.request.uri.appointmentGetDate(_this5.subdivision.id), {
        useCache: false
      }).subscribe(/*#__PURE__*/function () {
        var _ref5 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          if (result.result) {
            _this5.dates = result.data;
            const modal = yield _this5.modalService.openModal({
              component: _choose_date_choose_date_page__WEBPACK_IMPORTED_MODULE_7__.ChooseDatePage,
              cssClass: 'top-modal',
              type: 'card',
              componentProps: {
                data: Object.keys(_this5.dates)
              },
              presentingElement: yield _this5.modalController.getTop()
            });
            modal.onDidDismiss().then(data => {
              _this5.date = data.data ?? _this5.date;
              _this5.time = '';
              _this5.errorMessage = '';
            });
          }
        });
        return function (_x5) {
          return _ref5.apply(this, arguments);
        };
      }());
    })();
  }
  chooseTime() {
    var _this6 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this6.date) return;
      const modal = yield _this6.modalService.openModal({
        component: _choose_time_choose_time_page__WEBPACK_IMPORTED_MODULE_8__.ChooseTimePage,
        cssClass: 'top-modal',
        type: 'card',
        componentProps: {
          data: _this6.dates[_this6.date.value],
          old: _this6.time ? _this6.dates[_this6.date.value].indexOf(_this6.time) : Math.floor(_this6.dates[_this6.date.value].length / 2)
        },
        presentingElement: yield _this6.modalController.getTop()
      });
      modal.onDidDismiss().then(data => {
        _this6.time = data.data ?? _this6.time;
        _this6.errorMessage = '';
      });
    })();
  }
  prevStep() {
    var _this7 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this7.errorMessage = '';
      var currentIndex = _this7.swiper.activeIndex;
      if (currentIndex == 1) _this7.showPrevButton = false;
      if (currentIndex == 3) _this7.showSendButton = false;
      _this7.swiper.slidePrev();
    })();
  }
  nextStep() {
    var _this8 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var currentIndex = _this8.swiper.activeIndex;
      switch (currentIndex) {
        case 0:
          if (!_this8.subdivision?.name) {
            yield _this8.presentAlert();
            return;
          }
          _this8.showPrevButton = true;
          break;
        case 1:
          if (!_this8.theme?.name) {
            yield _this8.presentAlert();
            return;
          }
          break;
        case 2:
          if (!_this8.fio.el.value || !_this8.phone.el.value || !_this8.email.el.value) {
            yield _this8.presentAlert();
            return;
          }
          _this8.showSendButton = true;
          break;
        case 3:
          if (_this8.date && _this8.time) _this8.send();else {
            yield _this8.presentAlert();
            return;
          }
      }
      _this8.swiper.slideNext();
    })();
  }
  presentAlert() {
    var _this9 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this9.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this9.translate.get("ERROR_STRING.ATTENTION_HEADER")),
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this9.translate.get("APPEALS.APPOINTMENT_FORM_PAGE.ALERT")),
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this9.translate.get("BUTTONS.OK"))]
      }).then(alert => {
        alert.present();
      });
    })();
  }
  send() {
    var _this0 = this;
    var data = {
      subdivision: this.subdivision.id,
      theme: this.theme.id,
      comment: this.comment.el.value,
      ls: this.ls.el.value,
      fio: this.fio.el.value,
      phone: this.phone.el.value,
      email: this.email.el.value,
      date: `${this.date.value}T${this.time}:00`
    };
    this.request.postRequest(this.request.uri.appointmentRecording(), data, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref6 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        if (result.result) {
          const alert = yield _this0.modalService.openModal({
            component: _info_info_page__WEBPACK_IMPORTED_MODULE_11__.InfoPage,
            componentProps: {
              icon: 'Calendar',
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this0.translate.get('APPEALS.APPOINTMENT_FORM_PAGE.SUCCESS_HEADER')),
              description: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this0.translate.get('APPEALS.APPOINTMENT_FORM_PAGE.SUCCESS_TEXT', {
                date: _this0.date.name,
                time: _this0.time
              })),
              textBtn: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this0.translate.get('APPEALS.APPOINTMENT_FORM_PAGE.SUCCESS_BUTTON'))
            }
          });
          alert.onDidDismiss().then(() => {
            _this0.dismiss();
          });
        } else {
          _this0.errorMessage = result.message;
        }
      });
      return function (_x6) {
        return _ref6.apply(this, arguments);
      };
    }());
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_5__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_10__.HelperService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.AlertController
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.ModalController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      comment: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewChild,
        args: ['comment']
      }],
      ls: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewChild,
        args: ['ls']
      }],
      fio: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewChild,
        args: ['fio']
      }],
      phone: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewChild,
        args: ['phone']
      }],
      email: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewChild,
        args: ['email']
      }]
    };
  }
};
AppointmentPage = (0,tslib__WEBPACK_IMPORTED_MODULE_17__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_16__.Component)({
  selector: 'app-appointment',
  template: _appointment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_16__.ViewEncapsulation.None,
  styles: [(_appointment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AppointmentPage);


/***/ }),

/***/ 65707:
/*!********************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/choose-date/choose-date.page.ts ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChooseDatePage: () => (/* binding */ ChooseDatePage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _choose_date_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./choose-date.page.html?ngResource */ 12453);
/* harmony import */ var _choose_date_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./choose-date.page.scss?ngResource */ 80519);
/* harmony import */ var _choose_date_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_choose_date_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/helper.service */ 54102);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 5342);








let ChooseDatePage = class ChooseDatePage {
  constructor(translate, helper) {
    this.translate = translate;
    this.helper = helper;
    this.isLoadCalendar = false;
    this.isAccessibleDay = dateString => {
      return this.data.includes(dateString);
    };
  }
  ngOnInit() {
    this.highlightedDates = this.data.map(item => {
      return {
        date: item,
        textColor: 'var(--ion-color-primary)',
        backgroundColor: 'var(--ion-color-primary-lighten-4)'
      };
    });
  }
  ionViewDidEnter() {
    var styles = this.calendar.el.shadowRoot.styleSheets;
    var styleSheets = styles[styles.length - 1];
    var currentRulesLength = styleSheets.cssRules.length;
    styleSheets.insertRule(" .calendar-month-year { margin-left: -16px }", currentRulesLength++);
    styleSheets.insertRule(" ion-label { margin: 0; font-weight: 500; font-size: 20px!important; }", currentRulesLength++);
    styleSheets.insertRule(" ion-label::first-letter { text-transform: uppercase; }", currentRulesLength++);
    styleSheets.insertRule(" ion-icon { color: var(--custom-nav-btn-color)!important; width: 24px; height: 24px; }", currentRulesLength++);
    styleSheets.insertRule(" .calendar-days-of-week { margin-top: 8px; }", currentRulesLength++);
    styleSheets.insertRule(" .calendar-day { font-size: 16px!important; }", currentRulesLength++);
    styleSheets.insertRule(" .calendar-day-active { color: var(--custom-color-white)!important; }", currentRulesLength++);
    styleSheets.insertRule(" .calendar-day-active .calendar-day-highlight { opacity: 1!important; } ", currentRulesLength++);
    styleSheets.insertRule(" .picker-before { background: red!important; }", currentRulesLength++);
    styleSheets.insertRule(" ion-picker-internal { background: rgba(var(--background-rgb, var(--ion-background-color-rgb, 255, 255, 255)), 0.8); }", currentRulesLength++);
    this.isLoadCalendar = true;
  }
  dismiss() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data = null) {
      if (data) data = {
        name: yield _this.parseDate(),
        value: data
      };
      _this.modal.dismiss(data);
    }).apply(this, arguments);
  }
  chooseDate(event) {
    const value = event.target.value.slice(0, 10);
    this.pickedDate = this.isAccessibleDay(value) ? value : '';
  }
  parseDate() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const mass = _this2.pickedDate.split('-');
      let month = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_4__.lastValueFrom)(_this2.translate.get(_this2.helper.months[Number(mass[1]) - 1]));
      month = month.replace('{{value}}', '');
      return `${mass[2]} ${month} ${mass[0]}`;
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_5__.TranslateService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }];
  }
  static {
    this.propDecorators = {
      data: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      calendar: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: ['calendar']
      }]
    };
  }
};
ChooseDatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-choose-date',
  template: _choose_date_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_choose_date_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ChooseDatePage);


/***/ }),

/***/ 65092:
/*!********************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/choose-time/choose-time.page.ts ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChooseTimePage: () => (/* binding */ ChooseTimePage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _choose_time_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./choose-time.page.html?ngResource */ 11073);
/* harmony import */ var _choose_time_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./choose-time.page.scss?ngResource */ 18403);
/* harmony import */ var _choose_time_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_choose_time_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var swiper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! swiper */ 36705);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 3920);







swiper__WEBPACK_IMPORTED_MODULE_3__["default"].use([_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.IonicSlides, swiper__WEBPACK_IMPORTED_MODULE_3__.EffectCoverflow]);
let ChooseTimePage = class ChooseTimePage {
  constructor() {
    this.slidesOptions = {
      direction: "vertical",
      centeredSlides: true,
      slidesPerView: 9,
      effect: "coverflow",
      coverflowEffect: {
        rotate: 10,
        stretch: -10,
        slideShadows: false
      }
    };
  }
  ngOnInit() {}
  setSwiperInstance(swiper) {
    this.swiper = swiper;
    this.swiper.slideTo(this.old);
  }
  slideChange() {
    this.pickedTime = this.swiper.activeIndex;
  }
  dismiss() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data = null) {
      if (data !== null) data = _this.data[data];
      _this.modal.dismiss(data);
    }).apply(this, arguments);
  }
  static {
    this.ctorParameters = () => [];
  }
  static {
    this.propDecorators = {
      data: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }],
      old: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.Input
      }]
    };
  }
};
ChooseTimePage = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
  selector: 'app-choose-time',
  template: _choose_time_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_5__.ViewEncapsulation.None,
  styles: [(_choose_time_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ChooseTimePage);


/***/ }),

/***/ 75651:
/*!******************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/survey/survey.page.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveyPage: () => (/* binding */ SurveyPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _survey_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./survey.page.html?ngResource */ 95217);
/* harmony import */ var _survey_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./survey.page.scss?ngResource */ 82655);
/* harmony import */ var _survey_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_survey_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var swiper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! swiper */ 36705);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../services/modal.service */ 5455);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../../services/request.service */ 80931);
/* harmony import */ var _info_info_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../info/info.page */ 40871);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 5342);












swiper__WEBPACK_IMPORTED_MODULE_3__["default"].use([swiper__WEBPACK_IMPORTED_MODULE_3__.Pagination, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicSlides]);
let SurveyPage = class SurveyPage {
  constructor(modalService, translate, request) {
    this.modalService = modalService;
    this.translate = translate;
    this.request = request;
    this.surveyList = [];
    this.surveyStatus = 0;
    this.currentIndex = 0;
    this.currentQuestion = {};
    this.canSave = false;
    this.showPrevButton = false;
    this.showSendButton = false;
    this.isDisabled = true;
  }
  ngOnInit() {}
  //Получение вопросов
  ionViewDidEnter() {
    var _this = this;
    this.request.postRequest(this.data.appeal ? this.request.uri.surveysQuestionGet() : this.request.uri.surveysNewQuestionGet(), this.data, {
      useCache: false
    }).subscribe({
      next: function () {
        var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          result.data.filter(item => {
            if (item['тип'] === undefined) {
              let type = _this.getTypeField(item);
              item['тип'] = item[type];
            }
            if (item['@ответ'] && item['тип'] == 3) {
              item['@ответ'] = item['@ответ'].replace(/(\r\n|\n|\r)/gm, "");
              if (item['@ответ'][item['@ответ'].length - 1] == ';') item['@ответ'] = item['@ответ'].substring(0, item['@ответ'].length - 1);
              item['результат'] = item['@ответ'].split(';');
            }
            if (item['@ответ'] && item['тип'] == 1) {
              item['@ответ'] === 'Да' ? item['результат'] = '0' : '1';
            }
            if (item['тип'] === 3) {
              let tmp = '';
              if (item['результат']) {
                if (item['варианты']) {
                  item['результат'] = item['результат'].filter(item2 => {
                    if (item2.trim() !== '') {
                      if (item['варианты'].indexOf(item2) > -1) {
                        tmp += '1';
                      } else {
                        tmp += '0';
                      }
                      return item2;
                    }
                  });
                  tmp = tmp.split('').reverse().join('');
                  item['temp'] = tmp;
                  item['json_результатЧислом'] !== undefined ?? _this.convertToDecimal(tmp);
                }
              }
            }
            if (item['json_результатЧислом'] !== undefined && item['temp'] === undefined) {
              item['temp'] = _this.convertToBinary(+item['json_результатЧислом']).split('').reverse();
            }
            return item;
          });
          _this.survey = result.data;
          _this.surveyStatus = +result.status;
          _this.surveyList.push(result.data[0]);
          _this.canSave = result.canSave;
          _this.getFirstQuestion();
        });
        return function next(_x) {
          return _ref.apply(this, arguments);
        };
      }(),
      error: error => {
        this.dismiss(false);
      }
    });
  }
  //Получить первый не отвеченный вопрос по принципу реального прохождения от начала
  getFirstQuestion() {
    this.currentIndex = 0;
    this.currentQuestion = this.surveyList[this.currentIndex];
    if (this.surveyStatus != 2) {
      for (var i = 0; i < this.survey.length; i++) {
        if (+this.currentQuestion['статус'] === 1 && this.currentQuestion['результат'].length > 0) {
          this.currentQuestion = this.nextStep();
          i = this.currentIndex;
        } else {
          this.currentIndex = i;
          break;
        }
      }
    }
    this.isDisabled = this.currentQuestion['результат'].length === 0 && this.surveyStatus != 2;
  }
  //Получить имя поля тип
  getTypeField(item) {
    if (item['тип'] !== undefined) return 'тип';else if (item['результат-вопрос>тип'] !== undefined) return 'результат-вопрос>тип';else return 'вопрос-состав>тип';
  }
  dismiss(success) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.surveyStatus != 2) {
        _this2.send(false);
        return;
      }
      yield _this2.modal.dismiss(success);
    })();
  }
  setSwiperInstance(swiper) {
    this.swiper = swiper;
  }
  swiperChange() {
    if (!this.currentQuestion['результат']) this.currentQuestion['результат'] = '';
    this.isDisabled = this.surveyList[this.swiper.activeIndex]['результат'].length === 0 && this.surveyStatus != 2;
  }
  prevStep() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.errorMessage = '';
      _this3.swiper.slidePrev();
      _this3.surveyList.pop();
      if (_this3.surveyList.length == 1) _this3.showPrevButton = false;
      _this3.showSendButton = false;
      _this3.currentIndex = _this3.swiper.activeIndex;
      _this3.showCloseButton = _this3.survey.indexOf(_this3.currentQuestion) + 1 == _this3.survey.length && _this3.surveyStatus == 2;
    })();
  }
  nextStep() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this4.currentIndex = _this4.swiper.activeIndex;
      _this4.currentQuestion = _this4.surveyList[_this4.currentIndex];
      // Если текущий вопрос предусматривает ответ да/нет от которого зависит следующий вопрос, но ответ не дан
      if (_this4.currentQuestion['тип'] === 1 && !_this4.currentQuestion['результат'] && _this4.currentQuestion['переходда'] && _this4.currentQuestion['переходнет']) return;
      let index = _this4.survey.indexOf(_this4.currentQuestion);
      _this4.survey[index] = _this4.currentQuestion;
      // Если это последний вопрос, то сохраняем ответы
      if (index + 1 == _this4.survey.length) return _this4.send(true);
      // Определяем следующий вопрос
      var nextQuestion = _this4.survey[index + 1];
      if (_this4.currentQuestion['переходда'] && _this4.currentQuestion['переходнет']) {
        const searchID = _this4.currentQuestion['результат'] == '1' ? _this4.currentQuestion['переходнет'] : _this4.currentQuestion['переходда'];
        var searchQuestion = _this4.survey.filter(item => {
          return item['идсостав'] == searchID;
        }).pop();
        if (searchQuestion) nextQuestion = searchQuestion;
      }
      _this4.surveyList.push(nextQuestion);
      // Переходим на следующий слайд и отображаем нужные кнопки
      setTimeout(() => {
        _this4.swiper.slideNext();
        _this4.showPrevButton = _this4.surveyList.length > 1;
        _this4.showSendButton = _this4.survey.indexOf(nextQuestion) + 1 == _this4.survey.length;
        _this4.showCloseButton = _this4.survey.indexOf(nextQuestion) + 1 == _this4.survey.length && _this4.surveyStatus == 2;
      }, 100);
    })();
  }
  setVariable_0(question, variable) {
    if (question.editable == false) return;
    question['результат'] = variable;
    this.isDisabled = !question['результат'];
  }
  setVariable_3(question, variable, $event) {
    if (question['признакивыбора'] === 0 || question['признакивыбора'] === 2) {
      question['результат'] = variable;
      this.isDisabled = !question['результат'];
    } else {
      if (variable != null || variable != '') question['результат'].push(variable);
      question['результат'] = question['результат'].filter(item => {
        return item != variable || $event.detail.checked;
      });
      question['temp'] = [];
      question['варианты'].map(item => {
        question['temp'].push(question['результат'].indexOf(item) > -1 ? 1 : 0);
      });
      question['temp'] = question['temp'].reverse().join('');
      question['json_результатЧислом'] = this.convertToDecimal(question['temp']);
      this.checkMulti(question);
    }
    delete question['temp'];
  }
  //Конвертировать 10 в 2
  convertToBinary(number) {
    let num = number;
    let binary = (num % 2).toString();
    for (; num > 1;) {
      num = parseInt(String(num / 2));
      binary = num % 2 + binary;
    }
    return binary;
  }
  //Конвертировать 2 в 10
  convertToDecimal(number) {
    var persRet = 0;
    for (var i = 0; i < number.length; i++) {
      persRet += number[i] * Math.pow(2, number.length - 1 - i);
    }
    return persRet;
  }
  send(isDone = true) {
    var _this5 = this;
    let tempSurvey = this.surveyList;
    if (tempSurvey === undefined) return;
    let answer = tempSurvey.map(item => {
      switch (item[this.getTypeField(item)]) {
        case 0:
          {
            item['результат']--;
            if (item['результат'] < 0) item['результат'] = ''; //при отсутствии выбора варианта сохраняется -1
            break;
          }
        case 3:
          {
            if (item['признакивыбора'] == 0 || item['признакивыбора'] == 2) {
              item['json_результатЧислом'] = item['варианты'].indexOf(item['результат']);
            }
            item['результат'] = '';
            break;
          }
      }
      if (item['варианты'] !== undefined) {
        if (Array.isArray(item['варианты'])) {
          item['варианты'] = item['варианты'].join(';');
        }
      }
      if (item['editable'] !== undefined) {
        delete item['editable'];
      }
      if (item['свойвариант'] !== undefined) {
        delete item['свойвариант'];
      }
      if (item['temp'] !== undefined) {
        delete item['temp'];
      }
      return item;
    });
    var data = {
      survey: this.data.survey,
      appeal: this.data.appeal ?? -1,
      data: JSON.stringify(answer),
      isDone: isDone
    };
    this.request.postRequest(data.appeal !== -1 ? this.request.uri.surveysSaveQuestion() : this.request.uri.surveysSaveNewQuestion(), data, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        _this5.modal.dismiss(true, true);
        if (result.result) {
          if (isDone) {
            _this5.surveyStatus = 2;
            const alert = yield _this5.modalService.openModal({
              component: _info_info_page__WEBPACK_IMPORTED_MODULE_6__.InfoPage,
              componentProps: {
                icon: 'Thank',
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this5.translate.get('APPEALS.SURVEYS_FORM_PAGE.SURVEY.SUCCESS_HEADER')),
                description: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this5.translate.get('APPEALS.SURVEYS_FORM_PAGE.SURVEY.SUCCESS_TEXT')),
                textBtn: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this5.translate.get('APPEALS.SURVEYS_FORM_PAGE.SURVEY.SUCCESS_BUTTON'))
              }
            });
            alert.onDidDismiss().then(data => {
              _this5.dismiss(true);
            });
          }
          _this5.request.getRequest(_this5.request.uri.surveysNewCountGet(), {
            preloader: false,
            onlyCacheOrRequest: false
          }).subscribe(response => {
            _this5.request.accountLsSurveysCallback(response);
          });
        } else {
          _this5.errorMessage = result.message;
        }
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  changeText(event) {
    this.isDisabled = event.detail.value.length === 0;
  }
  changeRadio(event) {
    this.isDisabled = event.length === 0;
  }
  changeMulti(event, value) {}
  changeMultiComment(event, question) {
    question['json_свойвариант'] = event.detail.value;
    this.checkMulti(question);
  }
  checkMulti(question) {
    if (!question['json_свойвариант']) question['json_свойвариант'] = '';
    if (!question['json_результатЧислом']) question['json_результатЧислом'] = 0;
    this.isDisabled = question['json_свойвариант'].length === 0 && question['json_результатЧислом'] === 0;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__.TranslateService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_5__.RequestService
    }];
  }
  static {
    this.propDecorators = {
      data: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_10__.Input
      }],
      comment: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ViewChild,
        args: ['comment']
      }]
    };
  }
};
SurveyPage = (0,tslib__WEBPACK_IMPORTED_MODULE_11__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_10__.Component)({
  selector: 'app-survey',
  template: _survey_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  encapsulation: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ViewEncapsulation.None,
  styles: [(_survey_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SurveyPage);


/***/ }),

/***/ 26955:
/*!**********************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/surveys-routing.module.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveysPageRoutingModule: () => (/* binding */ SurveysPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _surveys_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveys.page */ 22109);




const routes = [{
  path: '',
  component: _surveys_page__WEBPACK_IMPORTED_MODULE_0__.SurveysPage
}, {
  path: 'survey',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_appeals_surveys_survey_survey_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./survey/survey.module */ 33176)).then(m => m.SurveyPageModule)
}];
let SurveysPageRoutingModule = class SurveysPageRoutingModule {};
SurveysPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SurveysPageRoutingModule);


/***/ }),

/***/ 59466:
/*!**************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/surveys.module.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveysPageModule: () => (/* binding */ SurveysPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _surveys_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveys-routing.module */ 26955);
/* harmony import */ var _surveys_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./surveys.page */ 22109);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! swiper/angular */ 72443);









let SurveysPageModule = class SurveysPageModule {};
SurveysPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _surveys_routing_module__WEBPACK_IMPORTED_MODULE_0__.SurveysPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule, swiper_angular__WEBPACK_IMPORTED_MODULE_8__.SwiperModule],
  declarations: [_surveys_page__WEBPACK_IMPORTED_MODULE_1__.SurveysPage]
})], SurveysPageModule);


/***/ }),

/***/ 22109:
/*!************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/surveys.page.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SurveysPage: () => (/* binding */ SurveysPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _surveys_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./surveys.page.html?ngResource */ 11615);
/* harmony import */ var _surveys_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./surveys.page.scss?ngResource */ 92309);
/* harmony import */ var _surveys_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_surveys_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../services/modal.service */ 5455);
/* harmony import */ var _survey_survey_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./survey/survey.page */ 75651);










let SurveysPage = class SurveysPage {
  constructor(request, modalService) {
    this.request = request;
    this.modalService = modalService;
    this.loading$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.signal)(false);
  }
  ngOnInit() {}
  ionViewWillEnter() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this.loading$()) {
        _this.timerLoad = setTimeout(() => {
          _this.loading$.set(true);
        }, 100);
        _this.loadData(true, true).finally(() => {
          clearTimeout(_this.timerLoad);
          _this.loading$.set(false);
        });
      }
    })();
  }
  doRefresh(_event) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.request.invalidateCacheGroup('surveys:' + _this2.request.activeLs.value);
      _this2.loadData(_event, false).finally(() => {
        if (_this2.infiniteScroll) {
          _this2.infiniteScroll.disabled = false;
        }
        _this2.refresher = null;
        _event.target.complete();
      });
      _this2.refresher = _event.target;
    })();
  }
  loadData(event, init) {
    var _this3 = this;
    return new Promise(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        if (_this3.refresher) {
          _this3.refresher.complete();
          _this3.refresher = null;
        }
        let disabledCache = false;
        if (event && !init) {
          disabledCache = event.type !== 'ionInfinite';
        }
        if (disabledCache) {
          yield _this3.request.invalidateCacheGroup('surveys:' + _this3.request.activeLs.value);
        }
        // Выполняем запрос
        _this3.request.getRequest(_this3.request.uri.surveysGet(), {
          preloader: false,
          cacheGroup: 'surveys:' + _this3.request.activeLs.value,
          onlyCacheOrRequest: !init
        }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.finalize)(() => {
          resolve(true);
        })).subscribe(/*#__PURE__*/function () {
          var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
            yield _this3.request.loadSurveysCallback()(result);
          });
          return function (_x2) {
            return _ref2.apply(this, arguments);
          };
        }());
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  openSurvey(survey) {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      var data = {
        appeal: survey['Аудитория-Обращение'],
        survey: survey.row_id,
        questionary: survey['Анкета-Опрос'],
        status: survey['Статус']
      };
      var modal = yield _this4.modalService.openModal({
        component: _survey_survey_page__WEBPACK_IMPORTED_MODULE_5__.SurveyPage,
        cssClass: 'fullscreen-modal top-modal',
        backdropDismiss: false,
        swipeToClose: false,
        componentProps: {
          data
        }
      });
      modal.onDidDismiss().then(data => {
        if (data.data) _this4.loadData(true, true);
      });
    })();
  }
  object() {
    return Object;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }];
  }
  static {
    this.propDecorators = {
      infiniteScroll: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild,
        args: [_ionic_angular__WEBPACK_IMPORTED_MODULE_8__.IonInfiniteScroll]
      }]
    };
  }
};
SurveysPage = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-surveys',
  template: _surveys_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_surveys_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SurveysPage);


/***/ }),

/***/ 43530:
/*!*******************************************************************!*\
  !*** ./src/app/pages/tabs/main/bind-ls/bind-ls-routing.module.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BindLsPageRoutingModule: () => (/* binding */ BindLsPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _bind_ls_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bind-ls.page */ 88316);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _bind_ls_page__WEBPACK_IMPORTED_MODULE_0__.BindLsPage
}];
let BindLsPageRoutingModule = class BindLsPageRoutingModule {};
BindLsPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], BindLsPageRoutingModule);


/***/ }),

/***/ 45491:
/*!***********************************************************!*\
  !*** ./src/app/pages/tabs/main/bind-ls/bind-ls.module.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BindLsPageModule: () => (/* binding */ BindLsPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _bind_ls_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bind-ls-routing.module */ 43530);
/* harmony import */ var _bind_ls_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bind-ls.page */ 88316);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let BindLsPageModule = class BindLsPageModule {};
BindLsPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _bind_ls_routing_module__WEBPACK_IMPORTED_MODULE_0__.BindLsPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_bind_ls_page__WEBPACK_IMPORTED_MODULE_1__.BindLsPage]
})], BindLsPageModule);


/***/ }),

/***/ 88316:
/*!*********************************************************!*\
  !*** ./src/app/pages/tabs/main/bind-ls/bind-ls.page.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BindLsPage: () => (/* binding */ BindLsPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _bind_ls_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bind-ls.page.html?ngResource */ 97984);
/* harmony import */ var _bind_ls_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bind-ls.page.scss?ngResource */ 87352);
/* harmony import */ var _bind_ls_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_bind_ls_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _services_http_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../services/http.service */ 56722);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../services/helper.service */ 54102);
/* harmony import */ var _info_info_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../info/info.page */ 40871);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../services/modal.service */ 5455);
/* harmony import */ var _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/taptic-engine/ngx */ 8287);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var inputmask__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! inputmask */ 80416);
/* harmony import */ var inputmask__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(inputmask__WEBPACK_IMPORTED_MODULE_9__);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */

















let BindLsPage = class BindLsPage {
  constructor(http, navCtrl, router, alertCtrl, helper, request, modalService, tapticEngine, platform, fb, translate) {
    this.http = http;
    this.navCtrl = navCtrl;
    this.router = router;
    this.alertCtrl = alertCtrl;
    this.helper = helper;
    this.request = request;
    this.modalService = modalService;
    this.tapticEngine = tapticEngine;
    this.platform = platform;
    this.fb = fb;
    this.translate = translate;
    this.amount = 0;
    this.bindingMethod = 'amount';
    this.availableByPu = false;
    this.numberConfig = {
      radixPoint: ',',
      inputtype: 'text',
      digits: "2",
      groupSeparator: " ",
      allowMinus: false,
      min: "0",
      max: "999 999,99",
      placeholder: ""
    };
  }
  ngOnInit() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.credentials = _this.fb.group({
        ls: [''],
        name: [''],
        amount: [_this.helper.paySumFormate(_this.amount, false, '*.*')],
        pu: ['']
      });
      _this.request.getRequest(_this.request.uri.bindAvailableByPuGet(), {
        onlyCacheOrRequest: true
      }).subscribe(result => {
        _this.request.cache(_this.request.uri.bindAvailableByPuGet(), result);
        _this.availableByPu = result.result;
      });
    })();
  }
  ionViewDidEnter() {
    new (inputmask__WEBPACK_IMPORTED_MODULE_9___default())("decimal", this.numberConfig).mask(this.inputAmount.el.querySelector('input'));
  }
  changeBindingMethod() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.availableByPu) {
        _this2.helper.showActionSheet({
          type: 'select',
          title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this2.translate.get('MAIN.BIND_LS_MODAL.BIND_TYPE.TITLE')),
          buttons: [{
            title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this2.translate.get('MAIN.BIND_LS_MODAL.BIND_TYPE.AMOUNT')),
            value: 'amount'
          }, {
            title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this2.translate.get('MAIN.BIND_LS_MODAL.BIND_TYPE.PU')),
            value: 'pu'
          }],
          value: _this2.bindingMethod
        }).then(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
            if (result) {
              _this2.bindingMethod = result.value;
            }
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }());
      }
    })();
  }
  maskSum(ev) {
    this.amount = +this.credentials.get('amount').value.split(' ').join('').split(',').join('.');
  }
  inputBlur(ev) {
    if (ev.target.value == '') {
      ev.target.value = '0';
    }
    const valueSum = this.credentials.get('amount').value.split(' ').join('').split(',').join('.');
    this.credentials.get('amount').setValue(this.helper.paySumFormate(valueSum, false));
  }
  bindLs() {
    var _this3 = this;
    let value = '';
    if (this.bindingMethod === 'amount') {
      value = this.credentials.get('amount').value;
    } else if (this.bindingMethod === 'pu') {
      value = this.credentials.get('pu').value;
    }
    const params = {
      ls: this.ls.value,
      type: this.bindingMethod,
      value,
      name: this.name.value,
      confirm: 'yes'
    };
    this.request.postRequest(this.request.uri.bindLsPost(), params, {
      useCache: false,
      background: true
    }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.catchError)(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (err) {
        _this3.tapticEngine.notification({
          type: 'error'
        }).catch(() => {});
        _this3.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_HEADER_TEHNIK")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("MAIN.BIND_LS_MODAL.BIND_ERROR")),
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
        }).then(alert => {
          alert.present().then(() => {});
        });
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_12__.of)(null);
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }()), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.filter)(value => value !== null)).subscribe(result => {
      if (result.result) {
        this.request.getRequest(this.request.uri.bindingsGet(), {
          forceUpdateCache: true
        }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.catchError)(/*#__PURE__*/function () {
          var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (err) {
            _this3.tapticEngine.notification({
              type: 'error'
            }).catch(() => {});
            _this3.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_HEADER_TEHNIK")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("MAIN.BIND_LS_MODAL.BIND_LOAD_ERROR")),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
            }).then(alert => {
              alert.present().then(() => {});
            });
            return (0,rxjs__WEBPACK_IMPORTED_MODULE_12__.of)(null);
          });
          return function (_x3) {
            return _ref3.apply(this, arguments);
          };
        }()), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.filter)(value => value !== null)).subscribe(/*#__PURE__*/function () {
          var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
            // Вызываем функцию коллбэк
            yield _this3.request.loadBindingsCallback(data);
            if (_this3.request.bindings.value[_this3.ls.value]) {
              _this3.request.setActiveLS(+_this3.ls.value).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                _this3.modalService.openModal({
                  component: _info_info_page__WEBPACK_IMPORTED_MODULE_6__.InfoPage,
                  componentProps: {
                    icon: 'BindingHome',
                    header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("MAIN.BIND_LS_MODAL.BIND_SUCCESS_HEADER")),
                    description: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("MAIN.BIND_LS_MODAL.BIND_SUCCESS_TEXT", {
                      value: _this3.ls.value
                    })),
                    taptic: 'success'
                  }
                }).then(modal => {
                  modal.onWillDismiss().then(() => {
                    _this3.navCtrl.navigateRoot('tabs/main', {
                      replaceUrl: true
                    });
                  });
                });
                _this3.dismiss({
                  result: true,
                  ls: _this3.ls.value
                }).catch(() => {});
              }));
            } else {
              _this3.tapticEngine.notification({
                type: 'error'
              }).catch(() => {});
              _this3.alertCtrl.create({
                header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ERROR_HEADER_TEHNIK")),
                message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("MAIN.BIND_LS_MODAL.BIND_LOAD_ERROR")),
                buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
              }).then(alert => {
                alert.present().then(() => {});
              });
              _this3.dismiss({
                result: true,
                ls: _this3.ls.value
              }).catch(() => {});
            }
          });
          return function (_x4) {
            return _ref4.apply(this, arguments);
          };
        }());
      } else {
        this.tapticEngine.notification({
          type: 'warning'
        }).catch(() => {});
        this.errorMessage = result.message;
      }
    });
  }
  dismiss() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (value = {
      result: false,
      ls: ''
    }) {
      yield _this4.modal.dismiss(value);
    }).apply(this, arguments);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_http_service__WEBPACK_IMPORTED_MODULE_3__.HttpService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.NavController
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_15__.Router
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_16__.AlertController
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_5__.HelperService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_7__.ModalService
    }, {
      type: _awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_8__.TapticEngine
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.Platform
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormBuilder
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_18__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      ls: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_19__.ViewChild,
        args: ['ls']
      }],
      name: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_19__.ViewChild,
        args: ['name']
      }],
      inputAmount: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_19__.ViewChild,
        args: ['inputAmount']
      }],
      inputPu: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_19__.ViewChild,
        args: ['inputPu']
      }]
    };
  }
};
BindLsPage = (0,tslib__WEBPACK_IMPORTED_MODULE_20__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_19__.Component)({
  selector: 'app-bind-ls',
  template: _bind_ls_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  providers: [_awesome_cordova_plugins_taptic_engine_ngx__WEBPACK_IMPORTED_MODULE_8__.TapticEngine],
  styles: [(_bind_ls_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], BindLsPage);


/***/ }),

/***/ 46117:
/*!*************************************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/description/description.page.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DescriptionPage: () => (/* binding */ DescriptionPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _description_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./description.page.html?ngResource */ 48439);
/* harmony import */ var _description_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./description.page.scss?ngResource */ 64367);
/* harmony import */ var _description_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_description_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../services/helper.service */ 54102);
/* harmony import */ var _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/keyboard/ngx */ 18532);
/* harmony import */ var _info_info_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../info/info.page */ 40871);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../services/modal.service */ 5455);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */











let DescriptionPage = class DescriptionPage {
  constructor(request, helper, keyboard, modalService) {
    this.request = request;
    this.helper = helper;
    this.keyboard = keyboard;
    this.modalService = modalService;
    this.ls = undefined;
  }
  ngOnInit() {
    if (!this.ls) {
      this.ls = this.request.activeLs.value;
    }
  }
  ionViewDidEnter() {
    this.input.setFocus();
  }
  ionViewWillLeave() {
    this.keyboard.hide();
  }
  updateLs() {
    var _this = this;
    const params = {
      name: this.input.value
    };
    this.request.postRequest(this.request.uri.updateBindLsPost(this.ls), params, {
      useCache: false
    }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.catchError)(err => {
      this.modalService.openModal({
        component: _info_info_page__WEBPACK_IMPORTED_MODULE_6__.InfoPage,
        componentProps: {
          icon: 'NotBindingHome',
          header: 'Техническая ошибка',
          description: 'Из-за технической ошибки не удалось добавить примечание. Повторите попытку позже'
        }
      }).then(() => {});
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.of)(null);
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.filter)(value => value !== null)).subscribe(result => {
      if (result.result) {
        this.request.getRequest(this.request.uri.bindingsGet(), {
          forceUpdateCache: true
        }).subscribe(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
            // Вызываем функцию коллбэк
            yield _this.request.loadBindingsCallback(data);
            _this.dismiss(true);
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }());
      } else {
        this.modalService.openModal({
          component: _info_info_page__WEBPACK_IMPORTED_MODULE_6__.InfoPage,
          componentProps: {
            icon: 'NotBindingHome',
            header: 'Не удалось добавить примечание',
            description: result.message
          }
        }).then(() => {});
      }
    });
  }
  dismiss(value = false) {
    this.modal.dismiss(value);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__.Keyboard
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_7__.ModalService
    }];
  }
  static {
    this.propDecorators = {
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['input']
      }],
      ls: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }]
    };
  }
};
DescriptionPage = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-description',
  template: _description_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_description_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], DescriptionPage);


/***/ }),

/***/ 51634:
/*!*******************************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/ls-info-routing.module.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsInfoPageRoutingModule: () => (/* binding */ LsInfoPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ls_info_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ls-info.page */ 27124);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _ls_info_page__WEBPACK_IMPORTED_MODULE_0__.LsInfoPage
}, {
  path: 'description',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_main_ls-info_description_description_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./description/description.module */ 56642)).then(m => m.DescriptionPageModule)
}];
let LsInfoPageRoutingModule = class LsInfoPageRoutingModule {};
LsInfoPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], LsInfoPageRoutingModule);


/***/ }),

/***/ 47195:
/*!***********************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/ls-info.module.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsInfoPageModule: () => (/* binding */ LsInfoPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ls_info_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ls-info-routing.module */ 51634);
/* harmony import */ var _ls_info_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ls-info.page */ 27124);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../pipes/active-ls/active-ls */ 61863);
/* harmony import */ var _pipes_address_address__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../pipes/address/address */ 35403);
/* harmony import */ var _pipes_fio_fio__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../pipes/fio/fio */ 54171);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */











let LsInfoPageModule = class LsInfoPageModule {};
LsInfoPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.IonicModule, _ls_info_routing_module__WEBPACK_IMPORTED_MODULE_0__.LsInfoPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__.TranslateModule, _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__.ActiveLsPipe, _pipes_address_address__WEBPACK_IMPORTED_MODULE_3__.AddressPipe, _pipes_fio_fio__WEBPACK_IMPORTED_MODULE_4__.FioPipe],
  declarations: [_ls_info_page__WEBPACK_IMPORTED_MODULE_1__.LsInfoPage]
})], LsInfoPageModule);


/***/ }),

/***/ 27124:
/*!*********************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/ls-info.page.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsInfoPage: () => (/* binding */ LsInfoPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ls_info_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ls-info.page.html?ngResource */ 46296);
/* harmony import */ var _ls_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ls-info.page.scss?ngResource */ 5200);
/* harmony import */ var _ls_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_ls_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../services/modal.service */ 5455);
/* harmony import */ var _description_description_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./description/description.page */ 46117);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../environments/storage */ 12960);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 5342);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */












let LsInfoPage = class LsInfoPage {
  constructor(request, modalService, alertCtrl, translate) {
    this.request = request;
    this.modalService = modalService;
    this.alertCtrl = alertCtrl;
    this.translate = translate;
    this.ls = undefined;
  }
  ngOnInit() {
    if (!this.ls) {
      this.ls = this.request.activeLs.value;
    }
  }
  openDescriptionChangePage() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.modalService.openModal({
        component: _description_description_page__WEBPACK_IMPORTED_MODULE_5__.DescriptionPage,
        componentProps: {
          ls: _this.ls
        }
      });
    })();
  }
  unbindLs() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("TEXT_STRING.UNBIND_QUESTION")),
        buttons: [{
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.CANCEL")),
          role: 'cancel'
        }, {
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.UNBIND")),
          handler: () => {
            _this2.request.postRequest(_this2.request.uri.unbindLsPost(_this2.ls), {}, {
              useCache: false
            }).subscribe(/*#__PURE__*/function () {
              var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (response) {
                if (response.result) {
                  _this2.request.getRequest(_this2.request.uri.bindingsGet(), {
                    forceUpdateCache: true
                  }).subscribe(/*#__PURE__*/function () {
                    var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
                      // Вызываем функцию коллбэк
                      yield _this2.request.loadBindingsCallback(data);
                      if (Object.values(_this2.request.bindings.value)[0]) {
                        // @ts-ignore
                        yield _this2.request.setActiveLS(Object.values(_this2.request.bindings.value)[0].number);
                      }
                      if (_this2.request.bindings.value[_this2.ls]) {
                        _this2.alertCtrl.create({
                          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("TEXT_STRING.UNBIND_MESSAGE_ERR")),
                          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
                        }).then(/*#__PURE__*/function () {
                          var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                            yield alert.present();
                          });
                          return function (_x3) {
                            return _ref3.apply(this, arguments);
                          };
                        }());
                      } else {
                        _this2.alertCtrl.create({
                          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("TEXT_STRING.UNBIND_MESSAGE")),
                          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
                        }).then(/*#__PURE__*/function () {
                          var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                            yield alert.present();
                          });
                          return function (_x4) {
                            return _ref4.apply(this, arguments);
                          };
                        }());
                        const lsInfo = _this2.request.lsInfo.value;
                        delete lsInfo[_this2.ls];
                        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_6__.Preferences.set({
                          key: _environments_storage__WEBPACK_IMPORTED_MODULE_7__.LS_DATA,
                          value: JSON.stringify(lsInfo)
                        });
                        _this2.request.lsInfo.next(lsInfo);
                        _this2.modal.dismiss();
                      }
                    });
                    return function (_x2) {
                      return _ref2.apply(this, arguments);
                    };
                  }());
                } else {
                  _this2.alertCtrl.create({
                    header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                    message: response.message,
                    buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_8__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
                  }).then(/*#__PURE__*/function () {
                    var _ref5 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
                      yield alert.present();
                    });
                    return function (_x5) {
                      return _ref5.apply(this, arguments);
                    };
                  }());
                }
              });
              return function (_x) {
                return _ref.apply(this, arguments);
              };
            }());
          }
        }]
      }).then(/*#__PURE__*/function () {
        var _ref6 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (alert) {
          yield alert.present();
        });
        return function (_x6) {
          return _ref6.apply(this, arguments);
        };
      }());
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      ls: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.Input
      }]
    };
  }
};
LsInfoPage = (0,tslib__WEBPACK_IMPORTED_MODULE_12__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-ls-info',
  template: _ls_info_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_ls_info_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], LsInfoPage);


/***/ }),

/***/ 45086:
/*!*****************************************************************************!*\
  !*** ./src/app/pages/tabs/more/ls-all-modal/ls-all-modal-routing.module.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsAllModalPageRoutingModule: () => (/* binding */ LsAllModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ls_all_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ls-all-modal.page */ 32800);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _ls_all_modal_page__WEBPACK_IMPORTED_MODULE_0__.LsAllModalPage
}];
let LsAllModalPageRoutingModule = class LsAllModalPageRoutingModule {};
LsAllModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], LsAllModalPageRoutingModule);


/***/ }),

/***/ 88615:
/*!*********************************************************************!*\
  !*** ./src/app/pages/tabs/more/ls-all-modal/ls-all-modal.module.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsAllModalPageModule: () => (/* binding */ LsAllModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ls_all_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ls-all-modal-routing.module */ 45086);
/* harmony import */ var _ls_all_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ls-all-modal.page */ 32800);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../pipes/active-ls/active-ls */ 61863);
/* harmony import */ var _pipes_address_address__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../pipes/address/address */ 35403);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */










let LsAllModalPageModule = class LsAllModalPageModule {};
LsAllModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_8__.IonicModule, _ls_all_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.LsAllModalPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__.TranslateModule, _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__.ActiveLsPipe, _pipes_address_address__WEBPACK_IMPORTED_MODULE_3__.AddressPipe],
  declarations: [_ls_all_modal_page__WEBPACK_IMPORTED_MODULE_1__.LsAllModalPage]
})], LsAllModalPageModule);


/***/ }),

/***/ 32800:
/*!*******************************************************************!*\
  !*** ./src/app/pages/tabs/more/ls-all-modal/ls-all-modal.page.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LsAllModalPage: () => (/* binding */ LsAllModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _ls_all_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ls-all-modal.page.html?ngResource */ 32888);
/* harmony import */ var _ls_all_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ls-all-modal.page.scss?ngResource */ 7320);
/* harmony import */ var _ls_all_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_ls_all_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _main_bind_ls_bind_ls_page__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../main/bind-ls/bind-ls.page */ 88316);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../services/modal.service */ 5455);
/* harmony import */ var _main_ls_info_ls_info_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../main/ls-info/ls-info.page */ 27124);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let LsAllModalPage = class LsAllModalPage {
  constructor(request, modalService) {
    this.request = request;
    this.modalService = modalService;
  }
  ngOnInit() {
    this.loadData().finally(() => {});
  }
  loadData(refresher) {
    var _this = this;
    return new Promise(resolve => {
      // Выполняем запрос
      this.request.getRequest(this.request.uri.bindingsGet(), {
        preloader: false,
        forceUpdateCache: refresher
      }).subscribe(/*#__PURE__*/function () {
        var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          // Вызываем функцию коллбэк
          yield _this.request.loadBindingsCallback(result);
          result.bindings.forEach(ls => {
            _this.request.getRequest(_this.request.uri.lsInfoGet(ls.number), {
              preloader: false,
              forceUpdateCache: refresher
            }).subscribe(resultAccountInfo => {
              _this.request.loadLsInfoCallback(resultAccountInfo, ls.number);
            });
          });
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
    });
  }
  openBindLsPage() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.modalService.openModal({
        component: _main_bind_ls_bind_ls_page__WEBPACK_IMPORTED_MODULE_4__.BindLsPage
      }).then(modal => {
        modal.onDidDismiss().then(data => {
          if (data.data.result) {
            _this2.request.getRequest(_this2.request.uri.lsInfoGet(data.data.ls), {
              preloader: true,
              forceUpdateCache: true
            }).subscribe(response => {
              _this2.request.loadLsInfoCallback(response, data.data.ls);
            });
          }
        });
      });
    })();
  }
  openLsInfo(ls) {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.modalService.openModal({
        component: _main_ls_info_ls_info_page__WEBPACK_IMPORTED_MODULE_6__.LsInfoPage,
        presentingElement: yield _this3.modalService.modalCtrl.getTop(),
        componentProps: {
          ls
        },
        type: 'card',
        canDismiss: true
      });
    })();
  }
  dismiss(value = null) {
    this.modal.dismiss(value);
  }
  object() {
    return Object;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_5__.ModalService
    }];
  }
};
LsAllModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-ls-all-modal',
  template: _ls_all_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_ls_all_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], LsAllModalPage);


/***/ }),

/***/ 87738:
/*!**********************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/code-modal/code-modal-routing.module.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeModalPageRoutingModule: () => (/* binding */ CodeModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _code_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code-modal.page */ 66092);




const routes = [{
  path: '',
  component: _code_modal_page__WEBPACK_IMPORTED_MODULE_0__.CodeModalPage
}];
let CodeModalPageRoutingModule = class CodeModalPageRoutingModule {};
CodeModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], CodeModalPageRoutingModule);


/***/ }),

/***/ 49827:
/*!**************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/code-modal/code-modal.module.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeModalPageModule: () => (/* binding */ CodeModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _code_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./code-modal-routing.module */ 87738);
/* harmony import */ var _code_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code-modal.page */ 66092);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _components_card_block_card_block_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../components/card-block/card-block.component */ 65075);
/* harmony import */ var _components_menu_item_menu_item_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../components/menu-item/menu-item.component */ 23853);










let CodeModalPageModule = class CodeModalPageModule {};
CodeModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_8__.IonicModule, _code_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.CodeModalPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__.TranslateModule, _components_card_block_card_block_component__WEBPACK_IMPORTED_MODULE_2__.CardBlockComponent, _components_menu_item_menu_item_component__WEBPACK_IMPORTED_MODULE_3__.MenuItemComponent],
  declarations: [_code_modal_page__WEBPACK_IMPORTED_MODULE_1__.CodeModalPage]
})], CodeModalPageModule);


/***/ }),

/***/ 66092:
/*!************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/code-modal/code-modal.page.ts ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeModalPage: () => (/* binding */ CodeModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _code_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code-modal.page.html?ngResource */ 56660);
/* harmony import */ var _code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./code-modal.page.scss?ngResource */ 9058);
/* harmony import */ var _code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/in-app-auth.service */ 70604);
/* harmony import */ var _pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../pin-code/pin-code.page */ 47033);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../../environments/storage */ 12960);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../services/modal.service */ 5455);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _awesome_cordova_plugins_open_native_settings_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/open-native-settings/ngx */ 76319);
/* harmony import */ var _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @awesome-cordova-plugins/native-storage/ngx */ 76558);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 5342);















let CodeModalPage = class CodeModalPage {
  constructor(inAppAuth, modalService, alertCtrl, openNativeSettings, actionSheetController, nativeStorage, translate) {
    this.inAppAuth = inAppAuth;
    this.modalService = modalService;
    this.alertCtrl = alertCtrl;
    this.openNativeSettings = openNativeSettings;
    this.actionSheetController = actionSheetController;
    this.nativeStorage = nativeStorage;
    this.translate = translate;
    this.title = '';
  }
  ngOnInit() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.inAppAuth.faioType.value === 'finger') {
        _this.title = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("MORE.SETTINGS_PAGE.APP.CODE.TITLE_TOUCH_ID"));
        // eslint-disable-next-line max-len
      } else if (_this.inAppAuth.faioType.value === 'face' || _this.inAppAuth.faioErrorCode.value === -101 || _this.inAppAuth.faioErrorCode.value === -105) {
        _this.title = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("MORE.SETTINGS_PAGE.APP.CODE.TITLE_FACE_ID"));
      } else {
        _this.title = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this.translate.get("MORE.SETTINGS_PAGE.APP.CODE.TITLE"));
      }
    })();
  }
  changePinCode() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this2.modalService.openModal({
        component: _pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_4__.PinCodePage,
        cssClass: 'fullscreen-modal top-modal',
        backdropDismiss: false,
        swipeToClose: false,
        componentProps: {
          type: 'setCode',
          swipeToClose: true
        }
      });
      modal.onDidDismiss().then(/*#__PURE__*/function () {
        var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
          if (data.data) {
            _this2.inAppAuth.pinInst.next(true);
          }
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
    })();
  }
  disablePinCode() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const actionSheet = yield _this3.actionSheetController.create({
        buttons: [{
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("BUTTONS.DISABLED_PIN_CODE")),
          role: 'destructive',
          id: 'delete-button',
          data: {
            type: 'delete'
          }
        }, {
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this3.translate.get("BUTTONS.CANCEL")),
          role: 'cancel',
          data: {
            type: 'cancel'
          }
        }]
      });
      yield actionSheet.present();
      const {
        data
      } = yield actionSheet.onDidDismiss();
      if (data.type === 'delete') {
        _this3.inAppAuth.pinInst.next(false);
        _this3.inAppAuth.faioEnabled.next(false);
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PIN_CODE_ENABLED
        });
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PIN_CODE
        });
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAIO_ENABLED
        });
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAIO_CHANGED
        });
        _this3.nativeStorage.remove('blurPrivacyScreen').catch(err => console.error(err));
        _this3.modal.dismiss();
      }
    })();
  }
  toggleTouchId() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_this4.inAppAuth.faioAvailable.value) {
        _this4.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this4.translate.get("ERROR_STRING.ATTENTION_HEADER")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this4.translate.get("ERROR_STRING.BIO_PERMISSION_DENIED")),
          buttons: [{
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this4.translate.get("BUTTONS.CANCEL")),
            role: 'cancel'
          }, {
            text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.lastValueFrom)(_this4.translate.get("BUTTONS.SETTINGS")),
            handler: () => {
              _this4.openNativeSettings.open('settings');
            }
          }]
        }).then(alert => {
          alert.present().catch(() => {});
        });
      } else {
        if (_this4.inAppAuth.faioEnabled.value) {
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAIO_ENABLED,
            value: '0'
          });
        } else {
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAIO_ENABLED,
            value: '1'
          });
        }
        _this4.inAppAuth.faioEnabled.next(!_this4.inAppAuth.faioEnabled.value);
      }
    })();
  }
  dismiss(value = null) {
    this.modal.dismiss(value);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_in_app_auth_service__WEBPACK_IMPORTED_MODULE_3__.InAppAuthService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_7__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.AlertController
    }, {
      type: _awesome_cordova_plugins_open_native_settings_ngx__WEBPACK_IMPORTED_MODULE_8__.OpenNativeSettings
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.ActionSheetController
    }, {
      type: _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_9__.NativeStorage
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__.TranslateService
    }];
  }
};
CodeModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_13__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_14__.Component)({
  selector: 'app-code-modal',
  template: _code_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  providers: [_awesome_cordova_plugins_open_native_settings_ngx__WEBPACK_IMPORTED_MODULE_8__.OpenNativeSettings],
  styles: [(_code_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CodeModalPage);


/***/ }),

/***/ 9054:
/*!****************************************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/email-mailing-modal/email-mailing-modal-routing.module.ts ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailMailingModalPageRoutingModule: () => (/* binding */ EmailMailingModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./email-mailing-modal.page */ 2688);




const routes = [{
  path: '',
  component: _email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_0__.EmailMailingModalPage
}];
let EmailMailingModalPageRoutingModule = class EmailMailingModalPageRoutingModule {};
EmailMailingModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], EmailMailingModalPageRoutingModule);


/***/ }),

/***/ 37447:
/*!********************************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/email-mailing-modal/email-mailing-modal.module.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailMailingModalPageModule: () => (/* binding */ EmailMailingModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _email_mailing_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./email-mailing-modal-routing.module */ 9054);
/* harmony import */ var _email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./email-mailing-modal.page */ 2688);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);








let EmailMailingModalPageModule = class EmailMailingModalPageModule {};
EmailMailingModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _email_mailing_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.EmailMailingModalPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_email_mailing_modal_page__WEBPACK_IMPORTED_MODULE_1__.EmailMailingModalPage]
})], EmailMailingModalPageModule);


/***/ }),

/***/ 2688:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/email-mailing-modal/email-mailing-modal.page.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EmailMailingModalPage: () => (/* binding */ EmailMailingModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _email_mailing_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./email-mailing-modal.page.html?ngResource */ 51760);
/* harmony import */ var _email_mailing_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./email-mailing-modal.page.scss?ngResource */ 84294);
/* harmony import */ var _email_mailing_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_email_mailing_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/request.service */ 80931);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../../environments/storage */ 12960);











let EmailMailingModalPage = class EmailMailingModalPage {
  constructor(fb, request, alertCtrl, translate, actionSheetController) {
    this.fb = fb;
    this.request = request;
    this.alertCtrl = alertCtrl;
    this.translate = translate;
    this.actionSheetController = actionSheetController;
  }
  ngOnInit() {
    this.credentials = this.fb.group({
      input: [this.item.label, [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.email]]
    });
    if (this.item.label == '') {
      this.getSettingsEmail();
    }
  }
  getSettingsEmail() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.request.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_4__.SETTINGS_EMAIL, _this.request.settingsEmail);
      if (_this.request.settingsEmail.value.email !== '' && _this.request.settingsEmail.value.email !== undefined) {
        _this.credentials.get('input').setValue(_this.request.settingsEmail.value.email);
      }
    })();
  }
  dismiss(value) {
    this.modal.dismiss(value);
  }
  unsubscribeEmail() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const actionSheet = yield _this2.actionSheetController.create({
        buttons: [{
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.lastValueFrom)(_this2.translate.get("MORE.SETTINGS_PAGE.PERSONAL_ACCOUNT.MAILING.MAILING_EMAIL.UNSUBSCRIBE")),
          role: 'destructive',
          id: 'delete-button',
          data: {
            type: 'delete'
          }
        }, {
          text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.lastValueFrom)(_this2.translate.get("BUTTONS.CANCEL")),
          role: 'cancel',
          data: {
            type: 'cancel'
          }
        }]
      });
      yield actionSheet.present();
      const {
        data
      } = yield actionSheet.onDidDismiss();
      if (data.type === 'delete') {
        _this2.submit(false);
      }
    })();
  }
  submit(value) {
    var _this3 = this;
    const body = {
      type: this.item.type,
      value,
      email: value ? this.credentials.get('input').value : '',
      rowId: this.item.rowId || undefined
    };
    this.request.postRequest(this.request.uri.settingsMailingsPost(), body, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (responce) {
        if (responce.result) {
          const mailing = _this3.request.settingsMailings.value[_this3.request.activeLs.value];
          mailing.parameter[0].value = value;
          mailing.parameter[0].subTitle = value ? _this3.credentials.get('input').value : '';
          yield _this3.request.cache(_this3.request.uri.settingsMailingsGet(), mailing, true);
          _this3.dismiss(value ? _this3.credentials.get('input').value : false);
        } else {
          yield (yield _this3.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: responce.message || (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.lastValueFrom)(_this3.translate.get("MORE.SETTINGS_PAGE.PERSONAL_ACCOUNT.MAILING.CHANGE_ERROR")))
          })).present();
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_5__.UntypedFormBuilder
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__.TranslateService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.ActionSheetController
    }];
  }
  static {
    this.propDecorators = {
      item: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_9__.Input
      }]
    };
  }
};
EmailMailingModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_9__.Component)({
  selector: 'app-email-mailing-modal',
  template: _email_mailing_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_email_mailing_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], EmailMailingModalPage);


/***/ }),

/***/ 32945:
/*!****************************************************************!*\
  !*** ./src/app/pages/tabs/payment/help/help-routing.module.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HelpPageRoutingModule: () => (/* binding */ HelpPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _help_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./help.page */ 39955);




const routes = [{
  path: '',
  component: _help_page__WEBPACK_IMPORTED_MODULE_0__.HelpPage
}];
let HelpPageRoutingModule = class HelpPageRoutingModule {};
HelpPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], HelpPageRoutingModule);


/***/ }),

/***/ 93608:
/*!********************************************************!*\
  !*** ./src/app/pages/tabs/payment/help/help.module.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HelpPageModule: () => (/* binding */ HelpPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _help_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./help-routing.module */ 32945);
/* harmony import */ var _help_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./help.page */ 39955);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! swiper/angular */ 72443);








let HelpPageModule = class HelpPageModule {};
HelpPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _help_routing_module__WEBPACK_IMPORTED_MODULE_0__.HelpPageRoutingModule, swiper_angular__WEBPACK_IMPORTED_MODULE_7__.SwiperModule],
  declarations: [_help_page__WEBPACK_IMPORTED_MODULE_1__.HelpPage]
})], HelpPageModule);


/***/ }),

/***/ 39955:
/*!******************************************************!*\
  !*** ./src/app/pages/tabs/payment/help/help.page.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HelpPage: () => (/* binding */ HelpPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _help_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./help.page.html?ngResource */ 53365);
/* harmony import */ var _help_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./help.page.scss?ngResource */ 55503);
/* harmony import */ var _help_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_help_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../services/request.service */ 80931);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../services/app-theme.service */ 43017);
/* harmony import */ var swiper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! swiper */ 36705);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 3920);








swiper__WEBPACK_IMPORTED_MODULE_4__["default"].use([swiper__WEBPACK_IMPORTED_MODULE_4__.Pagination, _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.IonicSlides]);
let HelpPage = class HelpPage {
  constructor(request, appTheme) {
    this.request = request;
    this.appTheme = appTheme;
    this.slidesOptions = {
      initialSlide: 0,
      // Начальное положение слайдера
      centeredSlides: true,
      // Разрешает центрировать слайд не всегда с левой стороны
      centeredSlidesBounds: true,
      // Центрирование слайда по центру (Требуется свойство 'centeredSlides' = true)
      spaceBetween: 24,
      // Дополнительное расстояние между слайдами
      slidesPerView: 1,
      // Количество слайдом которое должно помещаться на экран одновременно
      watchSlidesProgress: true,
      // Переключение пагинации во время перелистывания (еще до того как пользователь отпустит палец)
      resizeObserver: true,
      observer: true,
      // Отслеживание изменений
      observeParents: true,
      // Отслеживание изменений родительских элементов
      observeSlideChildren: true,
      // Отслеживание изменений родительских элементов
      updateOnWindowResize: true,
      centerInsufficientSlides: true,
      autoHeight: true,
      resistanceRatio: 0.65
    };
  }
  ngOnInit() {}
  dismiss() {
    this.modal.dismiss();
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_2__.RequestService
    }, {
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__.AppThemeService
    }];
  }
  static {
    this.propDecorators = {
      gateway: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }]
    };
  }
};
HelpPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-help',
  template: _help_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_help_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], HelpPage);


/***/ }),

/***/ 3660:
/*!******************************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/check-modal/check-modal.page.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckModalPage: () => (/* binding */ CheckModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _check_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./check-modal.page.html?ngResource */ 91576);
/* harmony import */ var _check_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./check-modal.page.scss?ngResource */ 31838);
/* harmony import */ var _check_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_check_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../../services/helper.service */ 54102);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../../services/request.service */ 80931);
/* harmony import */ var _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../../../services/phone-mask.service */ 10449);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../../../environments/storage */ 12960);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../../../types/settingsPayChequeType */ 27518);















let CheckModalPage = class CheckModalPage {
  constructor(helper, request, alertCtrl, fb, translate) {
    this.helper = helper;
    this.request = request;
    this.alertCtrl = alertCtrl;
    this.fb = fb;
    this.translate = translate;
    this.payChequeInput = {};
    this.payCheque = {};
    // Обертка для использования перечислений в верстке
    this.payChequeTypes = (() => {
      return _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes;
    })();
    this.maskPhone = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__.maskPhone;
    this.maskPredicate = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__.maskPredicate;
  }
  ngOnInit() {
    if (this.payChequeInput.type) {
      this.payCheque.type = this.payChequeInput.type;
      this.payCheque.email = this.payChequeInput.email;
      this.payCheque.tel = this.payChequeInput.tel;
      this.credentials = this.fb.group({
        email: [this.payCheque.email ?? ''],
        tel: [this.helper.phoneFormat(this.payCheque.tel ?? '')]
      });
    } else {
      this.credentials = this.fb.group({
        email: [''],
        tel: [this.helper.phoneFormat('')]
      });
    }
  }
  changePayChequeType() {
    var _this = this;
    let buttons = [{
      title: this.helper.translate.instant('PAYMENT.PAY.PAY_MODAL.CHECK.EMAIL'),
      value: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.EMAIL
    }, {
      title: this.helper.translate.instant('PAYMENT.PAY.PAY_MODAL.CHECK.NONE'),
      value: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.NONE
    }];
    if (this.helper.authByPhone.value) {
      buttons.push({
        title: this.helper.translate.instant('PAYMENT.PAY.PAY_MODAL.CHECK.PHONE'),
        value: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.TEL
      });
    }
    this.helper.showActionSheet({
      type: 'select',
      title: this.helper.translate.instant('PAYMENT.PAY.PAY_MODAL.CHECK.TITLE'),
      buttons,
      value: this.payCheque.type
    }).then(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        if (result) {
          _this.payCheque.type = result.value;
          switch (_this.payCheque.type) {
            case _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.EMAIL:
              {
                if (_this.payCheque.email === '' || _this.payCheque.email === undefined) {
                  yield _this.request.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_EMAIL, _this.request.settingsEmail);
                  if (_this.request.settingsEmail.value.email !== '' && _this.request.settingsEmail.value.email !== undefined) {
                    _this.credentials.get('email').setValue(_this.request.settingsEmail.value.email);
                  }
                }
                break;
              }
            case _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.TEL:
              {
                if (_this.payCheque.tel === '' || _this.payCheque.tel === undefined) {
                  yield _this.request.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PHONE, _this.request.settingsPhone);
                  if (_this.request.settingsPhone.value.phone !== '' && _this.request.settingsPhone.value.phone !== undefined) {
                    _this.credentials.get('tel').setValue(_this.request.settingsPhone.value.phone);
                  }
                }
                break;
              }
          }
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  checkPhone() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.payCheque.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.TEL) {
        // eslint-disable-next-line max-len
        const isValidPhone = _this2.credentials.get('tel').value.match(/^((8|\+7)([\- ]?)(?![\- ]))(\(?\d{3}\)?([\- ]?)(?![\- ]))?[\d]{3}([\- ])?(?![\- ])[\d]{2}([\- ])?(?![\- ])[\d]{2}$/i);
        if (!isValidPhone) {
          const alert = yield _this2.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this2.translate.get("ERROR_STRING.PHONE_INVALID")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
          });
          yield alert.present();
          return;
        } else {
          yield _this2.save();
        }
      }
    })();
  }
  save() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        if (_this3.payCheque.type) {
          if (_this3.payCheque.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.EMAIL && _this3.credentials.get('email').value && _this3.credentials.get('email').value !== '' || _this3.payCheque.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.TEL && _this3.credentials.get('tel').value && _this3.credentials.get('tel').value.length === 18) {
            _this3.payCheque.email = _this3.credentials.get('email').value;
            _this3.payCheque.tel = _this3.credentials.get('tel').value;
            const value = {
              type: _this3.payCheque.type,
              email: _this3.payCheque.email,
              tel: _this3.payCheque.tel
            };
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_7__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_CHEQUE,
              value: JSON.stringify(value)
            });
            _this3.modal.dismiss(_this3.payCheque);
          } else if (_this3.payCheque.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_8__.PayChequeTypes.NONE) {
            const value = {
              type: _this3.payCheque.type
            };
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_7__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_CHEQUE,
              value: JSON.stringify(value)
            });
            _this3.modal.dismiss(_this3.payCheque);
          } else {
            throw new Error('invalid');
          }
        }
      } catch (e) {
        if (e.message === 'invalid') {
          yield (yield _this3.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.FIELD_VALUE_INVALID")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
          })).present();
        } else {
          yield (yield _this3.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("ERROR_STRING.SAVE_ERROR")),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.lastValueFrom)(_this3.translate.get("BUTTONS.OK"))]
          })).present();
        }
      }
    })();
  }
  dismiss(value = null) {
    this.modal.dismiss(value);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.RequestService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.AlertController
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_11__.UntypedFormBuilder
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      inputTel: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.ViewChild,
        args: ['inputTel']
      }],
      payChequeInput: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_13__.Input
      }]
    };
  }
};
CheckModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_13__.Component)({
  selector: 'app-check-modal',
  template: _check_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_check_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CheckModalPage);


/***/ }),

/***/ 75261:
/*!**************************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/pay-modal-routing.module.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PayModalPageRoutingModule: () => (/* binding */ PayModalPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _pay_modal_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pay-modal.page */ 39279);




const routes = [{
  path: '',
  component: _pay_modal_page__WEBPACK_IMPORTED_MODULE_0__.PayModalPage
}, {
  path: 'check-modal',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_payment_pay-receipt_pay-modal_check-modal_check-modal_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./check-modal/check-modal.module */ 50243)).then(m => m.CheckModalPageModule)
}];
let PayModalPageRoutingModule = class PayModalPageRoutingModule {};
PayModalPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], PayModalPageRoutingModule);


/***/ }),

/***/ 98916:
/*!******************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/pay-modal.module.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PayModalPageModule: () => (/* binding */ PayModalPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _pay_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pay-modal-routing.module */ 75261);
/* harmony import */ var _pay_modal_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pay-modal.page */ 39279);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! swiper/angular */ 72443);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ 597);









let PayModalPageModule = class PayModalPageModule {};
PayModalPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _pay_modal_routing_module__WEBPACK_IMPORTED_MODULE_0__.PayModalPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, swiper_angular__WEBPACK_IMPORTED_MODULE_7__.SwiperModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__.TranslateModule],
  declarations: [_pay_modal_page__WEBPACK_IMPORTED_MODULE_1__.PayModalPage]
})], PayModalPageModule);


/***/ }),

/***/ 39279:
/*!****************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/pay-modal.page.ts ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PayModalPage: () => (/* binding */ PayModalPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _pay_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./pay-modal.page.html?ngResource */ 94141);
/* harmony import */ var _pay_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pay-modal.page.scss?ngResource */ 6435);
/* harmony import */ var _pay_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_pay_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../services/helper.service */ 54102);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../../environments/storage */ 12960);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../services/modal.service */ 5455);
/* harmony import */ var _check_modal_check_modal_page__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./check-modal/check-modal.page */ 3660);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../../../../environments/settings */ 79308);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var inputmask__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! inputmask */ 80416);
/* harmony import */ var inputmask__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(inputmask__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs */ 64334);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../../../types/settingsPayChequeType */ 27518);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _types_paymentsType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../../../types/paymentsType */ 88849);
/* harmony import */ var _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @awesome-cordova-plugins/app-version/ngx */ 24297);





















let PayModalPage = class PayModalPage {
  constructor(helper, request, modalService, fb, platform, alertCtrl, translate, appVersion) {
    this.helper = helper;
    this.request = request;
    this.modalService = modalService;
    this.fb = fb;
    this.platform = platform;
    this.alertCtrl = alertCtrl;
    this.translate = translate;
    this.appVersion = appVersion;
    this.sum = 0;
    this.peni = 0;
    this.title = '';
    this.totalCommission = 0;
    this.totalAmount = 0;
    this.numberConfig = {
      radixPoint: ',',
      inputtype: 'text',
      digits: "2",
      groupSeparator: " ",
      allowMinus: false,
      min: "0",
      max: "999 999,99",
      placeholder: ""
    };
    // Обертка для использования перечислений в верстке
    this.payChequeTypes = (() => {
      return _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes;
    })();
    this.payTypes = (() => {
      return _types_paymentsType__WEBPACK_IMPORTED_MODULE_12__.PayType;
    })();
  }
  ngOnInit() {
    this.credentials = this.fb.group({
      sum: [this.helper.paySumFormate(this.sum, false, '*.*')],
      peni: [this.helper.paySumFormate(this.peni, false, '*.*')]
    });
    this.payMethodForThisPayment = this.request.payMethodFilter(this.payment.gateway);
    _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_CHEQUE
    }).then(data => {
      if (data.value != null) {
        this.request.settingsPayCheque.next(JSON.parse(data.value));
      }
      if (Object.entries(this.request.settingsEmail.value).length === 0) {
        this.request.settingsEmail.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.filter)(value => Object.entries(value).length !== 0), (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.take)(1)).subscribe(value => {
          if (value.email != '' && value.email != null) {
            this.request.settingsPayCheque.next({
              type: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.EMAIL,
              email: value.email
            });
            _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_CHEQUE,
              value: JSON.stringify(this.request.settingsPayCheque.value)
            });
          }
        });
        this.loadEmail();
      } else {
        if (this.request.settingsEmail.value.email != '' && this.request.settingsEmail.value.email != null) {
          this.request.settingsPayCheque.next({
            type: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.EMAIL,
            email: this.request.settingsEmail.value.email
          });
          _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_CHEQUE,
            value: JSON.stringify(this.request.settingsPayCheque.value)
          });
        }
      }
      if (this.helper.authByPhone.value && Object.entries(this.request.settingsPhone.value).length === 0) {
        this.loadPhone();
      }
    });
    if (this.sum == 0 && this.peni == 0) {
      this.title = this.translate.instant('PAYMENT.PAY.PAY_MODAL.TITLE2');
    } else {
      this.title = this.translate.instant('PAYMENT.PAY.PAY_MODAL.TITLE');
    }
    this.calculation();
  }
  ionViewDidEnter() {
    new (inputmask__WEBPACK_IMPORTED_MODULE_10___default())("decimal", this.numberConfig).mask(this.inputSum.el.querySelector('input'));
    new (inputmask__WEBPACK_IMPORTED_MODULE_10___default())("decimal", this.numberConfig).mask(this.inputPeni.el.querySelector('input'));
    this.inputSum.el.querySelector('input').addEventListener('keydown', ev => {
      if (ev.key === 'Enter') {
        this.inputPeni.setFocus();
      }
    });
    this.inputPeni.el.querySelector('input').addEventListener('keydown', ev => {
      if (ev.key === 'Enter') {
        this.openBankPage();
      }
    });
  }
  loadEmail() {
    var _this = this;
    this.request.getRequest(this.request.uri.settingsEmailGet(), {
      preloader: false,
      background: true,
      onlyCacheOrRequest: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        // Вызываем функцию коллбэк
        yield _this.request.loadSettingsEmailCallback()(result);
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  loadPhone() {
    var _this2 = this;
    this.request.getRequest(this.request.uri.settingsPhoneGet(), {
      preloader: false,
      background: true,
      onlyCacheOrRequest: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        // Вызываем функцию коллбэк
        yield _this2.request.loadSettingsPhoneCallback()(result);
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  openChangePayChequeModal() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.modalService.openModal({
        component: _check_modal_check_modal_page__WEBPACK_IMPORTED_MODULE_8__.CheckModalPage,
        componentProps: {
          payChequeInput: _this3.request.settingsPayCheque.value
        }
      }).then(modal => {
        modal.onWillDismiss().then(data => {
          if (data.data) {
            _this3.request.settingsPayCheque.next(data.data);
          }
        });
      });
    })();
  }
  openChangePayMethodModal() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      let buttons = [];
      let cardCount = _this4.payMethodForThisPayment.filter(val => val.type == 'card').length;
      for (const payMethod of _this4.payMethodForThisPayment) {
        let title = payMethod.name;
        if (payMethod.type == 'card' && cardCount > 1) {
          title += ' (' + payMethod.description + ')';
        }
        title += ' <span class="description-text">(' + (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get('PAYMENT.PAY.PAY_MODAL.COMMISSION', {
          value: _this4.helper.paySumFormate(_this4.request.payments.value[_this4.request.activeLs.value].gateway[payMethod.id].commission, false, '*.d*')
        }))) + ')</span>';
        buttons.push({
          icon: payMethod.icon ?? null,
          title,
          value: payMethod.id
        });
      }
      _this4.helper.showActionSheet({
        type: 'select',
        title: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this4.translate.get('PAYMENT.PAY.PAY_MODAL.PAY_METHODS.TITLE')),
        buttons,
        value: !!_this4.getActivePayMethod() ? _this4.getActivePayMethod().id : ''
      }).then(/*#__PURE__*/function () {
        var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          if (result && result.value != _this4.getDefPayMethod().id) {
            const payMethod = _this4.request.settingsPayMethod.value[_this4.request.activeLs.value].find(val => val.id == result.value);
            _this4.setDefPayMethod(payMethod);
          }
        });
        return function (_x3) {
          return _ref3.apply(this, arguments);
        };
      }());
    })();
  }
  inputBlur(ev) {
    if (ev.target.value == '') {
      ev.target.value = '0';
    }
    this.credentials.get('sum').setValue(this.helper.paySumFormate(this.helper.strToNum(this.credentials.get('sum').value), false));
    this.credentials.get('peni').setValue(this.helper.paySumFormate(this.helper.strToNum(this.credentials.get('peni').value), false));
    this.calculation();
  }
  calculation() {
    this.sum = +this.credentials.get('sum').value.split(' ').join('').split(',').join('.');
    this.peni = +this.credentials.get('peni').value.split(' ').join('').split(',').join('.');
    if (this.sum + this.peni > 0) {
      // eslint-disable-next-line max-len
      let commission = (this.sum + this.peni) * this.request.payments.value[this.request.activeLs.value].gateway[this.getActivePayMethod().id].commissionMultiplier;
      if (this.request.payments.value[this.request.activeLs.value].gateway[this.getActivePayMethod().id].minCommission > 0) {
        if (commission < this.request.payments.value[this.request.activeLs.value].gateway[this.getActivePayMethod().id].minCommission) {
          commission = this.request.payments.value[this.request.activeLs.value].gateway[this.getActivePayMethod().id].minCommission;
        }
      }
      this.totalCommission = commission;
      this.totalAmount = this.sum + this.peni + commission;
    } else {
      this.totalCommission = 0;
      this.totalAmount = 0;
    }
  }
  openBankPage() {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this5.calculation();
      if (_this5.totalAmount > 0) {
        if (_this5.totalAmount >= _this5.request.payments.value[_this5.request.activeLs.value].gateway[_this5.getActivePayMethod().id].minPay) {
          const params = ['alias_bank=' + _this5.getActivePayMethod().id, 'pay_summ=' + _this5.sum, 'pay_peni=' + _this5.peni, 'url_scheme=' + _environments_settings__WEBPACK_IMPORTED_MODULE_9__.CUSTOM_URL_SCHEME, 'app_id=' + (yield _this5.appVersion.getPackageName()), 'os=' + (_this5.platform.is('ios') ? 'ios' : _this5.platform.is('android') ? 'android' : 'browser')];
          if (_this5.payType === 1) {} else if (_this5.payType === 3) {
            params.push('kvt_code=' + _this5.payment.kvt_code);
            params.push('isp_id=' + _this5.payment.isp_id);
            params.push('pol_id=' + _this5.payment.pol_id);
          }
          if (_this5.request.settingsPayCheque.value.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.EMAIL) {
            params.push('pay_email=' + _this5.request.settingsPayCheque.value.email);
          } else if (_this5.request.settingsPayCheque.value.type === _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.TEL) {
            params.push('pay_sms=' + _this5.request.settingsPayCheque.value.tel.replace(/[(^\+)(\s|\-)]/g, ''));
          }
          _this5.request.getRequest(_this5.request.uri.paymentsRedirectToBankGet(_this5.request.activeLs.value, params.join('&')), {
            useCache: false
          }).subscribe({
            next: function () {
              var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
                try {
                  if (result.result) {
                    _this5.helper.openUrl(result.link);
                  } else {
                    throw new Error();
                  }
                } catch (e) {
                  _this5.alertCtrl.create({
                    header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                    message: result.message ?? (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.TO_PAY_ERROR"))),
                    buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("BUTTONS.OK"))]
                  }).then(alert => alert.present());
                }
              });
              return function next(_x4) {
                return _ref4.apply(this, arguments);
              };
            }(),
            error: function () {
              var _ref5 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                _this5.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ATTENTION_HEADER")),
                  message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.TO_PAY_ERROR")),
                  buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("BUTTONS.OK"))]
                }).then(alert => alert.present());
              });
              return function error() {
                return _ref5.apply(this, arguments);
              };
            }()
          });
        } else {
          _this5.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ATTENTION_HEADER")),
            message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("TEXT_STRING.PAY_SUM_IS_LESS_MIN", {
              value: _this5.helper.paySumFormate(_this5.request.payments.value[_this5.request.activeLs.value].gateway[_this5.getActivePayMethod().id].minPay)
            })),
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("BUTTONS.OK"))]
          }).then(alert => alert.present());
        }
      } else {
        _this5.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ATTENTION_HEADER")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("TEXT_STRING.PAY_SUM_IS_NULL")),
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_16__.lastValueFrom)(_this5.translate.get("BUTTONS.OK"))]
        }).then(alert => alert.present());
      }
    })();
  }
  dismiss(value = null) {
    this.modal.dismiss(value);
  }
  /**
   * Возвращает способ оплаты по-умолчанию.
   *
   * Внимание! Способ оплаты по-умолчанию не всегда может быть доступен для оплаты.
   * Чтобы получить доступный способ оплаты, используйте метод getActivePayMethod
   */
  getDefPayMethod() {
    let def = this.request.settingsPayMethod.value[this.request.activeLs.value].filter(val => val.default)[0];
    // если активного способа оплаты нет, то ставим первый активным
    if (!def) {
      def = this.setDefPayMethod();
    }
    return def;
  }
  /**
   * Возвращает активный или первый (если активный недоступен) способ оплаты
   */
  getActivePayMethod() {
    let activePayMethod = this.payMethodForThisPayment.filter(payMethod => payMethod.default)[0];
    if (!activePayMethod) {
      activePayMethod = this.payMethodForThisPayment[0];
    }
    return activePayMethod;
  }
  /**
   * Сохраняет и применяет выбранный способ оплаты
   *
   * @param def
   */
  setDefPayMethod(def) {
    if (!def) {
      def = this.request.settingsPayMethod.value[this.request.activeLs.value][0];
    }
    let payMethods = this.request.settingsPayMethod.value;
    payMethods[this.request.activeLs.value].forEach(val => {
      val.default = val.id === def.id;
    });
    this.request.settingsPayMethod.next(payMethods);
    _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.set({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_METHODS,
      value: JSON.stringify(this.request.settingsPayMethod.value)
    });
    this.payMethodForThisPayment = this.request.payMethodFilter(this.payment.gateway);
    this.calculation();
    return this.request.settingsPayMethod.value[this.request.activeLs.value][0];
  }
  static {
    this.ctorParameters = () => [{
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_7__.ModalService
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_17__.UntypedFormBuilder
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_18__.Platform
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_19__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_20__.TranslateService
    }, {
      type: _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_13__.AppVersion
    }];
  }
  static {
    this.propDecorators = {
      inputSum: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['inputSum']
      }],
      inputPeni: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.ViewChild,
        args: ['inputPeni']
      }],
      sum: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }],
      peni: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }],
      payment: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }],
      payType: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_21__.Input
      }]
    };
  }
};
PayModalPage = (0,tslib__WEBPACK_IMPORTED_MODULE_22__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_21__.Component)({
  selector: 'app-pay-modal',
  template: _pay_modal_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_pay_modal_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], PayModalPage);


/***/ }),

/***/ 76751:
/*!*************************************************************************!*\
  !*** ./src/app/pages/technical-works/technical-works-routing.module.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TechnicalWorksPageRoutingModule: () => (/* binding */ TechnicalWorksPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _technical_works_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./technical-works.page */ 5601);




const routes = [{
  path: '',
  component: _technical_works_page__WEBPACK_IMPORTED_MODULE_0__.TechnicalWorksPage
}];
let TechnicalWorksPageRoutingModule = class TechnicalWorksPageRoutingModule {};
TechnicalWorksPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], TechnicalWorksPageRoutingModule);


/***/ }),

/***/ 14494:
/*!*****************************************************************!*\
  !*** ./src/app/pages/technical-works/technical-works.module.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TechnicalWorksPageModule: () => (/* binding */ TechnicalWorksPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _technical_works_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./technical-works-routing.module */ 76751);
/* harmony import */ var _technical_works_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./technical-works.page */ 5601);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);








let TechnicalWorksPageModule = class TechnicalWorksPageModule {};
TechnicalWorksPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _technical_works_routing_module__WEBPACK_IMPORTED_MODULE_0__.TechnicalWorksPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_technical_works_page__WEBPACK_IMPORTED_MODULE_1__.TechnicalWorksPage]
})], TechnicalWorksPageModule);


/***/ }),

/***/ 5601:
/*!***************************************************************!*\
  !*** ./src/app/pages/technical-works/technical-works.page.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TechnicalWorksPage: () => (/* binding */ TechnicalWorksPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _technical_works_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./technical-works.page.html?ngResource */ 93427);
/* harmony import */ var _technical_works_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./technical-works.page.scss?ngResource */ 72823);
/* harmony import */ var _technical_works_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_technical_works_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../environments/storage */ 12960);










let TechnicalWorksPage = class TechnicalWorksPage {
  constructor(appTheme, request, navCtrl) {
    this.appTheme = appTheme;
    this.request = request;
    this.navCtrl = navCtrl;
  }
  ngOnInit() {
    this.update();
  }
  update() {
    var _this = this;
    try {
      this.request.postRequest(this.request.uri.appInitPost(), {}, {
        useCache: false,
        preloader: false,
        background: true
      }).subscribe(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_5__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAGE_TECHNICAL_WORKS
        });
        if (_this.modal) {
          _this.modal.dismiss();
        } else {
          _this.navCtrl.navigateForward('/login', {
            replaceUrl: true
          });
        }
      }), () => {});
    } catch (e) {}
  }
  static {
    this.ctorParameters = () => [{
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_3__.AppThemeService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_4__.RequestService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.NavController
    }];
  }
};
TechnicalWorksPage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_9__.Component)({
  selector: 'app-technical-works',
  template: _technical_works_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_technical_works_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], TechnicalWorksPage);


/***/ }),

/***/ 53495:
/*!***************************************************************!*\
  !*** ./src/app/pages/update-app/update-app-routing.module.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UpdateAppPageRoutingModule: () => (/* binding */ UpdateAppPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _update_app_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./update-app.page */ 70777);




const routes = [{
  path: '',
  component: _update_app_page__WEBPACK_IMPORTED_MODULE_0__.UpdateAppPage
}];
let UpdateAppPageRoutingModule = class UpdateAppPageRoutingModule {};
UpdateAppPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], UpdateAppPageRoutingModule);


/***/ }),

/***/ 77574:
/*!*******************************************************!*\
  !*** ./src/app/pages/update-app/update-app.module.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UpdateAppPageModule: () => (/* binding */ UpdateAppPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _update_app_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./update-app-routing.module */ 53495);
/* harmony import */ var _update_app_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./update-app.page */ 70777);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);








let UpdateAppPageModule = class UpdateAppPageModule {};
UpdateAppPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _update_app_routing_module__WEBPACK_IMPORTED_MODULE_0__.UpdateAppPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_update_app_page__WEBPACK_IMPORTED_MODULE_1__.UpdateAppPage]
})], UpdateAppPageModule);


/***/ }),

/***/ 70777:
/*!*****************************************************!*\
  !*** ./src/app/pages/update-app/update-app.page.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   UpdateAppPage: () => (/* binding */ UpdateAppPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _update_app_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./update-app.page.html?ngResource */ 67243);
/* harmony import */ var _update_app_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./update-app.page.scss?ngResource */ 37187);
/* harmony import */ var _update_app_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_update_app_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/app-theme.service */ 43017);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/helper.service */ 54102);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 95072);








let UpdateAppPage = class UpdateAppPage {
  constructor(appTheme, helper, activeRoute) {
    this.appTheme = appTheme;
    this.helper = helper;
    this.activeRoute = activeRoute;
    this.linkIos = '';
    this.linkAndroid = '';
    if (this.activeRoute.snapshot.queryParamMap.get('params') !== null) {
      this.linkIos = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).linkIos;
      this.linkAndroid = JSON.parse(this.activeRoute.snapshot.queryParamMap.get('params')).linkAndroid;
    }
  }
  ngOnInit() {}
  goToStore() {
    if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.isPlatform)('ios') || (0,_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.isPlatform)('android')) {
      this.helper.openUrl((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_4__.isPlatform)('ios') ? this.linkIos : this.linkAndroid, '_system');
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_2__.AppThemeService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_3__.HelperService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute
    }];
  }
  static {
    this.propDecorators = {
      linkIos: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }],
      linkAndroid: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
      }]
    };
  }
};
UpdateAppPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-update-app',
  template: _update_app_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_update_app_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], UpdateAppPage);


/***/ }),

/***/ 61863:
/*!**********************************************!*\
  !*** ./src/app/pipes/active-ls/active-ls.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ActiveLsPipe: () => (/* binding */ ActiveLsPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../services/debug.service */ 33925);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




/**
 * Generated class for the NumberFormatPipe pipe.
 *
 * See https://angular.io/api/core/Pipe for more info on Angular Pipes.
 */
let ActiveLsPipe = class ActiveLsPipe {
  constructor(debug, request) {
    this.debug = debug;
    this.request = request;
  }
  /**
   * Takes a value and makes it lowercase.
   */
  transform(_ls) {
    return this.debug.screenMode$() ? _ls == this.request.activeLs.value ? this.debug.unreliableLS : this.debug.getRand() : _ls;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_0__.DebugService
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_1__.RequestService
    }];
  }
};
ActiveLsPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Pipe)({
  name: 'guardLsNumber',
  standalone: true
})], ActiveLsPipe);


/***/ }),

/***/ 35403:
/*!******************************************!*\
  !*** ./src/app/pipes/address/address.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AddressPipe: () => (/* binding */ AddressPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../services/debug.service */ 33925);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */



/**
 * Generated class for the NumberFormatPipe pipe.
 *
 * See https://angular.io/api/core/Pipe for more info on Angular Pipes.
 */
let AddressPipe = class AddressPipe {
  constructor(debug) {
    this.debug = debug;
  }
  /**
   * Takes a value and makes it lowercase.
   */
  transform(_address) {
    return this.debug.screenMode$() ? this.debug.unreliableAddress : _address;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_0__.DebugService
    }];
  }
};
AddressPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Pipe)({
  name: 'guardAddress',
  standalone: true
})], AddressPipe);


/***/ }),

/***/ 54171:
/*!**********************************!*\
  !*** ./src/app/pipes/fio/fio.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FioPipe: () => (/* binding */ FioPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../services/debug.service */ 33925);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */



/**
 * Generated class for the NumberFormatPipe pipe.
 *
 * See https://angular.io/api/core/Pipe for more info on Angular Pipes.
 */
let FioPipe = class FioPipe {
  constructor(debug) {
    this.debug = debug;
  }
  /**
   * Takes a value and makes it lowercase.
   */
  transform(_fio) {
    return this.debug.screenMode$() ? this.debug.unreliableFIO : _fio;
  }
  static {
    this.ctorParameters = () => [{
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_0__.DebugService
    }];
  }
};
FioPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Pipe)({
  name: 'guardFio',
  standalone: true
})], FioPipe);


/***/ }),

/***/ 2543:
/*!******************************************************!*\
  !*** ./src/app/pipes/number-format/number-format.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NumberFormatPipe: () => (/* binding */ NumberFormatPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */


/**
 * Generated class for the NumberFormatPipe pipe.
 *
 * See https://angular.io/api/core/Pipe for more info on Angular Pipes.
 */
let NumberFormatPipe = class NumberFormatPipe {
  /**
   * Takes a value and makes it lowercase.
   */
  transform(_number, args) {
    let num = _number.toString();
    num = (num + '').replace(/[^0-9+\-Ee.]/g, '');
    const n = !isFinite(+num) ? 0 : +num;
    const prec = !isFinite(+args[0]) ? 0 : Math.abs(args[0]);
    const sep = typeof args[1] === 'undefined' ? ',' : args[1];
    const dec = typeof args[2] === 'undefined' ? '.' : args[2];
    let s = '';
    s = (prec ? this.toFixedFix(n, prec) : '' + Math.round(n)).split('.');
    if (s[0].length > 3) {
      s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
    }
    if ((s[1] || '').length < prec) {
      s[1] = s[1] || '';
      s[1] += new Array(prec - s[1].length + 1).join('0');
    }
    return s.join(dec);
  }
  toFixedFix(n, prec) {
    const k = Math.pow(10, prec);
    return '' + (Math.round(n * k) / k).toFixed(prec);
  }
};
NumberFormatPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Pipe)({
  name: 'numberFormat'
})], NumberFormatPipe);


/***/ }),

/***/ 41683:
/*!***************************************!*\
  !*** ./src/app/pipes/pipes.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PipesModule: () => (/* binding */ PipesModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _number_format_number_format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./number-format/number-format */ 2543);
/* harmony import */ var _timer_format_timer_format__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./timer-format/timer-format */ 30243);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




let PipesModule = class PipesModule {};
PipesModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  declarations: [_number_format_number_format__WEBPACK_IMPORTED_MODULE_0__.NumberFormatPipe, _timer_format_timer_format__WEBPACK_IMPORTED_MODULE_1__.TimerFormatPipe],
  imports: [],
  exports: [_number_format_number_format__WEBPACK_IMPORTED_MODULE_0__.NumberFormatPipe, _timer_format_timer_format__WEBPACK_IMPORTED_MODULE_1__.TimerFormatPipe]
})], PipesModule);


/***/ }),

/***/ 30243:
/*!****************************************************!*\
  !*** ./src/app/pipes/timer-format/timer-format.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TimerFormatPipe: () => (/* binding */ TimerFormatPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */


/**
 * Generated class for the NumberFormatPipe pipe.
 *
 * See https://angular.io/api/core/Pipe for more info on Angular Pipes.
 */
let TimerFormatPipe = class TimerFormatPipe {
  /**
   * Takes a value and makes it lowercase.
   */
  transform(_seconds, _format = 'mm:ss') {
    const sec = _seconds % 60;
    const min = Math.trunc(_seconds / 60) % 60;
    const hor = Math.trunc(_seconds / 60 / 60);
    let result = '';
    const format = _format.split(':');
    format.forEach(item => {
      switch (item) {
        case 'hh':
          {
            result += this.toStr(hor, 2);
            break;
          }
        case 'h':
          {
            result += this.toStr(hor, 1);
            break;
          }
        case 'mm':
          {
            result += this.toStr(min, 2);
            break;
          }
        case 'm':
          {
            result += this.toStr(min, 1);
            break;
          }
        case 'ss':
          {
            result += this.toStr(sec, 2);
            break;
          }
        case 's':
          {
            result += this.toStr(sec, 1);
            break;
          }
      }
    });
    return result.slice(0, -1);
  }
  toStr(n, p) {
    if (p === 2 && n < 10) {
      return '0' + n + ':';
    }
    return n + ':';
  }
};
TimerFormatPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Pipe)({
  name: 'timerFormat'
})], TimerFormatPipe);


/***/ }),

/***/ 42341:
/*!*******************************************************!*\
  !*** ./src/app/services/android-safe-area.service.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AndroidSafeAreaService: () => (/* binding */ AndroidSafeAreaService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */


let AndroidSafeAreaService = class AndroidSafeAreaService {
  constructor() {
    // @ts-ignore
    if (window.AndroidNotch) {
      // @ts-ignore
      window.AndroidNotch.getInsetTop(safeAreaTop => {
        document.body.style.cssText = '--ion-safe-area-top: max(' + safeAreaTop + 'px, 30px)';
      });
    }
  }
  static {
    this.ctorParameters = () => [];
  }
};
AndroidSafeAreaService = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable)({
  providedIn: 'root'
})], AndroidSafeAreaService);


/***/ }),

/***/ 32310:
/*!**********************************************!*\
  !*** ./src/app/services/app-init.service.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppInitService: () => (/* binding */ AppInitService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _pages_message_message_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../pages/message/message.page */ 99849);
/* harmony import */ var _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../animations/pin-code-animation */ 6366);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./request.service */ 80931);
/* harmony import */ var _helper_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./helper.service */ 54102);
/* harmony import */ var _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @awesome-cordova-plugins/app-version/ngx */ 24297);
/* harmony import */ var _modal_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./modal.service */ 5455);
/* harmony import */ var _pages_update_app_update_app_page__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../pages/update-app/update-app.page */ 70777);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 51567);
















let AppInitService = class AppInitService {
  constructor(request, helper, appVersion, alertCtrl, modalService, navCtrl, translate) {
    var _this = this;
    this.request = request;
    this.helper = helper;
    this.appVersion = appVersion;
    this.alertCtrl = alertCtrl;
    this.modalService = modalService;
    this.navCtrl = navCtrl;
    this.translate = translate;
    this.updateInviteShow = false;
    this.request.available.subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (value) {
        if (value[_this.request.activeLs.value]) {
          if (value[_this.request.activeLs.value].result) yield _this.dateToFullText(+value[_this.request.activeLs.value].availableSendFrom, +value[_this.request.activeLs.value].availableSendTo, _this.helper.availableText);else _this.helper.availableText.next(value[_this.request.activeLs.value].message);
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
    this.helper.availablePaymentDate.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.filter)(value => value != null)).subscribe(/*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (value) {
        if (value.from && value.to) {
          yield _this.dateToFullText(+value.from, +value.to, _this.helper.availablePayText);
        }
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
    this.translate.onLangChange.subscribe(() => {
      this.request.available.next(this.request.available.value);
    });
  }
  /**
   * Функция принимает две даты и виде двух чисел (from, to), и преобразует их в интервал дат и записывает в 3-й параметр.
   * Предусмотрены все возможные варианты комбинаций чисел, в том числе когда from больше чем to
   *
   * Например: (from = 15, to = 25) => "С 15 до 25 января"
   *
   * @param from
   * @param to
   * @param variable
   */
  dateToFullText(from, to, variable) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const now = new Date();
      const lastDayCurrentMonth = +new Date(now.getFullYear(), now.getMonth() + 1, 0).getDate(); // последний день текущего месяца
      const lastDayNextMonth = +new Date(now.getFullYear(), now.getMonth() + 2, 0).getDate(); // последний день след. месяца
      let availableTextValue = '';
      const nextMonthId = (now.getMonth() + 1) % 12; // index след. месяца от текущей даты
      const nextYear = now.getMonth() < nextMonthId ? "" : " " + (now.getFullYear() + 1); // след. год в формате YYYY
      if (from <= to) {
        // передача показаний в рамках одного месяца
        if (now.getDate() < from || now.getDate() > to) {
          // если текущее число меньше даты начала показаний
          availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.FROM', {
            value: from + ' '
          }));
        }
        if (now.getDate() > to) {
          // Если в этом месяце период передачи прошел, показываем даты след. месяца
          if (lastDayNextMonth < to) {
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
              value: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[nextMonthId], {
                value: lastDayNextMonth
              }))) + nextYear
            }));
          } else {
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
              value: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[nextMonthId], {
                value: to
              }))) + nextYear
            }));
          }
        } else {
          // период в этом месяце еще не прошел, показываем даты текущего месяца
          if (lastDayCurrentMonth < to) {
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
              value: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[now.getMonth()], {
                value: lastDayCurrentMonth
              }))
            }));
          } else {
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
              value: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[now.getMonth()], {
                value: to
              }))
            }));
          }
        }
      } else {
        // передача показаний с конца одного до начала другого месяца
        if (now.getDate() < from && now.getDate() > to) {
          // если текущее число не входит в период передачи показаний
          if (lastDayCurrentMonth < from) {
            // период начала передачи показаний выходит за количество дней месяца - значит будем принимать с 1 числа след месяца
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.FROM', {
              value: 1 + ' '
            }));
          } else {
            // если период начинается позже в этом месяце
            availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.FROM', {
              value: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[now.getMonth()], {
                value: from
              }))) + ' '
            }));
          }
        }
        if (now.getDate() <= to) {
          // окончание периода в текущем месяце
          availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
            value: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[now.getMonth()], {
              value: to
            }))
          }));
        } else {
          // окончание периода в след месяце
          availableTextValue += yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get('MAIN.COUNTERS.TO', {
            value: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this2.translate.get(_this2.helper.months[nextMonthId], {
              value: to
            }))) + nextYear
          }));
        }
      }
      variable.next(availableTextValue);
    })();
  }
  sendAppInit(page) {
    var _this3 = this;
    this.request.postRequest(this.request.uri.appInitPost(), {}, {
      useCache: false,
      preloader: false,
      background: true
    }).subscribe(/*#__PURE__*/function () {
      var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_TECHNICAL_WORKS
        });
        let updateModelOpened = false;
        if (result.currentAppVersion !== undefined && result.minAppVersion !== undefined) {
          yield _this3.appCheckToUp(result, page, updateModelOpened);
        }
        if (result.infoPage !== undefined && !updateModelOpened) {
          if (result.infoPage.show) {
            if (document.querySelector('app-message') === null) {
              if (+(yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE_CLOSED
              })).value < result.infoPage.id) {
                _this3.modalService.openModal({
                  component: _pages_message_message_page__WEBPACK_IMPORTED_MODULE_2__.MessagePage,
                  cssClass: 'fullscreen-modal',
                  backdropDismiss: false,
                  swipeToClose: false,
                  enterAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_3__.enterPinCodeAnimation,
                  leaveAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_3__.leavePinCodeAnimation,
                  componentProps: {
                    type: 'message',
                    cssClass: 'fullscreen-modal',
                    overscroll: result.infoPage.overscroll,
                    backdropDismiss: false,
                    save: result.infoPage.save,
                    saveKey: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE,
                    saveClosed: true,
                    id: result.infoPage.id,
                    imageLight: result.infoPage.imageLight,
                    imageDark: result.infoPage.imageDark,
                    header: result.infoPage.header,
                    subHeader: result.infoPage.subHeader,
                    message: result.infoPage.message,
                    buttons: result.infoPage.buttons
                  },
                  type: 'fullscreen'
                }).then(() => {
                  _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
                    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE,
                    value: JSON.stringify({
                      type: 'message',
                      cssClass: 'fullscreen-modal',
                      overscroll: result.infoPage.overscroll,
                      backdropDismiss: false,
                      save: result.infoPage.save,
                      saveKey: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_MESSAGE,
                      saveClosed: true,
                      id: result.infoPage.id,
                      imageLight: result.infoPage.imageLight,
                      imageDark: result.infoPage.imageDark,
                      header: result.infoPage.header,
                      subHeader: result.infoPage.subHeader,
                      message: result.infoPage.message,
                      buttons: result.infoPage.buttons
                    })
                  });
                });
              }
            }
          }
        }
        if (result.payment !== undefined) {
          _this3.helper.availablePayment.next(result.payment);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_PAY,
            value: result.payment ? '1' : '0'
          });
        }
        if (result.paymentDate !== undefined) {
          _this3.helper.availablePaymentDate.next(result.paymentDate);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_PAY_DATE,
            value: JSON.stringify(result.paymentDate)
          });
        }
        if (result.readings !== undefined) {
          _this3.helper.availableReadings.next(result.readings);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_READINGS,
            value: result.readings ? '1' : '0'
          });
        }
        if (result.appeals !== undefined) {
          _this3.helper.availableAppeals.next(result.appeals);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_APPEALS,
            value: result.appeals ? '1' : '0'
          });
        }
        if (result.authByPhone !== undefined) {
          _this3.helper.authByPhone.next(result.authByPhone);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AUTH_BY_PHONE,
            value: result.authByPhone ? '1' : '0'
          });
        }
        if (result.quality !== undefined) {
          _this3.helper.availableQuality.next(result.quality);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_QUALITY,
            value: result.quality ? '1' : '0'
          });
        }
        if (result.recording !== undefined) {
          _this3.helper.availableRecording.next(result.recording);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.AVAILABLE_RECORDING,
            value: result.recording ? '1' : '0'
          });
        }
      });
      return function (_x3) {
        return _ref3.apply(this, arguments);
      };
    }());
  }
  appCheckToUp(result, page, updateModelOpened) {
    var _this4 = this;
    return this.appVersion.getVersionNumber().then(/*#__PURE__*/function () {
      var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (appVersion) {
        if (_this4.helper.checkNeedToUpdate(appVersion, result.minAppVersion)) {
          if (document.querySelector('app-update-app') === null) {
            updateModelOpened = true;
            yield _this4.modalService.openModal({
              component: _pages_update_app_update_app_page__WEBPACK_IMPORTED_MODULE_9__.UpdateAppPage,
              cssClass: 'fullscreen-modal',
              backdropDismiss: false,
              swipeToClose: false,
              enterAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_3__.enterPinCodeAnimation,
              leaveAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_3__.leavePinCodeAnimation,
              name: 'UpdateAppPage',
              componentProps: {
                linkIos: result.appStoreLink,
                linkAndroid: result.googlePlayLink
              },
              type: 'fullscreen'
            }).then(() => {
              _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP,
                value: JSON.stringify({
                  linkIos: result.appStoreLink,
                  linkAndroid: result.googlePlayLink,
                  appVersion: result.minAppVersion
                })
              }).then(() => {});
            });
          }
        } else {
          _this4.helper.needToUpdate.next(false);
          if (page === _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP && document.querySelector('app-update-app') !== null) {
            _this4.navCtrl.navigateForward('/tabs/main', {
              replaceUrl: true
            }).catch(() => {});
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.remove({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.PAGE_UPDATE_APP
            });
          }
          if (_this4.helper.checkNeedToUpdate(appVersion, result.currentAppVersion)) {
            if (_this4.helper.checkNeedToUpdate((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.UPDATE_INVITE_CLOSED
            })).value === null ? '0.1' : (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.UPDATE_INVITE_CLOSED
            })).value, result.currentAppVersion)) {
              if (!_this4.updateInviteShow) {
                _this4.updateInviteShow = true;
                const alert = yield _this4.alertCtrl.create({
                  header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this4.translate.get("TEXT_STRING.UPDATE_HEADER")),
                  message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this4.translate.get("TEXT_STRING.UPDATE_IS_AVAILABLE_MESSAGE")),
                  buttons: [{
                    text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this4.translate.get("BUTTONS.LATER")),
                    handler: () => {
                      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
                        key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.UPDATE_INVITE_CLOSED,
                        value: result.currentAppVersion
                      });
                    }
                  }, {
                    text: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this4.translate.get("BUTTONS.UPDATE")),
                    role: 'confirm',
                    handler: () => {
                      if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_12__.isPlatform)('ios')) {
                        _this4.helper.openUrl(result.appStoreLink, '_system');
                      } else {
                        _this4.helper.openUrl(result.googlePlayLink, '_system');
                      }
                    }
                  }]
                });
                yield alert.present();
              }
            }
          }
        }
      });
      return function (_x4) {
        return _ref4.apply(this, arguments);
      };
    }()).catch(err => {
      console.error(err);
      console.error('Плагин appVersion не поддерживается');
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _request_service__WEBPACK_IMPORTED_MODULE_5__.RequestService
    }, {
      type: _helper_service__WEBPACK_IMPORTED_MODULE_6__.HelperService
    }, {
      type: _awesome_cordova_plugins_app_version_ngx__WEBPACK_IMPORTED_MODULE_7__.AppVersion
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.AlertController
    }, {
      type: _modal_service__WEBPACK_IMPORTED_MODULE_8__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.NavController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_15__.TranslateService
    }];
  }
};
AppInitService = (0,tslib__WEBPACK_IMPORTED_MODULE_16__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_17__.Injectable)({
  providedIn: 'root'
})], AppInitService);


/***/ }),

/***/ 43017:
/*!***********************************************!*\
  !*** ./src/app/services/app-theme.service.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppThemeService: () => (/* binding */ AppThemeService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _status_bar_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./status-bar.service */ 48080);
/* harmony import */ var _modal_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modal.service */ 5455);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @awesome-cordova-plugins/keyboard/ngx */ 18532);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 3920);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */











let AppThemeService = class AppThemeService {
  constructor(statusBar, modalService, router, keyboard) {
    this.statusBar = statusBar;
    this.modalService = modalService;
    this.router = router;
    this.keyboard = keyboard;
    // Если в системе темная тема, то true, иначе false
    this.prefersDark = window.matchMedia('(prefers-color-scheme: dark)');
    /**
     * Выбранная тема оформления в приложении ('system', 'light', 'dark')
     */
    this.theme = 'system';
    /**
     * Текущая тема оформления в приложении ('light', 'dark')
     */
    this.prefers = 'light';
    this.performance = new rxjs__WEBPACK_IMPORTED_MODULE_6__.BehaviorSubject(null);
  }
  /**
   * Если выбрана системная тема, то подписываемся на изменение системной темы,
   * чтобы изменить тему приложения при изменении системной
   */
  systemThemeSubscribe(_themeInit = false) {
    this.systemThemeUnsubscribe();
    this.prefersDarkHandler = mediaQuery => {
      this.prefersDark = window.matchMedia('(prefers-color-scheme: dark)');
      if (document.body.getAttribute('color-theme') === 'system') {
        if (mediaQuery.matches) {
          this.setAppTheme('dark').catch(() => {});
        } else {
          this.setAppTheme('light').catch(() => {});
        }
      }
    };
    this.prefersDark.addEventListener('change', this.prefersDarkHandler);
    if (this.prefersDark.matches) {
      this.setAppTheme('dark', _themeInit).catch(() => {});
    } else {
      this.setAppTheme('light', _themeInit).catch(() => {});
    }
  }
  /**
   * Отписываемся если больше не нужно следить за изменением системной темы
   */
  systemThemeUnsubscribe() {
    this.prefersDark.removeEventListener('change', this.prefersDarkHandler);
  }
  /**
   * Устанавливает сохраненную в хранилище тему оформления
   */
  appThemeInit() {
    _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.APP_THEME
    }).then(data => {
      this.theme = data.value ? data.value : 'system';
      document.body.setAttribute('color-theme', this.theme);
      switch (this.theme) {
        case 'dark':
        case 'light':
          {
            this.setAppTheme(this.theme, true).catch(() => {});
            break;
          }
        case 'system':
        default:
          {
            this.systemThemeSubscribe(true);
          }
      }
    });
    this.performance.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_7__.filter)(value => value !== null)).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (value) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.APP_PERFORMANCE,
          value: (+value).toString()
        });
        if (value) {
          document.querySelector('html').classList.add('performance');
        } else {
          document.querySelector('html').classList.remove('performance');
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
    _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.APP_PERFORMANCE
    }).then(data => {
      if (data.value === null && (0,_ionic_angular__WEBPACK_IMPORTED_MODULE_8__.isPlatform)('android') || data.value === '1') {
        this.performance.next(true);
      } else {
        this.performance.next(false);
      }
    });
  }
  /**
   * Изменение темы оформления пользователем
   *
   * @param theme
   */
  appThemeChange(theme) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.theme = theme;
      _this.prefers = theme;
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.APP_THEME,
        value: theme
      }).catch(() => {});
      document.body.setAttribute('color-theme', theme);
      switch (theme) {
        case 'light':
        case 'dark':
          {
            _this.systemThemeUnsubscribe();
            yield _this.setAppTheme(theme);
            break;
          }
        case 'system':
        default:
          {
            _this.systemThemeSubscribe();
            break;
          }
      }
    })();
  }
  /**
   * Устанавливает темную или светлую тему оформления
   *
   * @param theme
   * @param themeInit
   */
  setAppTheme(_x2) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (theme, themeInit = false) {
      switch (theme) {
        case 'dark':
          {
            document.body.classList.toggle('dark', true);
            document.body.classList.toggle('light', false);
            _this2.prefers = 'dark';
            _this2.keyboard.setKeyboardStyle(_awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__.KeyboardStyle.Dark);
            break;
          }
        case 'light':
        default:
          {
            document.body.classList.toggle('dark', false);
            document.body.classList.toggle('light', true);
            _this2.prefers = 'light';
            _this2.keyboard.setKeyboardStyle(_awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__.KeyboardStyle.Light);
            break;
          }
      }
      if (Object.keys(_this2.modalService.openedModels).length > 0) {
        if (_this2.modalService.openedModels[_this2.modalService.openedModalsGetLastId()].type === 'card' || _this2.router.routerState.snapshot.url === '/tabs/main') {
          _this2.statusBar.styleLight();
        } else {
          _this2.statusBar.styleDefault();
        }
      } else {
        if (_this2.router.routerState.snapshot.url === '/tabs/main') {
          _this2.statusBar.styleLight();
        } else {
          _this2.statusBar.styleDefault();
        }
      }
    }).apply(this, arguments);
  }
  static {
    this.ctorParameters = () => [{
      type: _status_bar_service__WEBPACK_IMPORTED_MODULE_3__.StatusBarService
    }, {
      type: _modal_service__WEBPACK_IMPORTED_MODULE_4__.ModalService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_9__.Router
    }, {
      type: _awesome_cordova_plugins_keyboard_ngx__WEBPACK_IMPORTED_MODULE_5__.Keyboard
    }];
  }
};
AppThemeService = (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Injectable)({
  providedIn: 'root'
})], AppThemeService);


/***/ }),

/***/ 9214:
/*!****************************************************!*\
  !*** ./src/app/services/authentication.service.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthenticationService: () => (/* binding */ AuthenticationService),
/* harmony export */   isAuth: () => (/* binding */ isAuth)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs */ 56196);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs/operators */ 70271);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _global_loading_service_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./global-loading-service.service */ 81854);
/* harmony import */ var _http_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./http.service */ 56722);
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./request.service */ 80931);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../app.component */ 20092);
/* harmony import */ var _app_theme_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./app-theme.service */ 43017);
/* harmony import */ var ionic_cache__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ionic-cache */ 65503);
/* harmony import */ var _push_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./push.service */ 62802);
/* harmony import */ var _in_app_auth_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./in-app-auth.service */ 70604);
/* harmony import */ var _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../pages/add-code-modal/add-code-modal.page */ 10297);
/* harmony import */ var _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @awesome-cordova-plugins/native-storage/ngx */ 76558);
/* harmony import */ var _helper_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./helper.service */ 54102);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _app_init_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./app-init.service */ 32310);
/* harmony import */ var _token_service__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./token.service */ 2091);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */























const isAuth = new rxjs__WEBPACK_IMPORTED_MODULE_16__.BehaviorSubject(null);
let AuthenticationService = class AuthenticationService {
  constructor(http, router, navCtrl, device, globalLoadingService, alertCtrl, modalCtrl, request, appComponent, appTheme, cacheService, push, helper, inAppAuth, nativeStorage, translate, appInit) {
    this.http = http;
    this.router = router;
    this.navCtrl = navCtrl;
    this.device = device;
    this.globalLoadingService = globalLoadingService;
    this.alertCtrl = alertCtrl;
    this.modalCtrl = modalCtrl;
    this.request = request;
    this.appComponent = appComponent;
    this.appTheme = appTheme;
    this.cacheService = cacheService;
    this.push = push;
    this.helper = helper;
    this.inAppAuth = inAppAuth;
    this.nativeStorage = nativeStorage;
    this.translate = translate;
    this.appInit = appInit;
    this.loadToken().then(() => {});
  }
  /**
   * Подгружает из хранилища данные авторизации
   */
  loadToken() {
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const token = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.ACCESS_TOKEN
      });
      const accountId = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.ACCOUNT_ID
      });
      if (token && token.value && accountId.value) {
        _token_service__WEBPACK_IMPORTED_MODULE_15__["default"].next(token.value);
        isAuth.next(true);
      } else {
        isAuth.next(false);
      }
    })();
  }
  login(credentials) {
    var _this = this;
    return this.request.postRequest(this.request.uri.authPost(), credentials, {
      useCache: false
    }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_17__.map)(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (data.result) {
          _token_service__WEBPACK_IMPORTED_MODULE_15__["default"].next(data.access_token);
          yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.firstValueFrom)((0,_token_service__WEBPACK_IMPORTED_MODULE_15__.storeTokens)(data));
          isAuth.next(true);
          _this.request.getRequest(_this.request.uri.bindingsGet(), {
            forceUpdateCache: true,
            preloader: true
          }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_19__.finalize)(() => {
            _this.navCtrl.navigateRoot('/tabs/main', {
              animated: true,
              animationDirection: 'forward',
              replaceUrl: true,
              queryParams: {
                needToUpdateBindings: false
              }
            }).then(() => {});
          })).subscribe(/*#__PURE__*/function () {
            var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (response) {
              // Вызываем функцию коллбэк
              yield _this.request.loadBindingsCallback(response);
            });
            return function (_x2) {
              return _ref2.apply(this, arguments);
            };
          }());
        } else {
          isAuth.next(false);
          _this.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_20__.lastValueFrom)(_this.translate.get("TEXT_STRING.AUTH_FAILED_TITLE")),
            message: data.message,
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_20__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
          }).then(alert => {
            alert.present().then(() => {});
          });
        }
        return data;
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }()));
  }
  /**
   * Удаление данных авторизации, закрытие модальных окон, переход на страницу авторизации
   *
   * @param inPinCodePage - передавать true если вызывается со страницы ввода пин-кода
   */
  logout(inPinCodePage) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // перед логаутом закрываем все модальные окна с флагом равным null - что говорит о
      // незавершенном сеансе окна и будет повторный автоматический вызов окна, где это требуется
      if (!inPinCodePage) {
        while ((yield _this2.modalCtrl.getTop()) !== undefined) {
          yield (yield _this2.modalCtrl.getTop()).dismiss(null);
        }
        if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_21__.isPlatform)('ipad')) {
          _this2.modalCtrl.create({
            component: _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_11__.AddCodeModalPage,
            presentingElement: document.querySelector('ion-tabs').querySelector('ion-router-outlet'),
            cssClass: 'test-modal'
          }).then(/*#__PURE__*/function () {
            var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (modal) {
              yield modal.present();
            });
            return function (_x3) {
              return _ref3.apply(this, arguments);
            };
          }());
        }
      }
      _token_service__WEBPACK_IMPORTED_MODULE_15__["default"].next(null);
      const savedData = yield _this2.saveStorageData();
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.clear();
      _this2.nativeStorage.remove('blurPrivacyScreen').catch(err => console.error(err));
      yield _this2.cacheService.clearAll();
      _this2.request.reset();
      _this2.push.reset();
      isAuth.next(false);
      yield _this2.inAppAuth.reset();
      yield _this2.restoreStorageData(savedData);
      _this2.appInit.sendAppInit();
      setTimeout(() => {
        _this2.appTheme.appThemeChange('system');
      }, 300);
      yield _this2.navCtrl.navigateRoot('/login', {
        animated: !inPinCodePage,
        animationDirection: 'back',
        replaceUrl: true
      });
    })();
  }
  saveStorageData() {
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return {
        pageMessage: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.PAGE_MESSAGE
        })).value,
        pageMessageClosed: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.PAGE_MESSAGE_CLOSED
        })).value,
        availablePayments: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_PAY
        })).value,
        availablePaymentsDate: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_PAY_DATE
        })).value,
        availableAppeals: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_APPEALS
        })).value,
        availableReadings: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_READINGS
        })).value,
        availableRecording: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_RECORDING
        })).value,
        availableQuality: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AVAILABLE_QUALITY
        })).value,
        authByPhone: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.AUTH_BY_PHONE
        })).value,
        updateInviteClosed: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.UPDATE_INVITE_CLOSED
        })).value,
        AppPerformance: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.APP_PERFORMANCE
        })).value,
        pageUpdateApp: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.PAGE_UPDATE_APP
        })).value,
        pageTechnicalWorks: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.PAGE_TECHNICAL_WORKS
        })).value,
        divoSelectedOrg: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.DIVO_SELECTED_ORG
        })).value,
        apiUrl: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.API_URL
        })).value,
        unreliableLS: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.UNRELIABLE_LS
        })).value,
        deviceUUID: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_2__.DEVICE_UUID
        })).value
      };
    })();
  }
  restoreStorageData(dataSaved) {
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      Object.keys(dataSaved).forEach(item => {
        if (dataSaved[item] != null) {
          _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
            key: item,
            value: dataSaved[item]
          });
        }
      });
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _http_service__WEBPACK_IMPORTED_MODULE_5__.HttpService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_22__.Router
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_23__.NavController
    }, {
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_3__.Device
    }, {
      type: _global_loading_service_service__WEBPACK_IMPORTED_MODULE_4__.GlobalLoadingService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_24__.AlertController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_24__.ModalController
    }, {
      type: _request_service__WEBPACK_IMPORTED_MODULE_6__.RequestService
    }, {
      type: _app_component__WEBPACK_IMPORTED_MODULE_7__.AppComponent
    }, {
      type: _app_theme_service__WEBPACK_IMPORTED_MODULE_8__.AppThemeService
    }, {
      type: ionic_cache__WEBPACK_IMPORTED_MODULE_25__.CacheService
    }, {
      type: _push_service__WEBPACK_IMPORTED_MODULE_9__.PushService
    }, {
      type: _helper_service__WEBPACK_IMPORTED_MODULE_13__.HelperService
    }, {
      type: _in_app_auth_service__WEBPACK_IMPORTED_MODULE_10__.InAppAuthService
    }, {
      type: _awesome_cordova_plugins_native_storage_ngx__WEBPACK_IMPORTED_MODULE_12__.NativeStorage
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_26__.TranslateService
    }, {
      type: _app_init_service__WEBPACK_IMPORTED_MODULE_14__.AppInitService
    }];
  }
};
AuthenticationService = (0,tslib__WEBPACK_IMPORTED_MODULE_27__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_28__.Injectable)({
  providedIn: 'root'
})], AuthenticationService);


/***/ }),

/***/ 33925:
/*!*******************************************!*\
  !*** ./src/app/services/debug.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DebugService: () => (/* binding */ DebugService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/environment */ 45312);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _http_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./http.service */ 56722);
/* harmony import */ var _pages_change_data_modal_change_data_modal_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../pages/change-data-modal/change-data-modal.page */ 50553);
/* harmony import */ var _modal_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modal.service */ 5455);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../environments/connection */ 48129);










let DebugService = class DebugService {
  constructor(http, modalService) {
    this.http = http;
    this.modalService = modalService;
    this.isDebugMode = false;
    this.hideDevMenu = false;
    this.screenMode$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.signal)(false);
    this.deviceUUID = null;
    this.unreliableLS = null;
    this.unreliableFIO = null;
    this.defaultFIO = 'Иванов И.И.';
    this.unreliableAddress = null;
    this.defaultAddress = 'д Афанасьево, ул. Тепловиков, д. 5, кв. 20';
    this.unreliablePU = null;
    this.isDebugMode = this.checkDebugMode();
    if (this.isDebugMode) {
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.SCREEN_MODE
      }).then(value => {
        this.screenMode$.set(value.value == '1');
      });
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.API_URL
      }).then(value => {
        if (value.value) {
          this.http.api_url.next(value.value);
        }
      });
      if (this.unreliableLS === null) {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_LS
        }).then(value => {
          if (!value.value && this.screenMode$()) {
            this.generateLS();
          } else {
            this.unreliableLS = value.value;
          }
        });
      }
      if (this.unreliableFIO === null) {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_FIO
        }).then(value => {
          if (value.value) {
            this.unreliableFIO = value.value;
          } else {
            this.unreliableFIO = this.defaultFIO;
          }
        });
      }
      if (this.unreliableAddress === null) {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_ADDRESS
        }).then(value => {
          if (value.value) {
            this.unreliableAddress = value.value;
          } else {
            this.unreliableAddress = this.defaultAddress;
          }
        });
      }
      if (this.unreliablePU === null) {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_PU
        }).then(value => {
          if (value.value && this.screenMode$()) {
            this.unreliablePU = JSON.parse(value.value);
          } else {
            this.unreliablePU = {};
          }
        });
      }
      if (this.deviceUUID === null) {
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.DEVICE_UUID
        }).then(value => {
          if (!value.value) {
            this.changeDeviceUUID();
          } else {
            this.deviceUUID = value.value;
          }
        });
      }
    }
  }
  generateLS() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (length = 8) {
      _this.unreliableLS = _this.getRand(length);
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_LS,
        value: _this.unreliableLS
      });
    }).apply(this, arguments);
  }
  getCounterNumber(_realNumber) {
    if (!this.unreliablePU[_realNumber]) {
      this.unreliablePU[_realNumber] = this.getRand(length);
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.UNRELIABLE_PU,
        value: JSON.stringify(this.unreliablePU)
      });
    }
    return this.unreliablePU[_realNumber];
  }
  changeDeviceUUID() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (length = 8) {
      _this2.deviceUUID = _this2.getRand(length);
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.DEVICE_UUID,
        value: _this2.deviceUUID
      });
    }).apply(this, arguments);
  }
  getRand(length = 8) {
    return Math.floor(Math.random() * 1e8).toString().padStart(length, '0');
  }
  changeAPI() {
    var _this3 = this;
    return this.modalService.openModal({
      component: _pages_change_data_modal_change_data_modal_page__WEBPACK_IMPORTED_MODULE_5__.ChangeDataModalPage,
      componentProps: {
        title: 'Адрес API',
        inputType: 'text',
        name: 'ChangeAPISModal',
        value: this.http.api_url.value,
        handler: value => new Promise(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
            if (value.input != '') {
              _this3.http.api_url.next(value.input);
              yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.set({
                key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.API_URL,
                value: value.input
              });
            }
            resolve(true);
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }())
      }
    });
  }
  resetAPI() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this4.http.api_url.next((0,_environments_connection__WEBPACK_IMPORTED_MODULE_7__.GET_URL)());
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.remove({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_3__.API_URL
      });
    })();
  }
  checkDebugMode() {
    return !_environments_environment__WEBPACK_IMPORTED_MODULE_1__.environment.production && localStorage.getItem('DEBUG') !== '0';
  }
  static {
    this.ctorParameters = () => [{
      type: _http_service__WEBPACK_IMPORTED_MODULE_4__.HttpService
    }, {
      type: _modal_service__WEBPACK_IMPORTED_MODULE_6__.ModalService
    }];
  }
};
DebugService = (0,tslib__WEBPACK_IMPORTED_MODULE_9__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Injectable)({
  providedIn: 'root'
})], DebugService);


/***/ }),

/***/ 24704:
/*!******************************************!*\
  !*** ./src/app/services/file.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileService: () => (/* binding */ FileService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./request.service */ 80931);
/* harmony import */ var _angular_core_rxjs_interop__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core/rxjs-interop */ 49074);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 64334);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/preview-any-file/ngx */ 34505);
/* harmony import */ var _awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/file/ngx */ 66411);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _token_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./token.service */ 2091);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _http_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./http.service */ 56722);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../environments/settings */ 79308);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ngx-translate/core */ 597);















let FileService = class FileService {
  constructor(requestService, previewFile, file, platform, http, httpService, alertController, translate) {
    this.requestService = requestService;
    this.previewFile = previewFile;
    this.file = file;
    this.platform = platform;
    this.http = http;
    this.httpService = httpService;
    this.alertController = alertController;
    this.translate = translate;
    this.isCached$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.signal)(false);
    this.isLoading$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.signal)(false);
    this.isSuccessSave$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.signal)(false);
    this.isErrorSave$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.signal)(false);
    this.cachePrefix$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.signal)('');
    // todo: отрефачить после рефакторинга разрешенных файлов в settings.ts
    this.extensionsFiles = _environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_FILE;
    this.extensionsMedia = _environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_IMG;
    this.signatures = {
      JVBERi0: "application/pdf",
      R0lGODdh: "image/gif",
      R0lGODlh: "image/gif",
      iVBORw0KGgo: "image/png",
      TU0AK: "image/tiff",
      "/9j/": "image/jpg",
      UEs: "application/vnd.openxmlformats-officedocument.",
      PK: "application/zip"
    };
  }
  open(fileId, cacheKey, base64 = '', destroyRef) {
    cacheKey = cacheKey.split(" ").join("_");
    cacheKey = cacheKey.split("|").join("_");
    if (this.isCached$()) {
      this.loadFromCache(cacheKey);
    } else {
      destroyRef ? this.loadFileFromUrl(fileId, cacheKey, destroyRef) : this.openFile(base64, fileId);
    }
  }
  getFileWithUri(fullName = null, uri, destroyRef) {
    this.isLoading$.set(true);
    this.http.get(`${this.httpService.api_url.value}${uri}`, {
      headers: (0,_token_service__WEBPACK_IMPORTED_MODULE_4__.authHeader)(),
      responseType: 'blob'
    }).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_8__.take)(1), (0,_angular_core_rxjs_interop__WEBPACK_IMPORTED_MODULE_9__.takeUntilDestroyed)(destroyRef)).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.finalize)(() => this.isLoading$.set(false))).subscribe({
      next: blob => this.blobToBase64(blob).then(res => this.openFile(res, '', fullName)),
      error: err => console.error(err)
    });
  }
  isInCache(cacheKey, cachePrefix) {
    cacheKey = cacheKey.split(" ").join("_");
    cacheKey = cacheKey.split("|").join("_");
    this.cachePrefix$.set(cachePrefix);
    this.requestService.cacheService.itemExists(`${this.cachePrefix$()}${cacheKey}`).then(cached => {
      this.isCached$.set(cached);
    });
  }
  saveBase64(base64Data) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const blob = _this.base64ToBlob(base64Data, _this.getMimeTypeFromBase64(base64Data));
        const fileName = `downloaded_${new Date().getTime()}.jpg`;
        const path = _this.platform.is('android') ? `${_this.file.externalRootDirectory}Pictures/` : _this.file.documentsDirectory;
        _this.file.writeFile(path, fileName, blob, {
          replace: true
        }).then(() => _this.isSuccessSave$.set(true)).catch(() => _this.isErrorSave$.set(true));
      } catch (error) {
        _this.isErrorSave$.set(true);
      }
    })();
  }
  getMimeType(base64) {
    return this.getMimeTypeFromBase64(base64) ? this.getMimeTypeFromBase64(base64) : this.getMimeTypeFromSignature(base64);
  }
  getFileExtension(mimeType) {
    // todo: отрефачить весь метод после рефакторинга разрешенных файлов в settings.ts
    const fileExtensionIndex = this.extensionsFiles.value.indexOf(mimeType);
    const mediaExtensionIndex = this.extensionsMedia.value.indexOf(mimeType);
    let extension;
    if (fileExtensionIndex > -1 || mediaExtensionIndex > -1) {
      extension = fileExtensionIndex > -1 ? this.extensionsFiles.name[fileExtensionIndex] : this.extensionsMedia.name[mediaExtensionIndex];
    }
    return extension ? extension : null;
  }
  base64ToBlob(base64, contentType) {
    const byteCharacters = atob(base64.split(',')[1]);
    const byteArrays = [];
    for (let i = 0; i < byteCharacters.length; i += 512) {
      const slice = byteCharacters.slice(i, i + 512);
      const byteNumbers = new Array(slice.length);
      for (let j = 0; j < slice.length; j++) {
        byteNumbers[j] = slice.charCodeAt(j);
      }
      byteArrays.push(new Uint8Array(byteNumbers));
    }
    return new Blob(byteArrays, {
      type: contentType
    });
  }
  loadFileFromUrl(fileId, cacheKey, destroyRef) {
    const url = this.requestService.uri.receiptsGet(this.requestService.activeLs.value, fileId);
    this.isLoading$.set(true);
    this.requestService.getRequest(url, {
      preloader: false,
      background: false,
      onlyCacheOrRequest: true
    }).pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_8__.take)(1), (0,_angular_core_rxjs_interop__WEBPACK_IMPORTED_MODULE_9__.takeUntilDestroyed)(destroyRef), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.finalize)(() => this.isLoading$.set(false))).subscribe({
      next: res => {
        this.saveFileToCache(cacheKey, res.fileBase64);
        this.openFile(res.fileBase64, cacheKey);
      }
    });
  }
  loadFromCache(cacheKey) {
    this.requestService.cacheService.getRawItem(`${this.cachePrefix$()}${cacheKey}`).then(res => {
      this.openFile(JSON.parse(res.value), cacheKey);
    }).catch();
  }
  saveFileToCache(fileId, file) {
    this.requestService.cacheService.saveItem(`${this.cachePrefix$()}${fileId}`, file).then(() => {
      this.isCached$.set(true);
    });
  }
  openFile(file, fileId, fullName = null) {
    const mime = this.getMimeType(file);
    if (this.getFileExtension(mime)) {
      const name = fullName ? this.removeSpaces(fullName) : `${this.removeSpaces(fileId)}.${this.getFileExtension(file)}`;
      this.previewFile.previewBase64(file, {
        name,
        mimeType: this.getMimeType(file)
      }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_11__.catchError)(err => {
        console.error(err);
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_12__.of)(null);
      })).subscribe();
    } else {
      this.presentNotAllowedFile();
      return;
    }
  }
  blobToBase64(blob) {
    return new Promise((resolve, reject) => {
      const reader = new FileReader();
      reader.readAsDataURL(blob);
      reader.onloadend = () => resolve(reader.result);
      reader.onerror = reject;
    });
  }
  removeSpaces(name) {
    return name.split(' ').join('-');
  }
  presentNotAllowedFile() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.alertController.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_HEADER")),
        message: (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this2.translate.get("ERROR_STRING.MIME_TYPE_FILE_FAIL"))) + "\n" + (yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this2.translate.get("ERROR_STRING.MIME_TYPE_FILE"))) + [..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_IMG.name, ..._environments_settings__WEBPACK_IMPORTED_MODULE_6__.ALLOWED_EXTENSIONS_FILE.name].join(', '),
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_13__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
      }).then(alert => {
        alert.present();
      });
    })();
  }
  getMimeTypeFromBase64(base64) {
    return base64.split(';')[0].split(':')[1] || null;
  }
  getMimeTypeFromSignature(base64) {
    for (let s in this.signatures) {
      if (base64.indexOf(s) === 0) {
        return this.signatures[s];
      }
    }
  }
  static {
    this.ctorParameters = () => [{
      type: _request_service__WEBPACK_IMPORTED_MODULE_1__.RequestService
    }, {
      type: _awesome_cordova_plugins_preview_any_file_ngx__WEBPACK_IMPORTED_MODULE_2__.PreviewAnyFile
    }, {
      type: _awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_3__.File
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.Platform
    }, {
      type: _angular_common_http__WEBPACK_IMPORTED_MODULE_15__.HttpClient
    }, {
      type: _http_service__WEBPACK_IMPORTED_MODULE_5__.HttpService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_16__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_17__.TranslateService
    }];
  }
};
FileService = (0,tslib__WEBPACK_IMPORTED_MODULE_18__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Injectable)()], FileService);


/***/ }),

/***/ 81854:
/*!************************************************************!*\
  !*** ./src/app/services/global-loading-service.service.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GlobalLoadingService: () => (/* binding */ GlobalLoadingService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ionic/angular */ 21507);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */



let GlobalLoadingService = class GlobalLoadingService {
  constructor(loadingController) {
    this.loadingController = loadingController;
  }
  create(message) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const id = Math.random().toString(36).slice(2, 7);
      return yield _this.loadingController.create({
        message,
        id
      });
    })();
  }
  dismiss(id) {
    return new Promise((resolve, reject) => {
      this.loadingController.dismiss(id).then(res => {
        if (res) {
          resolve(id);
        } else {
          reject(id);
        }
      }).catch(e => {
        reject(e);
      });
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_1__.LoadingController
    }];
  }
};
GlobalLoadingService = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
  providedIn: 'root'
})], GlobalLoadingService);


/***/ }),

/***/ 54102:
/*!********************************************!*\
  !*** ./src/app/services/helper.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HelperService: () => (/* binding */ HelperService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _awesome_cordova_plugins_safari_view_controller_ngx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @awesome-cordova-plugins/safari-view-controller/ngx */ 85628);
/* harmony import */ var _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/in-app-browser/ngx */ 80197);
/* harmony import */ var _swipe_to_close_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./swipe-to-close.service */ 13719);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs/operators */ 80602);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../environments/settings */ 79308);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _awesome_cordova_plugins_clipboard_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/clipboard/ngx */ 96969);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */














let HelperService = class HelperService {
  constructor(translate, safariViewController, iab, device, animCtrl, platform, toastCtrl, clipboard) {
    var _this = this;
    this.translate = translate;
    this.safariViewController = safariViewController;
    this.iab = iab;
    this.device = device;
    this.animCtrl = animCtrl;
    this.platform = platform;
    this.toastCtrl = toastCtrl;
    this.clipboard = clipboard;
    this.availableText = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject('');
    this.availablePayText = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject('');
    this.availablePayment = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.availablePaymentDate = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(null);
    this.availableReadings = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.availableAppeals = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.authByPhone = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.availableQuality = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.availableRecording = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(false);
    this.focusToTabs = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(null);
    this.needToUpdate = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(null);
    // eslint-disable-next-line max-len
    this.selectData = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject({
      show: false
    });
    this.startActionHeight = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject(0);
    this.months = ['MONTHS.JANUARY', 'MONTHS.FEBRUARY', 'MONTHS.MARCH', 'MONTHS.APRIL', 'MONTHS.MAY', 'MONTHS.JUNE', 'MONTHS.JULY', 'MONTHS.AUGUST', 'MONTHS.SEPTEMBER', 'MONTHS.OCTOBER', 'MONTHS.NOVEMBERS', 'MONTHS.DECEMBER'];
    this.months2 = ['MONTHS2.JANUARY', 'MONTHS2.FEBRUARY', 'MONTHS2.MARCH', 'MONTHS2.APRIL', 'MONTHS2.MAY', 'MONTHS2.JUNE', 'MONTHS2.JULY', 'MONTHS2.AUGUST', 'MONTHS2.SEPTEMBER', 'MONTHS2.OCTOBER', 'MONTHS2.NOVEMBERS', 'MONTHS2.DECEMBER'];
    this.phoneMask = '+7 (___) ___ __-__';
    this.currency = _environments_settings__WEBPACK_IMPORTED_MODULE_6__.CURRENCY;
    this.symbolLocation = _environments_settings__WEBPACK_IMPORTED_MODULE_6__.SYMBOL_LOCATION;
    this.platform.ready().then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.swipe = new _swipe_to_close_service__WEBPACK_IMPORTED_MODULE_3__.SwipeToCloseService(document.querySelector('.custom-action-sheet-container'), _this.animCtrl, _this);
      _this.actionSheetInit();
    }));
  }
  /**
   * Преобразует номер телефона к определенному формату
   *
   * @param value
   */
  phoneFormat(value) {
    if (value === null || value === undefined) {
      value = '';
    }
    const matrix = this.phoneMask;
    let i = 0;
    const def = matrix.replace(/\D/g, '');
    const val = value.replace(/\D/g, '');
    let newValue = matrix.replace(/[_\d]/g, a => i < val.length ? val.charAt(i++) || def.charAt(i) : a);
    i = newValue.indexOf('_');
    if (i !== -1) {
      if (i < 5) {
        i = 3;
      }
      newValue = newValue.slice(0, i);
    }
    const reg = matrix.substr(0, value.length).replace(/_+/g, a => '\\d{1,' + a.length + '}').replace(/[+()]/g, '\\$&');
    const regExp = new RegExp('^' + reg + '$');
    value = newValue;
    //если подставляемый телефон вначале имеет не "+7" делаем "+7"
    value = value.replace(/^(\+\d)/g, '+7');
    return value;
  }
  checkNeedToUpdate(currentVersion, minVersion) {
    const arr1 = currentVersion.split('.');
    const arr2 = minVersion.split('.');
    while (arr1.length < arr2.length) {
      arr1.push('0');
    }
    try {
      arr1.forEach((num, key) => {
        if (+num < +arr2[key]) {
          // eslint-disable-next-line no-throw-literal
          throw {
            reason: true
          };
        } else if (+num > +arr2[key]) {
          // eslint-disable-next-line no-throw-literal
          throw {
            reason: false
          };
        }
      });
    } catch ({
      reason
    }) {
      return !!reason;
    }
    return false;
  }
  openUrl(url, target = '_self') {
    if (target === '_system') {
      this.openInAppBrowser(url);
    } else {
      this.openSafariViewController(url);
    }
  }
  openSafariViewController(url) {
    this.safariViewController.isAvailable().then(available => {
      if (available) {
        this.safariViewController.show({
          url,
          transition: 'curl',
          tintColor: window.getComputedStyle(document.body).getPropertyValue('--ion-color-primary-lighten-5'),
          barColor: window.getComputedStyle(document.body).getPropertyValue('--ion-color-primary-lighten-5'),
          controlTintColor: window.getComputedStyle(document.body).getPropertyValue('--ion-color-primary')
        }).subscribe({
          next: result => {
            //
          },
          error: error => console.error(error)
        });
      } else {
        // use fallback browser, example InAppBrowser
        this.openInAppBrowser(url);
      }
    }).catch(() => {
      this.openInAppBrowser(url);
    });
  }
  openInAppBrowser(url) {
    const options = 'location=yes,hidden=yes,beforeload=yes';
    const browser = this.iab.create(url, '_system', options);
    browser.executeScript({
      code: ''
    }).then(r => {});
    browser.on('loaderror').subscribe(error => {
      console.error(error);
    });
    browser.insertCSS({
      code: ''
    }).then(r => {});
    browser.on('loadstop').subscribe(event => {
      browser.insertCSS({
        code: ''
      }).then(r => {});
    });
    browser.close();
  }
  closeSafari() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this2.safariViewController.hide();
    })();
  }
  /**
   * Функция отображения собственного окна Action Sheet
   *
   * @param options
   */
  showActionSheet(options) {
    return new Promise(resolve => {
      this.selectData.next({
        show: true,
        data: options
      });
      this.selectData.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_10__.takeLast)(1)).subscribe(value => {
        if (value.data.result) {
          resolve(value.data.result);
        } else {
          resolve(null);
        }
      });
    });
  }
  /**
   * Функция закрытия окна Action sheet по любому из нескольких сценариев закрытия,
   * в случае закрытия с передачей значения - значение возвращается в качестве результата
   *
   * @param btn
   */
  closeSelect(btn) {
    // если нет блокировки для закрытия, то выполняем действия по закрытию
    if (!this.swipe.getBlockClose()) {
      const closeSelectHandle = selectBtn => {
        const nextValue = this.selectData.value;
        nextValue.show = false;
        nextValue.data.result = selectBtn;
        if (selectBtn) {
          nextValue.data.value = selectBtn.value;
        }
        // устанавливаем последнее значение для selectData и завершаем поток,
        // так как после завершения потока вернется результат из промиса, который был создан в showActionSheet
        this.selectData.next(nextValue);
        this.selectData.complete();
        // после полного закрытия окна создаем новый поток и инициализируем окно еще раз
        setTimeout(() => {
          this.selectData = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject({
            show: false
          });
          this.actionSheetInit();
          this.swipe.reset();
        }, 380);
      };
      if (btn && btn.handle) {
        btn.handle(btn).then(selectBtn => {
          if (selectBtn !== false) {
            closeSelectHandle(selectBtn);
          }
        }).catch(() => closeSelectHandle(null));
      } else {
        closeSelectHandle(btn);
      }
    }
  }
  close($event, value) {
    const btn = this.selectData.value.data.buttons[value];
    if (document.querySelector('.custom-action-sheet').querySelector('.el-anim-tap').getAttribute('block') !== 'true') {
      this.closeSelect(btn);
    }
  }
  changeChoice(value) {
    if (!this.swipe.getBlockClose()) {
      let dataValues = this.selectData.value.data.value;
      const index = dataValues.findIndex(i => i == value);
      if (index != -1) dataValues.splice(index, 1);else dataValues.push(value);
      this.selectData.value.data.value = dataValues;
    }
  }
  /**
   * Функция удаления дубликатов
   *
   * @param array
   */
  // arrayUnique(array) {
  //   const a = array.concat();
  //   for(let i=0; i<a.length; ++i) {
  //     for(let j=i+1; j<a.length; ++j) {
  //       if(a[i] === a[j])
  //         {a.splice(j--, 1);}
  //     }
  //   }
  //   return a;
  // };
  /**
   * Преобразует дату из формата (по-умолчанию) '20220721' в '21 июля 2022'
   * Форматы:
   *  1 'yyyymmdd' (по-умолчанию)
   *  2 'dd.mm.yyyy hh:mm:ss'
   *
   * @param num
   * @param format - исходный формат
   * @param time - если true, то в ответе будет дата и время (21 июля 2022 | 11:24)
   */
  dateConvert(num, format = 'yyyymmdd', time = false) {
    switch (format) {
      case 'yyyymmdd':
        {
          num = num.toString();
          const year = num[0] + num[1] + num[2] + num[3];
          const month = num[4] + num[5];
          const day = num[6] + num[7];
          return this.translate.instant(this.months[Number(month) - 1], {
            value: Number(day)
          }) + ' ' + Number(year);
        }
      case 'dd.mm.yyyy hh:mm:ss':
        {
          num = num.toString();
          const date = num.split(' ')[0];
          const year = date.split('.')[2];
          const month = date.split('.')[1];
          const day = date.split('.')[0];
          let timeStr = '';
          if (time) {
            const hour = num.split(' ')[1].split(':')[0];
            const minute = num.split(' ')[1].split(':')[1];
            timeStr = ' | ' + hour + ':' + minute;
          }
          return this.translate.instant(this.months[Number(month) - 1], {
            value: Number(day)
          }) + ' ' + Number(year) + timeStr;
        }
    }
  }
  /**
   * Функция удаления дубликатов уведомлений по id
   *
   * @param array
   */
  arrayNotificationsUnique(array) {
    const b = [];
    const a = array.concat();
    for (let i = 0; i < a.length; ++i) {
      for (let j = i + 1; j < a.length; ++j) {
        if (a[i].id === a[j].id) {
          if (a[i].companyStatus === null) {
            a[i].companyStatus = a[j].companyStatus;
          }
          a.splice(j--, 1);
          b.push(i);
        }
      }
    }
    return [a, b];
  }
  /**
   * Функция удаления дубликатов по полю
   *
   * @param array
   * @param key
   */
  arrayUnique(array, key) {
    const b = [];
    const a = array.concat();
    for (let i = 0; i < a.length; ++i) {
      for (let j = i + 1; j < a.length; ++j) {
        if (a[i][key] === a[j][key]) {
          a.splice(j--, 1);
          b.push(i);
        }
      }
    }
    return a;
  }
  arrayApplicationsUnique(array) {
    const a = array.concat();
    for (let i = 0; i < a.length; ++i) {
      for (let j = i + 1; j < a.length; ++j) {
        if (a[i].id === a[j].id) {
          a.splice(j--, 1);
        }
      }
    }
    return a;
  }
  /**
   * Группирует и сортирует массив сообщений по дням
   *
   * @param arr
   */
  arrayTransform(arr) {
    const retArr = {};
    this.sortByDate(arr);
    arr.forEach(item => {
      const date = this.dateConvert(item.date, 'dd.mm.yyyy hh:mm:ss');
      if (retArr[date] === undefined) {
        retArr[date] = [];
      }
      retArr[date].push(item);
    });
    return retArr;
  }
  /**
   * Фильтрует все новые уведомления и остаются только те из них, которые не были ранее сохранены
   *
   * @param arr1
   * @param arr2
   */
  onlyNewNotifications(arr1, arr2) {
    const a = [];
    for (const arr2Element of arr2) {
      let count = 0;
      for (const arr1Element of arr1) {
        if (arr2Element.id !== arr1Element.id) {
          count++;
        }
      }
      if (count === arr1.length) {
        a.push(arr2Element);
      }
    }
    return a;
  }
  /**
   * Сортировка массива уведомлений по дате
   *
   * @param array
   */
  sortByDate(array) {
    array.sort((a, b) => {
      try {
        const date1 = a.date.split(' ')[0].split('.');
        const time1 = a.date.split(' ')[1];
        const date2 = b.date.split(' ')[0].split('.');
        const time2 = b.date.split(' ')[1];
        const dateA = new Date(date1[2] + '-' + date1[1] + '-' + date1[0] + 'T' + time1);
        const dateB = new Date(date2[2] + '-' + date2[1] + '-' + date2[0] + 'T' + time2);
        // @ts-ignore
        return dateB - dateA;
      } catch (e) {
        console.error(e);
      }
    });
  }
  /**
   * Из переданной даты в формате '202301' возвращает название месяца 'январь'
   *
   * @param date
   */
  payDateConvert(date) {
    date = date.toString();
    const year = date[0] + date[1] + date[2] + date[3];
    const month = date[4] + date[5];
    return this.translate.instant(this.months[Number(month) - 1], {
      value: new Date(new Date().getFullYear(), month, 0).getDate()
    });
  }
  /**
   * Преобразует сумму к удобному для восприятия виду. Использует символ валюты из настроек
   * Пример: "12800.45" -> "12 800,45 ₽"
   * Принимает на вход число. На выходе строка
   *
   * @param sum - число для преобразования
   * @param rubleSign - нужно ли добавить в конце знак рубля (true)
   * @param format - Поддерживаемые форматы: '\*.\*' (default) и '\*.dd' и '\*.d*'
   */
  paySumFormate(sum, rubleSign = true, format = '*.*') {
    sum = Math.round(sum * 100) / 100;
    const parts = this.numberFormatted(sum).toString().split('.');
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
    if (format === '*.dd') {
      if (parts[1]) {
        if (parts[1].length === 1) {
          parts[1] += '0';
        }
      } else {
        parts[1] = '00';
      }
    } else if (format === '*.*') {
      if (parts[1]) {
        if (parts[1].length === 1) {
          parts[1] += '0';
        }
      }
    }
    let result = parts.join(',');
    if (rubleSign) {
      result = this.translate.instant('CURRENCY_' + _environments_settings__WEBPACK_IMPORTED_MODULE_6__.CURRENCY, {
        value: result
      });
    }
    return result;
  }
  /**
   * Округление суммы с копейками
   * @param sum
   */
  paySumRound(sum) {
    return Math.round(sum * 100) / 100;
  }
  /**
   * Преобразует строку в число, в том числе из формата суммы
   * @param str
   */
  strToNum(str) {
    return +str.split(' ').join('').split(',').join('.');
  }
  /**
   * Форматирует число в указанный формат
   *
   * @param number - число
   * @param format - формат (по-умолчанию 'd*.dd').
   * d - одна цифра, * - говорит о том что цифр может быть несколько, '.' - разделение целой и дробной части
   * @param capacity
   * @param capacityFractional
   */
  numberFormatted(number, format = 'd*.dd', capacity, capacityFractional) {
    const formatArr = format.split('.');
    let lengthIntegerPart = -1;
    let lengthFractionalPart = 0;
    let num = number.toString();
    num = num.split(',').join('.');
    const value = num.split('.');
    if (value.length > 1) {
      if (value[0] === '' && value[1] === '') {
        value[0] = '0';
        num = '0.';
      }
    }
    if (!Number(num) && Number(num) !== 0) {
      return '';
    }
    if (capacity) {
      lengthIntegerPart = capacity;
    } else if (formatArr[0].indexOf('*') === -1) {
      lengthIntegerPart = formatArr[0].length;
    }
    if (capacityFractional) {
      lengthFractionalPart = capacityFractional;
    } else if (formatArr[1]) {
      if (formatArr[1].indexOf('*') === -1) {
        lengthFractionalPart = formatArr[1].length;
      } else {
        lengthFractionalPart = -1;
      }
    }
    let diffIntegerPart = 0;
    let diffFractionalPart = 0;
    let result = '';
    if (lengthIntegerPart > 0) {
      if (value[0].length > lengthIntegerPart) {
        diffIntegerPart = value[0].length - lengthIntegerPart;
        result += value[0].slice(0, value[0].length - diffIntegerPart);
      } else if (value[0].length < lengthIntegerPart) {
        diffIntegerPart = lengthIntegerPart - value[0].length;
        for (let i = 0; i < diffIntegerPart; i++) {
          result += '0';
        }
        result += value[0];
      } else {
        result += value[0];
      }
    } else if (lengthIntegerPart == 0) {
      result += '0';
    } else {
      result += value[0];
    }
    if (lengthFractionalPart > 0) {
      if (value[1]) {
        if (value[1].length > lengthFractionalPart) {
          diffFractionalPart = value[1].length - lengthFractionalPart;
          result += '.' + value[1].slice(0, value[1].length - diffFractionalPart);
        } else if (value[1].length < lengthFractionalPart) {
          diffFractionalPart = lengthFractionalPart - value[1].length;
          result += '.' + value[1];
          for (let i = 0; i < diffFractionalPart; i++) {
            result += '0';
          }
        } else {
          result += '.' + value[1];
        }
      } else {
        result += '.0';
      }
    } else if (lengthFractionalPart === -1) {
      result += '.' + value[1];
    }
    return result;
  }
  /**
   * Функции инициализации custom Action sheet
   * внутри подписываемся на изменения selectData, для того чтобы отобразить или скрыть Action sheet
   *
   * Для отображения окна нужно вызвать функцию showActionSheet и передать необходимые параметры
   */
  actionSheetInit() {
    this.selectData.subscribe(value => {
      const backdrop = document.querySelector('ion-app').querySelector('.custom-action-sheet-block').querySelector('ion-backdrop');
      const el = document.querySelector('.custom-action-sheet');
      const block = document.querySelector('.custom-action-sheet-block');
      if (value.show) {
        // показывается анимация появления самого окна
        el.classList.add('show');
        const zIndexes = [];
        document.querySelector('ion-app').querySelectorAll('[style*="z-index:"]').forEach(el => {
          zIndexes.push(+el.style.zIndex);
        });
        block.style.zIndex = (Math.max(...zIndexes) + 1).toString();
        this.swipe.show();
        el.classList.add('custom-action-sheet-show');
        backdrop.classList.add('backdrop-show');
        backdrop.classList.add('backdrop-in-top');
      } else {
        // если присутствует тип окна, значит окно закрывается пользователем, а не при инициализации
        if (value.data !== undefined) {
          // показывается анимация закрытия самого окна
          this.swipe.hide();
          // показывается анимация закрытия фона
          el.classList.remove('custom-action-sheet-show');
          backdrop.classList.remove('backdrop-show');
          backdrop.classList.remove('backdrop-in-top');
          setTimeout(() => {
            el.classList.remove('show');
            el.classList.remove('lock');
            block.style.zIndex = 0 .toString();
          }, 380);
        } else {
          // иначе просто устанавливаем элементы в начальное положение готовое к анимации появления
          el.classList.remove('show');
          el.classList.remove('lock');
          this.swipe.init = false;
        }
      }
    });
  }
  getAppSettings() {
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return {
        theme: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.APP_THEME
        })).value == null ? 'system' : (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.APP_THEME
        })).value,
        performance: (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.APP_PERFORMANCE
        })).value
      };
    })();
  }
  shortFileName(str, maxlen = 16) {
    if (str.length > maxlen) {
      let endStrLength = 7;
      if (maxlen < 10) {
        endStrLength = 5;
      }
      let part1 = str.substring(0, maxlen - endStrLength - 1);
      let part2 = str.substring(str.length - endStrLength, str.length - endStrLength + endStrLength);
      return part1 + '…' + part2;
    }
    return str;
  }
  openIAP(url) {
    this.isIos() ? this.openSafariVc(this.formatUrl(url)) : this.openAndroidIap(url);
  }
  copy(text) {
    var _this3 = this;
    this.clipboard.copy(text).then(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.toastCtrl.create({
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_11__.lastValueFrom)(_this3.translate.get("TEXT_STRING.TEXT_COPYED")),
        duration: 3000
      }).then(/*#__PURE__*/function () {
        var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (toast) {
          yield toast.present();
        });
        return function (_x) {
          return _ref3.apply(this, arguments);
        };
      }());
    }));
  }
  formatUrl(url) {
    let formattedUrl = url;
    const isHttp = formattedUrl.includes('http') || formattedUrl.includes('https');
    if (!isHttp) {
      const urlArray = formattedUrl.split('');
      urlArray.unshift('https://');
      formattedUrl = urlArray.join('');
    }
    return formattedUrl.replace('www.', '');
  }
  isIos() {
    const platform = this.device.platform;
    if (!platform) return false;
    return platform.toLowerCase() === 'ios';
  }
  openSafariVc(url) {
    this.safariViewController.show({
      url,
      animated: true
    }).subscribe();
  }
  openAndroidIap(url) {
    this.iab.create(url).show();
  }
  static {
    this.ctorParameters = () => [{
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_12__.TranslateService
    }, {
      type: _awesome_cordova_plugins_safari_view_controller_ngx__WEBPACK_IMPORTED_MODULE_1__.SafariViewController
    }, {
      type: _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_2__.InAppBrowser
    }, {
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_7__.Device
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.AnimationController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_14__.Platform
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.ToastController
    }, {
      type: _awesome_cordova_plugins_clipboard_ngx__WEBPACK_IMPORTED_MODULE_8__.Clipboard
    }];
  }
};
HelperService = (0,tslib__WEBPACK_IMPORTED_MODULE_15__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_16__.Injectable)({
  providedIn: 'root'
})], HelperService);


/***/ }),

/***/ 56722:
/*!******************************************!*\
  !*** ./src/app/services/http.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HttpService: () => (/* binding */ HttpService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs */ 77919);
/* harmony import */ var _global_loading_service_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./global-loading-service.service */ 81854);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../app.component */ 20092);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../environments/connection */ 48129);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */









let HttpService = class HttpService {
  constructor(http,
  // private httpM: HttpClientModule,
  globalLoadingService, alertCtrl, translate) {
    this.http = http;
    this.globalLoadingService = globalLoadingService;
    this.alertCtrl = alertCtrl;
    this.translate = translate;
    this.api_url = new rxjs__WEBPACK_IMPORTED_MODULE_4__.BehaviorSubject((0,_environments_connection__WEBPACK_IMPORTED_MODULE_3__.GET_URL)());
  }
  get(_uri, _options) {
    if (!this.checkConnection()) {
      return this.internetError();
    }
    return this.http.get(this.api_url.value + _uri, _options);
  }
  post(_uri, _body, _options) {
    if (!this.checkConnection()) {
      return this.internetError();
    }
    return this.http.post(this.api_url.value + _uri, _body, _options);
  }
  checkConnection() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (!_app_component__WEBPACK_IMPORTED_MODULE_2__.AppComponent.networkConnect.value) {
        _this.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("ERROR_STRING.INTERNET_CONNECTION_FAIL_HEADER")),
          message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("ERROR_STRING.INTERNET_CONNECTION_FAIL")),
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
        }).then(alert => alert.present());
        return false;
      }
      return true;
    })();
  }
  internetError() {
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_6__.throwError)(() => new Error('Not internet connection'));
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_common_http__WEBPACK_IMPORTED_MODULE_7__.HttpClient
    }, {
      type: _global_loading_service_service__WEBPACK_IMPORTED_MODULE_1__.GlobalLoadingService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_8__.AlertController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_9__.TranslateService
    }];
  }
};
HttpService = (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Injectable)({
  providedIn: 'root'
})], HttpService);


/***/ }),

/***/ 70604:
/*!*************************************************!*\
  !*** ./src/app/services/in-app-auth.service.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InAppAuthService: () => (/* binding */ InAppAuthService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _pages_pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../pages/pin-code/pin-code.page */ 47033);
/* harmony import */ var _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../animations/pin-code-animation */ 6366);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../pages/add-code-modal/add-code-modal.page */ 10297);
/* harmony import */ var _modal_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modal.service */ 5455);
/* harmony import */ var _status_bar_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./status-bar.service */ 48080);
/* harmony import */ var _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/touch-id/ngx */ 76098);
/* harmony import */ var _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @awesome-cordova-plugins/fingerprint-aio/ngx */ 61649);
/* harmony import */ var _pages_bio_modal_bio_modal_page__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../pages/bio-modal/bio-modal.page */ 5865);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */














let InAppAuthService = class InAppAuthService {
  constructor(modalCtrl, statusBar, faio, modalService, touchId, platform) {
    this.modalCtrl = modalCtrl;
    this.statusBar = statusBar;
    this.faio = faio;
    this.modalService = modalService;
    this.touchId = touchId;
    this.platform = platform;
    this.isPin = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(false);
    this.pinInst = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(false);
    this.faioAvailable = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(false);
    this.faioChanged = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(false);
    this.faioEnabled = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(false);
    this.faioType = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(null);
    this.faioErrorCode = new rxjs__WEBPACK_IMPORTED_MODULE_11__.BehaviorSubject(0);
  }
  reset() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // сначала устанавливаем значение null, чтобы оно обработалось там где на объект подписаны, а затем false
      _this.isPin.next(null);
      _this.isPin.next(false);
      _this.pinInst.next(false);
      _this.faioAvailable.next(false);
      _this.faioChanged.next(false);
      _this.faioEnabled.next(false);
      _this.faioType.next(null);
      _this.faioErrorCode.next(0);
      yield _this.auth();
    })();
  }
  auth() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const pinCodeEnabled = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE_ENABLED
      });
      _this2.platform.ready().then(() => {
        _this2.faio.isAvailable({
          requireStrongBiometrics: false
        }).then(/*#__PURE__*/function () {
          var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (type) {
            _this2.touchId.didFingerprintDatabaseChange().then(/*#__PURE__*/function () {
              var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (changed) {
                if (changed || (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
                  key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED
                })).value === '1') {
                  // устанавливаем флаг о том что биометрия была изменена и пока пользователь не введет код-пароль сканирование невозможно
                  yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
                    key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_CHANGED,
                    value: '1'
                  });
                  _this2.faioChanged.next(true);
                } else {
                  _this2.faioChanged.next(false);
                }
              });
              return function (_x2) {
                return _ref2.apply(this, arguments);
              };
            }()).catch(() => {});
            _this2.faioAvailable.next(true);
            _this2.faioType.next(type);
            if ((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED
            })).value === '1') {
              _this2.faioEnabled.next(true);
            }
          });
          return function (_x) {
            return _ref.apply(this, arguments);
          };
        }()).catch(err => {
          _this2.faioErrorCode.next(err.code);
        });
      });
      if (pinCodeEnabled.value === '1') {
        _this2.pinInst.next(true);
        return yield _this2.presentModal().then(result => {
          result.onDidDismiss().then(value => {
            if (value.data) {
              _this2.isPin.next(value.data);
            }
          });
          return true;
        }).catch(err => {
          _this2.isPin.next(false);
          return false;
        });
      } else {
        _this2.pinInst.next(false);
        _this2.isPin.next(true);
        return new Promise(resolve => resolve(true)).then(() => true);
      }
    })();
  }
  showModalAddCode(routerOutlet) {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const pinCodeInvited = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE_INVITED
      });
      if (pinCodeInvited.value === null) {
        const modal = yield _this3.modalService.openModal({
          component: _pages_add_code_modal_add_code_modal_page__WEBPACK_IMPORTED_MODULE_5__.AddCodeModalPage,
          swipeToClose: true,
          presentingElement: routerOutlet.nativeEl,
          name: 'code_invite',
          type: 'card'
        });
        modal.onDidDismiss().then(/*#__PURE__*/function () {
          var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.PIN_CODE_INVITED,
              value: '1'
            });
            if (result.data) {
              _this3.faio.isAvailable({
                requireStrongBiometrics: false
              }).then(/*#__PURE__*/function () {
                var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (type) {
                  // если доступна биометрия и пользователь еще не активировал сканирование биометрии,
                  // то отображаем окно с предложением сделать это
                  if ((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
                    key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED
                  })).value === null) {
                    const modalTouchId = yield _this3.modalService.openModal({
                      component: _pages_bio_modal_bio_modal_page__WEBPACK_IMPORTED_MODULE_10__.BioModalPage,
                      swipeToClose: true,
                      presentingElement: routerOutlet.nativeEl,
                      type: 'card'
                    });
                  }
                });
                return function (_x4) {
                  return _ref4.apply(this, arguments);
                };
              }()).catch(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
                  key: _environments_storage__WEBPACK_IMPORTED_MODULE_4__.FAIO_ENABLED,
                  value: '0'
                });
              }));
            }
          });
          return function (_x3) {
            return _ref3.apply(this, arguments);
          };
        }());
      }
    })();
  }
  presentModal() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      let enterAnim;
      // eslint-disable-next-line prefer-const
      enterAnim = _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__.enterPinCodeAnimation;
      return yield _this4.modalService.openModal({
        component: _pages_pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_1__.PinCodePage,
        cssClass: 'fullscreen-modal top-modal',
        backdropDismiss: false,
        swipeToClose: false,
        enterAnimation: enterAnim,
        leaveAnimation: _animations_pin_code_animation__WEBPACK_IMPORTED_MODULE_2__.leavePinCodeAnimation,
        type: 'fullscreen'
      });
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_12__.ModalController
    }, {
      type: _status_bar_service__WEBPACK_IMPORTED_MODULE_7__.StatusBarService
    }, {
      type: _awesome_cordova_plugins_fingerprint_aio_ngx__WEBPACK_IMPORTED_MODULE_9__.FingerprintAIO
    }, {
      type: _modal_service__WEBPACK_IMPORTED_MODULE_6__.ModalService
    }, {
      type: _awesome_cordova_plugins_touch_id_ngx__WEBPACK_IMPORTED_MODULE_8__.TouchID
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_13__.Platform
    }];
  }
};
InAppAuthService = (0,tslib__WEBPACK_IMPORTED_MODULE_14__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_15__.Injectable)({
  providedIn: 'root'
})], InAppAuthService);


/***/ }),

/***/ 5455:
/*!*******************************************!*\
  !*** ./src/app/services/modal.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalService: () => (/* binding */ ModalService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 3920);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _status_bar_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./status-bar.service */ 48080);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _pages_pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../pages/pin-code/pin-code.page */ 47033);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */






let ModalService = class ModalService {
  constructor(modalCtrl, statusBar, router) {
    this.modalCtrl = modalCtrl;
    this.statusBar = statusBar;
    this.router = router;
    this.openedModels = {}; // Массив открытых модальных окон
  }
  openedModalsGetLastId() {
    if (Object.keys(this.openedModels).length > 0) {
      return +Object.keys(this.openedModels)[Object.keys(this.openedModels).length - 1];
    } else {
      return 1;
    }
  }
  openModal(config) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      config.mode = 'ios';
      if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_3__.isPlatform)('ipad')) {
        if (document.querySelectorAll('ion-modal').length > 0) {
          config.presentingElement = yield _this.modalCtrl.getTop();
        } else {
          config.presentingElement = yield _this.modalCtrl.getTop();
        }
        if (config.component !== _pages_pin_code_pin_code_page__WEBPACK_IMPORTED_MODULE_2__.PinCodePage || config.componentProps && config.componentProps.swipeToClose) {
          config.type = 'card';
        } else {
          config.type = 'fullscreen';
          delete config.presentingElement;
        }
      } else {
        if ((0,_ionic_angular__WEBPACK_IMPORTED_MODULE_3__.isPlatform)('android')) {
          config.type = 'fullscreen';
          delete config.presentingElement;
        }
        if (config.type === 'card') {
          config.mode = 'ios';
          config.cssClass = config.cssClass + ' modal-card';
          _this.statusBar.styleLight();
        } else {
          _this.statusBar.styleDefault();
        }
        if (config.presentingElement && config.type === 'card' && config.presentingElement !== document.querySelector('ion-tabs').querySelector('ion-router-outlet')) {
          document.querySelector('ion-tabs').querySelector('.tabs-inner').classList.add('presentingElement');
          document.querySelectorAll('.show-modal').forEach((item, key) => {
            if (key < document.querySelectorAll('.show-modal').length - 1) {
              item.classList.add('presentingElement');
            }
          });
        }
      }
      let modal;
      try {
        modal = yield _this.modalCtrl.create(config);
      } catch (e) {}
      if (!(0,_ionic_angular__WEBPACK_IMPORTED_MODULE_3__.isPlatform)('ipad')) {
        _this.openedModels[_this.openedModalsGetLastId() + 1] = {
          id: _this.openedModalsGetLastId() + 1,
          _modalName: config.name,
          type: config.type,
          modal
        };
        modal.onWillDismiss().then(data => {
          try {
            if (data.data) {
              if (data.data._modalName) {
                Object.values(_this.openedModels).forEach(item => {
                  // @ts-ignore
                  if (item._modalName === 'code_invite') {
                    // @ts-ignore
                    delete _this.openedModels[item.id];
                  }
                });
              } else {
                delete _this.openedModels[_this.openedModalsGetLastId()];
              }
            } else {
              delete _this.openedModels[_this.openedModalsGetLastId()];
            }
            if (Object.keys(_this.openedModels).length > 0) {
              if (_this.openedModels[_this.openedModalsGetLastId()].type === 'card') {
                _this.statusBar.styleLight();
              } else {
                _this.statusBar.styleDefault();
              }
              if (_this.openedModels[_this.openedModalsGetLastId()].type === 'card') {
                if (Object.keys(_this.openedModels).length > 1) {
                  if (document.querySelector('ion-tabs')) {
                    document.querySelector('ion-tabs').querySelector('.tabs-inner').classList.add('presentingElement');
                  }
                } else {
                  if (document.querySelector('ion-tabs')) {
                    document.querySelector('ion-tabs').querySelector('.tabs-inner').classList.remove('presentingElement');
                  }
                }
                document.querySelectorAll('ion-modal').forEach((item, key) => {
                  item.classList.remove('presentingElement');
                });
              } else {
                if (document.querySelector('ion-tabs')) {
                  document.querySelector('ion-tabs').querySelector('.tabs-inner').classList.remove('presentingElement');
                }
                document.querySelectorAll('ion-modal').forEach(item => {
                  item.classList.remove('presentingElement');
                });
              }
            } else {
              if (_this.router.routerState.snapshot.url === '/tabs/main') {
                _this.statusBar.styleLight();
              } else {
                _this.statusBar.styleDefault();
              }
              if (document.querySelector('ion-tabs')) {
                document.querySelector('ion-tabs').querySelector('.tabs-inner').classList.remove('presentingElement');
              }
            }
          } catch (e) {}
        });
      }
      yield modal.present();
      return modal;
    })();
  }
  closeModalByName(name) {
    Object.values(this.openedModels).forEach(item => {
      if (item.name === name) {
        item.modal.dismiss();
        return;
      }
    });
    this.router.navigateByUrl('/tabs/main', {
      replaceUrl: true
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController
    }, {
      type: _status_bar_service__WEBPACK_IMPORTED_MODULE_1__.StatusBarService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.Router
    }];
  }
};
ModalService = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Injectable)({
  providedIn: 'root'
})], ModalService);


/***/ }),

/***/ 10449:
/*!************************************************!*\
  !*** ./src/app/services/phone-mask.service.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   maskPhone: () => (/* binding */ maskPhone),
/* harmony export */   maskPredicate: () => (/* binding */ maskPredicate)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var _maskito_kit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @maskito/kit */ 45869);


const maskPredicate = /*#__PURE__*/function () {
  var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (el) {
    return el.getInputElement();
  });
  return function maskPredicate(_x) {
    return _ref.apply(this, arguments);
  };
}();
const maskPhone = {
  mask: ['+', '7', ' ', '(', /[0-9]/, /[0-9]/, /[0-9]/, ')', ' ', /[0-9]/, /[0-9]/, /[0-9]/, '-', /[0-9]/, /[0-9]/, '-', /[0-9]/, /[0-9]/],
  postprocessors: [
  // non-removable country prefix
  (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_1__.maskitoPrefixPostprocessorGenerator)('+7')],
  preprocessors: [createCompletePhoneInsertionPreprocessor()],
  plugins: [(0,_maskito_kit__WEBPACK_IMPORTED_MODULE_1__.maskitoAddOnFocusPlugin)('+7'), (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_1__.maskitoRemoveOnBlurPlugin)('+7'),
  // Forbids to put caret before non-removable country prefix
  // But allows to select all value!
  (0,_maskito_kit__WEBPACK_IMPORTED_MODULE_1__.maskitoCaretGuard)((value, [from, to]) => [from === to ? '+7'.length : 0, value.length])]
};
function createCompletePhoneInsertionPreprocessor() {
  const trimPrefix = value => value.replace(/^(\+?7?\s?)\s?/, '');
  const countDigits = value => value.replace(/\D/g, '').length;
  return ({
    elementState,
    data
  }) => {
    const {
      value,
      selection
    } = elementState;
    return {
      elementState: {
        selection,
        value: countDigits(value) > 11 ? trimPrefix(value) : value
      },
      data: countDigits(data) >= 11 ? trimPrefix(data) : data
    };
  };
}

/***/ }),

/***/ 62802:
/*!******************************************!*\
  !*** ./src/app/services/push.service.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PushService: () => (/* binding */ PushService),
/* harmony export */   oneSignalID: () => (/* binding */ oneSignalID)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/settings */ 79308);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./request.service */ 80931);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! onesignal-cordova-plugin */ 45871);
/* harmony import */ var onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _authentication_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./authentication.service */ 9214);
/* harmony import */ var _helper_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./helper.service */ 54102);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */












var oneSignalID = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject('null');
let PushService = class PushService {
  constructor(device, navCtrl, request, helper, platform) {
    this.device = device;
    this.navCtrl = navCtrl;
    this.request = request;
    this.helper = helper;
    this.platform = platform;
    this.opened = {};
    this.pulled = {};
    this.newPushHandler = this.newPush();
    this.openPushHandler = this.openPush();
  }
  /**
   * Инициализация приложения в сервисе OneSignal
   */
  init() {
    // @ts-ignore
    if (_environments_settings__WEBPACK_IMPORTED_MODULE_1__.ONESIGNAL_APP_ID !== '' && _environments_settings__WEBPACK_IMPORTED_MODULE_1__.GOOGLE_PROJECT_NUMBER !== '' && this.platform.is("cordova")) {
      this.platform.ready().then(() => {
        onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().initialize(_environments_settings__WEBPACK_IMPORTED_MODULE_1__.ONESIGNAL_APP_ID);
      });
    }
  }
  /**
   * Подписка пользователя на уведомления
   */
  sub() {
    this.platform.ready().then(() => {
      // @ts-ignore
      if (_environments_settings__WEBPACK_IMPORTED_MODULE_1__.ONESIGNAL_APP_ID !== '' && _environments_settings__WEBPACK_IMPORTED_MODULE_1__.GOOGLE_PROJECT_NUMBER !== '' && this.platform.is("cordova")) {
        try {
          onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().Notifications.requestPermission(false).then(val => {
            if (val) {
              onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().User.pushSubscription.optIn();
            }
            onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().Notifications.addEventListener('foregroundWillDisplay', this.newPushHandler);
            onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().Notifications.addEventListener('click', this.openPushHandler);
          }).finally(() => {
            onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().login('accountId_' + _request_service__WEBPACK_IMPORTED_MODULE_3__.accountId.value);
            onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().User.pushSubscription.getIdAsync().then(id => {
              oneSignalID.next(id);
              this.request.postRequest(this.request.uri.updateDeviceIdPost(), {
                userId: id,
                deviceId: this.device.uuid
              }, {
                useCache: false,
                preloader: false,
                background: true
              }).subscribe();
            });
          });
        } catch (e) {
          console.error(e);
        }
      }
    });
  }
  /**
   * Отключение пользователя от получения уведомлений
   */
  reset() {
    // @ts-ignore
    if (_environments_settings__WEBPACK_IMPORTED_MODULE_1__.ONESIGNAL_APP_ID !== '' && _environments_settings__WEBPACK_IMPORTED_MODULE_1__.GOOGLE_PROJECT_NUMBER !== '' && this.platform.is("cordova")) {
      onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().Notifications.removeEventListener('foregroundWillDisplay', this.newPushHandler);
      onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().Notifications.removeEventListener('click', this.openPushHandler);
      onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().logout();
      onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_6___default().User.pushSubscription.optOut();
    }
  }
  /**
   * Получение уведомления
   */
  newPush() {
    var _this = this;
    return /*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (!_authentication_service__WEBPACK_IMPORTED_MODULE_7__.isAuth.value) {
          return;
        }
        if (_this.pulled[data.getNotification().notificationId]) {
          return;
        }
        _this.pulled[data.getNotification().notificationId] = true;
        try {
          const ls = data.getNotification().additionalData['recipient_ls'];
          switch (data.getNotification().additionalData['type']) {
            case 'notification':
            default:
              {
                const newMessage = {
                  id: +data.getNotification().additionalData['message_id'] || 0,
                  title: data.getNotification().title || '',
                  text: data.getNotification().body,
                  date: new Date().toLocaleString('ru-RU').replace(',', ''),
                  status: 2,
                  companyStatus: null,
                  transport: 2
                };
                _this.request.invalidateCacheGroup('notifications:' + _this.request.activeLs.value);
                let notifications = JSON.parse((yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.get({
                  key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.NOTIFICATIONS
                })).value);
                if (notifications === null) {
                  notifications = {};
                }
                if (notifications[ls] === undefined) {
                  notifications[ls] = [];
                }
                const lengthBefore = notifications[ls].length;
                // notifications[ls] = this.helper.arrayNotificationsUnique([...notifications[ls], ...[newMessage]])[0];
                notifications[ls] = _this.helper.arrayNotificationsUnique([...notifications[ls]])[0];
                _this.helper.sortByDate(notifications[ls]);
                const lengthAfter = notifications[ls].length;
                // const newMessageCount = lengthAfter - lengthBefore
                const newMessageCount = 1;
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
                  key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.NOTIFICATIONS,
                  value: JSON.stringify(notifications)
                });
                _this.request.notifications.next(notifications);
                const noReadNotificationsCount = _this.request.noReadNotificationsCount.value;
                if (noReadNotificationsCount[ls] === undefined) {
                  noReadNotificationsCount[ls] = 0;
                }
                if (data.getNotification().badgeIncrement !== undefined) {
                  if (lengthBefore !== lengthAfter) {
                    noReadNotificationsCount[ls] = noReadNotificationsCount[ls] + +data.getNotification().badgeIncrement;
                  }
                } else if (data.getNotification().badge !== undefined) {
                  noReadNotificationsCount[ls] = +data.getNotification().badge;
                } else {
                  if (newMessageCount > 0) {
                    noReadNotificationsCount[ls]++;
                  }
                }
                if (noReadNotificationsCount[ls] < 0) noReadNotificationsCount[ls] = 0;
                _this.request.noReadNotificationsCount.next(noReadNotificationsCount);
                yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_4__.Preferences.set({
                  key: _environments_storage__WEBPACK_IMPORTED_MODULE_5__.NOTIFICATIONS_NO_READ_COUNT,
                  value: JSON.stringify(noReadNotificationsCount)
                });
              }
          }
        } catch (e) {
          console.error(e);
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
  }
  /**
   * Открытие уведомления
   */
  openPush() {
    var _this2 = this;
    return /*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (!_authentication_service__WEBPACK_IMPORTED_MODULE_7__.isAuth.value) {
          return;
        }
        if (_this2.opened[data.notification.notificationId]) {
          return;
        }
        data['getNotification'] = () => {
          return data.notification;
        };
        yield _this2.newPushHandler(data);
        _this2.opened[data.notification.notificationId] = true;
        if (data.notification.additionalData) {
          if (data.notification.additionalData['recipient_ls']) {
            yield _this2.request.setActiveLS(data.notification.additionalData['recipient_ls']);
          }
          if (data.notification.additionalData['url']) {
            let rootUrl = '/tabs/';
            let rootParams;
            const parsedUrl = data.notification.additionalData['url'].split('/');
            if (parsedUrl[0] !== '') {
              if (parsedUrl[0] !== 'tabs') {
                rootUrl += parsedUrl[0].split('&')[0];
                rootParams = parsedUrl[0].split('&')[1] || '{}';
                parsedUrl.unshift('', 'tabs');
              } else {
                rootUrl += parsedUrl[1].split('&')[0];
                rootParams = parsedUrl[1].split('&')[1] || '{}';
                parsedUrl.unshift('');
              }
            } else {
              if (parsedUrl[1] !== 'tabs') {
                rootUrl += parsedUrl[1].split('&')[0];
                rootParams = parsedUrl[1].split('&')[1] || '{}';
                parsedUrl.shift();
                parsedUrl.unshift('', 'tabs');
              } else {
                rootUrl += parsedUrl[2].split('&')[0];
                rootParams = parsedUrl[2].split('&')[1] || '{}';
              }
            }
            parsedUrl.shift();
            parsedUrl.shift();
            parsedUrl.shift();
            yield _this2.navCtrl.navigateRoot(rootUrl, {
              queryParams: JSON.parse(rootParams)
            });
            /**
             * Замыкание, которое будет поэтапно переходить по страницам, дожидаясь окончания анимации перехода каждой
             *
             * @param startUrl - начальное положение навигации
             */
            const stepByStepNavigation = startUrl => {
              let delay = 0;
              return page => {
                const nextUrl = startUrl += '/' + page.split('&')[0];
                const nextUrlParams = page.split('&')[1] || '{}';
                const delayCurrent = delay += 640;
                setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                  yield _this2.navCtrl.navigateForward(nextUrl, {
                    queryParams: JSON.parse(nextUrlParams)
                  });
                }), delayCurrent);
                return;
              };
            };
            // Инициализируем замыкание
            const navigateBy = stepByStepNavigation(rootUrl);
            for (const page of parsedUrl) {
              navigateBy(page);
            }
          } else {
            const newMessage = {
              id: +data.notification.additionalData['message_id'],
              title: data.notification.title || '',
              text: data.notification.body,
              date: new Date().toLocaleString('ru-RU').replace(',', ''),
              status: 2,
              companyStatus: null,
              transport: 2
            };
            yield _this2.navCtrl.navigateRoot('/tabs/main', {
              replaceUrl: true
            });
            yield _this2.navCtrl.navigateForward('/tabs/main/notifications', {
              queryParams: {
                // notificationId: data.notification.additionalData['message_id'],
                // notification: newMessage
              }
            });
          }
        }
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }();
  }
  static {
    this.ctorParameters = () => [{
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_2__.Device
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.NavController
    }, {
      type: _request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _helper_service__WEBPACK_IMPORTED_MODULE_8__.HelperService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_10__.Platform
    }];
  }
};
PushService = (0,tslib__WEBPACK_IMPORTED_MODULE_11__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_12__.Injectable)({
  providedIn: 'root'
})], PushService);


/***/ }),

/***/ 80931:
/*!*********************************************!*\
  !*** ./src/app/services/request.service.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RequestOptions: () => (/* binding */ RequestOptions),
/* harmony export */   RequestService: () => (/* binding */ RequestService),
/* harmony export */   accountId: () => (/* binding */ accountId)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _awesome_cordova_plugins_file_transfer_ngx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @awesome-cordova-plugins/file-transfer/ngx */ 35353);
/* harmony import */ var _awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/file/ngx */ 66411);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var ionic_cache__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ionic-cache */ 65503);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! rxjs */ 77919);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! rxjs */ 95429);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! rxjs */ 43942);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! rxjs/operators */ 72354);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! rxjs/operators */ 98764);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! rxjs/operators */ 36647);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../environments/connection */ 48129);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../environments/settings */ 79308);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var _interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../interceptors/jwt.interceptor */ 69339);
/* harmony import */ var _types_livePaysType__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../types/livePaysType */ 54455);
/* harmony import */ var _types_paymentsType__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../types/paymentsType */ 88849);
/* harmony import */ var _types_requestMethodType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../types/requestMethodType */ 69632);
/* harmony import */ var _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../types/settingsPayChequeType */ 27518);
/* harmony import */ var _global_loading_service_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./global-loading-service.service */ 81854);
/* harmony import */ var _helper_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./helper.service */ 54102);
/* harmony import */ var _http_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./http.service */ 56722);
/* harmony import */ var _token_service__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./token.service */ 2091);
/* harmony import */ var _debug_service__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./debug.service */ 33925);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
























/**
 * @param disableCached - если `true`, то результат в кэш записан не будет
 * @param forceUpdateCache - если `true` (по-умолчанию `false`), то будет отправлен запрос на сервер и после получения ответа записан в кэш, даже если в кэше уже есть значение
 * @param onlyCacheOrRequest - если `true` (по-умолчанию `false`), то будет выполнено только одно действие, либо данные будут получены из кэша при их наличии, либо загружены с сервера
 * @param useOnlyCache - если `true` (по-умолчанию `false`), то данные будут получены исключительно из кэша. Если в кэше их нет, то результат будет `null`
 * @param useCache - если `false` (по-умолчанию `true`), то просто будет выполнен запрос при этом после выполнения результат не будет записан в кэш,
 * если `true`, то сначала будет отображен результат из кэша и параллельно будет выполнен запрос,
 * после получения ответа результат полученный из кэша будет заменен полученным с сервера
 * @param cacheDelayType - по-умолчанию `all`, определяет какие данные брать из кэша.
 * Возможные значения: `all` - брать в любом случае если есть; `expired` - брать только если время жизни не истекло
 * @param preloader - по-умолчанию `true`, отображать ли прелоадер загрузки во время выполнения запроса
 * @param background - если `true` (по-умолчанию `false`), запрос будет выполнен и в случае ошибки будет выпрошено исключение, но сообщения на экране не будет.
 * Можно использовать для отображения ошибки отличной от стандартной
 * @param cacheGroup - группа для кэширования, для дальнейшей инвалидации целой группы (по-умолчанию общая группа 'data')
 * @param cacheTTL - время жизни кэша, по-умолчанию берется из файла с настройками
 */
class RequestOptions {
  constructor(options) {
    this.forceUpdateCache = options != null && options.forceUpdateCache != null ? options.forceUpdateCache : false;
    this.onlyCacheOrRequest = options != null && options.onlyCacheOrRequest != null ? options.onlyCacheOrRequest : false;
    this.useOnlyCache = options != null && options.useOnlyCache != null ? options.useOnlyCache : false;
    this.cacheDelayType = options != null && options.cacheDelayType != null ? options.cacheDelayType : "all";
    this.useCache = options != null && options.useCache != null ? options.useCache : true;
    this.preloader = options != null && options.preloader != null ? options.preloader : true;
    this.background = options != null && options.background != null ? options.background : false;
    this.cacheGroup = options != null && options.cacheGroup != null ? options.cacheGroup : "data";
    this.cacheTTL = options != null && options.cacheTTL != null ? options.cacheTTL : _environments_settings__WEBPACK_IMPORTED_MODULE_5__.CACHE_TTL;
  }
}
const accountId = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject(null);
let RequestService = class RequestService {
  constructor(http, alertCtrl, navCtrl, modalCtrl, cacheService, globalLoadingService, helper, translate, file, fileTransfer, debug) {
    this.http = http;
    this.alertCtrl = alertCtrl;
    this.navCtrl = navCtrl;
    this.modalCtrl = modalCtrl;
    this.cacheService = cacheService;
    this.globalLoadingService = globalLoadingService;
    this.helper = helper;
    this.translate = translate;
    this.file = file;
    this.fileTransfer = fileTransfer;
    this.debug = debug;
    this.inited = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject(false);
    this.activeLs = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject(null);
    this.counters = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.readingsHistory = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.bindings = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.balances = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.lsInfo = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.notifications = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.noReadNotificationsCount = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.settingsPhone = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.settingsEmail = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.settingsMailings = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.faq = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject([]);
    this.help = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.centers = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.available = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.availablePay = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.payments = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.nachislenieZaTekMesiac = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.paymentsHistory = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.receipts = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.applicationsForm = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.surveys = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.surveysAndAppeals = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.loadingCounters = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject(false);
    this.settingsPayCheque = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({
      type: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.NONE
    });
    this.settingsPayMethod = new rxjs__WEBPACK_IMPORTED_MODULE_17__.BehaviorSubject({});
    this.uri = {
      /** без авторизации */
      appInitPost: () => "/appInit",
      authCheckLoginPost: () => "/auth/checkLogin",
      authPost: () => "/auth",
      checkVerificationCodePost: () => "/checkVerificationCode",
      verifyEmailResendPost: () => "/verify/email/resend",
      registrationPost: () => "/registration",
      resetLinkPost: () => "/sendresetlink",
      resetPost: () => "/auth/reset",
      helpInfoGet: () => "/help",
      /**
       * Divo
       */
      getDivoOrgs: () => "/org/connected",
      // eslint-disable-next-line max-len
      notificationsGet: (page = 1, ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/notifications?page=" + page + "&size=" + _environments_settings__WEBPACK_IMPORTED_MODULE_5__.COUNT_NOTIFICATIONS_LOADING,
      notificationsNoReadCountGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/notifications/unread",
      // eslint-disable-next-line max-len
      notificationRead: (notificationId, ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/notification/" + notificationId + "/update",
      updateDeviceIdPost: () => "/account/" + accountId.value + "/notifications/device/update",
      bindingsGet: () => "/account/" + accountId.value + "/bindings",
      balanceGet: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/balance",
      bindAvailableByPuGet: () => "/account/" + accountId.value + "/bindAvailableByPu",
      bindLsPost: () => "/account/" + accountId.value + "/bind",
      unbindLsPost: (ls = this.activeLs.value) => "/account/" + accountId.value + "/unbind/" + ls,
      updateBindLsPost: (ls = this.activeLs.value) => "/account/" + accountId.value + "/bind/" + ls + "/update",
      countersGet: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/counters",
      lsInfoGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/bindings/" + ls,
      countersAddPost: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/counters/add",
      countersRemovePost: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/counters/value/remove",
      countersValuesGet: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/values",
      counterHistoryGet: counterId => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/values/counter/' + counterId,
      counterAsdHistoryGet: (counterId, date) => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/counters/' + counterId + '/asds/data/' + date,
      counterAsdHistoryHoursGet: (counterId, date, asdId) => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/counters/' + counterId + '/asd/' + asdId + '/data/' + date,
      paymentsGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/payment",
      paymentsRedirectToBankGet: (ls = this.activeLs.value, params) => "/account/" + accountId.value + "/data/" + ls + "/payment/redirecttobank?" + params,
      calculationGet: (ls = this.activeLs.value, date) => {
        if (date) {
          return "/account/" + accountId.value + "/data/" + ls + "/calculation?month=" + date + "&total=1";
        } else {
          return "/account/" + accountId.value + "/data/" + ls + "/calculation";
        }
      },
      paymentsHistoryGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/payments/history",
      receiptsGet: (ls = this.activeLs.value, id) => {
        if (id) {
          return "/account/" + accountId.value + "/data/" + ls + "/receipt/" + id;
        } else {
          return "/account/" + accountId.value + "/data/" + ls + "/receipts";
        }
      },
      applicationsFormGet: (page = 1, ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/appeals?page=" + page + "&size=" + _environments_settings__WEBPACK_IMPORTED_MODULE_5__.COUNT_APPLICATIONS_FORM_LOADING,
      applicationsFormTreeCategoriesGet: (orgCode = null) => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/tree-categories?orgCode=" + orgCode,
      applicationFormGetCustomFields: (appealsTypeId, appealsQuestionId = null) => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/customFields" + "?type=" + appealsTypeId + "&question=" + appealsQuestionId,
      applicationsFormDownloadTemplateGet: (type, id) => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/" + type + "/template/" + id,
      applicationsFormThemesGet: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/themes",
      applicationsFormQuestionsGet: themeId => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/types?theme_id=" + themeId,
      applicationsFormCreatePost: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/save",
      applicationsFormUploadFilePost: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/files/upload",
      appealMessagesGet: appealId => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeal/" + appealId + "/dialog",
      appealFileGet: fileId => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeals/getAppealFile?fileId=" + fileId,
      appealSendMessagePost: appealId => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/appeal/" + appealId + "/dialog/message",
      surveysGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/getSurveys',
      surveysQuestionGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/getQuestion',
      surveysNewQuestionGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/getNewQuestion',
      surveysSaveQuestion: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/saveQuestion',
      surveysSaveNewQuestion: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/saveNewQuestion',
      surveysNewCountGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/countSurveys',
      appealsUnreadCountGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/countAppeals',
      appealsSurveysUnreadCountGet: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/surveys/countAppealsSurveys',
      appealsOrgCodes: () => '/account/' + accountId.value + '/data/' + this.activeLs.value + '/appeals/getOrgCodes',
      appointmentGetSubdivisions: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/service-center/getSubdivisions",
      appointmentGetTheme: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/service-center/getThemes",
      appointmentGetDate: idSubdivisions => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/service-center/getDate/" + idSubdivisions,
      appointmentRecording: () => "/account/" + accountId.value + "/data/" + this.activeLs.value + "/service-center/recording",
      settingsPhoneGet: () => "/account/" + accountId.value + "/settings/phones",
      settingsPhonePost: () => "/account/" + accountId.value + "/settings/phones/save",
      settingsEmailGet: () => "/account/" + accountId.value + "/settings/email",
      settingsEmailPost: () => "/account/" + accountId.value + "/settings/email/save",
      settingsChangeLoginMethodPost: () => "/account/" + accountId.value + "/settings/changeLogin",
      sendCodePost: () => "/account/" + accountId.value + "/settings/sendVerificationCode",
      sendNewPassPost: () => "/account/" + accountId.value + "/settings/password",
      settingsMailingsGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/settings/maillingsManagment",
      settingsMailingsPost: (ls = this.activeLs.value) => "/account/" + accountId.value + "/data/" + ls + "/settings/maillingsManagment/save",
      settingsFAQGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/settings/faq",
      centersGet: (ls = this.activeLs.value) => "/account/" + accountId.value + "/bindings/" + ls + "/centers",
      accountRemovePost: () => "/account/" + accountId.value + "/remove"
    };
    this.paymentSub();
  }
  init() {
    return Promise.all([_capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACCOUNT_ID
    }).then(data => {
      if (data.value) {
        accountId.next(Number(data.value));
      }
    }), _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
    }).then(data => {
      if (data.value) {
        this.activeLs.next(data.value);
      }
    })]).finally(() => {
      Promise.all([this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.LS_DATA, this.lsInfo).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.BALANCES, this.balances).catch(() => {}), this.getBindings().catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.COUNTERS, this.counters).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.AVAILABLE, this.available).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.AVAILABLE_PAY, this.availablePay).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATIONS, this.notifications).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS, this.surveysAndAppeals).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATIONS_NO_READ_COUNT, this.noReadNotificationsCount).catch(() => {}), this.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_METHODS, this.settingsPayMethod).catch(() => {})]).finally(() => {
        this.inited.next(true);
        this.inited.complete();
      });
    });
  }
  reset() {
    accountId.next(null);
    this.activeLs.next(null);
    this.counters.next({});
    this.readingsHistory.next({});
    this.bindings.next({});
    this.surveysAndAppeals.next({});
    this.balances.next({});
    this.lsInfo.next({});
    this.notifications.next({});
    this.noReadNotificationsCount.next({});
    this.available.next({});
    this.availablePay.next({});
    this.settingsPhone.next({});
    this.settingsEmail.next({});
    this.settingsMailings.next({});
    this.faq.next([]);
    this.centers.next({});
    this.available.next({});
    this.availablePay.next({});
    this.payments.next({});
    this.nachislenieZaTekMesiac.next({});
    this.paymentsHistory.next({});
    this.receipts.next({});
    this.applicationsForm.next({});
    this.surveys.next({});
    this.loadingCounters.next(false);
    this.settingsPayCheque.next({
      type: _types_settingsPayChequeType__WEBPACK_IMPORTED_MODULE_11__.PayChequeTypes.NONE
    });
    this.settingsPayMethod.next({});
  }
  setApiUrl(url) {
    if (url.indexOf("connect.stack-divo.ru") <= -1 && _environments_settings__WEBPACK_IMPORTED_MODULE_5__.DIVO) {
      url += "/v2";
    }
    this.http.api_url.next(url);
  }
  /** Работа с локальным хранилищем ===== Начало ===== **/
  /**
   * Устанавливаем новый активный ЛС
   *
   * @param ls - лицевой счет
   */
  setActiveLS(ls) {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS,
        value: ls
      });
      _this.activeLs.next(ls);
    })();
  }
  /**
   * Проверяем есть ли активный ЛС
   * Если нет, то устанавливаем первый из списка привязок
   * Если список привязок пуст, то отправляем на страницу привязки ЛС
   *
   * @param goToBindLsPage
   */
  checkActiveLs() {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (goToBindLsPage = true) {
      try {
        const activeLs = (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
        })).value;
        yield _this2.getBindings();
        if (activeLs) {
          if (_this2.bindings.value[activeLs]) {} else {
            yield _this2.setActiveLS(_this2.bindings.value[Object.keys(_this2.bindings.value)[0]].number);
            yield (yield _this2.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.lastValueFrom)(_this2.translate.get("ERROR_STRING.ERROR_ACTIVE_LS")),
              buttons: ["ОК"]
            })).present;
          }
          return true;
        } else {
          yield _this2.setActiveLS(_this2.bindings.value[Object.keys(_this2.bindings.value)[0]].number);
          return true;
        }
      } catch (e) {
        // закрываем все модальные окна с флагом равным null - что говорит о
        // незавершенном сеансе окна и будет повторный автоматический вызов окна, где это требуется
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
        });
        _this2.activeLs.next(null);
        if (goToBindLsPage) {
          while ((yield _this2.modalCtrl.getTop()) !== undefined) {
            yield (yield _this2.modalCtrl.getTop()).dismiss(null);
          }
          yield _this2.navCtrl.navigateRoot("/bind-ls", {
            animated: true,
            animationDirection: "back",
            replaceUrl: true
          });
        }
        return false;
      }
    }).apply(this, arguments);
  }
  /**
   * Получаем активный ЛС из хранилища
   */
  getActiveLs() {
    return new Promise(resolve => {
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
      }).then(data => {
        try {
          if (data.value) {
            this.activeLs.next(data.value);
          }
          resolve(this.activeLs);
        } catch (e) {
          resolve(this.activeLs);
        }
      }).catch(() => {
        resolve(this.activeLs);
      });
    });
  }
  /**
   * Получаем привязки из хранилища
   */
  getBindings() {
    return new Promise(resolve => {
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.BINDINGS
      }).then(data => {
        try {
          const bindings = JSON.parse(data.value);
          if (bindings === null) {
            throw Error();
          }
          this.bindings.next(bindings);
          resolve(this.bindings);
        } catch (e) {
          this.bindings.next({});
          resolve(this.bindings);
        }
      }).catch(() => {
        resolve(this.bindings);
      });
    });
  }
  /**
   * Получение значений из локального хранилища (разных для каждого ЛС)
   *
   * @param key - ключ в localStorage
   * @param variable - переменная типа BehaviorSubject для записи значения в нее
   * @param ls - ЛС (По-умолчанию активный ЛС)
   */
  getStorageWithLS(key, variable, ls = this.activeLs.value) {
    return new Promise(resolve => {
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key
      }).then(data => {
        try {
          const storageValue = JSON.parse(data.value);
          if (storageValue === null || storageValue[ls] === undefined) {
            throw Error();
          }
          // let value = variable.value;
          let value = storageValue;
          // value[ls] = storageValue[ls];
          variable.next(value);
          resolve(value);
        } catch (e) {
          variable.next(variable.value);
          resolve(variable.value);
        }
      }).catch(() => {
        resolve(variable.value);
      });
    });
  }
  /**
   * Получение значений из локального хранилища (общих для каждого ЛС на аккаунте)
   *
   * @param key - ключ в localStorage
   * @param variable - переменная типа BehaviorSubject для записи значения в нее
   */
  getStorage(key, variable) {
    return new Promise(resolve => {
      _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
        key
      }).then(data => {
        try {
          if (data.value === null) {
            throw Error();
          }
          const storageValue = JSON.parse(data.value);
          if (storageValue === null) {
            throw Error();
          }
          variable.next(storageValue);
          resolve(variable);
        } catch (e) {
          variable.next(variable.value);
          resolve(variable);
        }
      }).catch(() => {
        resolve(variable);
      });
    });
  }
  /** Работа с локальным хранилищем ===== Конец ===== **/
  /** Запросы в АПИ ===== Начало ===== **/
  /**
   * Создает запрос в АПИ с указанными параметрами
   * По возможности следует использовать обертки для вызова запроса (getRequest, postRequest)
   *
   * @param uri
   * @param method
   * @param params
   * @param requestOptions
   * @param options
   */
  createRequest(uri, method, params = {}, requestOptions, options) {
    const _httpContext = new _angular_common_http__WEBPACK_IMPORTED_MODULE_19__.HttpContext();
    if (options) {
      options.context = _httpContext.set(_interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_7__.BACKGROUND, requestOptions.background);
    } else {
      options = {
        context: _httpContext.set(_interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_7__.BACKGROUND, requestOptions.background)
      };
    }
    let loading = null;
    // Запускаем прелоадер, если передан параметр (по-умолчанию передается)
    if (requestOptions.preloader && !requestOptions.useOnlyCache) {
      loading = this.globalLoadingService.create();
    }
    let request;
    // Создаем сам запрос на сервер АПИ в зависимости от метода запроса
    switch (method) {
      case "GET":
        request = this.http.get(uri, options);
        break;
      case "POST":
        request = this.http.post(uri, params, options);
        break;
    }
    // Устанавливаем таймаут для запроса и убираем прелоадер после выполнения запроса, если он был отображен
    request = request.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_20__.timeout)(_environments_connection__WEBPACK_IMPORTED_MODULE_4__.HTTP_TIMEOUT), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_21__.catchError)(err => {
      return this.timeoutErrorHandler(err, requestOptions.background);
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_22__.tap)(res => {
      if (requestOptions.forceUpdateCache || requestOptions.onlyCacheOrRequest) {
        this.cache(uri, res, true, requestOptions.cacheGroup, requestOptions.cacheTTL);
      }
    }), (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_23__.finalize)(() => {
      if (loading !== null) {
        loading.then(loading => {
          const f = (loading, count = 0) => {
            this.globalLoadingService.dismiss(loading.id).catch(e => {
              if (count <= 10) {
                setTimeout(() => {
                  f(loading, ++count);
                }, 500);
              }
            });
          };
          f(loading);
        });
      }
    }));
    let readyRequest;
    // если используется кэш, то в 1 очередь будут получены и отображены данные из кэша,
    // а после выполнения запроса будут отображены новые данные
    if (requestOptions.useCache && !requestOptions.forceUpdateCache && !requestOptions.onlyCacheOrRequest && !requestOptions.useOnlyCache) {
      // использовать кэш
      readyRequest = this.cacheService.loadFromDelayedObservable(uri, request, requestOptions.cacheGroup, requestOptions.cacheTTL, requestOptions.cacheDelayType);
    } else if ((requestOptions.onlyCacheOrRequest || requestOptions.useOnlyCache) && requestOptions.useCache) {
      // Запускаем прелоадер, если передан параметр (по-умолчанию передается)
      if (loading !== null) {
        loading.then(loading => {
          loading.present();
        });
      }
      readyRequest = this.getCachedOrRequest(uri, request, loading, requestOptions);
    } else {
      readyRequest = request;
      // Запускаем прелоадер, если передан параметр (по-умолчанию передается)
      if (loading !== null) {
        loading.then(loading => {
          loading.present();
        });
      }
    }
    return readyRequest;
  }
  /**
   * Обертка для вызова GET запроса
   *
   * @param uri - адрес запроса
   * @param options - пользовательские параметры запроса
   * @param httpOptions - параметры запроса HttpClient
   */
  getRequest(uri, options, httpOptions) {
    return this.createRequest(uri, _types_requestMethodType__WEBPACK_IMPORTED_MODULE_10__.Method.GET, {}, new RequestOptions(options), httpOptions);
  }
  /**
   * Обертка для вызова POST запроса
   *
   * @param uri - адрес запроса
   * @param params - параметры запроса
   * @param options - пользовательские параметры запроса
   * @param httpOptions - параметры запроса HttpClient
   */
  postRequest(uri, params = {}, options, httpOptions) {
    return this.createRequest(uri, _types_requestMethodType__WEBPACK_IMPORTED_MODULE_10__.Method.POST, params, new RequestOptions(options), httpOptions);
  }
  downloadFile(uri, dir, fileName, trustAllHosts) {
    var _this3 = this;
    return new Promise(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve, reject) {
        try {
          yield _this3.file.checkDir(_this3.file.dataDirectory, dir);
        } catch (e) {
          yield _this3.file.createDir(_this3.file.dataDirectory, dir, true);
        }
        _this3.fileTransfer.create().download(_this3.http.api_url.value + uri, _this3.file.dataDirectory + "/" + dir + "/" + fileName, trustAllHosts, {
          headers: (0,_token_service__WEBPACK_IMPORTED_MODULE_15__.authHeader)()
        }).then(f => resolve(f)).catch(e => {
          if (e.http_status == 401) {
            _this3.getRequest(_this3.uri.bindingsGet(), {
              preloader: false,
              onlyCacheOrRequest: true,
              useCache: false
            }).subscribe(response => {
              _this3.fileTransfer.create().download(_this3.http.api_url.value + uri, _this3.file.dataDirectory + "/" + dir + "/" + fileName, trustAllHosts, {
                headers: (0,_token_service__WEBPACK_IMPORTED_MODULE_15__.authHeader)()
              }).then(f => resolve(f)).catch(e => {
                if (e.http_status == 401) {
                  _this3.getRequest(_this3.uri.bindingsGet(), {
                    preloader: false,
                    onlyCacheOrRequest: true,
                    useCache: false
                  }).subscribe(() => {
                    reject();
                  });
                } else {
                  reject();
                }
              });
            });
          } else {
            reject();
          }
        });
      });
      return function (_x, _x2) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  /**
   * Обработка ошибки таймаута запроса
   *
   * @param error
   * @param background
   * @private
   */
  timeoutErrorHandler(error, background) {
    if (error.name && error.name == "TimeoutError") {
      if (!background) {
        if (!this.showError) {
          this.showError = true;
          this.alertCtrl.create({
            header: this.translate.instant("ERROR_STRING.ERROR_HEADER"),
            message: this.translate.instant("ERROR_STRING.HTTP_ERROR_MESSAGES.TIMEOUT"),
            buttons: [this.translate.instant("BUTTONS.OK")]
          }).then(alert => {
            alert.onDidDismiss().then(() => {
              this.showError = false;
            });
            alert.present().then(() => {});
          });
        }
      }
    }
    return (0,rxjs__WEBPACK_IMPORTED_MODULE_24__.throwError)(error);
  }
  accountLsSurveysAndAppealsCallback(result) {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const surveysAndAppealsNoReadCount = yield _this4.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS, _this4.surveysAndAppeals);
        if (result.result) {
          surveysAndAppealsNoReadCount[_this4.activeLs.value] = result;
        } else {
          surveysAndAppealsNoReadCount[_this4.activeLs.value] = {
            surveysAndAppeals: {
              countAppeals: "0",
              countSurveys: "0"
            }
          };
        }
        _this4.surveysAndAppeals.next(surveysAndAppealsNoReadCount);
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS,
          value: JSON.stringify(surveysAndAppealsNoReadCount)
        });
      } catch (e) {
        _this4.surveysAndAppeals.next(_this4.surveysAndAppeals.value);
      }
    })();
  }
  /** Запросы в АПИ ===== Конец ===== **/
  /** Функции Callback после получения ответа от АПИ ===== Начало ===== **/
  /**
   * Функция обработки ответа после получения привязок
   */
  loadBindingsCallback(result) {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const bindings = {};
      try {
        if (!(result.bindings.length > 0)) {
          yield _this5.invalidateCache(_this5.uri.bindingsGet());
        }
        result.bindings.forEach(value => {
          bindings[value.number] = value;
        });
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.BINDINGS,
          value: JSON.stringify(bindings)
        });
        _this5.bindings.next(bindings);
      } catch (e) {
        _this5.bindings.next(_this5.bindings.value);
      }
      try {
        const activeLs = (yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.get({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
        })).value;
        if (!bindings[activeLs]) {
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS,
            value: bindings[Object.keys(bindings)[0]].number
          });
          _this5.activeLs.next(bindings[Object.keys(bindings)[0]].number);
          if (activeLs) {
            yield (yield _this5.alertCtrl.create({
              header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ATTENTION_HEADER")),
              message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.lastValueFrom)(_this5.translate.get("ERROR_STRING.ERROR_ACTIVE_LS")),
              buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_18__.lastValueFrom)(_this5.translate.get("BUTTONS.OK"))]
            })).present();
          }
        }
      } catch (e) {
        console.error(e);
        // закрываем все модальные окна с флагом равным null - что говорит о
        // незавершенном сеансе окна и будет повторный автоматический вызов окна, где это требуется
        // const modal = async () => {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.remove({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.ACTIVE_LS
        });
        _this5.activeLs.next(null);
      }
    })();
  }
  /**
   * Функция обработки ответа после получения баланса
   */
  loadBalanceCallback(result) {
    var _this6 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const balances = yield _this6.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.BALANCES, _this6.balances);
        balances[_this6.activeLs.value] = result.balance;
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.BALANCES,
          value: JSON.stringify(balances)
        });
        _this6.balances.next(balances);
      } catch (e) {
        _this6.balances.next(_this6.balances.value);
      }
    })();
  }
  /**
   * Функция обработки ответа после получения данных по ЛС
   */
  loadLsInfoCallback(result, _ls) {
    var _this7 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        let ls = _this7.activeLs.value;
        if (_ls) {
          ls = _ls;
        }
        const lsInfo = yield _this7.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.LS_DATA, _this7.lsInfo);
        lsInfo[ls] = result.info;
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.LS_DATA,
          value: JSON.stringify(lsInfo)
        });
        if (_ls === _this7.activeLs.value) {
          _this7.lsInfo.next(lsInfo);
        }
      } catch (e) {
        _this7.lsInfo.next(_this7.lsInfo.value);
      }
    })();
  }
  /**
   * Функция обработки ответа после получения счетчиков
   */
  loadCountersCallback(result) {
    var _this8 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const counters = yield _this8.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.COUNTERS, _this8.counters);
        const available = yield _this8.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.AVAILABLE, _this8.available);
        if (result.result) {
          counters[_this8.activeLs.value] = result.counters;
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.COUNTERS,
            value: JSON.stringify(counters)
          });
          available[_this8.activeLs.value] = result.avaliable;
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.AVAILABLE,
            value: JSON.stringify(available)
          });
        }
        _this8.counters.next(counters);
        _this8.available.next(available);
        _this8.loadingCounters.next(false);
      } catch (e) {
        _this8.counters.next(_this8.counters.value);
        _this8.available.next(_this8.available.value);
        _this8.loadingCounters.next(false);
      }
    })();
  }
  /**
   * Функция обработки ответа после получения уведомлений
   */
  loadNotificationsCallback(page = 1) {
    var _this9 = this;
    return /*#__PURE__*/function () {
      var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const notifications = _this9.notifications.value;
          if (notifications[_this9.activeLs.value] === undefined) {
            notifications[_this9.activeLs.value] = [];
          }
          if (page == 1 && result.notifications.length > 0 && notifications[_this9.activeLs.value].length > 0) {
            if (result.notifications[0].id != notifications[_this9.activeLs.value][0].id) {
              yield _this9.invalidateCacheGroup("notifications:" + _this9.activeLs.value);
              notifications[_this9.activeLs.value] = [];
            }
          }
          const arr = _this9.helper.arrayNotificationsUnique([...result.notifications, ...notifications[_this9.activeLs.value]]);
          notifications[_this9.activeLs.value] = arr[0];
          // if (arr[1].length > 0) {
          //   Preferences.get({ key: NOTIFICATIONS }).then(data => {
          //
          //     const notificationsStorage = JSON.parse(data.value);
          //
          //     if (notificationsStorage[this.activeLs.value]) {
          //       const removeValFromIndex = arr[1];
          //
          //       removeValFromIndex.sort((a, b) => b - a);
          //
          //       for (let i = removeValFromIndex.length -1; i >= 0; i--) {
          //         notificationsStorage[this.activeLs.value].splice(removeValFromIndex[i],1);
          //       }
          //
          //       Preferences.set({ key: NOTIFICATIONS, value: JSON.stringify(notificationsStorage) });
          //
          //       this.invalidateCacheGroup('notifications:' + this.activeLs.value);
          //     }
          //   }).catch(e => {
          //     //
          //   });
          // }
          _this9.helper.sortByDate(notifications[_this9.activeLs.value]);
          _this9.notifications.next(notifications);
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
            key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATIONS,
            value: JSON.stringify(notifications)
          });
          _this9.loadNotificationsNoReadCountCallback(result.notificationsNoReadCount).catch(err => {
            console.error(err);
          });
        } catch (e) {
          console.error(e);
          _this9.notifications.next(_this9.notifications.value);
        }
      });
      return function (_x3) {
        return _ref2.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения количества непрочитанных уведомлений
   */
  loadNotificationsNoReadCountCallback(result) {
    var _this0 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const notificationsNoReadCount = yield _this0.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATIONS_NO_READ_COUNT, _this0.noReadNotificationsCount);
        let noReadCount = result.count;
        if (_this0.notifications.value[_this0.activeLs.value]) {
          Object.values(_this0.notifications.value[_this0.activeLs.value]).forEach(notification => {
            if (notification.status === 2 && notification.companyStatus === null) {
              noReadCount++;
            }
          });
        }
        notificationsNoReadCount[_this0.activeLs.value] = noReadCount;
        _this0.noReadNotificationsCount.next(notificationsNoReadCount);
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.NOTIFICATIONS_NO_READ_COUNT,
          value: JSON.stringify(notificationsNoReadCount)
        });
      } catch (e) {
        _this0.noReadNotificationsCount.next(_this0.noReadNotificationsCount.value);
      }
    })();
  }
  /**
   * Функция обработки ответа после получения истории показаний
   */
  loadReadingsHistoryCallback() {
    var _this1 = this;
    return /*#__PURE__*/function () {
      var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this1.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.READINGS_HISTORY, _this1.readingsHistory);
          const readingsHistory = _this1.readingsHistory.value;
          if (result.result) {
            readingsHistory[_this1.activeLs.value] = {
              ofDate: result.values,
              ofPu: result.values2
            };
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.READINGS_HISTORY,
              value: JSON.stringify(readingsHistory)
            });
          }
          _this1.readingsHistory.next(readingsHistory);
        } catch (e) {
          _this1.readingsHistory.next(_this1.readingsHistory.value);
        }
      });
      return function (_x4) {
        return _ref3.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения телефона из настроек
   */
  loadSettingsPhoneCallback() {
    var _this10 = this;
    return /*#__PURE__*/function () {
      var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this10.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PHONE, _this10.settingsPhone);
          let settingsPhone = _this10.settingsPhone.value;
          if (result.result) {
            settingsPhone = result;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PHONE,
              value: JSON.stringify(settingsPhone)
            });
          }
          _this10.settingsPhone.next(settingsPhone);
        } catch (e) {
          _this10.settingsPhone.next(_this10.settingsPhone.value);
        }
      });
      return function (_x5) {
        return _ref4.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения email из настроек
   */
  loadSettingsEmailCallback() {
    var _this11 = this;
    return /*#__PURE__*/function () {
      var _ref5 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this11.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_EMAIL, _this11.settingsEmail);
          let settingsEmail = _this11.settingsEmail.value;
          if (result.result) {
            settingsEmail = result;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_EMAIL,
              value: JSON.stringify(settingsEmail)
            });
          }
          _this11.settingsEmail.next(settingsEmail);
        } catch (e) {
          _this11.settingsEmail.next(_this11.settingsEmail.value);
        }
      });
      return function (_x6) {
        return _ref5.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения включенных рассылок в настройках
   */
  loadSettingsMailingsCallback() {
    var _this12 = this;
    return /*#__PURE__*/function () {
      var _ref6 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const settingsMailing = yield _this12.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_MAILING, _this12.settingsMailings);
          if (result.result) {
            settingsMailing[_this12.activeLs.value] = result;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_MAILING,
              value: JSON.stringify(settingsMailing)
            });
          }
          _this12.settingsMailings.next(settingsMailing);
        } catch (e) {
          _this12.settingsMailings.next(_this12.settingsMailings.value);
        }
      });
      return function (_x7) {
        return _ref6.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения ответов на частые вопросы
   */
  loadFAQCallback() {
    var _this13 = this;
    return /*#__PURE__*/function () {
      var _ref7 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this13.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAQ, _this13.faq);
          let faq = _this13.faq.value;
          if (result.result) {
            faq = result.data;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.FAQ,
              value: JSON.stringify(faq)
            });
          }
          _this13.faq.next(faq);
        } catch (e) {
          _this13.faq.next(_this13.faq.value);
        }
      });
      return function (_x8) {
        return _ref7.apply(this, arguments);
      };
    }();
  }
  loadHelpCallback() {
    var _this14 = this;
    return /*#__PURE__*/function () {
      var _ref8 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this14.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.HELP, _this14.help);
          let help = _this14.help.value;
          if (result.result) {
            help = result.data;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.HELP,
              value: JSON.stringify(help)
            });
          }
          _this14.help.next(help);
        } catch (e) {
          _this14.help.next(_this14.help.value);
        }
      });
      return function (_x9) {
        return _ref8.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения контактной информации
   */
  loadCentersCallback() {
    var _this15 = this;
    return /*#__PURE__*/function () {
      var _ref9 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          yield _this15.getStorage(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.CENTERS, _this15.centers);
          const centers = _this15.centers.value;
          if (result.result) {
            centers[_this15.activeLs.value] = result.info;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.CENTERS,
              value: JSON.stringify(centers)
            });
          }
          _this15.centers.next(centers);
        } catch (e) {
          _this15.centers.next(_this15.centers.value);
        }
      });
      return function (_x0) {
        return _ref9.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения информации для оплаты
   */
  loadPaymentsCallback() {
    var _this16 = this;
    return /*#__PURE__*/function () {
      var _ref0 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const payments = yield _this16.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAYMENTS, _this16.payments);
          if (result.result) {
            payments[_this16.activeLs.value] = result;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAYMENTS,
              value: JSON.stringify(payments)
            });
          }
          _this16.payments.next(payments);
        } catch (e) {
          _this16.payments.next(_this16.payments.value);
        }
      });
      return function (_x1) {
        return _ref0.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения истории платежей
   */
  loadPaymentsHistoryCallback() {
    var _this17 = this;
    return /*#__PURE__*/function () {
      var _ref1 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const paymentsHistory = yield _this17.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAYMENTS_HISTORY, _this17.paymentsHistory);
          if (result.result) {
            paymentsHistory[_this17.activeLs.value] = _this17.helper.arrayTransform(result.data);
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.PAYMENTS_HISTORY,
              value: JSON.stringify(paymentsHistory)
            });
          }
          _this17.paymentsHistory.next(paymentsHistory);
        } catch (e) {
          _this17.paymentsHistory.next(_this17.paymentsHistory.value);
        }
      });
      return function (_x10) {
        return _ref1.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения списка квитанций
   */
  loadReceiptsCallback() {
    var _this18 = this;
    return /*#__PURE__*/function () {
      var _ref10 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const receipts = yield _this18.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.RECEIPTS, _this18.receipts);
          if (result.result) {
            receipts[_this18.activeLs.value] = result.data;
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.RECEIPTS,
              value: JSON.stringify(receipts)
            });
          }
          _this18.receipts.next(receipts);
        } catch (e) {
          _this18.receipts.next(_this18.receipts.value);
        }
      });
      return function (_x11) {
        return _ref10.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения списка обращений
   *
   * @param page
   */
  loadApplicationsFormCallback(page = 1) {
    var _this19 = this;
    return /*#__PURE__*/function () {
      var _ref11 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const applicationsForm = _this19.applicationsForm.value;
          if (applicationsForm[_this19.activeLs.value] === undefined) {
            applicationsForm[_this19.activeLs.value] = [];
          }
          if (result.result) {
            const arr = _this19.helper.arrayNotificationsUnique([...result.appeals, ...applicationsForm[_this19.activeLs.value]]);
            applicationsForm[_this19.activeLs.value] = arr[0];
            const surveysAndAppealsNoReadCount = yield _this19.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS, _this19.surveysAndAppeals);
            if (surveysAndAppealsNoReadCount[_this19.activeLs.value] == null) {
              surveysAndAppealsNoReadCount[_this19.activeLs.value] = {
                surveysAndAppeals: {
                  countAppeals: "0",
                  countSurveys: "0"
                }
              };
            }
            surveysAndAppealsNoReadCount[_this19.activeLs.value].surveysAndAppeals.countAppeals = String(Array.from(applicationsForm[_this19.activeLs.value]).filter(appeal => appeal.marked).length) ?? "0";
            _this19.surveysAndAppeals.next(surveysAndAppealsNoReadCount);
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS,
              value: JSON.stringify(surveysAndAppealsNoReadCount)
            });
          }
          _this19.applicationsForm.next(applicationsForm);
        } catch (e) {
          _this19.applicationsForm.next(_this19.applicationsForm.value);
        }
      });
      return function (_x12) {
        return _ref11.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция обработки ответа после получения опросов
   * @param force
   */
  loadSurveysCallback(force) {
    var _this20 = this;
    return /*#__PURE__*/function () {
      var _ref12 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
        try {
          const surveys = _this20.surveys.value;
          if (surveys[_this20.activeLs.value] == null) {
            surveys[_this20.activeLs.value] = {};
          }
          if (result.result) {
            surveys[_this20.activeLs.value] = result.data;
            let unreadSurveys = 0;
            Object.values(surveys[_this20.activeLs.value]).map(survey => {
              unreadSurveys += survey.filter(survey => survey["Статус"] === 0).length;
            });
            const surveysAndAppealsNoReadCount = yield _this20.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS, _this20.surveysAndAppeals);
            if (surveysAndAppealsNoReadCount[_this20.activeLs.value] == null) {
              surveysAndAppealsNoReadCount[_this20.activeLs.value] = {
                surveysAndAppeals: {
                  countAppeals: "0",
                  countSurveys: "0"
                }
              };
            }
            surveysAndAppealsNoReadCount[_this20.activeLs.value].surveysAndAppeals.countSurveys = String(unreadSurveys) ?? "0";
            _this20.surveysAndAppeals.next(surveysAndAppealsNoReadCount);
            yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
              key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS,
              value: JSON.stringify(surveysAndAppealsNoReadCount)
            });
          }
          _this20.surveys.next(surveys);
        } catch (e) {
          _this20.surveys.next(_this20.surveys.value);
        }
      });
      return function (_x13) {
        return _ref12.apply(this, arguments);
      };
    }();
  }
  /**
   * Функция получения кол-ва новых опросов
   * @param result
   */
  accountLsSurveysCallback(result) {
    var _this21 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        const surveysAndAppealsNoReadCount = yield _this21.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS, _this21.surveysAndAppeals);
        if (result.result) {
          surveysAndAppealsNoReadCount[_this21.activeLs.value].surveysAndAppeals.countSurveys = result.data;
        } else {
          surveysAndAppealsNoReadCount[_this21.activeLs.value] = {
            surveysAndAppeals: {
              countAppeals: surveysAndAppealsNoReadCount[_this21.activeLs.value]?.surveysAndAppeals?.countAppeals ?? "0",
              countSurveys: surveysAndAppealsNoReadCount[_this21.activeLs.value]?.surveysAndAppeals?.countSurveys ?? "0"
            }
          };
        }
        _this21.surveysAndAppeals.next(surveysAndAppealsNoReadCount);
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.APPEALS_AND_SURVEYS,
          value: JSON.stringify(surveysAndAppealsNoReadCount)
        });
      } catch (e) {
        _this21.surveysAndAppeals.next(_this21.surveysAndAppeals.value);
      }
    })();
  }
  /** Функции Callback после получения ответа от АПИ ===== Конец ===== **/
  /**
   * Возвращает запись из кэша или выполняет запрос если запись устарела
   *
   * @param key - ключ кэша
   * @param request - запрос на сервер (type: Observable)
   * @param loading
   * @param requestOptions
   */
  getCachedOrRequest(key, request, loading, requestOptions) {
    let promise;
    if (requestOptions.cacheDelayType == "all") {
      promise = this.cacheService.getRawItem(key).catch(() => false);
    } else {
      promise = this.cacheService.getItem(key).catch(() => false);
    }
    const observable = (0,rxjs__WEBPACK_IMPORTED_MODULE_25__.from)(promise);
    return observable.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_26__.switchMap)(data => {
      if (data && !requestOptions.forceUpdateCache) {
        if (loading !== null) {
          loading.then(loading => {
            const f = (loading, count = 0) => {
              this.globalLoadingService.dismiss(loading.id).catch(e => {
                if (count <= 10) {
                  setTimeout(() => {
                    f(loading, ++count);
                  }, 500);
                }
              });
            };
            f(loading);
          });
        }
        return new rxjs__WEBPACK_IMPORTED_MODULE_27__.Observable(subscriber => {
          subscriber.next(JSON.parse(data.value));
          subscriber.complete();
        });
      } else if (requestOptions.useOnlyCache) {
        if (loading !== null) {
          loading.then(loading => {
            const f = (loading, count = 0) => {
              this.globalLoadingService.dismiss(loading.id).catch(e => {
                if (count <= 10) {
                  setTimeout(() => {
                    f(loading, ++count);
                  }, 500);
                }
              });
            };
            f(loading);
          });
        }
        if (data) {
          return new rxjs__WEBPACK_IMPORTED_MODULE_27__.Observable(subscriber => {
            subscriber.next(JSON.parse(data.value));
            subscriber.complete();
          });
        } else {
          return new rxjs__WEBPACK_IMPORTED_MODULE_27__.Observable(subscriber => {
            subscriber.next(null);
            subscriber.complete();
          });
        }
      } else {
        return request;
      }
    }));
  }
  /**
   * Сохранение данных в кэш
   *
   * @param uri - используется в качестве ключа кэша
   * @param data - данные для кэширования
   * @param force - если true, то данные в кэше перекэшируются
   * @param groupKey - ключ группы, по нему можно инвалидировать одно или несколько значений кэша
   * @param cacheTTL - время жизни кэша
   */
  cache(_x14, _x15, _x16) {
    var _this22 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (uri, data, force, groupKey = "data", cacheTTL = _environments_settings__WEBPACK_IMPORTED_MODULE_5__.CACHE_TTL) {
      if (data.result) {
        if (force) {
          yield _this22.cacheService.saveItem(uri, data, groupKey, cacheTTL);
        } else {
          yield _this22.cacheService.getOrSetItem(uri, /*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
            return data;
          }), groupKey, cacheTTL);
        }
      }
    }).apply(this, arguments);
  }
  /**
   * Удаляет данные из кэша по ключу, предусмотрено использование паттернов ('songs/metal/*')
   *
   * @param key - ключ кэша, может быть паттерном
   */
  invalidateCache(key) {
    var _this23 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        yield _this23.cacheService.removeItems(key);
      } catch (e) {}
    })();
  }
  /**
   * Удаляет данные из кэша по ключу группы
   *
   * @param key
   */
  invalidateCacheGroup(key) {
    var _this24 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      try {
        yield _this24.cacheService.clearGroup(key);
      } catch (e) {}
    })();
  }
  paymentSub() {
    this.payments.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_28__.filter)(() => this.activeLs.value !== null)).subscribe(value => {
      {
        let nachislenieZaTekMesiac = this.nachislenieZaTekMesiac.value;
        if (value != null && !!value[this.activeLs.value]) {
          if (this.payments.value[this.activeLs.value].type_pay === 3) {
            nachislenieZaTekMesiac[this.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_8__.LivePaysEnum.KVTS;
          } else if (this.payments.value[this.activeLs.value].type_pay === 4) {
            if (!this.nachislenieZaTekMesiac.value[this.activeLs.value]) {
              nachislenieZaTekMesiac[this.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_8__.LivePaysEnum.PAYS;
            } else {
              nachislenieZaTekMesiac[this.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_8__.LivePaysEnum.PAYS_ACCRUALS;
            }
          }
        } else {
          nachislenieZaTekMesiac[this.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_8__.LivePaysEnum.KVTS;
        }
        this.nachislenieZaTekMesiac.next(nachislenieZaTekMesiac);
      }
      if (!!value[this.activeLs.value] && !!value[this.activeLs.value].gateway && Object.keys(value[this.activeLs.value].gateway).length > 0) {
        let payMethods = this.settingsPayMethod.value;
        if (value != null && !!value[this.activeLs.value]) {
          let newPayMethodsLS = this.fillPayMethods(value[this.activeLs.value].gateway);
          payMethods[this.activeLs.value] = newPayMethodsLS;
        } else {
          payMethods[this.activeLs.value] = [];
        }
        this.settingsPayMethod.next(payMethods);
        _capacitor_preferences__WEBPACK_IMPORTED_MODULE_3__.Preferences.set({
          key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.SETTINGS_PAY_METHODS,
          value: JSON.stringify(this.settingsPayMethod.value)
        });
      }
    });
  }
  /**
   * Принимает оконхи (gatewaysName) доступные для выбранной квитанции или поставщика
   * и возвращает доступные способы оплаты с учетом включенных оконхов в ЛК
   *
   * @param payGateways - оконхи выбранной квитанции или поставщика
   */
  payMethodFilter(payGateways) {
    if (!!this.payments.value[this.activeLs.value]) {
      /**
       * Принимает два массива оконхов (gatewaysName) в виде имен
       * и возвращает их пересечение уже в виде объектов (gateways)
       *
       * @param first
       * @param second
       */
      const intersection = (first, second) => {
        let s = new Set(second);
        let result = {};
        first.filter(item => s.has(item)).forEach(okonxName => {
          try {
            result[okonxName] = this.payments.value[this.activeLs.value].gateway[okonxName];
          } catch (e) {}
        });
        return result;
      };
      if (this.payments.value[this.activeLs.value].type_pay == 1) {
        return this.settingsPayMethod.value[this.activeLs.value];
      } else if (this.payments.value[this.activeLs.value].type_pay == 3 || this.payments.value[this.activeLs.value].type_pay == 4) {
        return this.fillPayMethods(intersection(Object.keys(this.payments.value[this.activeLs.value].gateway),
        // все доступные оконхи
        payGateways));
      }
      return [];
    }
  }
  /**
   * Принимает оконхи и возвращает на основе них доступные способы оплаты
   *
   * @param gateway
   * @private
   */
  fillPayMethods(gateway) {
    let payMethods = this.settingsPayMethod.value;
    let defMethod = null;
    let defIsSet = false;
    if (!!payMethods[this.activeLs.value]) {
      defMethod = payMethods[this.activeLs.value].filter(value => value.default)[0];
    }
    let newPayMethodsLS = [];
    for (const okonx of Object.keys(gateway)) {
      let match = new RegExp('^(.*?)(SBP)?$', 'g').exec(okonx);
      if (match[2] !== undefined) {
        newPayMethodsLS.push({
          id: okonx,
          type: _types_paymentsType__WEBPACK_IMPORTED_MODULE_9__.PayType.SBP,
          name: this.translate.instant("PAYMENT.PAY.PAY_MODAL.PAY_METHODS.SBP"),
          description: this.payments.value[this.activeLs.value].gateway[okonx].discript ?? "",
          icon: "assets/icons/SBP.svg",
          default: false
        });
      } else {
        newPayMethodsLS.push({
          id: okonx,
          type: _types_paymentsType__WEBPACK_IMPORTED_MODULE_9__.PayType.CARD,
          name: this.translate.instant("PAYMENT.PAY.PAY_MODAL.PAY_METHODS.CARD"),
          description: this.payments.value[this.activeLs.value].gateway[okonx].discript ?? "",
          icon: "assets/icons/Credit_Card.svg",
          default: false
        });
      }
    }
    if (!!defMethod && !!defMethod.id) {
      newPayMethodsLS.forEach(okonx => {
        if (okonx.id === defMethod.id) {
          defIsSet = true;
          okonx.default = true;
        } else {
          okonx.default = false;
        }
      });
    }
    if (!defIsSet && newPayMethodsLS[0]) {
      newPayMethodsLS[0].default = true;
    }
    return newPayMethodsLS;
  }
  static {
    this.ctorParameters = () => [{
      type: _http_service__WEBPACK_IMPORTED_MODULE_14__.HttpService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_29__.AlertController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_30__.NavController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_29__.ModalController
    }, {
      type: ionic_cache__WEBPACK_IMPORTED_MODULE_31__.CacheService
    }, {
      type: _global_loading_service_service__WEBPACK_IMPORTED_MODULE_12__.GlobalLoadingService
    }, {
      type: _helper_service__WEBPACK_IMPORTED_MODULE_13__.HelperService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_32__.TranslateService
    }, {
      type: _awesome_cordova_plugins_file_ngx__WEBPACK_IMPORTED_MODULE_2__.File
    }, {
      type: _awesome_cordova_plugins_file_transfer_ngx__WEBPACK_IMPORTED_MODULE_1__.FileTransfer
    }, {
      type: _debug_service__WEBPACK_IMPORTED_MODULE_16__.DebugService
    }];
  }
};
RequestService = (0,tslib__WEBPACK_IMPORTED_MODULE_33__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_34__.Injectable)({
  providedIn: "root"
})], RequestService);


/***/ }),

/***/ 12186:
/*!********************************************!*\
  !*** ./src/app/services/search.service.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SearchService: () => (/* binding */ SearchService),
/* harmony export */   alfavitType: () => (/* binding */ alfavitType)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
var SearchService_1;


var alfavitType;
(function (alfavitType) {
  alfavitType["EN"] = "en";
  alfavitType["RU"] = "ru";
  alfavitType["ALL"] = "all";
})(alfavitType || (alfavitType = {}));
let SearchService = class SearchService {
  static {
    SearchService_1 = this;
  }
  constructor() {}
  /**
   * Поиск с использованием расстояния Левенштейна
   *
   * @param search - строка поиска
   * @param array - массив объектов в котором ищем
   * @param field - поле по которому ищем объект
   * @param lev - значение расстояния Левенштейна при котором строка считается найденной
   */
  static searchLevenshtein(search, array, field, lev) {
    return array.filter(item => {
      return SearchService_1.levenshtein(search, item[field]) <= lev;
    });
  }
  /**
   * Поиск с использованием проверки сходства слов (нечеткое сравнение с биграммами)
   *
   * @param search - строка поиска
   * @param array - массив объектов в котором ищем
   * @param field - поле по которому ищем объект
   * @param means - значение сходства при котором строка считается найденной
   */
  static searchBigrams(search, array, field, means) {
    return array.filter(item => {
      return SearchService_1.checkSimilarity(search, item[field]) >= means;
    });
  }
  /**
   * Проверка сходства слов (нечеткое сравнение с биграммами)
   *
   * @param a
   * @param b
   */
  static checkSimilarity(a, b) {
    if (a.length > 0 && b.length > 0) {
      const aBigram = SearchService_1.createBigram(a);
      const bBigram = SearchService_1.createBigram(b);
      let hits = 0;
      for (let x = 0; x < aBigram.length; ++x) {
        for (let y = 0; y < bBigram.length; ++y) {
          if (aBigram[x] === bBigram[y]) {
            hits += 1;
          }
        }
      }
      if (hits > 0) {
        const union = aBigram.length + bBigram.length;
        return 2.0 * hits / union;
      }
    }
    return 0;
  }
  /**
   * Вычисление расстояния Левенштейна
   *
   * @param a
   * @param b
   */
  static levenshtein(a, b) {
    if (a === b) {
      return 0;
    }
    if (a.length > b.length) {
      var tmp = a;
      a = b;
      b = tmp;
    }
    var la = a.length;
    var lb = b.length;
    while (la > 0 && a.charCodeAt(la - 1) === b.charCodeAt(lb - 1)) {
      la--;
      lb--;
    }
    var offset = 0;
    while (offset < la && a.charCodeAt(offset) === b.charCodeAt(offset)) {
      offset++;
    }
    la -= offset;
    lb -= offset;
    if (la === 0 || lb < 3) {
      return lb;
    }
    var x = 0;
    var y;
    var d0;
    var d1;
    var d2;
    var d3;
    var dd;
    var dy;
    var ay;
    var bx0;
    var bx1;
    var bx2;
    var bx3;
    var vector = [];
    for (y = 0; y < la; y++) {
      vector.push(y + 1);
      vector.push(a.charCodeAt(offset + y));
    }
    var len = vector.length - 1;
    for (; x < lb - 3;) {
      bx0 = b.charCodeAt(offset + (d0 = x));
      bx1 = b.charCodeAt(offset + (d1 = x + 1));
      bx2 = b.charCodeAt(offset + (d2 = x + 2));
      bx3 = b.charCodeAt(offset + (d3 = x + 3));
      dd = x += 4;
      for (y = 0; y < len; y += 2) {
        dy = vector[y];
        ay = vector[y + 1];
        d0 = SearchService_1.min(dy, d0, d1, bx0, ay);
        d1 = SearchService_1.min(d0, d1, d2, bx1, ay);
        d2 = SearchService_1.min(d1, d2, d3, bx2, ay);
        dd = SearchService_1.min(d2, d3, dd, bx3, ay);
        vector[y] = dd;
        d3 = d2;
        d2 = d1;
        d1 = d0;
        d0 = dy;
      }
    }
    for (; x < lb;) {
      bx0 = b.charCodeAt(offset + (d0 = x));
      dd = ++x;
      for (y = 0; y < len; y += 2) {
        dy = vector[y];
        vector[y] = dd = SearchService_1.min(dy, d0, dd, bx0, vector[y + 1]);
        d0 = dy;
      }
    }
    return dd;
  }
  static min(d0, d1, d2, bx, ay) {
    return d0 < d1 || d2 < d1 ? d0 > d2 ? d2 + 1 : d0 + 1 : bx === ay ? d1 : d1 + 1;
  }
  /**
   * Алгоритм Soundex
   *
   * @param letter
   * @param alfavit
   */
  static calculateSoundexCode(letter, alfavit = alfavitType.ALL) {
    const b = {
      "en": [/[^A-Z]/ig, /[BFPV]/ig, /[CGJKQSXZ]/ig, /[DT]/ig, /[L]/ig, /[MN]/ig, /[R]/ig, /[HW]/ig, /[AEIOUY]/ig],
      "ru": [/[^А-Я]/ig, /[БВПФ]/ig, /[ГЗКСХЦ]/ig, /[ДТ]/ig, /[Л]/ig, /[МН]/ig, /[Р]/ig, /[ЖЙЧШЩЬЪ]/ig, /[АЕЁИОУЫЭЯЮ]/ig],
      "all": [/[^A-ZА-Я]/ig,
      // 0 - Алфавит
      /[BFPVБВПФ]/ig,
      // 1 +
      /[CGJKQSXZГЗКСХЦ]/ig,
      // 2 ¦
      /[DTДТ]/ig,
      // 3 ¦
      /[LЛ]/ig,
      // 4 + Кодируемые согласные
      /[MNМН]/ig,
      // 5 ¦
      /[RР]/ig,
      // 6 +
      /[HWЖЙЧШЩЬЪ]/ig,
      // 7 - Не кодируемые согласные
      /[AEIOUYАЕЁИОУЫЭЯЮ]/ig]
    }[alfavit]; // 8 - Гласные
    return (letter.charAt(0) + (
    // Сохраняем первый символ
    function (a) {
      for (var c = 7; --c;) {
        a = a.replace(b[c], c);
      }
      return a;
    } // Кодируем согласные
    (letter.replace(b[0], "").
    // Удаляем не алфавитные
    replace(b[7], function (a, b, c) {
      return !c || b;
    })).
    // Удаляем не кодируемые
    replace(/(.)\1*/gi, "$1").
    // Удаляем повтор кода
    slice(1) + "000").
    //
    replace(b[8], "")).
    // Удаляем гласные
    slice(0, 4).toUpperCase();
  }
  /**
   * Вычисление биграмм
   *
   * @param word
   * @private
   */
  static createBigram(word) {
    const input = word.toUpperCase();
    const vector = [];
    for (let i = 0; i < input.length; ++i) {
      vector.push(input.slice(i, i + 2));
    }
    return vector;
  }
  /**
   * Замена латинских букв на русские
   *
   * @param a
   * @private
   */
  static normalize(a) {
    const map = {
      'q': 'й',
      'w': 'ц',
      'e': 'у',
      'r': 'к',
      't': 'е',
      'y': 'н',
      'u': 'г',
      'i': 'ш',
      'o': 'щ',
      'p': 'з',
      '[': 'х',
      ']': 'ъ',
      'a': 'ф',
      's': 'ы',
      'd': 'в',
      'f': 'а',
      'g': 'п',
      'h': 'р',
      'j': 'о',
      'k': 'л',
      'l': 'д',
      ';': 'ж',
      '\'': 'э',
      'z': 'я',
      'x': 'ч',
      'c': 'с',
      'v': 'м',
      'b': 'и',
      'n': 'т',
      'm': 'ь',
      ',': 'б',
      '.': 'ю',
      'Q': 'Й',
      'W': 'Ц',
      'E': 'У',
      'R': 'К',
      'T': 'Е',
      'Y': 'Н',
      'U': 'Г',
      'I': 'Ш',
      'O': 'Щ',
      'P': 'З',
      '{': 'Х',
      '}': 'Ъ',
      'A': 'Ф',
      'S': 'Ы',
      'D': 'В',
      'F': 'А',
      'G': 'П',
      'H': 'Р',
      'J': 'О',
      'K': 'Л',
      'L': 'Д',
      ":": 'Ж',
      '"': 'Э',
      'Z': '?',
      'X': 'ч',
      'C': 'С',
      'V': 'М',
      'B': 'И',
      'N': 'Т',
      'M': 'Ь',
      '<': 'Б',
      '>': 'Ю'
    };
    let val = "";
    for (let i = 0; i < a.length; i++) if (map[a[i]]) val += map[a[i]];else val += a[i];
    return val;
  }
  static {
    this.ctorParameters = () => [];
  }
};
SearchService = SearchService_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable)({
  providedIn: 'root'
})], SearchService);


/***/ }),

/***/ 48080:
/*!************************************************!*\
  !*** ./src/app/services/status-bar.service.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StatusBarService: () => (/* binding */ StatusBarService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @awesome-cordova-plugins/status-bar/ngx */ 61203);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ionic/angular */ 4059);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




let StatusBarService = class StatusBarService {
  constructor(statusBar, platform) {
    this.statusBar = statusBar;
    this.platform = platform;
  }
  /**
   * Используйте строку состояния светлого содержимого (светлый текст).
   */
  styleLight() {
    this.platform.ready().then(() => {
      this.statusBar.styleLightContent();
    });
  }
  /**
   * Используйте строку состояния темного содержимого (темный текст).
   */
  styleDark() {
    this.platform.ready().then(() => {
      this.statusBar.styleDefault();
    });
  }
  /**
   * Используйте строку состояния по умолчанию (темный текст для светлой темы и светлый текст для темной темы).
   */
  styleDefault() {
    if (document.body.classList.value.indexOf('dark') > -1) {
      this.styleLight();
    } else {
      this.styleDark();
    }
  }
  /**
   * Установите, будет ли строка состояния перекрывать основной вид приложения. Значение по умолчанию равно true.
   *
   * @param doesOverlay
   */
  overlaysWebView(doesOverlay) {
    this.statusBar.overlaysWebView(doesOverlay);
  }
  static {
    this.ctorParameters = () => [{
      type: _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_0__.StatusBar
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_1__.Platform
    }];
  }
};
StatusBarService = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
  providedIn: 'root'
})], StatusBarService);


/***/ }),

/***/ 81314:
/*!***************************************************!*\
  !*** ./src/app/services/swipe-to-back.service.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SwipeToBackService: () => (/* binding */ SwipeToBackService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 37580);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */


let SwipeToBackService = class SwipeToBackService {
  constructor() {
    this.startY = 0;
    this.startX = 0;
    this.swiped = false;
    this.init();
  }
  init() {
    this.handler = ev => {
      try {
        if (ev.type === 'mousemove') {
          if (!this.swiped) {
            if (ev.clientX - this.startX > 10 && Math.abs(ev.clientY - this.startY) < 20) {
              this.swiped = true;
              // @ts-ignore
              ev.path.forEach(el => {
                try {
                  if (el.getAttributeNames().indexOf('no-back') > 0) {
                    document.querySelector('ion-app').removeEventListener('mousemove', this.handler);
                    this.swiped = false;
                  }
                } catch (err) {}
              });
              if (this.swiped) {
                this.el = document.querySelectorAll('ion-router-outlet');
                let el = this.el[0];
                if (!document.querySelector('app-tabs') || document.querySelector('app-tabs').getAttributeNames().indexOf('aria-hidden') == -1) {
                  el = this.el[1];
                }
                const mouseEvent = new MouseEvent('mousedown', {
                  clientX: 1,
                  clientY: ev.clientY,
                  relatedTarget: el
                });
                el.dispatchEvent(mouseEvent);
              }
            } else if (ev.clientX - this.startX < 0 || Math.abs(ev.clientY - this.startY) > 20) {
              document.querySelector('ion-app').removeEventListener('mousemove', this.handler);
            }
          }
        } else {
          if (!this.swiped) {
            if (ev.changedTouches[0].clientX - this.startX > 10 && Math.abs(ev.changedTouches[0].clientY - this.startY) < 20) {
              this.swiped = true;
              let loop = el => {
                if (el.attributes['no-back']) {
                  return true;
                } else {
                  if (el.parentElement) {
                    return loop(el.parentElement);
                  } else {
                    return false;
                  }
                }
              };
              if (loop(ev.changedTouches[0].target)) {
                document.querySelector('ion-app').removeEventListener('touchmove', this.handler);
                this.swiped = false;
              }
              if (this.swiped) {
                this.el = document.querySelectorAll('ion-router-outlet');
                let el = this.el[0];
                if (!document.querySelector('app-tabs') || document.querySelector('app-tabs').getAttributeNames().indexOf('aria-hidden') == -1) {
                  el = this.el[1];
                }
                const touch = new Touch({
                  identifier: Date.now(),
                  target: el,
                  clientY: ev.changedTouches[0].clientY,
                  clientX: 1
                });
                const touchEvent = new TouchEvent('touchstart', {
                  changedTouches: [touch]
                });
                el.dispatchEvent(touchEvent);
              }
            } else if (ev.changedTouches[0].clientX - this.startX < 0 || Math.abs(ev.changedTouches[0].clientY - this.startY) > 20) {
              document.querySelector('ion-app').removeEventListener('touchmove', this.handler);
            }
          }
        }
      } catch (e) {
        //
      }
    };
    document.querySelector('ion-app').addEventListener('touchend', ev => {
      document.querySelector('ion-app').removeEventListener('touchmove', this.handler);
      this.swiped = false;
    });
    document.querySelector('ion-app').addEventListener('mouseup', ev => {
      document.querySelector('ion-app').removeEventListener('mousemove', this.handler);
      this.swiped = false;
    });
    document.querySelector('ion-app').addEventListener('touchstart', ev => {
      this.startY = ev.changedTouches[0].clientY;
      this.startX = ev.changedTouches[0].clientX;
      document.querySelector('ion-app').addEventListener('touchmove', this.handler);
    });
    document.querySelector('ion-app').addEventListener('mousedown', ev => {
      this.startY = ev.clientY;
      this.startX = ev.clientX;
      document.querySelector('ion-app').addEventListener('mousemove', this.handler);
    });
  }
  static {
    this.ctorParameters = () => [];
  }
};
SwipeToBackService = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Injectable)({
  providedIn: 'root'
})], SwipeToBackService);


/***/ }),

/***/ 13719:
/*!****************************************************!*\
  !*** ./src/app/services/swipe-to-close.service.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SwipeToCloseService: () => (/* binding */ SwipeToCloseService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _helper_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helper.service */ 54102);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */






let SwipeToCloseService = class SwipeToCloseService {
  constructor(elem, animCtrl, helper) {
    this.initHeight = 0;
    this.init = true;
    this.routerOutletBlock = false;
    this.elemMoving = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject(null);
    this.elemMovingOversize = new rxjs__WEBPACK_IMPORTED_MODULE_2__.BehaviorSubject(null);
    this.startX = 0;
    this.startY = 0;
    this.moveX = 0;
    this.moveY = 0;
    this.moveToClose = false;
    this.speed = 270;
    this.moveXOtp = 0;
    this.moveYOpt = 0;
    this.mouseClicked = false;
    this.touched = false;
    this.swiping = false;
    this.blockClose = false;
    this.elem = elem;
    this.animCtrl = animCtrl;
    this.helper = helper;
    this.mouseClicked = false;
    this.moveToBack = this.animCtrl.create();
    this.elemMoving.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.filter)(value => value !== null)).subscribe(value => {
      this.elem.setAttribute('style', 'transform: translateY(' + value + 'px);');
      this.elem.querySelectorAll('.el-anim-tap').forEach(item => {
        if (item.getAttribute('block') !== 'true') {
          item.click();
          item.setAttribute('block', 'true');
        }
      });
    });
    this.elemMovingOversize.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_3__.filter)(value => value !== null)).subscribe(value => {
      this.elem.setAttribute('style', 'height: ' + value + 'px;' + this.elem.getAttribute('style'));
      this.elem.querySelectorAll('.el-anim-tap').forEach(item => {
        if (item.getAttribute('block') !== 'true') {
          item.click();
          item.setAttribute('block', 'true');
        }
      });
    });
  }
  /**
   * Функция возвращает состояние переменной blockClose, которая отвечает за блокировку закрытия окна
   */
  getBlockClose() {
    return this.blockClose;
  }
  /**
   * Функция, которая вызывается при первом касании на экране и фиксирует позицию пальца
   *
   * @param ev
   */
  touchStart(ev) {
    if (ev.touches.length > 1) {
      // если экрана качается больше одного пальца, то прекращаем все анимации
      this.touchEnd(ev);
    } else {
      // фиксируем позицию первого касания
      this.startX = ev.touches[0].clientX;
      this.startY = ev.touches[0].clientY;
      // расчет свободного расстояния сверху блока
      const freeHeight = Math.round(document.body.clientHeight - (this.initHeight !== 0 ? this.initHeight : this.elem.clientHeight));
      // если свободное расстояние сверху блока не равно изначальному,
      // значит пользователь растянул блок и это нужно учитывать при дальнейшем перемещении блока,
      // разница записывается в переменную moveYOpt и вызывается handler для остановки анимации возврата в исходное положение
      if (Math.round(this.elem.getBoundingClientRect().top) !== freeHeight) {
        this.moveX = this.startX;
        this.moveY = this.startY;
        this.moveYOpt = this.elem.getBoundingClientRect().top - freeHeight;
        this.moveToBack.stop();
        this.swiping = true;
        this.handler();
      }
      this.touched = true;
    }
  }
  touchEnd(ev) {
    if (this.swiping) {
      this.swiping = false;
      if (this.moveToClose) {
        this.blockClose = false;
        this.helper.closeSelect();
        setTimeout(() => {
          this.moveToClose = false;
          this.elem.querySelectorAll('.el-anim-tap').forEach(item => {
            item.setAttribute('block', 'false');
          });
        }, 380);
      } else {
        this.moveToBack.addElement(this.elem).easing('ease').duration(380).keyframes([{
          offset: 0,
          transform: 'translateY(' + this.elemMoving.value + 'px)',
          height: this.elem.clientHeight + 'px'
        }, {
          offset: 1,
          transform: 'translateY(0px)',
          height: this.initHeight !== 0 ? this.initHeight + 'px' : this.elem.clientHeight + 'px'
        }]);
        this.elemMoving.next(0);
        this.moveToBack.play().finally(() => {
          this.elem.querySelectorAll('.el-anim-tap').forEach(item => {
            item.setAttribute('block', 'false');
          });
          this.moveToBack.stop();
          this.initHeight = 0;
          this.moveYOpt = 0;
          this.moveXOtp = 0;
          this.blockClose = false;
        });
      }
      this.touched = false;
    } else {
      this.elem.querySelectorAll('.el-anim-tap').forEach(item => {
        item.setAttribute('block', 'false');
      });
    }
  }
  touchMove(ev) {
    if ((ev.touches[0].clientY - this.moveY > 20 || this.startY - this.moveY <= -100 && ev.touches[0].clientY - this.moveY >= 0) && this.touched) {
      this.moveToClose = true;
      this.speed = 270 - (ev.touches[0].clientY - this.moveY) * 6;
      if (this.speed < 100) {
        if (this.speed > 0) {
          this.speed = 100;
        } else {
          this.speed = 270;
        }
      }
    } else {
      this.moveToClose = false;
      this.speed = 270;
    }
    if (this.touched && ev.touches.length === 1) {
      this.moveX = ev.touches[0].clientX;
      this.moveY = ev.touches[0].clientY;
      this.handler();
    } else {
      this.touchEnd(ev);
    }
  }
  mouseDown(ev) {
    if (document.querySelector('html').classList.contains('plt-desktop')) {
      this.startX = ev.clientX;
      this.startY = ev.clientY;
      this.mouseClicked = true;
    }
  }
  mouseUp(ev) {
    if (document.querySelector('html').classList.contains('plt-desktop')) {
      if (this.mouseClicked) {
        this.touchEnd(ev);
        this.mouseClicked = false;
      }
    }
  }
  mouseMove(ev) {
    if (document.querySelector('html').classList.contains('plt-desktop')) {
      if ((ev.clientY - this.moveY > 20 || this.startY - this.moveY <= -100 && ev.clientY - this.moveY >= 0) && this.mouseClicked) {
        this.moveToClose = true;
        this.speed = 270 - (ev.clientY - this.moveY) * 6;
        if (this.speed < 100) {
          if (this.speed > 0) {
            this.speed = 100;
          } else {
            this.speed = 270;
          }
        }
      } else {
        this.moveToClose = false;
        this.speed = 270;
      }
      if (this.mouseClicked) {
        this.moveX = ev.clientX;
        this.moveY = ev.clientY;
        this.handler();
      }
    }
  }
  show() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const fun = () => {
        // Later, you can stop observing
        observer.disconnect();
        const enterSelect = _this.animCtrl.create().addElement(_this.elem).easing('ease').duration(380).keyframes([{
          offset: 0,
          bottom: '-' + _this.elem.clientHeight + 'px',
          opacity: 1
        }, {
          offset: 0.5,
          bottom: '-' + _this.elem.clientHeight + 'px',
          opacity: 1
        }, {
          offset: 1,
          bottom: '0px',
          opacity: 1
        }]);
        _this.init = true;
        _this.routerOutletBlock = true;
        enterSelect.play().finally(() => {
          _this.init = false;
        });
      };
      let timer;
      const handler = (mutationList, observer) => {
        if (document.querySelector('.custom-action-sheet-container').clientHeight > 0) {
          clearTimeout(timer);
          timer = setTimeout(fun, 30);
        }
      };
      // Create an observer instance linked to the callback function
      const observer = new MutationObserver(handler);
      // Options for the observer (which mutations to observe)
      const config = {
        childList: true,
        subtree: true,
        characterDataOldValue: true
      };
      // Start observing the target node for configured mutations
      observer.observe(document.querySelector('.custom-action-sheet-container'), config);
    })();
  }
  hide() {
    const leaveSelect = this.animCtrl.create().addElement(this.elem).easing('ease').duration(this.speed);
    if (this.moveToClose) {
      leaveSelect.keyframes([{
        offset: 0,
        bottom: '-' + this.elemMoving.value + 'px',
        opacity: 1
      }, {
        offset: 1,
        bottom: '-' + this.elem.clientHeight + 'px',
        opacity: 1
      }]);
    } else {
      leaveSelect.keyframes([{
        offset: 0,
        bottom: '0px',
        opacity: 1
      }, {
        offset: 1,
        bottom: '-' + this.elem.clientHeight + 'px',
        opacity: 1
      }]);
    }
    document.querySelector('.custom-action-sheet-container').setAttribute('style', 'transform: translateY(0px); opacity: 0;');
    document.querySelector('.custom-action-sheet').classList.add('lock');
    this.init = true;
    leaveSelect.play().finally(() => {
      setTimeout(() => {
        leaveSelect.stop();
      }, 100);
      this.init = false;
      this.speed = 270;
    }).catch(() => {});
  }
  reset() {
    this.initHeight = 0;
    this.init = true;
    this.elemMoving.next(null);
    this.elemMovingOversize.next(null);
    this.startX = 0;
    this.startY = 0;
    this.moveX = 0;
    this.moveY = 0;
    this.moveToClose = false;
    this.speed = 270;
    this.moveXOtp = 0;
    this.moveYOpt = 0;
    this.mouseClicked = false;
    this.touched = false;
    this.swiping = false;
    this.blockClose = false;
    this.routerOutletBlock = false;
  }
  /**
   * Функция перемещения блока
   *
   * @private
   */
  handler() {
    if (!this.init) {
      if (!this.swiping) {
        if (this.moveY - this.startY >= 10 || this.moveY - this.startY <= -10) {
          this.swiping = true;
          this.blockClose = true;
          if (this.moveY - this.startY >= 10) {
            this.startY = this.startY + 10;
          } else {
            this.startY = this.startY - 10;
          }
        }
      } else {
        if (this.moveY + this.moveYOpt - this.startY < 0) {
          this.elemMoving.next(0);
          const calcMove = (this.moveY - this.startY) / 30;
          const optMove = this.moveYOpt < 0 ? this.moveYOpt : 0;
          const moving = calcMove + optMove > -20 ? calcMove + optMove : -20;
          if (this.initHeight === 0) {
            this.initHeight = this.elem.clientHeight;
          }
          this.elemMovingOversize.next(this.initHeight - moving);
        } else {
          this.elemMoving.next(this.moveY + this.moveYOpt - this.startY);
        }
      }
    }
  }
  static {
    this.ctorParameters = () => [{
      type: HTMLElement
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AnimationController
    }, {
      type: _helper_service__WEBPACK_IMPORTED_MODULE_1__.HelperService
    }];
  }
};
SwipeToCloseService = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Injectable)({
  providedIn: 'root'
})
/**
 * Инструкция по использованию
 * Пример кода контроллера:
 *
 *   private elem; - // объект модального окна
 *   private swipe; - // объект созданного экземпляра класса SwipeToCloseService
 *
 *   constructor() { }
 *
 *   ngOnInit() {
 *     // для закрытия модального окна по свайпу внутри контента
 *     this.swipe = new SwipeToCloseService(this.elem); // Создаем экземпляр класса SwipeToCloseService
 *   }
 *
 *   // Создаем функцию scroll для передачи в класс SwipeToCloseService текущего положения скролла
 *   // для разделения свайпа(для закрытия) от скролла(по странице)
 *   scroll(event) {
 *     this.swipe.scrollContent = event.detail.scrollTop;
 *   }
 *
 * Пример кода HTML:
 *  // Нужно добавить атрибут scroll-events для включения отслеживания скролла на странице
 *  // и для события (ionScroll) вызывать функцию scroll созданную в контроллере
 *   <ion-content scroll-events="true" (ionScroll)="scroll($event)">
 *
 *   </ion-content>
 */], SwipeToCloseService);


/***/ }),

/***/ 2091:
/*!*******************************************!*\
  !*** ./src/app/services/token.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TokenSubject: () => (/* binding */ TokenSubject),
/* harmony export */   authHeader: () => (/* binding */ authHeader),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   storeTokens: () => (/* binding */ storeTokens),
/* harmony export */   updateToken: () => (/* binding */ updateToken)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 75797);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 95429);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 77919);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! rxjs */ 59452);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../environments/storage */ 12960);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ 36647);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs/operators */ 61318);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common/http */ 46443);
/* harmony import */ var _interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../interceptors/jwt.interceptor */ 69339);
/* harmony import */ var _request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./request.service */ 80931);







const Token = new rxjs__WEBPACK_IMPORTED_MODULE_4__.BehaviorSubject('');
const TokenSubject = new rxjs__WEBPACK_IMPORTED_MODULE_4__.BehaviorSubject(null);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Token);
const authHeader = () => {
  return {
    Authorization: Token.value
  };
};
const updateToken = (uuid, http) => {
  // Устанавливаем ключ в значение null чтобы другие запросы ждали обновление токена
  Token.next(null);
  const refreshToken = (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.from)(_capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.get({
    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.REFRESH_TOKEN
  }));
  return refreshToken.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.switchMap)(token => {
    if (token && token.value) {
      const body = {
        refreshToken: token.value,
        deviceUuid: uuid
      };
      const options = {
        context: new _angular_common_http__WEBPACK_IMPORTED_MODULE_7__.HttpContext().set(_interceptors_jwt_interceptor__WEBPACK_IMPORTED_MODULE_2__.UPDATE_TOKEN, true)
      };
      return http.post('/auth/refresh', body, options).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_8__.catchError)(err => {
        return (0,rxjs__WEBPACK_IMPORTED_MODULE_9__.throwError)(err);
      }));
    } else {
      // No stored refresh token
      return (0,rxjs__WEBPACK_IMPORTED_MODULE_10__.of)(null);
    }
  }));
};
const storeTokens = data => {
  const storeAccess = _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.set({
    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.ACCESS_TOKEN,
    value: data.access_token
  });
  const storeRefresh = _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.set({
    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.REFRESH_TOKEN,
    value: data.refresh_token
  });
  const storeAccountId = _capacitor_preferences__WEBPACK_IMPORTED_MODULE_0__.Preferences.set({
    key: _environments_storage__WEBPACK_IMPORTED_MODULE_1__.ACCOUNT_ID,
    value: data.id.toString()
  });
  Token.next(data.access_token);
  _request_service__WEBPACK_IMPORTED_MODULE_3__.accountId.next(data.id);
  return (0,rxjs__WEBPACK_IMPORTED_MODULE_5__.from)(Promise.all([storeAccess, storeRefresh, storeAccountId]));
};

/***/ }),

/***/ 54455:
/*!***************************************!*\
  !*** ./src/app/types/livePaysType.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LivePaysEnum: () => (/* binding */ LivePaysEnum)
/* harmony export */ });
var LivePaysEnum;
(function (LivePaysEnum) {
  LivePaysEnum["KVTS"] = "kvts";
  LivePaysEnum["PAYS"] = "pays";
  LivePaysEnum["PAYS_ACCRUALS"] = "pays_accruals";
})(LivePaysEnum || (LivePaysEnum = {}));

/***/ }),

/***/ 88849:
/*!***************************************!*\
  !*** ./src/app/types/paymentsType.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PayType: () => (/* binding */ PayType)
/* harmony export */ });
var PayType;
(function (PayType) {
  PayType["SBP"] = "sbp";
  PayType["CARD"] = "card";
})(PayType || (PayType = {}));

/***/ }),

/***/ 69632:
/*!********************************************!*\
  !*** ./src/app/types/requestMethodType.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Method: () => (/* binding */ Method)
/* harmony export */ });
var Method;
(function (Method) {
  Method["GET"] = "GET";
  Method["POST"] = "POST";
})(Method || (Method = {}));

/***/ }),

/***/ 27518:
/*!************************************************!*\
  !*** ./src/app/types/settingsPayChequeType.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PayChequeTypes: () => (/* binding */ PayChequeTypes)
/* harmony export */ });
var PayChequeTypes;
(function (PayChequeTypes) {
  PayChequeTypes["NONE"] = "none";
  PayChequeTypes["EMAIL"] = "email";
  PayChequeTypes["TEL"] = "tel";
})(PayChequeTypes || (PayChequeTypes = {}));

/***/ }),

/***/ 48129:
/*!****************************************!*\
  !*** ./src/environments/connection.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BASIC_AUTH_LOGIN: () => (/* binding */ BASIC_AUTH_LOGIN),
/* harmony export */   BASIC_AUTH_PASSWORD: () => (/* binding */ BASIC_AUTH_PASSWORD),
/* harmony export */   DIVO_ORGS_URL: () => (/* binding */ DIVO_ORGS_URL),
/* harmony export */   GET_URL: () => (/* binding */ GET_URL),
/* harmony export */   HTTP_TIMEOUT: () => (/* binding */ HTTP_TIMEOUT),
/* harmony export */   ICONS_URL: () => (/* binding */ ICONS_URL),
/* harmony export */   IMGS_URL: () => (/* binding */ IMGS_URL),
/* harmony export */   TRUST_MODE: () => (/* binding */ TRUST_MODE),
/* harmony export */   USED_BASIC_AUTH: () => (/* binding */ USED_BASIC_AUTH)
/* harmony export */ });
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
const GET_URL = (isApi = true) => `${BASE_URL}/${isApi ? API : DOCS}`;
// export const BASE_URL = "https://lkfiz-master.testapp.stack.stack-it.ru/api";
// export const BASE_URL = "https://fl-test.yantarenergosbyt.ru";
// export const BASE_URL = "https://lkfiz.202407.dev.stack-it.ru/api";
const BASE_URL = 'https://lk.stack-it.ru';
// const BASE_URL = 'https://lk.energosale34.ru'
const API = "api";
const DOCS = "help/mp-fiz/web_mp_fl";
const DIVO_ORGS_URL = "https://connect.stack-divo.ru/api";
const ICONS_URL = "https://lk.tempmp.stack-divo.ru/mobile/icons"; // not used
const IMGS_URL = "https://lk.tempmp.stack-divo.ru/mobile/imgs"; // not used
const HTTP_TIMEOUT = 30000; //ms
const USED_BASIC_AUTH = false; // not used
const BASIC_AUTH_LOGIN = ""; // not used
const BASIC_AUTH_PASSWORD = ""; // not used
// 'default': обработка проверки доверия SSL и имени хоста по умолчанию с использованием сертификатов CA системы
// 'legacy': использовать устаревшее поведение по умолчанию
// 'nocheck': отключить проверку SSL-сертификатов и проверку имени хоста,
// доверяя всем сертификатам (предназначенным для использования только в целях тестирования).
// 'pinned': доверяйте только предоставленным сертификатам
const TRUST_MODE = "nocheck"; // not used

/***/ }),

/***/ 45312:
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   environment: () => (/* binding */ environment)
/* harmony export */ });
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
  production: false
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.

/***/ }),

/***/ 79308:
/*!**************************************!*\
  !*** ./src/environments/settings.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ALLOWED_EXTENSIONS_FILE: () => (/* binding */ ALLOWED_EXTENSIONS_FILE),
/* harmony export */   ALLOWED_EXTENSIONS_IMG: () => (/* binding */ ALLOWED_EXTENSIONS_IMG),
/* harmony export */   APP_LANGS: () => (/* binding */ APP_LANGS),
/* harmony export */   APP_LANG_DEFAULT: () => (/* binding */ APP_LANG_DEFAULT),
/* harmony export */   CACHE_TTL: () => (/* binding */ CACHE_TTL),
/* harmony export */   CODE_PUSH: () => (/* binding */ CODE_PUSH),
/* harmony export */   COUNT_APPLICATIONS_FORM_LOADING: () => (/* binding */ COUNT_APPLICATIONS_FORM_LOADING),
/* harmony export */   COUNT_NOTIFICATIONS_LOADING: () => (/* binding */ COUNT_NOTIFICATIONS_LOADING),
/* harmony export */   CURRENCY: () => (/* binding */ CURRENCY),
/* harmony export */   CUSTOM_URL_SCHEME: () => (/* binding */ CUSTOM_URL_SCHEME),
/* harmony export */   DEMO: () => (/* binding */ DEMO),
/* harmony export */   DEMO_LOGIN: () => (/* binding */ DEMO_LOGIN),
/* harmony export */   DEMO_PASS: () => (/* binding */ DEMO_PASS),
/* harmony export */   DIVO: () => (/* binding */ DIVO),
/* harmony export */   GOOGLE_PROJECT_NUMBER: () => (/* binding */ GOOGLE_PROJECT_NUMBER),
/* harmony export */   MAX_FILE_COUNT_UPLOAD: () => (/* binding */ MAX_FILE_COUNT_UPLOAD),
/* harmony export */   MAX_FILE_SIZE_UPLOAD: () => (/* binding */ MAX_FILE_SIZE_UPLOAD),
/* harmony export */   MIN_PASSWORD_LENGTH: () => (/* binding */ MIN_PASSWORD_LENGTH),
/* harmony export */   ONESIGNAL_APP_ID: () => (/* binding */ ONESIGNAL_APP_ID),
/* harmony export */   SSL_PINNING_MODE: () => (/* binding */ SSL_PINNING_MODE),
/* harmony export */   SYMBOL_LOCATION: () => (/* binding */ SYMBOL_LOCATION)
/* harmony export */ });
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
const ONESIGNAL_APP_ID = '15e45b18-a8d6-44e6-8dfd-db3b8f1b5f97';
const GOOGLE_PROJECT_NUMBER = '1038814615588';
const MIN_PASSWORD_LENGTH = 6;
const ALLOWED_EXTENSIONS_IMG = {
  name: ['jpg', 'jpeg', 'png'],
  value: ['image/jpg', 'image/jpeg', 'image/png']
};
const ALLOWED_EXTENSIONS_FILE = {
  name: ['pdf', 'doc', 'docx', 'txt', 'xls', 'xlsx'],
  value: ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'text/plain', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet']
};
const MAX_FILE_SIZE_UPLOAD = 5242880; //5mb
const MAX_FILE_COUNT_UPLOAD = 5;
const SSL_PINNING_MODE = false; //not used
const CACHE_TTL = 600; //seconds
const COUNT_NOTIFICATIONS_LOADING = 40;
const COUNT_APPLICATIONS_FORM_LOADING = 1000;
const CUSTOM_URL_SCHEME = 'stackit';
const CURRENCY = 'RUB'; // RUB
const SYMBOL_LOCATION = 'right'; // right|left
const APP_LANGS = ['ru'];
const APP_LANG_DEFAULT = 'ru';
const CODE_PUSH = false; // plugin not supported
const DIVO = false;
const DEMO = true;
const DEMO_LOGIN = 'web@stack-it.ru';
const DEMO_PASS = '12345678';

/***/ }),

/***/ 12960:
/*!*************************************!*\
  !*** ./src/environments/storage.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCESS_TOKEN: () => (/* binding */ ACCESS_TOKEN),
/* harmony export */   ACCOUNT_ID: () => (/* binding */ ACCOUNT_ID),
/* harmony export */   ACTIVE_LS: () => (/* binding */ ACTIVE_LS),
/* harmony export */   API_URL: () => (/* binding */ API_URL),
/* harmony export */   APPEALS_AND_SURVEYS: () => (/* binding */ APPEALS_AND_SURVEYS),
/* harmony export */   APPLICATIONS_FORM: () => (/* binding */ APPLICATIONS_FORM),
/* harmony export */   APPLICATION_LANG: () => (/* binding */ APPLICATION_LANG),
/* harmony export */   APP_PERFORMANCE: () => (/* binding */ APP_PERFORMANCE),
/* harmony export */   APP_THEME: () => (/* binding */ APP_THEME),
/* harmony export */   AUTH_BY_PHONE: () => (/* binding */ AUTH_BY_PHONE),
/* harmony export */   AVAILABLE: () => (/* binding */ AVAILABLE),
/* harmony export */   AVAILABLE_APPEALS: () => (/* binding */ AVAILABLE_APPEALS),
/* harmony export */   AVAILABLE_PAY: () => (/* binding */ AVAILABLE_PAY),
/* harmony export */   AVAILABLE_PAY_DATE: () => (/* binding */ AVAILABLE_PAY_DATE),
/* harmony export */   AVAILABLE_QUALITY: () => (/* binding */ AVAILABLE_QUALITY),
/* harmony export */   AVAILABLE_READINGS: () => (/* binding */ AVAILABLE_READINGS),
/* harmony export */   AVAILABLE_RECORDING: () => (/* binding */ AVAILABLE_RECORDING),
/* harmony export */   BALANCES: () => (/* binding */ BALANCES),
/* harmony export */   BINDINGS: () => (/* binding */ BINDINGS),
/* harmony export */   CALCULATION: () => (/* binding */ CALCULATION),
/* harmony export */   CENTERS: () => (/* binding */ CENTERS),
/* harmony export */   COUNTERS: () => (/* binding */ COUNTERS),
/* harmony export */   DEVICE_UUID: () => (/* binding */ DEVICE_UUID),
/* harmony export */   DIVO_SELECTED_ORG: () => (/* binding */ DIVO_SELECTED_ORG),
/* harmony export */   FAIO_CHANGED: () => (/* binding */ FAIO_CHANGED),
/* harmony export */   FAIO_ENABLED: () => (/* binding */ FAIO_ENABLED),
/* harmony export */   FAQ: () => (/* binding */ FAQ),
/* harmony export */   HELP: () => (/* binding */ HELP),
/* harmony export */   LS_DATA: () => (/* binding */ LS_DATA),
/* harmony export */   NOTIFICATIONS: () => (/* binding */ NOTIFICATIONS),
/* harmony export */   NOTIFICATIONS_NO_READ_COUNT: () => (/* binding */ NOTIFICATIONS_NO_READ_COUNT),
/* harmony export */   PAGE_MESSAGE: () => (/* binding */ PAGE_MESSAGE),
/* harmony export */   PAGE_MESSAGE_CLOSED: () => (/* binding */ PAGE_MESSAGE_CLOSED),
/* harmony export */   PAGE_TECHNICAL_WORKS: () => (/* binding */ PAGE_TECHNICAL_WORKS),
/* harmony export */   PAGE_UPDATE_APP: () => (/* binding */ PAGE_UPDATE_APP),
/* harmony export */   PAYMENTS: () => (/* binding */ PAYMENTS),
/* harmony export */   PAYMENTS_HISTORY: () => (/* binding */ PAYMENTS_HISTORY),
/* harmony export */   PIN_CODE: () => (/* binding */ PIN_CODE),
/* harmony export */   PIN_CODE_ENABLED: () => (/* binding */ PIN_CODE_ENABLED),
/* harmony export */   PIN_CODE_INVITED: () => (/* binding */ PIN_CODE_INVITED),
/* harmony export */   READINGS_HISTORY: () => (/* binding */ READINGS_HISTORY),
/* harmony export */   RECEIPTS: () => (/* binding */ RECEIPTS),
/* harmony export */   REFRESH_TOKEN: () => (/* binding */ REFRESH_TOKEN),
/* harmony export */   SCREEN_MODE: () => (/* binding */ SCREEN_MODE),
/* harmony export */   SETTINGS_EMAIL: () => (/* binding */ SETTINGS_EMAIL),
/* harmony export */   SETTINGS_MAILING: () => (/* binding */ SETTINGS_MAILING),
/* harmony export */   SETTINGS_PAY_CHEQUE: () => (/* binding */ SETTINGS_PAY_CHEQUE),
/* harmony export */   SETTINGS_PAY_METHODS: () => (/* binding */ SETTINGS_PAY_METHODS),
/* harmony export */   SETTINGS_PHONE: () => (/* binding */ SETTINGS_PHONE),
/* harmony export */   UNRELIABLE_ADDRESS: () => (/* binding */ UNRELIABLE_ADDRESS),
/* harmony export */   UNRELIABLE_FIO: () => (/* binding */ UNRELIABLE_FIO),
/* harmony export */   UNRELIABLE_LS: () => (/* binding */ UNRELIABLE_LS),
/* harmony export */   UNRELIABLE_PU: () => (/* binding */ UNRELIABLE_PU),
/* harmony export */   UPDATE_INVITE_CLOSED: () => (/* binding */ UPDATE_INVITE_CLOSED)
/* harmony export */ });
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
const DIVO_SELECTED_ORG = 'divoSelectedOrg';
const APPEALS_AND_SURVEYS = 'appealsAndSurveys';
const LS_DATA = 'accountData';
const COUNTERS = 'counters';
const ACTIVE_LS = 'activeLS';
const BINDINGS = 'bindings';
const ACCESS_TOKEN = 'accessToken';
const REFRESH_TOKEN = 'refreshToken';
const PIN_CODE = 'pinCode';
const PIN_CODE_ENABLED = 'pinCodeEnabled';
const PIN_CODE_INVITED = 'pinCodeInvited';
const FAIO_ENABLED = 'touchID';
const FAIO_CHANGED = 'faioChanged';
const ACCOUNT_ID = 'accountId';
const APP_THEME = 'appTheme';
const AVAILABLE = 'available';
const NOTIFICATIONS_NO_READ_COUNT = 'notificationsNoReadCount';
const NOTIFICATIONS = 'notifications';
const READINGS_HISTORY = 'readingsHistory';
const BALANCES = 'balances';
const SETTINGS_PHONE = 'settingsPhone';
const SETTINGS_EMAIL = 'settingsEmail';
const SETTINGS_MAILING = 'settingsMailing';
const APP_PERFORMANCE = 'appPerformance';
const FAQ = 'FAQ';
const HELP = 'help';
const CENTERS = 'centers';
const CALCULATION = 'calculation';
const PAYMENTS = 'payments';
const PAYMENTS_HISTORY = 'paymentsHistory';
const RECEIPTS = 'receipts';
const SETTINGS_PAY_CHEQUE = 'settingsPayCheque';
const APPLICATIONS_FORM = 'applicationsForm';
const SETTINGS_PAY_METHODS = 'settingsPayMethods';
const AVAILABLE_PAY = 'availablePayments';
const AVAILABLE_PAY_DATE = 'availablePaymentsDate';
const AVAILABLE_READINGS = 'availableReadings';
const AVAILABLE_APPEALS = 'availableAppeals';
const AUTH_BY_PHONE = 'authByPhone';
const PAGE_UPDATE_APP = 'pageUpdateApp';
const PAGE_TECHNICAL_WORKS = 'pageTechnicalWorks';
const PAGE_MESSAGE = 'pageMessage';
const PAGE_MESSAGE_CLOSED = 'pageMessageClosed';
const UPDATE_INVITE_CLOSED = 'updateInviteClosed';
const APPLICATION_LANG = 'applicationLang';
const AVAILABLE_QUALITY = 'availableQuality';
const AVAILABLE_RECORDING = 'availableRecording';
const SCREEN_MODE = 'screenMode';
const UNRELIABLE_LS = 'unreliableLS';
const UNRELIABLE_PU = 'unreliablePU';
const UNRELIABLE_FIO = 'unreliableFIO';
const UNRELIABLE_ADDRESS = 'unreliableAddress';
const DEVICE_UUID = 'deviceUUID';
const API_URL = 'apiUrl';

/***/ }),

/***/ 84429:
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/platform-browser-dynamic */ 52476);
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app/app.module */ 50635);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./environments/environment */ 45312);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




if (_environments_environment__WEBPACK_IMPORTED_MODULE_1__.environment.production) {
  (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.enableProdMode)();
}
(0,_angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__.platformBrowserDynamic)().bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_0__.AppModule).catch(err => {});

/***/ }),

/***/ 88996:
/*!******************************************************************************************************************************************!*\
  !*** ./node_modules/@ionic/core/dist/esm/ lazy ^\.\/.*\.entry\.js$ include: \.entry\.js$ exclude: \.system\.entry\.js$ namespace object ***!
  \******************************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./ion-accordion_2.entry.js": [
		37518,
		"common",
		"node_modules_ionic_core_dist_esm_ion-accordion_2_entry_js"
	],
	"./ion-action-sheet.entry.js": [
		41981,
		"common",
		"node_modules_ionic_core_dist_esm_ion-action-sheet_entry_js"
	],
	"./ion-alert.entry.js": [
		71603,
		"common",
		"node_modules_ionic_core_dist_esm_ion-alert_entry_js"
	],
	"./ion-app_8.entry.js": [
		82273,
		"common",
		"node_modules_ionic_core_dist_esm_ion-app_8_entry_js"
	],
	"./ion-avatar_3.entry.js": [
		19642,
		"node_modules_ionic_core_dist_esm_ion-avatar_3_entry_js"
	],
	"./ion-back-button.entry.js": [
		32095,
		"common",
		"node_modules_ionic_core_dist_esm_ion-back-button_entry_js"
	],
	"./ion-backdrop.entry.js": [
		72335,
		"node_modules_ionic_core_dist_esm_ion-backdrop_entry_js"
	],
	"./ion-breadcrumb_2.entry.js": [
		78221,
		"common",
		"node_modules_ionic_core_dist_esm_ion-breadcrumb_2_entry_js"
	],
	"./ion-button_2.entry.js": [
		47184,
		"node_modules_ionic_core_dist_esm_ion-button_2_entry_js"
	],
	"./ion-card_5.entry.js": [
		38759,
		"node_modules_ionic_core_dist_esm_ion-card_5_entry_js"
	],
	"./ion-checkbox.entry.js": [
		24248,
		"node_modules_ionic_core_dist_esm_ion-checkbox_entry_js"
	],
	"./ion-chip.entry.js": [
		69863,
		"node_modules_ionic_core_dist_esm_ion-chip_entry_js"
	],
	"./ion-col_3.entry.js": [
		51769,
		"node_modules_ionic_core_dist_esm_ion-col_3_entry_js"
	],
	"./ion-datetime-button.entry.js": [
		2569,
		"default-node_modules_ionic_core_dist_esm_data-CKHMWxfe_js",
		"node_modules_ionic_core_dist_esm_ion-datetime-button_entry_js"
	],
	"./ion-datetime_3.entry.js": [
		76534,
		"default-node_modules_ionic_core_dist_esm_data-CKHMWxfe_js",
		"common",
		"node_modules_ionic_core_dist_esm_ion-datetime_3_entry_js"
	],
	"./ion-fab_3.entry.js": [
		25458,
		"common",
		"node_modules_ionic_core_dist_esm_ion-fab_3_entry_js"
	],
	"./ion-img.entry.js": [
		70654,
		"node_modules_ionic_core_dist_esm_ion-img_entry_js"
	],
	"./ion-infinite-scroll_2.entry.js": [
		36034,
		"common",
		"node_modules_ionic_core_dist_esm_ion-infinite-scroll_2_entry_js"
	],
	"./ion-input-otp.entry.js": [
		20381,
		"common",
		"node_modules_ionic_core_dist_esm_ion-input-otp_entry_js"
	],
	"./ion-input-password-toggle.entry.js": [
		5196,
		"common",
		"node_modules_ionic_core_dist_esm_ion-input-password-toggle_entry_js"
	],
	"./ion-input.entry.js": [
		20761,
		"default-node_modules_ionic_core_dist_esm_input_utils-be4gBvVY_js-node_modules_ionic_core_dist-a8d71f",
		"common",
		"node_modules_ionic_core_dist_esm_ion-input_entry_js"
	],
	"./ion-item-option_3.entry.js": [
		6492,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item-option_3_entry_js"
	],
	"./ion-item_8.entry.js": [
		29557,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item_8_entry_js"
	],
	"./ion-loading.entry.js": [
		68353,
		"common",
		"node_modules_ionic_core_dist_esm_ion-loading_entry_js"
	],
	"./ion-menu_3.entry.js": [
		51024,
		"common",
		"node_modules_ionic_core_dist_esm_ion-menu_3_entry_js"
	],
	"./ion-modal.entry.js": [
		29160,
		"common",
		"node_modules_ionic_core_dist_esm_ion-modal_entry_js"
	],
	"./ion-nav_2.entry.js": [
		60393,
		"node_modules_ionic_core_dist_esm_ion-nav_2_entry_js"
	],
	"./ion-picker-column-option.entry.js": [
		68442,
		"node_modules_ionic_core_dist_esm_ion-picker-column-option_entry_js"
	],
	"./ion-picker-column.entry.js": [
		43110,
		"common",
		"node_modules_ionic_core_dist_esm_ion-picker-column_entry_js"
	],
	"./ion-picker.entry.js": [
		15575,
		"node_modules_ionic_core_dist_esm_ion-picker_entry_js"
	],
	"./ion-popover.entry.js": [
		16772,
		"common",
		"node_modules_ionic_core_dist_esm_ion-popover_entry_js"
	],
	"./ion-progress-bar.entry.js": [
		34810,
		"node_modules_ionic_core_dist_esm_ion-progress-bar_entry_js"
	],
	"./ion-radio_2.entry.js": [
		14639,
		"common",
		"node_modules_ionic_core_dist_esm_ion-radio_2_entry_js"
	],
	"./ion-range.entry.js": [
		90628,
		"common",
		"node_modules_ionic_core_dist_esm_ion-range_entry_js"
	],
	"./ion-refresher_2.entry.js": [
		10852,
		"common",
		"node_modules_ionic_core_dist_esm_ion-refresher_2_entry_js"
	],
	"./ion-reorder_2.entry.js": [
		61479,
		"common",
		"node_modules_ionic_core_dist_esm_ion-reorder_2_entry_js"
	],
	"./ion-ripple-effect.entry.js": [
		24065,
		"node_modules_ionic_core_dist_esm_ion-ripple-effect_entry_js"
	],
	"./ion-route_4.entry.js": [
		57971,
		"node_modules_ionic_core_dist_esm_ion-route_4_entry_js"
	],
	"./ion-searchbar.entry.js": [
		93184,
		"common",
		"node_modules_ionic_core_dist_esm_ion-searchbar_entry_js"
	],
	"./ion-segment-content.entry.js": [
		94312,
		"node_modules_ionic_core_dist_esm_ion-segment-content_entry_js"
	],
	"./ion-segment-view.entry.js": [
		54540,
		"common",
		"node_modules_ionic_core_dist_esm_ion-segment-view_entry_js"
	],
	"./ion-segment_2.entry.js": [
		469,
		"common",
		"node_modules_ionic_core_dist_esm_ion-segment_2_entry_js"
	],
	"./ion-select-modal.entry.js": [
		57101,
		"node_modules_ionic_core_dist_esm_ion-select-modal_entry_js"
	],
	"./ion-select_3.entry.js": [
		78471,
		"common",
		"node_modules_ionic_core_dist_esm_ion-select_3_entry_js"
	],
	"./ion-spinner.entry.js": [
		40388,
		"common",
		"node_modules_ionic_core_dist_esm_ion-spinner_entry_js"
	],
	"./ion-split-pane.entry.js": [
		42392,
		"node_modules_ionic_core_dist_esm_ion-split-pane_entry_js"
	],
	"./ion-tab-bar_2.entry.js": [
		36059,
		"common",
		"node_modules_ionic_core_dist_esm_ion-tab-bar_2_entry_js"
	],
	"./ion-tab_2.entry.js": [
		5427,
		"node_modules_ionic_core_dist_esm_ion-tab_2_entry_js"
	],
	"./ion-text.entry.js": [
		50198,
		"node_modules_ionic_core_dist_esm_ion-text_entry_js"
	],
	"./ion-textarea.entry.js": [
		1735,
		"default-node_modules_ionic_core_dist_esm_input_utils-be4gBvVY_js-node_modules_ionic_core_dist-a8d71f",
		"node_modules_ionic_core_dist_esm_ion-textarea_entry_js"
	],
	"./ion-toast.entry.js": [
		7510,
		"common",
		"node_modules_ionic_core_dist_esm_ion-toast_entry_js"
	],
	"./ion-toggle.entry.js": [
		45297,
		"common",
		"node_modules_ionic_core_dist_esm_ion-toggle_entry_js"
	]
};
function webpackAsyncContext(req) {
	if(!__webpack_require__.o(map, req)) {
		return Promise.resolve().then(() => {
			var e = new Error("Cannot find module '" + req + "'");
			e.code = 'MODULE_NOT_FOUND';
			throw e;
		});
	}

	var ids = map[req], id = ids[0];
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(() => {
		return __webpack_require__(id);
	});
}
webpackAsyncContext.keys = () => (Object.keys(map));
webpackAsyncContext.id = 88996;
module.exports = webpackAsyncContext;

/***/ }),

/***/ 54140:
/*!************************************************************************************************************************************************************!*\
  !*** ./node_modules/@stencil/core/internal/client/ lazy ^\.\/.*\.entry\.js.*$ include: \.entry\.js$ exclude: \.system\.entry\.js$ strict namespace object ***!
  \************************************************************************************************************************************************************/
/***/ ((module) => {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncaught exception popping up in devtools
	return Promise.resolve().then(() => {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	});
}
webpackEmptyAsyncContext.keys = () => ([]);
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = 54140;
module.exports = webpackEmptyAsyncContext;

/***/ }),

/***/ 37282:
/*!***********************************************!*\
  !*** ./src/app/app.component.scss?ngResource ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.update-window {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  backdrop-filter: saturate(210%) blur(6px);
  background: var(--backdrop-background);
  z-index: 999999999;
}
.update-window-content {
  width: 270px;
  border-radius: 13px;
  overflow: hidden;
  background: var(--ion-card-background);
}
.update-window-content-title {
  padding: 20px 16px 7px 16px;
  text-align: center;
  font-size: 17px;
  color: var(--ion-text-color);
}
.update-window-content-progress {
  padding: 8px 16px 8px 16px;
}
.update-window-content-progress ion-progress-bar {
  border-radius: 4px;
}
.update-window-content-message {
  padding: 0 16px 21px 16px;
  text-align: center;
}`, "",{"version":3,"sources":["webpack://./src/app/app.component.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,kBAAA;EACA,MAAA;EACA,OAAA;EACA,QAAA;EACA,SAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,yCAAA;EACA,sCAAA;EACA,kBAAA;AACF;AACE;EACE,YAAA;EACA,mBAAA;EACA,gBAAA;EACA,sCAAA;AACJ;AACI;EACE,2BAAA;EACA,kBAAA;EACA,eAAA;EACA,4BAAA;AACN;AAEI;EACE,0BAAA;AAAN;AAEM;EACE,kBAAA;AAAR;AAII;EACE,yBAAA;EACA,kBAAA;AAFN","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.update-window {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  backdrop-filter: saturate(210%) blur(6px);\n  background: var(--backdrop-background);\n  z-index: 999999999;\n\n  &-content {\n    width: 270px;\n    border-radius: 13px;\n    overflow: hidden;\n    background: var(--ion-card-background);\n\n    &-title {\n      padding: 20px 16px 7px 16px;\n      text-align: center;\n      font-size: 17px;\n      color: var(--ion-text-color);\n    }\n\n    &-progress {\n      padding: 8px 16px 8px 16px;\n\n      ion-progress-bar {\n        border-radius: 4px;\n      }\n    }\n\n    &-message {\n      padding: 0 16px 21px 16px;\n      text-align: center;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 9109:
/*!****************************************************************************!*\
  !*** ./src/app/components/card-block/card-block.component.scss?ngResource ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.card-block {
  padding-top: 16px;
}
.card-block .name {
  margin: 8px 24px 0 24px;
}
.card-block ion-card {
  margin-top: 8px;
  margin-bottom: 0;
}
.card-block ion-card app-menu-item {
  display: contents;
}
.card-block ion-card > * .custom-card-content {
  border-bottom: 1px solid var(--color-separate);
}
.card-block ion-card > *:last-child .custom-card-content {
  border-bottom: none !important;
}
.card-block ion-card ion-item {
  --min-height: 0;
}
.card-block ion-card ion-toggle {
  pointer-events: none;
}
.card-block ion-card .disabled {
  opacity: 0.3;
}
.card-block ion-card .loading {
  pointer-events: none;
  opacity: 0.3;
}`, "",{"version":3,"sources":["webpack://./src/app/components/card-block/card-block.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,uBAAA;AACJ;AAEE;EACE,eAAA;EACA,gBAAA;AAAJ;AAEI;EACE,iBAAA;AAAN;AAIM;EACE,8CAAA;AAFR;AAMQ;EACE,8BAAA;AAJV;AASI;EACE,eAAA;AAPN;AAUI;EACE,oBAAA;AARN;AAWI;EACE,YAAA;AATN;AAYI;EACE,oBAAA;EACA,YAAA;AAVN","sourcesContent":[".card-block {\n  padding-top: 16px;\n\n  .name {\n    margin: 8px 24px 0 24px\n  }\n\n  ion-card {\n    margin-top: 8px;\n    margin-bottom: 0;\n\n    app-menu-item {\n      display: contents;\n    }\n\n    & > * {\n      .custom-card-content {\n        border-bottom: 1px solid var(--color-separate);\n      }\n\n      &:last-child {\n        .custom-card-content {\n          border-bottom: none !important;\n        }\n      }\n    }\n\n    ion-item {\n      --min-height: 0;\n    }\n\n    ion-toggle {\n      pointer-events: none;\n    }\n\n    .disabled {\n      opacity: 0.3;\n    }\n\n    .loading {\n      pointer-events: none;\n      opacity: 0.3;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 7:
/*!******************************************************************************!*\
  !*** ./src/app/components/custom-item/custom-item.component.scss?ngResource ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `ion-item {
  padding-left: 24px;
  padding-right: 24px;
  margin-left: -24px;
  margin-right: -24px;
  margin-bottom: 5px;
  margin-top: -5px;
  padding-top: 5px;
  box-sizing: content-box;
  position: relative;
}
ion-item::before {
  content: "";
  background: var(--background);
  display: block;
  position: absolute;
  top: 0;
  left: 24px;
  right: 24px;
  bottom: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/components/custom-item/custom-item.component.scss"],"names":[],"mappings":"AAAA;EACE,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,gBAAA;EACA,gBAAA;EACA,uBAAA;EAEA,kBAAA;AAAF;AAEE;EACE,WAAA;EACA,6BAAA;EACA,cAAA;EACA,kBAAA;EACA,MAAA;EACA,UAAA;EACA,WAAA;EACA,SAAA;AAAJ","sourcesContent":["ion-item {\n  padding-left: 24px;\n  padding-right: 24px;\n  margin-left: -24px;\n  margin-right: -24px;\n  margin-bottom: 5px;\n  margin-top: -5px;\n  padding-top: 5px;\n  box-sizing: content-box;\n\n  position: relative;\n\n  &::before {\n    content: \"\";\n    background: var(--background);\n    display: block;\n    position: absolute;\n    top: 0;\n    left: 24px;\n    right: 24px;\n    bottom: 0;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 10407:
/*!******************************************************************************************!*\
  !*** ./src/app/components/date-button-field/date-button-field.component.scss?ngResource ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `ion-content .datepicker {
  width: 100%;
  height: auto;
  margin-top: 80px;
}
ion-content .datepicker ion-datetime {
  height: 50%;
  max-width: 100%;
  width: 100%;
  --background: transparent;
  --background-rgb: transparent;
  border-radius: 16px;
  box-shadow: rgba(var(--ion-color-rose-rgb), 0.3) 0 10px 15px -3px;
  text-align: -webkit-center;
}
ion-content .datepicker ion-datetime .picker-item {
  height: 48px !important;
}
ion-content .datepicker .period {
  min-height: 372px;
}
ion-content .fullDate {
  margin: 8px 12px 0 12px;
}
ion-content ion-datetime::part(calendar-day):focus {
  box-shadow: none !important;
}
ion-content ion-datetime::part(active)::before {
  position: absolute;
  left: -3px;
  right: -3px;
  top: 0;
  bottom: 0;
  z-index: -1;
  background: rgba(0, 0, 0, 0.1);
  border-radius: 0;
}
ion-content ion-datetime::part(active)::after {
  position: absolute;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;
  z-index: -1;
  background: var(--ion-color-primary);
  border-radius: 24px;
}`, "",{"version":3,"sources":["webpack://./src/app/components/date-button-field/date-button-field.component.scss"],"names":[],"mappings":"AACE;EACE,WAAA;EACA,YAAA;EACA,gBAAA;AAAJ;AAEI;EACE,WAAA;EACA,eAAA;EACA,WAAA;EAEA,yBAAA;EACA,6BAAA;EAEA,mBAAA;EACA,iEAAA;EAEA,0BAAA;AAHN;AAKM;EACE,uBAAA;AAHR;AAOI;EACE,iBAAA;AALN;AASE;EACE,uBAAA;AAPJ;AAUE;EACE,2BAAA;AARJ;AAYI;EACE,kBAAA;EACA,UAAA;EACA,WAAA;EACA,MAAA;EACA,SAAA;EACA,WAAA;EACA,8BAAA;EACA,gBAAA;AAVN;AAaI;EACE,kBAAA;EACA,OAAA;EACA,QAAA;EACA,MAAA;EACA,SAAA;EACA,WAAA;EACA,oCAAA;EACA,mBAAA;AAXN","sourcesContent":["ion-content {\n  .datepicker {\n    width: 100%;\n    height: auto;\n    margin-top: 80px;\n\n    ion-datetime{\n      height: 50%;\n      max-width: 100%;\n      width: 100%;\n\n      --background: transparent;\n      --background-rgb: transparent;\n\n      border-radius: 16px;\n      box-shadow: rgba(var(--ion-color-rose-rgb), 0.3) 0 10px 15px -3px;\n\n      text-align: -webkit-center;\n\n      .picker-item{\n        height: 48px !important;\n      }\n    }\n\n    .period {\n      min-height: 372px;\n    }\n  }\n\n  .fullDate {\n    margin: 8px 12px 0 12px;\n  }\n\n  ion-datetime::part(calendar-day):focus {\n    box-shadow: none !important;\n  }\n\n  ion-datetime::part(active) {\n    &::before {\n      position: absolute;\n      left: -3px;\n      right: -3px;\n      top: 0;\n      bottom: 0;\n      z-index: -1;\n      background: rgba(0,0,0,.1);\n      border-radius: 0;\n    }\n\n    &::after {\n      position: absolute;\n      left: 0;\n      right: 0;\n      top: 0;\n      bottom: 0;\n      z-index: -1;\n      background: var(--ion-color-primary);\n      border-radius: 24px;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 92611:
/*!**************************************************************************************************!*\
  !*** ./src/app/components/datetime-button-field/datetime-button-field.component.scss?ngResource ***!
  \**************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-custom-item {
  display: contents;
}
app-custom-item ion-label {
  margin: 0;
  padding: 0 0 10px 0;
}
app-custom-item ion-label ion-text {
  display: block;
  font-size: 12px;
  flex-grow: 1;
  color: var(--font-color-secondary);
  margin: 5px 0 6px 0;
  overflow: hidden;
  text-overflow: ellipsis;
}
app-custom-item ion-label ion-datetime-button {
  justify-content: start;
  margin-left: -2px;
}
app-custom-item ion-label ion-datetime-button div {
  color: var(--font-color-secondary);
  line-height: 1rem;
}

ion-modal {
  --width: 100%;
  --height: auto;
}
ion-modal .wrapper {
  width: 100%;
  padding-bottom: var(--ion-safe-area-bottom);
  display: flex;
  justify-content: center;
  background: var(--ion-color-light, #ffffff);
}
ion-modal .wrapper ion-datetime {
  width: 338px;
}
ion-modal .wrapper ion-datetime .datetime-time ion-picker-internal ion-picker-column-internal {
  width: 100% !important;
}
ion-modal .wrapper .period {
  min-height: 372px;
}

ion-datetime::part(calendar-day):focus {
  box-shadow: none !important;
}

ion-datetime::part(active)::before {
  position: absolute;
  left: -3px;
  right: -3px;
  top: 0;
  bottom: 0;
  z-index: -1;
  background: rgba(0, 0, 0, 0.1);
  border-radius: 0;
}
ion-datetime::part(active)::after {
  position: absolute;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;
  z-index: -1;
  background: var(--ion-color-primary);
  border-radius: 24px;
}`, "",{"version":3,"sources":["webpack://./src/app/components/datetime-button-field/datetime-button-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,SAAA;EACA,mBAAA;AACJ;AACI;EACE,cAAA;EACA,eAAA;EACA,YAAA;EACA,kCAAA;EACA,mBAAA;EACA,gBAAA;EACA,uBAAA;AACN;AAEI;EACE,sBAAA;EACA,iBAAA;AAAN;AAEM;EACE,kCAAA;EACA,iBAAA;AAAR;;AAMA;EACE,aAAA;EACA,cAAA;AAHF;AAKE;EACE,WAAA;EACA,2CAAA;EACA,aAAA;EACA,uBAAA;EACA,2CAAA;AAHJ;AAKI;EACE,YAAA;AAHN;AAOU;EACE,sBAAA;AALZ;AAgBI;EACE,iBAAA;AAdN;;AAkCA;EACE,2BAAA;AA/BF;;AAqCE;EACE,kBAAA;EACA,UAAA;EACA,WAAA;EACA,MAAA;EACA,SAAA;EACA,WAAA;EACA,8BAAA;EACA,gBAAA;AAlCJ;AAqCE;EACE,kBAAA;EACA,OAAA;EACA,QAAA;EACA,MAAA;EACA,SAAA;EACA,WAAA;EACA,oCAAA;EACA,mBAAA;AAnCJ","sourcesContent":["app-custom-item {\n  display: contents;\n\n  ion-label {\n    margin: 0;\n    padding: 0 0 10px 0;\n\n    ion-text {\n      display: block;\n      font-size: 12px;\n      flex-grow: 1;\n      color: var(--font-color-secondary);\n      margin: 5px 0 6px 0;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n\n    ion-datetime-button {\n      justify-content: start;\n      margin-left: -2px;\n\n      div {\n        color: var(--font-color-secondary);\n        line-height: 1rem;\n      }\n    }\n  }\n}\n\nion-modal {\n  --width: 100%;\n  --height: auto;\n\n  .wrapper {\n    width: 100%;\n    padding-bottom: var(--ion-safe-area-bottom);\n    display: flex;\n    justify-content: center;\n    background: var(--ion-color-light, #ffffff);\n\n    ion-datetime {\n      width: 338px;\n\n      .datetime-time {\n        ion-picker-internal {\n          ion-picker-column-internal {\n            width: 100% !important;\n          }\n        }\n      }\n\n      //ion-datetime::part(calendar-day active) {\n      //  //background-color: #00a3d3;\n      //  background: #00a3d3;\n      //}\n    }\n\n    .period {\n      min-height: 372px;\n    }\n  }\n}\n\n//ion-datetime::part(calendar-day) {\n//  &::before {\n//    content: \"\";\n//    position: absolute;\n//    left: 0;\n//    right: 0;\n//    //left: -4px;\n//    //right: -4px;\n//    top: 0;\n//    bottom: 0;\n//    background: aqua;\n//    z-index: -1;\n//  }\n//}\n\nion-datetime::part(calendar-day):focus {\n  box-shadow: none !important;\n}\n\nion-datetime::part(active) {\n  //background: none;\n\n  &::before {\n    position: absolute;\n    left: -3px;\n    right: -3px;\n    top: 0;\n    bottom: 0;\n    z-index: -1;\n    background: rgba(0,0,0,.1);\n    border-radius: 0;\n  }\n\n  &::after {\n    position: absolute;\n    left: 0;\n    right: 0;\n    top: 0;\n    bottom: 0;\n    z-index: -1;\n    background: var(--ion-color-primary);\n    border-radius: 24px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 93415:
/*!****************************************************************************!*\
  !*** ./src/app/components/file-field/file-field.component.scss?ngResource ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `ion-item-sliding {
  overflow: visible;
}
ion-item-sliding app-custom-item {
  display: contents;
}
ion-item-sliding app-custom-item ion-item {
  position: relative;
}
ion-item-sliding app-custom-item ion-item::before {
  content: "";
  background: aliceblue;
  display: block;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
}
ion-item-sliding app-custom-item .icon-wrapper {
  line-height: 0;
}
ion-item-sliding app-custom-item ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
ion-item-sliding app-custom-item ion-label {
  margin: 0;
  padding: 0 0 6px 0;
}
ion-item-sliding app-custom-item ion-label strong {
  display: block;
  overflow: hidden;
  text-overflow: ellipsis;
}
ion-item-sliding app-custom-item ion-label ion-text {
  display: block;
  font-size: 12px;
  flex-grow: 1;
  color: var(--font-color-secondary);
  margin: 5px 0 6px 0;
  overflow: hidden;
  text-overflow: ellipsis;
}
ion-item-sliding app-custom-item ion-label ion-label {
  display: flex;
  align-items: center;
  padding: 0;
  min-height: 28px;
}
ion-item-sliding app-custom-item ion-label ion-label ion-icon {
  margin-right: 10px;
  min-width: 28px;
  width: 28px;
  height: 28px;
}
ion-item-sliding app-custom-item ion-label ion-label img {
  margin-right: 10px;
  width: auto;
  height: auto;
  max-width: 28px;
  max-height: 28px;
}
ion-item-sliding app-custom-item ion-label ion-label ion-note {
  display: block;
  font-size: 16px;
  color: var(--font-color-caption);
  text-wrap: wrap;
}
ion-item-sliding .selected ion-label ion-label ion-icon {
  color: var(--font-color-primary);
}
ion-item-sliding .selected ion-label ion-label ion-note {
  color: var(--font-color-primary);
}
ion-item-sliding ion-item-options {
  padding-bottom: 5px;
  border-bottom-width: 0 !important;
}
ion-item-sliding ion-item-options ion-item-option {
  margin-top: -5px;
}`, "",{"version":3,"sources":["webpack://./src/app/components/file-field/file-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,iBAAA;AACJ;AACI;EACE,kBAAA;AACN;AACM;EACE,WAAA;EACA,qBAAA;EACA,cAAA;EACA,kBAAA;EACA,MAAA;EACA,OAAA;EACA,QAAA;EACA,SAAA;AACR;AAGI;EACE,cAAA;AADN;AAII;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AAFN;AAKI;EACE,SAAA;EACA,kBAAA;AAHN;AAKM;EACE,cAAA;EACA,gBAAA;EACA,uBAAA;AAHR;AAMM;EACE,cAAA;EACA,eAAA;EACA,YAAA;EACA,kCAAA;EACA,mBAAA;EACA,gBAAA;EACA,uBAAA;AAJR;AAOM;EACE,aAAA;EACA,mBAAA;EACA,UAAA;EACA,gBAAA;AALR;AAOQ;EACE,kBAAA;EACA,eAAA;EACA,WAAA;EACA,YAAA;AALV;AAQQ;EACE,kBAAA;EACA,WAAA;EACA,YAAA;EACA,eAAA;EACA,gBAAA;AANV;AASQ;EACE,cAAA;EACA,eAAA;EACA,gCAAA;EACA,eAAA;AAPV;AAgBQ;EACE,gCAAA;AAdV;AAiBQ;EACE,gCAAA;AAfV;AAqBE;EACE,mBAAA;EACA,iCAAA;AAnBJ;AAqBI;EACE,gBAAA;AAnBN","sourcesContent":["ion-item-sliding {\n  overflow: visible;\n\n  app-custom-item {\n    display: contents;\n\n    ion-item {\n      position: relative;\n\n      &::before {\n        content: \"\";\n        background: aliceblue;\n        display: block;\n        position: absolute;\n        top: 0;\n        left: 0;\n        right: 0;\n        bottom: 0;\n      }\n    }\n\n    .icon-wrapper {\n      line-height: 0;\n    }\n\n    ion-icon {\n      width: 24px;\n      height: 24px;\n      color: var(--base-color-icon);\n    }\n\n    ion-label {\n      margin: 0;\n      padding: 0 0 6px 0;\n\n      strong {\n        display: block;\n        overflow: hidden;\n        text-overflow: ellipsis;\n      }\n\n      ion-text {\n        display: block;\n        font-size: 12px;\n        flex-grow: 1;\n        color: var(--font-color-secondary);\n        margin: 5px 0 6px 0;\n        overflow: hidden;\n        text-overflow: ellipsis;\n      }\n\n      ion-label {\n        display: flex;\n        align-items: center;\n        padding: 0;\n        min-height: 28px;\n\n        ion-icon {\n          margin-right: 10px;\n          min-width: 28px;\n          width: 28px;\n          height: 28px;\n        }\n\n        img {\n          margin-right: 10px;\n          width: auto;\n          height: auto;\n          max-width: 28px;\n          max-height: 28px;\n        }\n\n        ion-note {\n          display: block;\n          font-size: 16px;\n          color: var(--font-color-caption);\n          text-wrap: wrap;\n        }\n      }\n    }\n  }\n\n  .selected {\n    ion-label {\n      ion-label {\n        ion-icon {\n          color: var(--font-color-primary);\n        }\n\n        ion-note {\n          color: var(--font-color-primary);\n        }\n      }\n    }\n  }\n\n  ion-item-options {\n    padding-bottom: 5px;\n    border-bottom-width: 0 !important;\n\n    ion-item-option {\n      margin-top: -5px;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 45139:
/*!******************************************************************************!*\
  !*** ./src/app/components/input-field/input-field.component.scss?ngResource ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-custom-item {
  display: contents;
}
app-custom-item .custom-card-content {
  display: flex;
  justify-content: space-between;
  width: 100%;
  flex-direction: column;
  padding: 0 0 0 0;
  margin-bottom: -5px;
}
app-custom-item .custom-card-content ion-input {
  min-height: 63px;
}
app-custom-item .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 2px 0;
}
app-custom-item .custom-card-content-item-title {
  font-size: 16px;
  line-height: 1.25rem;
  flex-grow: 1;
  color: var(--font-color-secondary);
}
app-custom-item .custom-card-content-item-title span {
  line-height: inherit;
}`, "",{"version":3,"sources":["webpack://./src/app/components/input-field/input-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,aAAA;EACA,8BAAA;EACA,WAAA;EACA,sBAAA;EACA,gBAAA;EACA,mBAAA;AACJ;AACI;EACE,gBAAA;AACN;AAEI;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AAAN;AAEM;EACE,eAAA;EACA,oBAAA;EACA,YAAA;EACA,kCAAA;AAAR;AAEQ;EACE,oBAAA;AAAV","sourcesContent":["app-custom-item {\n  display: contents;\n\n  .custom-card-content {\n    display: flex;\n    justify-content: space-between;\n    width: 100%;\n    flex-direction: column;\n    padding: 0 0 0 0;\n    margin-bottom: -5px;\n\n    ion-input {\n      min-height: 63px;\n    }\n\n    &-item {\n      width: 100%;\n      display: flex;\n      align-items: center;\n      justify-content: space-between;\n      gap: 8px;\n      margin: 2px 0;\n\n      &-title {\n        font-size: 16px;\n        line-height: 1.25rem;\n        flex-grow: 1;\n        color: var(--font-color-secondary);\n\n        span {\n          line-height: inherit;\n        }\n      }\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 65487:
/*!**************************************************************************!*\
  !*** ./src/app/components/menu-item/menu-item.component.scss?ngResource ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.item-disabled {
  opacity: 1;
}
.item-disabled > * > * {
  opacity: 0.3;
}

ion-note {
  line-height: initial;
  margin-top: 12px;
  font-size: 0.9em;
}`, "",{"version":3,"sources":["webpack://./src/app/components/menu-item/menu-item.component.scss"],"names":[],"mappings":"AAAA;EACE,UAAA;AACF;AACE;EACE,YAAA;AACJ;;AAGA;EACE,oBAAA;EACA,gBAAA;EACA,gBAAA;AAAF","sourcesContent":[".item-disabled {\n  opacity: 1;\n\n  & > * > * {\n    opacity: .3;\n  }\n}\n\nion-note {\n  line-height: initial;\n  margin-top: 12px;\n  font-size: 0.9em;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 62843:
/*!********************************************************************************!*\
  !*** ./src/app/components/select-field/select-field.component.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-custom-item {
  display: contents;
}
app-custom-item .icon-wrapper {
  line-height: 0;
}
app-custom-item .icon-wrapper ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
app-custom-item ion-label {
  margin: 0;
  padding: 0 0 5px 0;
}
app-custom-item ion-label strong {
  display: block;
  overflow: hidden;
  text-overflow: ellipsis;
}
app-custom-item ion-label ion-text {
  display: block;
  font-size: 12px;
  flex-grow: 1;
  color: var(--font-color-secondary);
  margin: 5px 0 6px 0;
  overflow: hidden;
  text-overflow: ellipsis;
}
app-custom-item ion-label ion-note {
  display: block;
  font-size: 16px;
  color: var(--font-color-caption);
  margin: 5px 0;
  text-wrap: wrap;
}
app-custom-item ion-label .selected {
  color: var(--font-color-primary);
}`, "",{"version":3,"sources":["webpack://./src/app/components/select-field/select-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,cAAA;AACJ;AACI;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AACN;AAGE;EACE,SAAA;EACA,kBAAA;AADJ;AAGI;EACE,cAAA;EACA,gBAAA;EACA,uBAAA;AADN;AAII;EACE,cAAA;EACA,eAAA;EACA,YAAA;EACA,kCAAA;EACA,mBAAA;EACA,gBAAA;EACA,uBAAA;AAFN;AAKI;EACE,cAAA;EACA,eAAA;EACA,gCAAA;EACA,aAAA;EACA,eAAA;AAHN;AAMI;EACE,gCAAA;AAJN","sourcesContent":["app-custom-item {\n  display: contents;\n\n  .icon-wrapper {\n    line-height: 0;\n\n    ion-icon {\n      width: 24px;\n      height: 24px;\n      color: var(--base-color-icon);\n    }\n  }\n\n  ion-label {\n    margin: 0;\n    padding: 0 0 5px 0;\n\n    strong {\n      display: block;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n\n    ion-text {\n      display: block;\n      font-size: 12px;\n      flex-grow: 1;\n      color: var(--font-color-secondary);\n      margin: 5px 0 6px 0;\n      overflow: hidden;\n      text-overflow: ellipsis;\n    }\n\n    ion-note {\n      display: block;\n      font-size: 16px;\n      color: var(--font-color-caption);\n      margin: 5px 0;\n      text-wrap: wrap;\n    }\n\n    .selected {\n      color: var(--font-color-primary);\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 51785:
/*!****************************************************************************!*\
  !*** ./src/app/components/text-field/text-field.component.scss?ngResource ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-custom-item {
  display: contents;
}
app-custom-item .custom-card-content {
  display: flex;
  justify-content: space-between;
  width: 100%;
  flex-direction: column;
  padding: 0 0 0 0;
  margin-bottom: -5px;
}
app-custom-item .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 2px 0;
}
app-custom-item .custom-card-content-item-title {
  font-size: 16px;
  line-height: 1em;
  flex-grow: 1;
  color: var(--font-color-secondary);
}
app-custom-item .custom-card-content-item-title span {
  line-height: inherit;
}`, "",{"version":3,"sources":["webpack://./src/app/components/text-field/text-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AACE;EACE,aAAA;EACA,8BAAA;EACA,WAAA;EACA,sBAAA;EACA,gBAAA;EACA,mBAAA;AACJ;AACI;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AACN;AACM;EACE,eAAA;EACA,gBAAA;EACA,YAAA;EACA,kCAAA;AACR;AACQ;EACE,oBAAA;AACV","sourcesContent":["app-custom-item {\n  display: contents;\n\n  .custom-card-content {\n    display: flex;\n    justify-content: space-between;\n    width: 100%;\n    flex-direction: column;\n    padding: 0 0 0 0;\n    margin-bottom: -5px;\n\n    &-item {\n      width: 100%;\n      display: flex;\n      align-items: center;\n      justify-content: space-between;\n      gap: 8px;\n      margin: 2px 0;\n\n      &-title {\n        font-size: 16px;\n        line-height: 1em;\n        flex-grow: 1;\n        color: var(--font-color-secondary);\n\n        span {\n          line-height: inherit;\n        }\n      }\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 2139:
/*!********************************************************************************!*\
  !*** ./src/app/components/toggle-field/toggle-field.component.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-custom-item {
  display: contents;
}
app-custom-item ion-toggle::part(track) {
  margin-bottom: 5px;
}
app-custom-item ion-toggle.toggle-checked ion-label {
  color: var(--font-color-primary) !important;
}
app-custom-item ion-toggle ion-label {
  color: var(--font-color-secondary) !important;
}
app-custom-item ion-toggle ion-note {
  font-size: 14px !important;
  color: var(--font-color-secondary) !important;
}`, "",{"version":3,"sources":["webpack://./src/app/components/toggle-field/toggle-field.component.scss"],"names":[],"mappings":"AAAA;EACE,iBAAA;AACF;AAEI;EACE,kBAAA;AAAN;AAIM;EACE,2CAAA;AAFR;AAMI;EACE,6CAAA;AAJN;AAOI;EACE,0BAAA;EACA,6CAAA;AALN","sourcesContent":["app-custom-item {\n  display: contents;\n\n  ion-toggle {\n    &::part(track) {\n      margin-bottom: 5px;\n    }\n\n    &.toggle-checked {\n      ion-label {\n        color: var(--font-color-primary) !important;\n      }\n    }\n\n    ion-label {\n      color: var(--font-color-secondary) !important;\n    }\n\n    ion-note {\n      font-size: 14px !important;\n      color: var(--font-color-secondary) !important;\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 57457:
/*!******************************************************************************!*\
  !*** ./src/app/pages/account-verified/account-verified.page.scss?ngResource ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.modal {
  padding-top: calc(var(--ion-safe-area-top) + 24px) !important;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/account-verified/account-verified.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,6DAAA;AACF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.modal {\n  padding-top: calc(var(--ion-safe-area-top) + 24px) !important;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 5639:
/*!**************************************************************************!*\
  !*** ./src/app/pages/add-code-modal/add-code-modal.page.scss?ngResource ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */`, "",{"version":3,"sources":["webpack://./src/app/pages/add-code-modal/add-code-modal.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 37440:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/auth/recovery-password/recovery-password.page.scss?ngResource ***!
  \*************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-content .content-page {
  padding: 45px 24px 24px 24px;
}
ion-content .content-page .input-group {
  margin-top: 40px;
  margin-bottom: 24px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/auth/recovery-password/recovery-password.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,4BAAA;AAAJ;AAEI;EACE,gBAAA;EACA,mBAAA;AAAN","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-content {\n  .content-page {\n    padding: 45px 24px 24px 24px;\n\n    .input-group {\n      margin-top: 40px;\n      margin-bottom: 24px;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 43551:
/*!****************************************************************!*\
  !*** ./src/app/pages/bio-modal/bio-modal.page.scss?ngResource ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */`, "",{"version":3,"sources":["webpack://./src/app/pages/bio-modal/bio-modal.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 51727:
/*!********************************************************************************!*\
  !*** ./src/app/pages/change-data-modal/change-data-modal.page.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page .input-block .text {
  align-self: start;
  width: 100%;
  margin: 48px 0 24px 0;
}
.content-page .toggle-block {
  padding: 0 16px;
}
.content-page .toggle-block .custom-card-content {
  padding: 16px 0;
}
.content-page .helper-text {
  text-align: left;
  font-size: 14px;
}
.content-page .toggle-block:last-child ion-item {
  --inner-border-width: 0px;
}
.content-page .name {
  margin: 16px 24px 0 24px;
}
.content-page .name ~ ion-card {
  margin-top: 8px;
  margin-bottom: 24px;
}

ion-toggle {
  pointer-events: none;
  max-width: 40px;
}

.disabled {
  opacity: 0.3;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/change-data-modal/change-data-modal.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAMI;EACE,iBAAA;EACA,WAAA;EACA,qBAAA;AADN;AAKE;EACE,eAAA;AAHJ;AAII;EACE,eAAA;AAFN;AAME;EACE,gBAAA;EACA,eAAA;AAJJ;AAaI;EACE,yBAAA;AAXN;AAeE;EACE,wBAAA;AAbJ;AAgBE;EACE,eAAA;EACA,mBAAA;AAdJ;;AAkBA;EACE,oBAAA;EACA,eAAA;AAfF;;AAkBA;EACE,YAAA;AAfF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  .input-block {\n    .text {\n      align-self: start;\n      width: 100%;\n      margin: 48px 0 24px 0;\n    }\n  }\n\n  .toggle-block {\n    padding: 0 16px;\n    .custom-card-content {\n      padding: 16px 0;\n    }\n  }\n\n  .helper-text {\n    text-align: left;\n    font-size: 14px;\n  }\n\n  ion-item {\n    //--inner-border-width: 0px 0px 1px 0px;\n    //--background: var(--color-separate);\n  }\n\n  .toggle-block:last-child {\n    ion-item {\n      --inner-border-width: 0px;\n    }\n  }\n\n  .name {\n    margin: 16px 24px 0 24px;\n  }\n\n  .name ~ ion-card {\n    margin-top: 8px;\n    margin-bottom: 24px;\n  }\n}\n\nion-toggle {\n  pointer-events: none;\n  max-width: 40px;\n}\n\n.disabled {\n  opacity: 0.3;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 9411:
/*!********************************************************************!*\
  !*** ./src/app/pages/choose-data/choose-data.page.scss?ngResource ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page {
  padding: 0 24px;
}
.content-page ion-label {
  color: var(--font-color-primary) !important;
  line-height: 24px;
  letter-spacing: 0.02em;
  margin: 20px 0 19px;
}
.content-page ion-label .description {
  line-height: 14px;
  color: var(--font-color-caption);
}`, "",{"version":3,"sources":["webpack://./src/app/pages/choose-data/choose-data.page.scss"],"names":[],"mappings":"AAAA;EACE,eAAA;AACF;AACE;EACE,2CAAA;EACA,iBAAA;EACA,sBAAA;EACA,mBAAA;AACJ;AAAI;EACE,iBAAA;EACA,gCAAA;AAEN","sourcesContent":[".content-page{\n  padding: 0 24px;\n\n  ion-label {\n    color: var(--font-color-primary)!important;\n    line-height: 24px;\n    letter-spacing: 0.02em;\n    margin: 20px 0 19px;\n    .description{\n      line-height: 14px;\n      color: var(--font-color-caption);\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 93087:
/*!********************************************************************************!*\
  !*** ./src/app/pages/code-verification/code-verification.page.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-toolbar ion-title {
  padding-left: 24px;
  padding-right: 24px;
  text-align: left;
  padding-inline: 24px 50px !important;
}

.content-page {
  padding: 24px;
}
.content-page .input-group {
  display: flex;
  justify-content: space-between;
  max-width: 400px;
  margin: 24px 0;
}
.content-page .input-group ion-item {
  width: 100%;
}
.content-page .input-group ion-item .num {
  display: flex;
  justify-content: space-between;
  width: 100%;
}
.content-page .input-group ion-item .num span {
  display: flex;
  justify-content: center;
  align-items: center;
  height: 64px;
  width: 64px;
  border-bottom: 1px solid var(--base-color-border-input);
  font-size: 24px;
  font-weight: 500;
}
.content-page .input-group ion-item ion-input {
  position: absolute;
  opacity: 0;
}
.content-page .timer, .content-page timer-btn {
  font-size: 16px;
  font-weight: 400;
}
.content-page .timer span, .content-page timer-btn span {
  color: var(--ion-color-primary);
}
.content-page .timer-btn {
  color: var(--ion-color-primary);
}
.content-page .hide-input {
  opacity: 0;
  pointer-events: none;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/code-verification/code-verification.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,kBAAA;EACA,mBAAA;EACA,gBAAA;EACA,oCAAA;AAAJ;;AAIA;EACE,aAAA;AADF;AAEE;EACE,aAAA;EACA,8BAAA;EACA,gBAAA;EACA,cAAA;AAAJ;AAEI;EACE,WAAA;AAAN;AAEM;EACE,aAAA;EACA,8BAAA;EACA,WAAA;AAAR;AAEQ;EACE,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,YAAA;EACA,WAAA;EACA,uDAAA;EACA,eAAA;EACA,gBAAA;AAAV;AAIM;EACE,kBAAA;EACA,UAAA;AAFR;AAOE;EACE,eAAA;EACA,gBAAA;AALJ;AAOI;EACE,+BAAA;AALN;AASE;EACE,+BAAA;AAPJ;AAUE;EACE,UAAA;EACA,oBAAA;AARJ","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-toolbar {\n  ion-title {\n    padding-left: 24px;\n    padding-right: 24px;\n    text-align: left;\n    padding-inline: 24px 50px !important;\n  }\n}\n\n.content-page {\n  padding: 24px;\n  .input-group {\n    display: flex;\n    justify-content: space-between;\n    max-width: 400px;\n    margin: 24px 0;\n\n    ion-item {\n      width: 100%;\n\n      .num {\n        display: flex;\n        justify-content: space-between;\n        width: 100%;\n\n        span {\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          height: 64px;\n          width: 64px;\n          border-bottom: 1px solid var(--base-color-border-input);\n          font-size: 24px;\n          font-weight: 500;\n        }\n      }\n\n      ion-input {\n        position: absolute;\n        opacity: 0;\n      }\n    }\n  }\n\n  .timer, timer-btn {\n    font-size: 16px;\n    font-weight: 400;\n\n    span {\n      color: var(--ion-color-primary)\n    }\n  }\n\n  .timer-btn {\n    color: var(--ion-color-primary);\n  }\n\n  .hide-input {\n    opacity: 0;\n    pointer-events: none;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 30969:
/*!******************************************************!*\
  !*** ./src/app/pages/info/info.page.scss?ngResource ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page .description {
  display: block;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/info/info.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,cAAA;AAAJ","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  .description {\n    display: block;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 17455:
/*!************************************************************!*\
  !*** ./src/app/pages/message/message.page.scss?ngResource ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page {
  padding: 0 0 calc(24px + var(--ion-safe-area-bottom)) 0 !important;
}

.subHeader, .message {
  text-align: center;
}

.message {
  color: var(--font-color-secondary);
}

.btn {
  display: flex;
  gap: 12px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/message/message.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,kEAAA;AACF;;AAEA;EACE,kBAAA;AACF;;AAEA;EACE,kCAAA;AACF;;AAEA;EACE,aAAA;EACA,SAAA;AACF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  padding: 0 0 calc(24px + var(--ion-safe-area-bottom)) 0 !important;\n}\n\n.subHeader, .message {\n  text-align: center;\n}\n\n.message {\n  color: var(--font-color-secondary);\n}\n\n.btn {\n  display: flex;\n  gap: 12px;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 76935:
/*!**************************************************************!*\
  !*** ./src/app/pages/pin-code/pin-code.page.scss?ngResource ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-content {
  display: flex;
  align-items: center;
}

.fullscreen {
  height: 100%;
  display: flex;
  align-items: center;
}

.pin-code-page {
  display: flex;
  flex-direction: column;
  height: 100%;
  width: 100%;
  padding-bottom: calc(var(--ion-safe-area-bottom) + 30px);
  padding-top: var(--ion-safe-area-top);
}
.pin-code-page .pin-code {
  flex-grow: 2;
  display: flex;
  justify-content: center;
  align-items: center;
  flex-direction: column;
}
.pin-code-page .pin-code .row {
  display: flex;
  justify-content: center;
  align-items: center;
  text-align: center;
  font-size: 16px;
  line-height: 24px;
  min-height: 50px;
  color: var(--font-color-secondary);
}
.pin-code-page .pin-code .row .text {
  position: absolute;
  transform: translateX(250px);
  opacity: 0;
}
.pin-code-page .pin-code .row .col {
  width: 14px;
  height: 14px;
  margin: 0 12px;
  background: var(--ion-color-medium);
  color: var(--ion-color-medium);
  border-radius: 50%;
  transition: 0.15s;
}
.pin-code-page .pin-code .row .col .success {
  color: inherit;
  width: 18px;
  height: 18px;
  margin: -2px -2px 2px -2px;
  opacity: 1;
}
.pin-code-page .pin-code .row .check {
  background: var(--ion-color-primary);
  color: var(--ion-color-primary);
  animation: scale 0.28s ease normal;
}
@keyframes scale {
  from {
    transform: scale(1, 1);
  }
  60% {
    transform: scale(1.7, 1.7);
  }
  to {
    transform: scale(1, 1);
  }
}
.pin-code-page .pin-code .row .clicked {
  background-color: var(--ion-color-success);
}
.pin-code-page .buttons {
  display: flex;
  flex-direction: column;
}
.pin-code-page .buttons .row {
  display: flex;
  justify-content: center;
}
.pin-code-page .buttons .row .col {
  display: flex;
  justify-content: center;
  width: 100px;
  height: 70px;
  align-items: center;
  font-size: 32px;
}
.pin-code-page .buttons .row .col:before {
  content: "";
  width: 66px;
  height: 66px;
  position: absolute;
  border-radius: 50%;
  transition: 0.35s;
  pointer-events: none;
  -webkit-user-select: none;
          user-select: none;
  z-index: -1;
}
.pin-code-page .buttons .row .col:active:before {
  background-color: var(--base-color-hover);
  transition: 0s;
}
.pin-code-page .buttons .row .col .num {
  pointer-events: none;
  -webkit-user-select: none;
          user-select: none;
}
.pin-code-page .buttons .row .col ion-icon {
  color: var(--base-color-icon);
}
.pin-code-page .buttons .row .text {
  font-size: 14px;
}
.pin-code-page .buttons .row .hide {
  opacity: 0;
}
.pin-code-page .disabled {
  pointer-events: none;
}

.ipad {
  max-height: 600px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/pin-code/pin-code.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,aAAA;EACA,mBAAA;AACF;;AAEA;EACE,YAAA;EACA,aAAA;EACA,mBAAA;AACF;;AAEA;EACE,aAAA;EACA,sBAAA;EACA,YAAA;EACA,WAAA;EACA,wDAAA;EACA,qCAAA;AACF;AACE;EACE,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,sBAAA;AACJ;AACI;EACE,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,kBAAA;EAEA,eAAA;EACA,iBAAA;EACA,gBAAA;EACA,kCAAA;AAAN;AAEM;EACE,kBAAA;EACA,4BAAA;EACA,UAAA;AAAR;AAGM;EACE,WAAA;EACA,YAAA;EACA,cAAA;EACA,mCAAA;EACA,8BAAA;EACA,kBAAA;EACA,iBAAA;AADR;AAKQ;EACE,cAAA;EACA,WAAA;EACA,YAAA;EACA,0BAAA;EACA,UAAA;AAHV;AAOM;EACE,oCAAA;EACA,+BAAA;EACA,kCAAA;AALR;AAQM;EACE;IAAM,sBAAA;EALZ;EAMM;IAAK,0BAAA;EAHX;EAIM;IAAI,sBAAA;EADV;AACF;AAGM;EACE,0CAAA;AADR;AAME;EACE,aAAA;EACA,sBAAA;AAJJ;AAMI;EACE,aAAA;EACA,uBAAA;AAJN;AAMM;EACE,aAAA;EACA,uBAAA;EACA,YAAA;EACA,YAAA;EACA,mBAAA;EACA,eAAA;AAJR;AAMQ;EACE,WAAA;EACA,WAAA;EACA,YAAA;EACA,kBAAA;EACA,kBAAA;EACA,iBAAA;EACA,oBAAA;EACA,yBAAA;UAAA,iBAAA;EACA,WAAA;AAJV;AAQU;EACE,yCAAA;EACA,cAAA;AANZ;AAUQ;EACE,oBAAA;EACA,yBAAA;UAAA,iBAAA;AARV;AAWQ;EACE,6BAAA;AATV;AAaM;EACE,eAAA;AAXR;AAcM;EACE,UAAA;AAZR;AAiBE;EACE,oBAAA;AAfJ;;AAmBA;EACE,iBAAA;AAhBF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-content {\n  display: flex;\n  align-items: center;\n}\n\n.fullscreen {\n  height: 100%;\n  display: flex;\n  align-items: center;\n}\n\n.pin-code-page {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  width: 100%;\n  padding-bottom: calc(var(--ion-safe-area-bottom) + 30px);\n  padding-top: var(--ion-safe-area-top);\n\n  .pin-code {\n    flex-grow: 2;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    flex-direction: column;\n\n    .row {\n      display: flex;\n      justify-content: center;\n      align-items: center;\n      text-align: center;\n      //margin: 36px 0;\n      font-size: 16px;\n      line-height: 24px;\n      min-height: 50px;\n      color: var(--font-color-secondary);\n\n      .text {\n        position: absolute;\n        transform: translateX(250px);\n        opacity: 0;\n      }\n\n      .col {\n        width: 14px;\n        height: 14px;\n        margin: 0 12px;\n        background: var(--ion-color-medium);\n        color: var(--ion-color-medium);\n        border-radius: 50%;\n        transition: 0.15s;\n\n        //transform: scale(1.2, 1.2);\n\n        .success {\n          color: inherit;\n          width: 18px;\n          height: 18px;\n          margin: -2px -2px 2px -2px;\n          opacity: 1;\n        }\n      }\n\n      .check {\n        background: var(--ion-color-primary);\n        color: var(--ion-color-primary);\n        animation: scale 0.28s ease normal;\n      }\n\n      @keyframes scale {\n        from {transform: scale(1.0, 1.0)}\n        60% {transform: scale(1.7, 1.7)}\n        to {transform: scale(1.0, 1.0)}\n      }\n\n      .clicked {\n        background-color: var(--ion-color-success);\n      }\n    }\n  }\n\n  .buttons {\n    display: flex;\n    flex-direction: column;\n\n    .row {\n      display: flex;\n      justify-content: center;\n\n      .col {\n        display: flex;\n        justify-content: center;\n        width: 100px;\n        height: 70px;\n        align-items: center;\n        font-size: 32px;\n\n        &:before {\n          content: '';\n          width: 66px;\n          height: 66px;\n          position: absolute;\n          border-radius: 50%;\n          transition: 0.35s;\n          pointer-events: none;\n          user-select: none;\n          z-index: -1;\n        }\n\n        &:active {\n          &:before {\n            background-color: var(--base-color-hover);\n            transition: 0s;\n          }\n        }\n\n        .num {\n          pointer-events: none;\n          user-select: none;\n        }\n\n        ion-icon {\n          color: var(--base-color-icon);\n        }\n      }\n\n      .text {\n        font-size: 14px;\n      }\n\n      .hide {\n        opacity: 0;\n      }\n    }\n  }\n\n  .disabled {\n    pointer-events: none;\n  }\n}\n\n.ipad {\n  max-height: 600px;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 89808:
/*!*****************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/create-modal.page.scss?ngResource ***!
  \*****************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page {
  padding-bottom: calc(var(--ion-safe-area-bottom) + 100px) !important;
}
.content-page ion-item {
  padding-left: 24px;
  padding-right: 24px;
  margin-left: -24px;
  margin-right: -24px;
  box-sizing: content-box;
}
.content-page ion-list {
  display: contents;
}
.content-page .custom-card-content {
  display: flex;
  justify-content: space-between;
  width: 100%;
  flex-direction: column;
  padding: 0 0 6px 0;
}
.content-page .custom-card-content-center {
  text-align: center;
}
.content-page .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 5px 0;
}
.content-page .custom-card-content-item-name {
  font-size: 12px;
  color: var(--font-color-caption);
  padding-bottom: 4px;
  text-transform: uppercase;
  flex-grow: 1;
}
.content-page .custom-card-content-item-title {
  font-size: 12px;
  flex-grow: 1;
  color: var(--font-color-secondary);
}
.content-page .custom-card-content-item-values {
  width: 100%;
}
.content-page .custom-card-content-item-values-title {
  display: flex;
  justify-content: space-between;
}
.content-page .custom-card-content-item-values-title span:last-child {
  color: var(--font-color-caption);
  margin: 0 10px;
}
.content-page .custom-card-content-item-value {
  font-size: 16px;
  color: var(--font-color-primary);
}
.content-page .custom-card-content-item-value-null {
  color: var(--font-color-caption);
}
.content-page .custom-card-content-item ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page .custom-card-content-item ion-checkbox {
  margin: 0;
  width: 24px;
  height: 24px;
  opacity: 1;
}
.content-page .appeal-files {
  display: flex;
  width: 100%;
  flex-direction: column;
}
.content-page .appeal-files-header {
  margin-top: 24px;
  text-align: left;
  font-size: 18px;
  font-weight: 500;
  color: var(--font-color-primary);
}
.content-page .appeal-files-header-counter-files {
  font-size: 14px;
  border-radius: 12px;
  background-color: var(--base-color-dark-background);
  padding: 4px 16px 4px 16px;
  color: var(--font-color-secondary);
  margin-left: 5px;
}
.content-page .appeal-files-cat-name {
  font-size: 16px;
  color: var(--font-color-secondary);
  margin-top: 16px;
}
.content-page .appeal-files-cat-name span {
  color: var(--ion-color-danger);
}
.content-page .appeal-files-cat-block {
  display: flex;
  gap: 24px;
  margin: 8px 0 0 0;
  flex-wrap: wrap;
}
.content-page .appeal-files-cat-block-arr {
  display: flex;
  flex-direction: column;
  width: 64px;
  height: 110px;
  border-radius: 8px;
  overflow: visible;
  align-items: center;
  justify-content: flex-start;
  margin: 0;
  box-shadow: none;
  position: relative;
  contain: initial;
  background: none;
}
.content-page .appeal-files-cat-block-arr-remove {
  position: absolute;
  right: -17px;
  top: -17px;
  width: 34px;
  height: 34px;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 9;
  transition: 0.2s;
}
.content-page .appeal-files-cat-block-arr-remove:active {
  transform: scale(0.9);
}
.content-page .appeal-files-cat-block-arr-remove-icon {
  background: var(--ion-color-danger);
  width: 20px;
  height: 20px;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 10px;
}
.content-page .appeal-files-cat-block-arr-remove-icon ion-icon {
  width: 14px;
  height: 14px;
  color: var(--custom-color-white);
  position: relative;
}
.content-page .appeal-files-cat-block-arr-preview, .content-page .appeal-files-cat-block-arr-preview-bg {
  width: 64px;
  height: 64px;
  display: flex;
  justify-content: center;
  align-items: center;
  border-radius: 8px;
  overflow: hidden;
  position: relative;
}
.content-page .appeal-files-cat-block-arr-preview-bg, .content-page .appeal-files-cat-block-arr-preview-bg-bg {
  background: var(--ion-color-primary-lighten-5);
}
.content-page .appeal-files-cat-block-arr-preview-bg ion-icon, .content-page .appeal-files-cat-block-arr-preview-bg-bg ion-icon {
  width: 32px;
  height: 32px;
  color: var(--ion-color-primary);
}
.content-page .appeal-files-cat-block-arr-preview img, .content-page .appeal-files-cat-block-arr-preview-bg img {
  object-fit: cover;
  width: 100%;
  height: 100%;
}
.content-page .appeal-files-cat-block-arr-name {
  width: 80px;
  overflow: hidden;
  text-align: center;
  position: relative;
  margin: auto 0;
}
.content-page .appeal-files-cat-block-add {
  display: flex;
  width: 64px;
  height: 64px;
  border-radius: 8px;
  background: var(--ion-color-primary-lighten-5);
  overflow: hidden;
  align-items: center;
  justify-content: center;
  margin: 0;
  box-shadow: none;
}
.content-page .appeal-files-cat-block-add ion-icon {
  width: 32px;
  height: 32px;
  color: var(--ion-color-primary);
}
.content-page .template-download {
  min-width: 100%;
}
.content-page .template-download .template-download-btn {
  color: var(--ion-color-primary);
  display: flex;
  font-size: 14px;
  align-items: center;
  margin: 0 0 16px 0;
}
.content-page .template-download .template-download-btn ion-icon {
  width: 20px;
  min-width: 20px;
  height: 20px;
  fill: var(--ion-color-primary);
}
.content-page .template-download .template-download-btn .template-download-btn-text {
  padding: 10px;
}

.newApplicationForm {
  bottom: 0;
  left: 0;
  right: 0;
  backdrop-filter: saturate(210%) blur(20px);
  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);
  padding: 24px 24px calc(24px + var(--ion-safe-area-bottom)) 24px;
  border-radius: 16px 16px 0 0;
  z-index: 1;
}
.newApplicationForm .create {
  margin: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/applications-form/create-modal/create-modal.page.scss"],"names":[],"mappings":"AAAA;EACE,oEAAA;AACF;AACE;EACE,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,uBAAA;AACJ;AAEE;EACE,iBAAA;AAAJ;AAGE;EACE,aAAA;EACA,8BAAA;EACA,WAAA;EACA,sBAAA;EACA,kBAAA;AADJ;AAGI;EACE,kBAAA;AADN;AAII;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AAFN;AAIM;EACE,eAAA;EACA,gCAAA;EACA,mBAAA;EACA,yBAAA;EACA,YAAA;AAFR;AAKM;EACE,eAAA;EACA,YAAA;EACA,kCAAA;AAHR;AAMM;EACE,WAAA;AAJR;AAMQ;EACE,aAAA;EACA,8BAAA;AAJV;AAMU;EACE,gCAAA;EACA,cAAA;AAJZ;AASM;EACE,eAAA;EACA,gCAAA;AAPR;AASQ;EACE,gCAAA;AAPV;AAWM;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AATR;AAYM;EACE,SAAA;EACA,WAAA;EACA,YAAA;EACA,UAAA;AAVR;AAeE;EACE,aAAA;EACA,WAAA;EACA,sBAAA;AAbJ;AAeI;EACE,gBAAA;EACA,gBAAA;EACA,eAAA;EACA,gBAAA;EACA,gCAAA;AAbN;AAeM;EACE,eAAA;EACA,mBAAA;EACA,mDAAA;EACA,0BAAA;EACA,kCAAA;EACA,gBAAA;AAbR;AAiBM;EACE,eAAA;EACA,kCAAA;EACA,gBAAA;AAfR;AAiBQ;EACE,8BAAA;AAfV;AAmBM;EACE,aAAA;EAEA,SAAA;EACA,iBAAA;EACA,eAAA;AAlBR;AAoBQ;EACE,aAAA;EACA,sBAAA;EACA,WAAA;EACA,aAAA;EACA,kBAAA;EACA,iBAAA;EACA,mBAAA;EACA,2BAAA;EACA,SAAA;EACA,gBAAA;EACA,kBAAA;EACA,gBAAA;EACA,gBAAA;AAlBV;AAoBU;EACE,kBAAA;EACA,YAAA;EACA,UAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,UAAA;EACA,gBAAA;AAlBZ;AAoBY;EACE,qBAAA;AAlBd;AAqBY;EACE,mCAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,mBAAA;AAnBd;AAqBc;EACE,WAAA;EACA,YAAA;EACA,gCAAA;EAEA,kBAAA;AApBhB;AAyBU;EACE,WAAA;EACA,YAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EAEA,kBAAA;EACA,gBAAA;EACA,kBAAA;AAxBZ;AA0BY;EACE,8CAAA;AAxBd;AA0Bc;EACE,WAAA;EACA,YAAA;EACA,+BAAA;AAxBhB;AA4BY;EAKE,iBAAA;EACA,WAAA;EACA,YAAA;AA9Bd;AAkCU;EACE,WAAA;EACA,gBAAA;EACA,kBAAA;EACA,kBAAA;EACA,cAAA;AAhCZ;AAsCQ;EACE,aAAA;EACA,WAAA;EACA,YAAA;EACA,kBAAA;EACA,8CAAA;EACA,gBAAA;EACA,mBAAA;EACA,uBAAA;EACA,SAAA;EACA,gBAAA;AApCV;AAsCU;EACE,WAAA;EACA,YAAA;EACA,+BAAA;AApCZ;AA2CE;EACE,eAAA;AAzCJ;AA2CI;EACE,+BAAA;EACA,aAAA;EACA,eAAA;EACA,mBAAA;EACA,kBAAA;AAzCN;AA2CM;EACE,WAAA;EACA,eAAA;EACA,YAAA;EACA,8BAAA;AAzCR;AA4CM;EACE,aAAA;AA1CR;;AAgDA;EACE,SAAA;EACA,OAAA;EACA,QAAA;EAEA,0CAAA;EACA,8CAAA;EACA,gEAAA;EACA,4BAAA;EACA,UAAA;AA9CF;AAiDE;EACE,SAAA;AA/CJ","sourcesContent":[".content-page {\n  padding-bottom: calc(var(--ion-safe-area-bottom) + 100px) !important;\n\n  ion-item {\n    padding-left: 24px;\n    padding-right: 24px;\n    margin-left: -24px;\n    margin-right: -24px;\n    box-sizing: content-box;\n  }\n\n  ion-list {\n    display: contents;\n  }\n\n  .custom-card-content {\n    display: flex;\n    justify-content: space-between;\n    width: 100%;\n    flex-direction: column;\n    padding: 0 0 6px 0;\n\n    &-center {\n      text-align: center;\n    }\n\n    &-item {\n      width: 100%;\n      display: flex;\n      align-items: center;\n      justify-content: space-between;\n      gap: 8px;\n      margin: 5px 0;\n\n      &-name {\n        font-size: 12px;\n        color: var(--font-color-caption);\n        padding-bottom: 4px;\n        text-transform: uppercase;\n        flex-grow: 1;\n      }\n\n      &-title {\n        font-size: 12px;\n        flex-grow: 1;\n        color: var(--font-color-secondary);\n      }\n\n      &-values {\n        width: 100%;\n\n        &-title {\n          display: flex;\n          justify-content: space-between;\n\n          span:last-child {\n            color: var(--font-color-caption);\n            margin: 0 10px;\n          }\n        }\n      }\n\n      &-value {\n        font-size: 16px;\n        color: var(--font-color-primary);\n\n        &-null {\n          color: var(--font-color-caption);\n        }\n      }\n\n      ion-icon {\n        width: 24px;\n        height: 24px;\n        color: var(--base-color-icon);\n      }\n\n      ion-checkbox {\n        margin: 0;\n        width: 24px;\n        height: 24px;\n        opacity: 1;\n      }\n    }\n  }\n\n  .appeal-files {\n    display: flex;\n    width: 100%;\n    flex-direction: column;\n\n    &-header {\n      margin-top: 24px;\n      text-align: left;\n      font-size: 18px;\n      font-weight: 500;\n      color: var(--font-color-primary);\n\n      &-counter-files {\n        font-size: 14px;\n        border-radius: 12px;\n        background-color: var(--base-color-dark-background);\n        padding: 4px 16px 4px 16px;\n        color: var(--font-color-secondary);\n        margin-left: 5px;\n      }\n    }\n    &-cat {\n      &-name {\n        font-size: 16px;\n        color: var(--font-color-secondary);\n        margin-top: 16px;\n\n        span {\n          color: var(--ion-color-danger);\n        }\n      }\n\n      &-block {\n        display: flex;\n        //margin: 0 -24px;\n        gap: 24px;\n        margin: 8px 0 0 0;\n        flex-wrap: wrap;\n\n        &-arr {\n          display: flex;\n          flex-direction: column;\n          width: 64px;\n          height: 110px;\n          border-radius: 8px;\n          overflow: visible;\n          align-items: center;\n          justify-content: flex-start;\n          margin: 0;\n          box-shadow: none;\n          position: relative;\n          contain: initial;\n          background: none;\n\n          &-remove {\n            position: absolute;\n            right: -17px;\n            top: -17px;\n            width: 34px;\n            height: 34px;\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            z-index: 9;\n            transition: 0.2s;\n\n            &:active {\n              transform: scale(0.90);\n            }\n\n            &-icon {\n              background: var(--ion-color-danger);\n              width: 20px;\n              height: 20px;\n              display: flex;\n              justify-content: center;\n              align-items: center;\n              border-radius: 10px;\n\n              ion-icon {\n                width: 14px;\n                height: 14px;\n                color: var(--custom-color-white);\n                //color: var(--ion-color-danger);\n                position: relative;\n              }\n            }\n          }\n\n          &-preview, &-preview-bg {\n            width: 64px;\n            height: 64px;\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            //background: var(--ion-color-primary-lighten-5);\n            border-radius: 8px;\n            overflow: hidden;\n            position: relative;\n\n            &-bg {\n              background: var(--ion-color-primary-lighten-5);\n\n              ion-icon {\n                width: 32px;\n                height: 32px;\n                color: var(--ion-color-primary);\n              }\n            }\n\n            img {\n              //max-width: 64px;\n              //max-height: 64px;\n              //margin: auto;\n              //position: absolute;\n              object-fit: cover;\n              width: 100%;\n              height: 100%;\n            }\n          }\n\n          &-name {\n            width: 80px;\n            overflow: hidden;\n            text-align: center;\n            position: relative;\n            margin: auto 0;\n            //display: -webkit-box;\n            //-webkit-line-clamp: 2;\n            //-webkit-box-orient: horizontal;\n          }\n        }\n        &-add {\n          display: flex;\n          width: 64px;\n          height: 64px;\n          border-radius: 8px;\n          background: var(--ion-color-primary-lighten-5);\n          overflow: hidden;\n          align-items: center;\n          justify-content: center;\n          margin: 0;\n          box-shadow: none;\n\n          ion-icon {\n            width: 32px;\n            height: 32px;\n            color: var(--ion-color-primary);\n          }\n        }\n      }\n    }\n  }\n\n  .template-download {\n    min-width: 100%;\n\n    .template-download-btn {\n      color: var(--ion-color-primary);\n      display: flex;\n      font-size: 14px;\n      align-items: center;\n      margin: 0 0 16px 0;\n\n      ion-icon {\n        width: 20px;\n        min-width: 20px;\n        height: 20px;\n        fill: var(--ion-color-primary);\n      }\n\n      .template-download-btn-text {\n        padding: 10px;\n      }\n    }\n  }\n}\n\n.newApplicationForm {\n  bottom: 0;\n  left: 0;\n  right: 0;\n  //background: rgba(var(--ion-tab-bar-background-color-alternative), .64);\n  backdrop-filter: saturate(210%) blur(20px);\n  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);\n  padding: 24px 24px calc(24px + var(--ion-safe-area-bottom)) 24px;\n  border-radius: 16px 16px 0 0;\n  z-index: 1;\n\n\n  .create {\n    margin: 0;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 23017:
/*!*************************************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/custom-fields/custom-fields.component.scss?ngResource ***!
  \*************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ``, "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 31763:
/*!****************************************************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/applications-form/create-modal/select-modal/select-modal-page.component.scss?ngResource ***!
  \****************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page ion-list {
  display: contents;
}
.content-page ion-list ion-item {
  padding-left: 24px;
  padding-right: 24px;
  margin-left: -24px;
  margin-right: -24px;
  box-sizing: content-box;
  overflow: visible;
}
.content-page ion-list ion-item:not(.lines):last-child {
  --border-color: transparent;
}
.content-page ion-list ion-item .custom-card-content {
  margin: 20px 0;
}
.content-page ion-list ion-item .input-wrapper {
  flex-grow: 1;
}
.content-page ion-list ion-item .checkbox-wrapper {
  line-height: 0;
  margin-left: 12px;
}
.content-page ion-list ion-item .checkbox-wrapper ion-checkbox {
  position: relative;
}
.content-page ion-list ion-item .checkbox-wrapper ion-checkbox::before {
  content: "";
  position: absolute;
  top: -15px;
  bottom: -15px;
  left: -15px;
  right: -15px;
}
.content-page ion-list ion-item ion-input .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 2px 0;
}
.content-page ion-list ion-item ion-input .custom-card-content-item-title {
  font-size: 16px;
  line-height: 1.25rem;
  flex-grow: 1;
  color: var(--font-color-secondary);
}
.content-page ion-list ion-item ion-input .custom-card-content-item-title span {
  line-height: inherit;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/applications-form/create-modal/select-modal/select-modal-page.component.scss"],"names":[],"mappings":"AACI;EACI,iBAAA;AAAR;AAEQ;EACI,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,uBAAA;EACA,iBAAA;AAAZ;AAEY;EACI,2BAAA;AAAhB;AAGY;EACI,cAAA;AADhB;AAIY;EACI,YAAA;AAFhB;AAKY;EACI,cAAA;EACA,iBAAA;AAHhB;AAKgB;EACI,kBAAA;AAHpB;AAKoB;EACI,WAAA;EACA,kBAAA;EACA,UAAA;EACA,aAAA;EACA,WAAA;EACA,YAAA;AAHxB;AASgB;EACI,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AAPpB;AASoB;EACI,eAAA;EACA,oBAAA;EACA,YAAA;EACA,kCAAA;AAPxB;AASwB;EACI,oBAAA;AAP5B","sourcesContent":[".content-page {\n    ion-list {\n        display: contents;\n\n        ion-item {\n            padding-left: 24px;\n            padding-right: 24px;\n            margin-left: -24px;\n            margin-right: -24px;\n            box-sizing: content-box;\n            overflow: visible;\n\n            &:not(.lines):last-child {\n                --border-color: transparent;\n            }\n\n            .custom-card-content {\n                margin: 20px 0;\n            }\n\n            .input-wrapper {\n                flex-grow: 1;\n            }\n\n            .checkbox-wrapper {\n                line-height: 0;\n                margin-left: 12px;\n\n                ion-checkbox {\n                    position: relative;\n\n                    &::before {\n                        content: \"\";\n                        position: absolute;\n                        top: -15px;\n                        bottom: -15px;\n                        left: -15px;\n                        right: -15px;\n                    }\n                }\n            }\n\n            ion-input {\n                .custom-card-content-item {\n                    width: 100%;\n                    display: flex;\n                    align-items: center;\n                    justify-content: space-between;\n                    gap: 8px;\n                    margin: 2px 0;\n\n                    &-title {\n                        font-size: 16px;\n                        line-height: 1.25rem;\n                        flex-grow: 1;\n                        color: var(--font-color-secondary);\n\n                        span {\n                            line-height: inherit;\n                        }\n                    }\n                }\n            }\n        }\n    }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 8857:
/*!*********************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/appointment.page.scss?ngResource ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-appointment ion-header ion-toolbar {
  padding-top: var(--ion-safe-area-top);
  padding-bottom: 0;
}
app-appointment .content-page ion-icon {
  width: 24px;
  height: 24px;
}
app-appointment .content-page .header {
  font-weight: 500;
  font-size: 20px;
  line-height: 23px;
  text-align: left;
  margin-bottom: 24px;
}
app-appointment .content-page .swiper {
  width: 100%;
  height: 100%;
}
app-appointment .content-page .swiper .swiper-pagination {
  position: initial;
  display: flex;
  padding: 0 20px;
}
app-appointment .content-page .swiper .swiper-pagination .swiper-pagination-bullet {
  flex-grow: 1;
  background: var(--ion-color-primary-lighten-3);
}
app-appointment .content-page .swiper .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active {
  background: var(--ion-color-primary);
  width: unset;
}
app-appointment .content-page .swiper .custom-swiper-slide {
  width: 100%;
  padding: 32px 24px calc(137px + var(--ion-safe-area-bottom)) !important;
}
app-appointment .content-page .custom-card-content {
  width: 100%;
  padding: 15px 0;
}
app-appointment .content-page .custom-card-content-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin: 5px 0;
  letter-spacing: 0.02em;
  line-height: 24px;
  color: var(--font-color-caption);
}
app-appointment .content-page .custom-card-content-item-value {
  color: var(--font-color-primary);
}
app-appointment .content-page .custom-card-content-item ion-icon {
  color: var(--base-color-icon);
}
app-appointment .content-page .item-interactive-disabled ion-label {
  opacity: 1 !important;
}
app-appointment .content-page .error-block {
  margin-top: 24px;
  background: var(--ion-color-danger-lighten-4);
  padding: 16px;
  border-radius: 8px;
  color: var(--ion-color-danger-darken-4);
  display: flex;
  line-height: 24px;
  font-size: 16px;
  letter-spacing: 0.02em;
  text-align: start;
}
app-appointment .content-page .error-block ion-icon {
  margin-right: 8px;
  color: var(--ion-color-danger);
}
app-appointment .content-page .description {
  background: var(--ion-color-warning-lighten-4);
  color: var(--ion-color-warning-darken-4);
  font-size: 16px;
  line-height: 24px;
  letter-spacing: 0.02em;
  border-radius: 8px;
  padding: 18px;
  margin-top: 24px;
}
app-appointment .content-page .description ion-icon {
  color: var(--ion-color-warning);
  margin-right: 10px;
}
app-appointment .content-page .description .description-content {
  text-align: left;
  width: 100%;
}
app-appointment .newApplicationForm {
  display: flex;
  bottom: 0;
  left: 0;
  right: 0;
  background: rgba(var(--ion-tab-bar-background-color-alternative), 0.64);
  backdrop-filter: saturate(210%) blur(20px);
  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);
  padding: 24px calc(max((100% - 562px) / 2, 0px) + 24px) calc(44px + var(--ion-safe-area-bottom)) calc(max((100% - 562px) / 2, 0px) + 24px);
  border-radius: 16px 16px 0 0;
}
app-appointment .newApplicationForm .prev {
  width: unset;
  margin-right: 8px;
  --border-width: 2px;
}
app-appointment .newApplicationForm ion-button {
  margin: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/appointment/appointment.page.scss"],"names":[],"mappings":"AAGI;EACE,qCAAA;EACA,iBAAA;AAFN;AAQI;EACE,WAAA;EACA,YAAA;AANN;AASI;EACE,gBAAA;EACA,eAAA;EACA,iBAAA;EACA,gBAAA;EACA,mBAAA;AAPN;AAUI;EACE,WAAA;EACA,YAAA;AARN;AAUM;EACE,iBAAA;EACA,aAAA;EACA,eAAA;AARR;AAUQ;EACE,YAAA;EACA,8CAAA;AARV;AAUU;EACE,oCAAA;EACA,YAAA;AARZ;AAaM;EACE,WAAA;EACA,uEAAA;AAXR;AAeI;EACE,WAAA;EACA,eAAA;AAbN;AAeM;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,aAAA;EACA,sBAAA;EACA,iBAAA;EACA,gCAAA;AAbR;AAeQ;EACE,gCAAA;AAbV;AAgBQ;EACE,6BAAA;AAdV;AAmBI;EACE,qBAAA;AAjBN;AAoBI;EACE,gBAAA;EACA,6CAAA;EACA,aAAA;EACA,kBAAA;EACA,uCAAA;EACA,aAAA;EACA,iBAAA;EACA,eAAA;EACA,sBAAA;EACA,iBAAA;AAlBN;AAoBM;EACE,iBAAA;EACA,8BAAA;AAlBR;AAsBI;EACE,8CAAA;EACA,wCAAA;EACA,eAAA;EACA,iBAAA;EACA,sBAAA;EACA,kBAAA;EACA,aAAA;EACA,gBAAA;AApBN;AAsBM;EACE,+BAAA;EACA,kBAAA;AApBR;AAuBM;EACE,gBAAA;EACA,WAAA;AArBR;AA0BE;EACE,aAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,uEAAA;EACA,0CAAA;EACA,8CAAA;EACA,0IAAA;EACA,4BAAA;AAxBJ;AA0BI;EACE,YAAA;EACA,iBAAA;EACA,mBAAA;AAxBN;AA2BI;EACE,SAAA;AAzBN","sourcesContent":["app-appointment {\n\n  ion-header {\n    ion-toolbar {\n      padding-top: var(--ion-safe-area-top);\n      padding-bottom: 0;\n    }\n  }\n\n  .content-page {\n\n    ion-icon {\n      width: 24px;\n      height: 24px;\n    }\n\n    .header {\n      font-weight: 500;\n      font-size: 20px;\n      line-height: 23px;\n      text-align: left;\n      margin-bottom: 24px;\n    }\n\n    .swiper {\n      width: 100%;\n      height: 100%;\n\n      .swiper-pagination {\n        position: initial;\n        display: flex;\n        padding: 0 20px;\n\n        .swiper-pagination-bullet {\n          flex-grow: 1;\n          background: var(--ion-color-primary-lighten-3);\n\n          &.swiper-pagination-bullet-active {\n            background: var(--ion-color-primary);\n            width: unset;\n          }\n        }\n      }\n\n      .custom-swiper-slide {\n        width: 100%;\n        padding: 32px 24px calc(24px * 3 + 20px + 45px + var(--ion-safe-area-bottom)) !important;\n      }\n    }\n\n    .custom-card-content {\n      width: 100%;\n      padding: 15px 0;\n\n      &-item {\n        display: flex;\n        align-items: center;\n        justify-content: space-between;\n        margin: 5px 0;\n        letter-spacing: 0.02em;\n        line-height: 24px;\n        color: var(--font-color-caption);\n\n        &-value {\n          color: var(--font-color-primary);\n        }\n\n        ion-icon {\n          color: var(--base-color-icon);\n        }\n      }\n    }\n\n    .item-interactive-disabled ion-label {\n      opacity: 1 !important;\n    }\n\n    .error-block {\n      margin-top: 24px;\n      background: var(--ion-color-danger-lighten-4);\n      padding: 16px;\n      border-radius: 8px;\n      color: var(--ion-color-danger-darken-4);\n      display: flex;\n      line-height: 24px;\n      font-size: 16px;\n      letter-spacing: 0.02em;\n      text-align: start;\n\n      ion-icon {\n        margin-right: 8px;\n        color: var(--ion-color-danger);\n      }\n    }\n\n    .description {\n      background: var(--ion-color-warning-lighten-4);\n      color: var(--ion-color-warning-darken-4);\n      font-size: 16px;\n      line-height: 24px;\n      letter-spacing: 0.02em;\n      border-radius: 8px;\n      padding: 18px;\n      margin-top: 24px;\n\n      ion-icon {\n        color: var(--ion-color-warning);\n        margin-right: 10px;\n      }\n\n      .description-content {\n        text-align: left;\n        width: 100%;\n      }\n    }\n  }\n\n  .newApplicationForm {\n    display: flex;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    background: rgba(var(--ion-tab-bar-background-color-alternative), .64);\n    backdrop-filter: saturate(210%) blur(20px);\n    box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);\n    padding: 24px calc(max(((100% - 562px)/2), 0px) + 24px) calc(24px + 20px + var(--ion-safe-area-bottom)) calc(max(((100% - 562px)/2), 0px) + 24px);\n    border-radius: 16px 16px 0 0;\n\n    .prev {\n      width: unset;\n      margin-right: 8px;\n      --border-width: 2px;\n    }\n\n    ion-button {\n      margin: 0;\n    }\n  }\n}\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 80519:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/choose-date/choose-date.page.scss?ngResource ***!
  \*********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page {
  padding: 0 24px;
  opacity: 0;
}
.content-page.show {
  opacity: 1;
}
.content-page ion-datetime {
  background: none;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/appointment/choose-date/choose-date.page.scss"],"names":[],"mappings":"AAAA;EACE,eAAA;EACA,UAAA;AACF;AACE;EACE,UAAA;AACJ;AAEE;EACE,gBAAA;AAAJ","sourcesContent":[".content-page {\n  padding: 0 24px;\n  opacity: 0;\n\n  &.show {\n    opacity: 1;\n  }\n\n  ion-datetime {\n    background: none;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 18403:
/*!*********************************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/appointment/choose-time/choose-time.page.scss?ngResource ***!
  \*********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-choose-time .content-page {
  padding: 0 24px;
  height: 100%;
}
app-choose-time .content-page .swiper {
  width: 100%;
  height: 50%;
}
app-choose-time .content-page .swiper .swiper-slide-active {
  font-weight: 500;
  color: var(--ion-color-primary) !important;
  background: var(--ion-color-primary-lighten-5);
  height: 40px !important;
  padding: 4px;
}
app-choose-time .content-page .swiper .swiper-slide {
  font-size: 24px;
  border-radius: 8px;
  color: var(--font-color-caption);
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/appointment/choose-time/choose-time.page.scss"],"names":[],"mappings":"AACE;EACE,eAAA;EACA,YAAA;AAAJ;AAEI;EACE,WAAA;EACA,WAAA;AAAN;AAEM;EACE,gBAAA;EACA,0CAAA;EACA,8CAAA;EACA,uBAAA;EACA,YAAA;AAAR;AAGM;EACE,eAAA;EACA,kBAAA;EACA,gCAAA;AADR","sourcesContent":["app-choose-time {\n  .content-page {\n    padding: 0 24px;\n    height: 100%;\n\n    .swiper {\n      width: 100%;\n      height: 50%;\n\n      .swiper-slide-active {\n        font-weight: 500;\n        color: var(--ion-color-primary) !important;\n        background: var(--ion-color-primary-lighten-5);\n        height: 40px !important;\n        padding: 4px;\n      }\n\n      .swiper-slide {\n        font-size: 24px;\n        border-radius: 8px;\n        color: var(--font-color-caption);\n      }\n    }\n  }\n}\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 82655:
/*!*******************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/survey/survey.page.scss?ngResource ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `app-survey ion-header ion-toolbar {
  padding-top: var(--ion-safe-area-top);
  padding-bottom: 0;
}
app-survey .content-page ion-icon {
  width: 24px;
  height: 24px;
}
app-survey .content-page .header {
  font-weight: 500;
  font-size: 20px;
  line-height: 23px;
  text-align: left;
  margin-bottom: 24px;
}
app-survey .content-page .header p {
  font-weight: 400;
  font-size: 16px;
  letter-spacing: 0.02em;
  line-height: 24px;
  color: var(--font-color-secondary);
  margin: 16px 0 0;
}
app-survey .content-page .swiper {
  width: 100%;
  height: 100%;
}
app-survey .content-page .swiper .swiper-pagination {
  position: initial;
  display: flex;
  padding: 0 20px;
}
app-survey .content-page .swiper .swiper-pagination .swiper-pagination-bullet {
  flex-grow: 1;
  background: var(--ion-color-primary-lighten-3);
}
app-survey .content-page .swiper .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active {
  background: var(--ion-color-primary);
  width: unset;
}
app-survey .content-page .swiper .custom-swiper-slide {
  width: 100%;
  padding: 32px 24px calc(137px + var(--ion-safe-area-bottom)) !important;
}
app-survey .content-page ion-label {
  font-size: 14px !important;
  letter-spacing: 0.02em;
  line-height: 16px;
  --font-color-secondary: var(--font-color-primary);
}
app-survey .content-page ion-label::first-letter {
  text-transform: uppercase;
}
app-survey .content-page .range {
  display: flex;
  justify-content: space-between;
  background: var(--ion-color-warning-lighten-3);
  padding: 8px;
  border-radius: 8px;
  font-size: 14px;
}
app-survey .content-page .range.disabled {
  opacity: 0.6;
}
app-survey .content-page .range .value {
  width: 40px;
  height: 40px;
  border-radius: 8px;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--custom-font-color-black);
}
app-survey .content-page .range .value.active {
  color: var(--ion-color-warning);
  background: var(--ion-color-warning-contrast);
}
app-survey .content-page ion-radio-group ion-radio {
  width: 18px;
  height: 18px;
  margin-right: 10px;
}
app-survey .content-page ion-radio-group ion-radio::part(container) {
  border-radius: 50%;
  border: 2px solid var(--base-color-icon);
  width: 1.5rem;
  height: 1.5rem;
}
app-survey .content-page ion-radio-group ion-radio.radio-checked::part(container) {
  background: var(--ion-color-primary);
  border-color: transparent;
}
app-survey .content-page ion-radio-group ion-radio.radio-checked::part(mark) {
  border-radius: 50%;
  width: 100%;
  height: 100%;
  border: 3px solid white;
}
app-survey .content-page ion-checkbox {
  --size: 18px;
  --background-checked: var(--ion-color-primary);
  --checkmark-width: 2px;
}
app-survey .content-page ion-checkbox::part(container) {
  border-radius: 2px;
  border: 2px solid var(--base-color-icon);
}
app-survey .content-page .checkbox-checked::part(container) {
  border: none;
}
app-survey .content-page .comment {
  margin-top: 24px;
}
app-survey .content-page .error-block {
  margin-top: 24px;
  background: var(--ion-color-danger-lighten-4);
  padding: 16px;
  border-radius: 8px;
  color: var(--ion-color-danger-darken-4);
  display: flex;
  line-height: 24px;
  font-size: 16px;
  letter-spacing: 0.02em;
  text-align: start;
}
app-survey .content-page .error-block ion-icon {
  margin-right: 8px;
  color: var(--ion-color-danger);
}
app-survey .content-page .description {
  background: var(--ion-color-warning-lighten-4);
  color: var(--ion-color-warning-darken-4);
  font-size: 16px;
  line-height: 24px;
  letter-spacing: 0.02em;
  border-radius: 8px;
  padding: 18px;
  margin-top: 24px;
}
app-survey .content-page .description ion-icon {
  color: var(--ion-color-warning);
  margin-right: 10px;
}
app-survey .content-page .description .description-content {
  text-align: left;
  width: 100%;
}
app-survey .newApplicationForm {
  display: flex;
  bottom: 0;
  left: 0;
  right: 0;
  background: rgba(var(--ion-tab-bar-background-color-alternative), 0.64);
  backdrop-filter: saturate(210%) blur(20px);
  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);
  padding: 24px calc(max((100% - 562px) / 2, 0px) + 24px) calc(44px + var(--ion-safe-area-bottom)) calc(max((100% - 562px) / 2, 0px) + 24px);
  border-radius: 16px 16px 0 0;
}
app-survey .newApplicationForm .prev {
  width: unset;
  margin-right: 8px;
  --border-width: 2px;
}
app-survey .newApplicationForm ion-button {
  margin: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/surveys/survey/survey.page.scss"],"names":[],"mappings":"AAGI;EACE,qCAAA;EACA,iBAAA;AAFN;AAQI;EACE,WAAA;EACA,YAAA;AANN;AASI;EACE,gBAAA;EACA,eAAA;EACA,iBAAA;EACA,gBAAA;EACA,mBAAA;AAPN;AASM;EACE,gBAAA;EACA,eAAA;EACA,sBAAA;EACA,iBAAA;EACA,kCAAA;EACA,gBAAA;AAPR;AAWI;EACE,WAAA;EACA,YAAA;AATN;AAWM;EACE,iBAAA;EACA,aAAA;EACA,eAAA;AATR;AAWQ;EACE,YAAA;EACA,8CAAA;AATV;AAWU;EACE,oCAAA;EACA,YAAA;AATZ;AAcM;EACE,WAAA;EACA,uEAAA;AAZR;AAgBI;EACE,0BAAA;EACA,sBAAA;EACA,iBAAA;EACA,iDAAA;AAdN;AAgBM;EACE,yBAAA;AAdR;AAkBI;EACE,aAAA;EACA,8BAAA;EACA,8CAAA;EACA,YAAA;EACA,kBAAA;EACA,eAAA;AAhBN;AAkBM;EACE,YAAA;AAhBR;AAmBM;EACE,WAAA;EACA,YAAA;EACA,kBAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,qCAAA;AAjBR;AAmBQ;EACE,+BAAA;EACA,6CAAA;AAjBV;AAwBM;EACE,WAAA;EACA,YAAA;EACA,kBAAA;AAtBR;AAyBM;EACE,kBAAA;EACA,wCAAA;EACA,aAAA;EACA,cAAA;AAvBR;AA0BM;EACE,oCAAA;EACA,yBAAA;AAxBR;AA2BM;EACE,kBAAA;EACA,WAAA;EACA,YAAA;EACA,uBAAA;AAzBR;AA6BI;EACE,YAAA;EACA,8CAAA;EACA,sBAAA;AA3BN;AA8BI;EACE,kBAAA;EACA,wCAAA;AA5BN;AA+BI;EACE,YAAA;AA7BN;AAgCI;EACE,gBAAA;AA9BN;AAiCI;EACE,gBAAA;EACA,6CAAA;EACA,aAAA;EACA,kBAAA;EACA,uCAAA;EACA,aAAA;EACA,iBAAA;EACA,eAAA;EACA,sBAAA;EACA,iBAAA;AA/BN;AAiCM;EACE,iBAAA;EACA,8BAAA;AA/BR;AAmCI;EACE,8CAAA;EACA,wCAAA;EACA,eAAA;EACA,iBAAA;EACA,sBAAA;EACA,kBAAA;EACA,aAAA;EACA,gBAAA;AAjCN;AAmCM;EACE,+BAAA;EACA,kBAAA;AAjCR;AAoCM;EACE,gBAAA;EACA,WAAA;AAlCR;AAuCE;EACE,aAAA;EACA,SAAA;EACA,OAAA;EACA,QAAA;EACA,uEAAA;EACA,0CAAA;EACA,8CAAA;EACA,0IAAA;EACA,4BAAA;AArCJ;AAuCI;EACE,YAAA;EACA,iBAAA;EACA,mBAAA;AArCN;AAwCI;EACE,SAAA;AAtCN","sourcesContent":["app-survey {\n\n  ion-header {\n    ion-toolbar {\n      padding-top: var(--ion-safe-area-top);\n      padding-bottom: 0;\n    }\n  }\n\n  .content-page {\n\n    ion-icon {\n      width: 24px;\n      height: 24px;\n    }\n\n    .header {\n      font-weight: 500;\n      font-size: 20px;\n      line-height: 23px;\n      text-align: left;\n      margin-bottom: 24px;\n\n      p {\n        font-weight: 400;\n        font-size: 16px;\n        letter-spacing: 0.02em;\n        line-height: 24px;\n        color: var(--font-color-secondary);\n        margin: 16px 0 0;\n      }\n    }\n\n    .swiper {\n      width: 100%;\n      height: 100%;\n\n      .swiper-pagination {\n        position: initial;\n        display: flex;\n        padding: 0 20px;\n\n        .swiper-pagination-bullet {\n          flex-grow: 1;\n          background: var(--ion-color-primary-lighten-3);\n\n          &.swiper-pagination-bullet-active {\n            background: var(--ion-color-primary);\n            width: unset;\n          }\n        }\n      }\n\n      .custom-swiper-slide {\n        width: 100%;\n        padding: 32px 24px calc(24px * 3 + 20px + 45px + var(--ion-safe-area-bottom)) !important;\n      }\n    }\n\n    ion-label {\n      font-size: 14px !important;\n      letter-spacing: 0.02em;\n      line-height: 16px;\n      --font-color-secondary: var(--font-color-primary);\n\n      &::first-letter {\n        text-transform: uppercase;\n      }\n    }\n\n    .range {\n      display: flex;\n      justify-content: space-between;\n      background: var(--ion-color-warning-lighten-3);\n      padding: 8px;\n      border-radius: 8px;\n      font-size: 14px;\n\n      &.disabled {\n        opacity: 0.6;\n      }\n\n      .value {\n        width: 40px;\n        height: 40px;\n        border-radius: 8px;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        color: var(--custom-font-color-black);\n\n        &.active {\n          color: var(--ion-color-warning);\n          background: var(--ion-color-warning-contrast);\n        }\n      }\n    }\n\n    ion-radio-group {\n\n      ion-radio {\n        width: 18px;\n        height: 18px;\n        margin-right: 10px;\n      }\n\n      ion-radio::part(container) {\n        border-radius: 50%;\n        border: 2px solid var(--base-color-icon);\n        width: 1.5rem;\n        height: 1.5rem;\n      }\n\n      ion-radio.radio-checked::part(container) {\n        background: var(--ion-color-primary);\n        border-color: transparent;\n      }\n\n      ion-radio.radio-checked::part(mark) {\n        border-radius: 50%;\n        width: 100%;\n        height: 100%;\n        border: 3px solid white;\n      }\n    }\n\n    ion-checkbox {\n      --size: 18px;\n      --background-checked: var(--ion-color-primary);\n      --checkmark-width: 2px;\n    }\n\n    ion-checkbox::part(container) {\n      border-radius: 2px;\n      border: 2px solid var(--base-color-icon);\n    }\n\n    .checkbox-checked::part(container) {\n      border: none;\n    }\n\n    .comment{\n      margin-top: 24px;\n    }\n\n    .error-block {\n      margin-top: 24px;\n      background: var(--ion-color-danger-lighten-4);\n      padding: 16px;\n      border-radius: 8px;\n      color: var(--ion-color-danger-darken-4);\n      display: flex;\n      line-height: 24px;\n      font-size: 16px;\n      letter-spacing: 0.02em;\n      text-align: start;\n\n      ion-icon {\n        margin-right: 8px;\n        color: var(--ion-color-danger);\n      }\n    }\n\n    .description {\n      background: var(--ion-color-warning-lighten-4);\n      color: var(--ion-color-warning-darken-4);\n      font-size: 16px;\n      line-height: 24px;\n      letter-spacing: 0.02em;\n      border-radius: 8px;\n      padding: 18px;\n      margin-top: 24px;\n\n      ion-icon {\n        color: var(--ion-color-warning);\n        margin-right: 10px;\n      }\n\n      .description-content {\n        text-align: left;\n        width: 100%;\n      }\n    }\n  }\n\n  .newApplicationForm {\n    display: flex;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    background: rgba(var(--ion-tab-bar-background-color-alternative), .64);\n    backdrop-filter: saturate(210%) blur(20px);\n    box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);\n    padding: 24px calc(max(((100% - 562px)/2), 0px) + 24px) calc(24px + 20px + var(--ion-safe-area-bottom)) calc(max(((100% - 562px)/2), 0px) + 24px);\n    border-radius: 16px 16px 0 0;\n\n    .prev {\n      width: unset;\n      margin-right: 8px;\n      --border-width: 2px;\n    }\n\n    ion-button {\n      margin: 0;\n    }\n  }\n}\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 92309:
/*!*************************************************************************!*\
  !*** ./src/app/pages/tabs/appeals/surveys/surveys.page.scss?ngResource ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `:host {
  --ion-background-color: var(--alternative-color-page);
}

.content-page .list {
  margin-top: 0;
}
.content-page .list .list-header {
  position: relative;
}
.content-page .list ion-card {
  box-shadow: none;
  margin: 0;
  border-radius: 0;
}
.content-page .list ion-card.group {
  border-top: 1px solid var(--color-separate) !important;
}
.content-page .list ion-card .applications-form-card-icon {
  border-radius: 8px;
  background: var(--ion-color-primary-lighten-4);
}
.content-page .list ion-card .applications-form-card-icon ion-icon {
  color: var(--ion-color-primary);
}
.content-page .list ion-card ion-item ion-card-title {
  padding: 0 16px;
  font-weight: normal;
  font-size: 16px;
}
.content-page .list ion-card ion-item ion-card-title.ion-card-title-bold {
  font-weight: 700;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/appeals/surveys/surveys.page.scss"],"names":[],"mappings":"AAAA;EACE,qDAAA;AACF;;AAGE;EACE,aAAA;AAAJ;AAEI;EACE,kBAAA;AAAN;AAGI;EACE,gBAAA;EACA,SAAA;EACA,gBAAA;AADN;AAGM;EACE,sDAAA;AADR;AAIM;EACE,kBAAA;EACA,8CAAA;AAFR;AAIQ;EACE,+BAAA;AAFV;AAOQ;EACE,eAAA;EACA,mBAAA;EACA,eAAA;AALV;AAOU;EACE,gBAAA;AALZ","sourcesContent":[":host {\n  --ion-background-color: var(--alternative-color-page);\n}\n\n.content-page {\n  .list {\n    margin-top: 0;\n\n    .list-header {\n      position: relative;\n    }\n\n    ion-card {\n      box-shadow: none;\n      margin: 0;\n      border-radius: 0;\n\n      &.group {\n        border-top: 1px solid var(--color-separate) !important;\n      }\n\n      .applications-form-card-icon {\n        border-radius: 8px;\n        background: var(--ion-color-primary-lighten-4);\n\n        ion-icon {\n          color: var(--ion-color-primary);\n        }\n      }\n\n      ion-item {\n        ion-card-title {\n          padding: 0 16px;\n          font-weight: normal;\n          font-size: 16px;\n\n          &.ion-card-title-bold {\n            font-weight: 700;\n          }\n        }\n      }\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 87352:
/*!**********************************************************************!*\
  !*** ./src/app/pages/tabs/main/bind-ls/bind-ls.page.scss?ngResource ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-header ion-toolbar {
  padding-top: var(--ion-safe-area-top);
}

.content-page .text {
  padding: 40px 24px;
  margin: 0;
  text-align: left;
}
.content-page ion-item {
  padding-left: 24px;
  padding-right: 24px;
  margin-left: -24px;
  margin-right: -24px;
  box-sizing: content-box;
}
.content-page ion-item ion-input div {
  position: absolute;
  color: transparent;
  pointer-events: none;
}
.content-page ion-item ion-input div span {
  color: var(--font-color-primary);
}
.content-page ion-item .zeroValue {
  color: var(--font-color-caption);
}
.content-page ion-item .zeroValue div span {
  color: var(--font-color-caption);
}
.content-page .custom-card-content {
  display: flex;
  justify-content: space-between;
  width: 100%;
  flex-direction: column;
  padding: 0 0 6px 0;
}
.content-page .custom-card-content-center {
  text-align: center;
}
.content-page .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 5px 0;
}
.content-page .custom-card-content-item-name {
  font-size: 12px;
  color: var(--font-color-caption);
  padding-bottom: 4px;
  text-transform: uppercase;
  flex-grow: 1;
}
.content-page .custom-card-content-item-title {
  font-size: 12px;
  flex-grow: 1;
}
.content-page .custom-card-content-item-values {
  width: 100%;
}
.content-page .custom-card-content-item-values-title {
  display: flex;
  justify-content: space-between;
}
.content-page .custom-card-content-item-values-title span:last-child {
  color: var(--font-color-caption);
  margin: 0 10px;
}
.content-page .custom-card-content-item-value {
  font-size: 16px;
  color: var(--font-color-primary);
  text-align: end;
}
.content-page .custom-card-content-item ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page .custom-card-content-item ion-checkbox {
  margin: 0;
  width: 24px;
  height: 24px;
  opacity: 1;
}
.content-page .disabled {
  pointer-events: none;
  opacity: 0.3;
}
.content-page .error-block {
  margin-top: 16px;
  background: var(--ion-color-danger-lighten-4);
  padding: 16px;
  border-radius: 8px;
  color: var(--ion-color-danger);
  display: flex;
  line-height: 24px;
  font-size: 16px;
}
.content-page .error-block ion-icon {
  width: 24px;
  height: 24px;
  margin-right: 8px;
}
.content-page .description {
  margin-bottom: 8px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/main/bind-ls/bind-ls.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,qCAAA;AAAJ;;AAKE;EACE,kBAAA;EACA,SAAA;EACA,gBAAA;AAFJ;AA4BE;EACE,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,uBAAA;AA1BJ;AA6BM;EACE,kBAAA;EACA,kBAAA;EACA,oBAAA;AA3BR;AA6BQ;EACE,gCAAA;AA3BV;AAiCI;EACE,gCAAA;AA/BN;AAkCQ;EACE,gCAAA;AAhCV;AAsCE;EACE,aAAA;EACA,8BAAA;EACA,WAAA;EACA,sBAAA;EACA,kBAAA;AApCJ;AAsCI;EACE,kBAAA;AApCN;AAuCI;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AArCN;AAuCM;EACE,eAAA;EACA,gCAAA;EACA,mBAAA;EACA,yBAAA;EACA,YAAA;AArCR;AAwCM;EACE,eAAA;EACA,YAAA;AAtCR;AAyCM;EACE,WAAA;AAvCR;AAyCQ;EACE,aAAA;EACA,8BAAA;AAvCV;AAyCU;EACE,gCAAA;EACA,cAAA;AAvCZ;AA4CM;EACE,eAAA;EACA,gCAAA;EACA,eAAA;AA1CR;AA6CM;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AA3CR;AA8CM;EACE,SAAA;EACA,WAAA;EACA,YAAA;EACA,UAAA;AA5CR;AAiDE;EACE,oBAAA;EACA,YAAA;AA/CJ;AAkDE;EACE,gBAAA;EACA,6CAAA;EACA,aAAA;EACA,kBAAA;EACA,8BAAA;EACA,aAAA;EACA,iBAAA;EACA,eAAA;AAhDJ;AAkDI;EACE,WAAA;EACA,YAAA;EACA,iBAAA;AAhDN;AAoDE;EACE,kBAAA;AAlDJ","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-header {\n  ion-toolbar {\n    padding-top: var(--ion-safe-area-top);\n  };\n}\n\n.content-page {\n  .text {\n    padding: 40px 24px;\n    margin: 0;\n    text-align: left;\n  }\n\n  //ion-card {\n  //  //padding: 16px;\n  //  margin-top: 8px;\n  //  margin-bottom: 0;\n  //\n  //  ion-item {\n  //    --min-height: 0;\n  //  }\n  //\n  //  ion-toggle {\n  //    pointer-events: none;\n  //  }\n  //\n  //  .disabled {\n  //    opacity: 0.3;\n  //  }\n  //\n  //  .loading {\n  //    pointer-events: none;\n  //    opacity: 0.3;\n  //  }\n  //}\n\n  ion-item {\n    padding-left: 24px;\n    padding-right: 24px;\n    margin-left: -24px;\n    margin-right: -24px;\n    box-sizing: content-box;\n\n    ion-input {\n      div {\n        position: absolute;\n        color: transparent;\n        pointer-events: none;\n\n        span {\n          color: var(--font-color-primary);\n          //color: var(--font-color-caption);\n        }\n      }\n    }\n\n    .zeroValue {\n      color: var(--font-color-caption);\n\n      div {\n        span {\n          color: var(--font-color-caption);\n        }\n      }\n    }\n  }\n\n  .custom-card-content {\n    display: flex;\n    justify-content: space-between;\n    width: 100%;\n    flex-direction: column;\n    padding: 0 0 6px 0;\n\n    &-center {\n      text-align: center;\n    }\n\n    &-item {\n      width: 100%;\n      display: flex;\n      align-items: center;\n      justify-content: space-between;\n      gap: 8px;\n      margin: 5px 0;\n\n      &-name {\n        font-size: 12px;\n        color: var(--font-color-caption);\n        padding-bottom: 4px;\n        text-transform: uppercase;\n        flex-grow: 1;\n      }\n\n      &-title {\n        font-size: 12px;\n        flex-grow: 1;\n      }\n\n      &-values {\n        width: 100%;\n\n        &-title {\n          display: flex;\n          justify-content: space-between;\n\n          span:last-child {\n            color: var(--font-color-caption);\n            margin: 0 10px;\n          }\n        }\n      }\n\n      &-value {\n        font-size: 16px;\n        color: var(--font-color-primary);\n        text-align: end;\n      }\n\n      ion-icon {\n        width: 24px;\n        height: 24px;\n        color: var(--base-color-icon);\n      }\n\n      ion-checkbox {\n        margin: 0;\n        width: 24px;\n        height: 24px;\n        opacity: 1;\n      }\n    }\n  }\n\n  .disabled {\n    pointer-events: none;\n    opacity: 0.3;\n  }\n\n  .error-block {\n    margin-top: 16px;\n    background: var(--ion-color-danger-lighten-4);\n    padding: 16px;\n    border-radius: 8px;\n    color: var(--ion-color-danger);\n    display: flex;\n    line-height: 24px;\n    font-size: 16px;\n\n    ion-icon {\n      width: 24px;\n      height: 24px;\n      margin-right: 8px;\n    }\n  }\n\n  .description {\n    margin-bottom: 8px;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 64367:
/*!**************************************************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/description/description.page.scss?ngResource ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/main/ls-info/description/description.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 5200:
/*!**********************************************************************!*\
  !*** ./src/app/pages/tabs/main/ls-info/ls-info.page.scss?ngResource ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page {
  justify-content: space-between;
}
.content-page ion-card {
  padding: 16px;
}
.content-page ion-card .ls-card-header {
  display: flex;
  align-items: flex-start;
  padding-bottom: 8px;
  --inner-border-width: 0 0 0.55px 0;
}
.content-page ion-card .ls-card-header .ls-card-icon {
  width: 48px;
  height: 48px;
  border-radius: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  background: var(--ion-color-primary-lighten-4);
  margin-bottom: 8px;
}
.content-page ion-card .ls-card-header .ls-card-icon ion-icon {
  color: var(--ion-color-primary);
  width: 24px;
  height: 24px;
}
.content-page ion-card .ls-card-header ion-card-header {
  padding: 0 0 8px 16px;
}
.content-page ion-card .ls-card-header ion-card-header ion-card-title {
  font-weight: normal;
}
.content-page ion-card .ls-card-header ion-card-header ion-card-subtitle {
  font-size: 12px;
}
.content-page ion-card ion-card-content {
  padding: 0 !important;
}
.content-page ion-card ion-card-content .ls-card-content {
  display: flex;
  justify-content: space-between;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-center {
  text-align: center;
  display: flex;
  justify-content: center;
  align-items: center;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-name {
  text-transform: uppercase;
  font-size: 10px;
  color: var(--font-color-caption);
  padding-bottom: 4px;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-value {
  font-size: 14px;
  color: var(--font-color-primary);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-value sup {
  font-size: 8px;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description, .content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add {
  font-size: 16px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  width: 100%;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description ion-icon, .content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add {
  color: var(--ion-color-primary);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon {
  color: var(--ion-color-primary);
}

.width-100 {
  width: 100%;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/main/ls-info/ls-info.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,8BAAA;AACF;AAAE;EACE,aAAA;AAEJ;AADI;EACE,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,kCAAA;AAGN;AAFM;EACE,WAAA;EACA,YAAA;EACA,kBAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,8CAAA;EACA,kBAAA;AAIR;AAHQ;EACE,+BAAA;EACA,WAAA;EACA,YAAA;AAKV;AAFM;EACE,qBAAA;AAIR;AAHQ;EACE,mBAAA;AAKV;AAHQ;EACE,eAAA;AAKV;AAAI;EACE,qBAAA;AAEN;AADM;EACE,aAAA;EACA,8BAAA;AAGR;AAFQ;EACE,kBAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;AAIV;AADU;EACE,yBAAA;EACA,eAAA;EACA,gCAAA;EACA,mBAAA;AAGZ;AADU;EACE,eAAA;EACA,gCAAA;AAGZ;AAFY;EACE,cAAA;AAId;AADU;EACE,eAAA;EACA,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,WAAA;AAGZ;AAFY;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AAId;AADU;EACE,+BAAA;AAGZ;AAFY;EACE,+BAAA;AAId;;AAKA;EACE,WAAA;AAFF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  justify-content: space-between;\n  ion-card {\n    padding: 16px;\n    .ls-card-header {\n      display: flex;\n      align-items: flex-start;\n      padding-bottom: 8px;\n      --inner-border-width: 0 0 0.55px 0;\n      .ls-card-icon {\n        width: 48px;\n        height: 48px;\n        border-radius: 8px;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        background: var(--ion-color-primary-lighten-4);\n        margin-bottom: 8px;\n        ion-icon {\n          color: var(--ion-color-primary);\n          width: 24px;\n          height: 24px;\n        }\n      }\n      ion-card-header {\n        padding: 0 0 8px 16px;\n        ion-card-title {\n          font-weight: normal;\n        }\n        ion-card-subtitle {\n          font-size: 12px;\n        }\n      }\n    }\n\n    ion-card-content {\n      padding: 0 !important;\n      .ls-card-content {\n        display: flex;\n        justify-content: space-between;\n        .ls-card-content-center {\n          text-align: center;\n          display: flex;\n          justify-content: center;\n          align-items: center;\n        }\n        .ls-card-content-item {\n          .ls-card-content-item-name {\n            text-transform: uppercase;\n            font-size: 10px;\n            color: var(--font-color-caption);\n            padding-bottom: 4px;\n          }\n          .ls-card-content-item-value {\n            font-size: 14px;\n            color: var(--font-color-primary);\n            sup {\n              font-size: 8px;\n            }\n          }\n          .ls-card-content-item-description, .ls-card-content-item-description-add {\n            font-size: 16px;\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            width: 100%;\n            ion-icon {\n              width: 24px;\n              height: 24px;\n              color: var(--base-color-icon);\n            }\n          }\n          .ls-card-content-item-description-add {\n            color: var(--ion-color-primary);\n            ion-icon {\n              color: var(--ion-color-primary);\n            }\n          }\n        }\n      }\n    }\n  }\n}\n\n.width-100 {\n  width: 100%;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 7320:
/*!********************************************************************************!*\
  !*** ./src/app/pages/tabs/more/ls-all-modal/ls-all-modal.page.scss?ngResource ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page ion-card {
  padding: 16px 16px 0 16px;
}
.content-page ion-card .ls-card-header {
  display: flex;
  align-items: flex-start;
  --inner-border-width: 0 0 0.55px 0;
}
.content-page ion-card .ls-card-header .ls-card-icon {
  width: 48px;
  height: 48px;
  border-radius: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  background: var(--ion-color-primary-lighten-4);
  margin-bottom: 8px;
}
.content-page ion-card .ls-card-header .ls-card-icon ion-icon {
  color: var(--ion-color-primary);
  width: 24px;
  height: 24px;
}
.content-page ion-card .ls-card-header ion-card-header {
  padding: 0 0 8px 16px;
  width: 100%;
}
.content-page ion-card .ls-card-header ion-card-header ion-card-title {
  font-weight: normal;
  display: flex;
  justify-content: space-between;
  align-items: center;
  width: 100%;
}
.content-page ion-card .ls-card-header ion-card-header ion-card-title ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page ion-card .ls-card-header ion-card-header ion-card-subtitle {
  font-size: 12px;
}
.content-page ion-card .ls-card-header ion-card-header ion-card-subtitle .ls-name {
  margin-top: 8px;
  color: var(--font-color-caption);
}
.content-page ion-card ion-card-content {
  padding: 0 !important;
}
.content-page ion-card ion-card-content .ls-card-content {
  display: flex;
  justify-content: space-between;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-center {
  text-align: center;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-name {
  text-transform: uppercase;
  font-size: 10px;
  color: var(--font-color-caption);
  padding-bottom: 4px;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-value {
  font-size: 14px;
  color: var(--font-color-primary);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-value sup {
  font-size: 8px;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description, .content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add {
  font-size: 16px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  width: 100%;
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description ion-icon, .content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add {
  color: var(--ion-color-primary);
}
.content-page ion-card ion-card-content .ls-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon {
  color: var(--ion-color-primary);
}
.content-page ion-card ion-card-content ion-button {
  margin-top: 0 !important;
}
.content-page .add {
  padding-bottom: 16px;
}

.width-100 {
  width: 100%;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/more/ls-all-modal/ls-all-modal.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,yBAAA;AAAJ;AACI;EACE,aAAA;EACA,uBAAA;EACA,kCAAA;AACN;AACM;EACE,WAAA;EACA,YAAA;EACA,kBAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,8CAAA;EACA,kBAAA;AACR;AAAQ;EACE,+BAAA;EACA,WAAA;EACA,YAAA;AAEV;AACM;EACE,qBAAA;EACA,WAAA;AACR;AAAQ;EACE,mBAAA;EACA,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,WAAA;AAEV;AAAU;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AAEZ;AACQ;EACE,eAAA;AACV;AACU;EACE,eAAA;EACA,gCAAA;AACZ;AAKI;EACE,qBAAA;AAHN;AAIM;EACE,aAAA;EACA,8BAAA;AAFR;AAGQ;EACE,kBAAA;AADV;AAIU;EACE,yBAAA;EACA,eAAA;EACA,gCAAA;EACA,mBAAA;AAFZ;AAIU;EACE,eAAA;EACA,gCAAA;AAFZ;AAGY;EACE,cAAA;AADd;AAIU;EACE,eAAA;EACA,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,WAAA;AAFZ;AAGY;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AADd;AAIU;EACE,+BAAA;AAFZ;AAGY;EACE,+BAAA;AADd;AAOM;EACE,wBAAA;AALR;AASE;EACE,oBAAA;AAPJ;;AAWA;EACE,WAAA;AARF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  ion-card {\n    padding: 16px 16px 0 16px;\n    .ls-card-header {\n      display: flex;\n      align-items: flex-start;\n      --inner-border-width: 0 0 0.55px 0;\n      //padding-bottom: 8px;\n      .ls-card-icon {\n        width: 48px;\n        height: 48px;\n        border-radius: 8px;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        background: var(--ion-color-primary-lighten-4);\n        margin-bottom: 8px;\n        ion-icon {\n          color: var(--ion-color-primary);\n          width: 24px;\n          height: 24px;\n        }\n      }\n      ion-card-header {\n        padding: 0 0 8px 16px;\n        width: 100%;\n        ion-card-title {\n          font-weight: normal;\n          display: flex;\n          justify-content: space-between;\n          align-items: center;\n          width: 100%;\n\n          ion-icon {\n            width: 24px;\n            height: 24px;\n            color: var(--base-color-icon);\n          }\n        }\n        ion-card-subtitle {\n          font-size: 12px;\n\n          .ls-name {\n            margin-top: 8px;\n            color: var(--font-color-caption);\n          }\n        }\n      }\n    }\n\n    ion-card-content {\n      padding: 0 !important;\n      .ls-card-content {\n        display: flex;\n        justify-content: space-between;\n        .ls-card-content-center {\n          text-align: center;\n        }\n        .ls-card-content-item {\n          .ls-card-content-item-name {\n            text-transform: uppercase;\n            font-size: 10px;\n            color: var(--font-color-caption);\n            padding-bottom: 4px;\n          }\n          .ls-card-content-item-value {\n            font-size: 14px;\n            color: var(--font-color-primary);\n            sup {\n              font-size: 8px;\n            }\n          }\n          .ls-card-content-item-description, .ls-card-content-item-description-add {\n            font-size: 16px;\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            width: 100%;\n            ion-icon {\n              width: 24px;\n              height: 24px;\n              color: var(--base-color-icon);\n            }\n          }\n          .ls-card-content-item-description-add {\n            color: var(--ion-color-primary);\n            ion-icon {\n              color: var(--ion-color-primary);\n            }\n          }\n        }\n      }\n\n      ion-button {\n        margin-top: 0 !important;\n      }\n    }\n  }\n  .add {\n    padding-bottom: 16px;\n  }\n}\n\n.width-100 {\n  width: 100%;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 9058:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/code-modal/code-modal.page.scss?ngResource ***!
  \*************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page .input-block .text {
  align-self: start;
  margin: 48px 0 0 0;
}
.content-page ion-card .custom-card-content .ls-card-content-item {
  width: auto;
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-value {
  font-size: 14px;
  color: var(--font-color-primary);
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-value sup {
  font-size: 8px;
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description, .content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-add, .content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-delete {
  font-size: 16px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  width: 100%;
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description ion-icon, .content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon, .content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-delete ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-add {
  color: var(--ion-color-primary);
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-add ion-icon {
  color: var(--ion-color-primary);
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-delete {
  color: var(--ion-color-danger);
}
.content-page ion-card .custom-card-content .ls-card-content-item .ls-card-content-item-description-delete ion-icon {
  color: var(--ion-color-danger);
}
.content-page ion-card ion-toggle {
  pointer-events: none;
  max-width: 40px;
}
.content-page ion-card .disabled {
  opacity: 0.3;
}
.content-page ion-card .loading {
  pointer-events: none;
  opacity: 0.3;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/more/settings/code-modal/code-modal.page.scss"],"names":[],"mappings":"AAEI;EACE,iBAAA;EACA,kBAAA;AADN;AAQM;EACE,WAAA;AANR;AAOQ;EACE,eAAA;EACA,gCAAA;AALV;AAMU;EACE,cAAA;AAJZ;AAOQ;EACE,eAAA;EACA,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,WAAA;AALV;AAMU;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AAJZ;AAOQ;EACE,+BAAA;AALV;AAMU;EACE,+BAAA;AAJZ;AAOQ;EACE,8BAAA;AALV;AAMU;EACE,8BAAA;AAJZ;AAUI;EACE,oBAAA;EACA,eAAA;AARN;AAWI;EACE,YAAA;AATN;AAYI;EACE,oBAAA;EACA,YAAA;AAVN","sourcesContent":[".content-page {\n  .input-block {\n    .text {\n      align-self: start;\n      margin: 48px 0 0 0;\n    }\n  }\n\n  ion-card {\n    .custom-card-content {\n      //width: auto;\n      .ls-card-content-item {\n        width: auto;\n        .ls-card-content-item-value {\n          font-size: 14px;\n          color: var(--font-color-primary);\n          sup {\n            font-size: 8px;\n          }\n        }\n        .ls-card-content-item-description, .ls-card-content-item-description-add, .ls-card-content-item-description-delete {\n          font-size: 16px;\n          display: flex;\n          justify-content: space-between;\n          align-items: center;\n          width: 100%;\n          ion-icon {\n            width: 24px;\n            height: 24px;\n            color: var(--base-color-icon);\n          }\n        }\n        .ls-card-content-item-description-add {\n          color: var(--ion-color-primary);\n          ion-icon {\n            color: var(--ion-color-primary);\n          }\n        }\n        .ls-card-content-item-description-delete {\n          color: var(--ion-color-danger);\n          ion-icon {\n            color: var(--ion-color-danger);\n          }\n        }\n      }\n    }\n\n    ion-toggle {\n      pointer-events: none;\n      max-width: 40px;\n    }\n\n    .disabled {\n      opacity: 0.3;\n    }\n\n    .loading {\n      pointer-events: none;\n      opacity: 0.3;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 84294:
/*!*******************************************************************************************************!*\
  !*** ./src/app/pages/tabs/more/settings/email-mailing-modal/email-mailing-modal.page.scss?ngResource ***!
  \*******************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page ion-card .ls-card-content-item-description-add {
  color: var(--ion-color-primary);
}
.content-page ion-card .ls-card-content-item-description-add ion-icon {
  color: var(--ion-color-primary);
}
.content-page ion-card .ls-card-content-item-description-delete {
  color: var(--ion-color-danger);
  text-align: center;
}
.content-page ion-card .ls-card-content-item-description-delete ion-icon {
  color: var(--ion-color-danger);
}
.content-page .unsubscribe-email {
  justify-content: flex-end;
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/more/settings/email-mailing-modal/email-mailing-modal.page.scss"],"names":[],"mappings":"AAEI;EACE,+BAAA;AADN;AAEM;EACE,+BAAA;AAAR;AAGI;EACE,8BAAA;EACA,kBAAA;AADN;AAEM;EACE,8BAAA;AAAR;AAKE;EACE,yBAAA;EACA,YAAA;EACA,aAAA;EACA,sBAAA;AAHJ","sourcesContent":[".content-page {\n  ion-card {\n    .ls-card-content-item-description-add {\n      color: var(--ion-color-primary);\n      ion-icon {\n        color: var(--ion-color-primary);\n      }\n    }\n    .ls-card-content-item-description-delete {\n      color: var(--ion-color-danger);\n      text-align: center;\n      ion-icon {\n        color: var(--ion-color-danger);\n      }\n    }\n  }\n\n  .unsubscribe-email {\n    justify-content: flex-end;\n    flex-grow: 1;\n    display: flex;\n    flex-direction: column;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 55503:
/*!*******************************************************************!*\
  !*** ./src/app/pages/tabs/payment/help/help.page.scss?ngResource ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page {
  padding-bottom: 0 !important;
}
.content-page .swiper {
  width: 100%;
  height: 100%;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/payment/help/help.page.scss"],"names":[],"mappings":"AAAA;EACE,4BAAA;AACF;AACE;EACE,WAAA;EACA,YAAA;AACJ","sourcesContent":[".content-page {\n  padding-bottom: 0 !important;\n\n  .swiper {\n    width: 100%;\n    height: 100%;\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 31838:
/*!*******************************************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/check-modal/check-modal.page.scss?ngResource ***!
  \*******************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page ion-item {
  padding-left: 24px;
  padding-right: 24px;
  margin-left: -24px;
  margin-right: -24px;
  box-sizing: content-box;
}
.content-page .custom-card-content {
  display: flex;
  justify-content: space-between;
  width: 100%;
  flex-direction: column;
  padding: 0 0 6px 0;
}
.content-page .custom-card-content-center {
  text-align: center;
}
.content-page .custom-card-content-item {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 8px;
  margin: 5px 0;
}
.content-page .custom-card-content-item-name {
  font-size: 12px;
  color: var(--font-color-caption);
  padding-bottom: 4px;
  text-transform: uppercase;
  flex-grow: 1;
}
.content-page .custom-card-content-item-title {
  font-size: 12px;
  flex-grow: 1;
  color: var(--font-color-secondary);
}
.content-page .custom-card-content-item-values {
  width: 100%;
}
.content-page .custom-card-content-item-values-title {
  display: flex;
  justify-content: space-between;
}
.content-page .custom-card-content-item-values-title span:last-child {
  color: var(--font-color-caption);
  margin: 0 10px;
}
.content-page .custom-card-content-item-value {
  font-size: 16px;
  color: var(--font-color-primary);
  text-align: end;
}
.content-page .custom-card-content-item ion-icon {
  width: 24px;
  height: 24px;
  color: var(--base-color-icon);
}
.content-page .custom-card-content-item ion-checkbox {
  margin: 0;
  width: 24px;
  height: 24px;
  opacity: 1;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/payment/pay-receipt/pay-modal/check-modal/check-modal.page.scss"],"names":[],"mappings":"AACE;EACE,kBAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,uBAAA;AAAJ;AAEE;EACE,aAAA;EACA,8BAAA;EACA,WAAA;EACA,sBAAA;EACA,kBAAA;AAAJ;AAEI;EACE,kBAAA;AAAN;AAGI;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,QAAA;EACA,aAAA;AADN;AAGM;EACE,eAAA;EACA,gCAAA;EACA,mBAAA;EACA,yBAAA;EACA,YAAA;AADR;AAIM;EACE,eAAA;EACA,YAAA;EACA,kCAAA;AAFR;AAKM;EACE,WAAA;AAHR;AAKQ;EACE,aAAA;EACA,8BAAA;AAHV;AAKU;EACE,gCAAA;EACA,cAAA;AAHZ;AAQM;EACE,eAAA;EACA,gCAAA;EACA,eAAA;AANR;AASM;EACE,WAAA;EACA,YAAA;EACA,6BAAA;AAPR;AAUM;EACE,SAAA;EACA,WAAA;EACA,YAAA;EACA,UAAA;AARR","sourcesContent":[".content-page {\n  ion-item {\n    padding-left: 24px;\n    padding-right: 24px;\n    margin-left: -24px;\n    margin-right: -24px;\n    box-sizing: content-box;\n  }\n  .custom-card-content {\n    display: flex;\n    justify-content: space-between;\n    width: 100%;\n    flex-direction: column;\n    padding: 0 0 6px 0;\n\n    &-center {\n      text-align: center;\n    }\n\n    &-item {\n      width: 100%;\n      display: flex;\n      align-items: center;\n      justify-content: space-between;\n      gap: 8px;\n      margin: 5px 0;\n\n      &-name {\n        font-size: 12px;\n        color: var(--font-color-caption);\n        padding-bottom: 4px;\n        text-transform: uppercase;\n        flex-grow: 1;\n      }\n\n      &-title {\n        font-size: 12px;\n        flex-grow: 1;\n        color: var(--font-color-secondary);\n      }\n\n      &-values {\n        width: 100%;\n\n        &-title {\n          display: flex;\n          justify-content: space-between;\n\n          span:last-child {\n            color: var(--font-color-caption);\n            margin: 0 10px;\n          }\n        }\n      }\n\n      &-value {\n        font-size: 16px;\n        color: var(--font-color-primary);\n        text-align: end;\n      }\n\n      ion-icon {\n        width: 24px;\n        height: 24px;\n        color: var(--base-color-icon);\n      }\n\n      ion-checkbox {\n        margin: 0;\n        width: 24px;\n        height: 24px;\n        opacity: 1;\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 6435:
/*!*****************************************************************************************!*\
  !*** ./src/app/pages/tabs/payment/pay-receipt/pay-modal/pay-modal.page.scss?ngResource ***!
  \*****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.content-page form {
  padding: 24px 24px 0 24px;
}
.content-page form + .commission {
  padding-top: 24px !important;
}
.content-page form ion-item ion-input div {
  position: absolute;
  color: var(--font-color-primary);
  pointer-events: none;
  display: flex;
  align-items: center;
}
.content-page form ion-item ion-input div span {
  color: var(--font-color-primary);
}
.content-page form ion-item ion-input div label {
  display: flex;
  align-items: center;
  margin-right: 3px;
}
.content-page form ion-item .left_symbol {
  --padding-start: 14px;
}
.content-page form ion-item .zeroValue div {
  color: var(--font-color-caption);
}
.content-page form ion-item .zeroValue div span {
  color: var(--font-color-caption);
}
.content-page .gateways {
  white-space: nowrap;
  overflow: auto;
  display: flex;
  padding: 24px 24px;
}
.content-page .gateways .enumeration:last-child ion-card {
  margin: 0 !important;
}
.content-page .gateways .enumeration ion-card {
  min-width: 80px;
  width: 80px;
  max-width: 80px;
  min-height: 80px;
  height: 80px;
  max-height: 80px;
  margin: 0 8px 0 0 !important;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  overflow: visible;
  contain: none;
}
.content-page .gateways .enumeration ion-card .icon {
  border-radius: 50px;
  overflow: hidden;
  width: 24px;
  height: 24px;
  margin: 8px;
}
.content-page .gateways .enumeration ion-card .icon img {
  width: 24px;
  height: 24px;
}
.content-page .gateways .enumeration ion-card .description {
  margin: 8px;
  max-width: calc(100% - 16px);
  overflow: hidden;
  display: -webkit-box;
  -webkit-line-clamp: 1;
  -webkit-box-orient: vertical;
  white-space: pre-line;
}
.content-page .gateways .enumeration ion-card ion-item {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  overflow: visible;
}
.content-page .gateways .enumeration ion-card ion-item ion-radio {
  width: 80px;
  height: 80px;
  margin: 0;
  opacity: 0;
}
.content-page .gateways .enumeration ion-card .item-radio-checked:after {
  content: "";
  display: block;
  position: absolute;
  top: -4px;
  left: -4px;
  right: -4px;
  bottom: -4px;
  border: 2px solid var(--ion-color-primary);
  border-radius: 12px;
}
.content-page .commission {
  padding: 0 24px;
  display: flex;
  justify-content: space-between;
  font-size: 14px;
}
.content-page .commission .name {
  color: var(--font-color-secondary);
}
.content-page .payBtn {
  margin: 0 24px 24px 24px;
}
.content-page .payBtn ion-button ion-icon {
  width: 40px;
  height: 40px;
  position: absolute;
  left: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/payment/pay-receipt/pay-modal/pay-modal.page.scss"],"names":[],"mappings":"AACE;EACE,yBAAA;AAAJ;AAEI;EACE,4BAAA;AAAN;AAOQ;EACE,kBAAA;EACA,gCAAA;EAEA,oBAAA;EACA,aAAA;EACA,mBAAA;AANV;AAQU;EACE,gCAAA;AANZ;AAUU;EACE,aAAA;EACA,mBAAA;EACA,iBAAA;AARZ;AAgCM;EACE,qBAAA;AA9BR;AAgDQ;EACE,gCAAA;AA9CV;AA+CU;EACE,gCAAA;AA7CZ;AA4FE;EACE,mBAAA;EACA,cAAA;EACA,aAAA;EACA,kBAAA;AA1FJ;AA8FQ;EACE,oBAAA;AA5FV;AA+FM;EACE,eAAA;EACA,WAAA;EACA,eAAA;EACA,gBAAA;EACA,YAAA;EACA,gBAAA;EACA,4BAAA;EACA,aAAA;EACA,sBAAA;EACA,8BAAA;EACA,iBAAA;EACA,aAAA;AA7FR;AA+FQ;EACE,mBAAA;EACA,gBAAA;EACA,WAAA;EACA,YAAA;EACA,WAAA;AA7FV;AA8FU;EACE,WAAA;EACA,YAAA;AA5FZ;AAgGQ;EACE,WAAA;EACA,4BAAA;EACA,gBAAA;EACA,oBAAA;EACA,qBAAA;EACA,4BAAA;EACA,qBAAA;AA9FV;AAiGQ;EACE,kBAAA;EACA,MAAA;EACA,OAAA;EACA,QAAA;EACA,SAAA;EACA,iBAAA;AA/FV;AAiGU;EACE,WAAA;EACA,YAAA;EACA,SAAA;EACA,UAAA;AA/FZ;AAoGU;EACE,WAAA;EACA,cAAA;EACA,kBAAA;EACA,SAAA;EACA,UAAA;EACA,WAAA;EACA,YAAA;EACA,0CAAA;EACA,mBAAA;AAlGZ;AA0GE;EACE,eAAA;EACA,aAAA;EACA,8BAAA;EACA,eAAA;AAxGJ;AA0GI;EACE,kCAAA;AAxGN;AA4GE;EACE,wBAAA;AA1GJ;AA6GM;EACE,WAAA;EACA,YAAA;EACA,kBAAA;EACA,OAAA;AA3GR","sourcesContent":[".content-page {\n  form {\n    padding: 24px 24px 0 24px;\n\n    & + .commission {\n      padding-top: 24px !important;\n    }\n\n    ion-item {\n      ion-input {\n        //color: transparent;\n\n        div {\n          position: absolute;\n          color: var(--font-color-primary);\n          //color: transparent;\n          pointer-events: none;\n          display: flex;\n          align-items: center;\n\n          span {\n            color: var(--font-color-primary);\n            //color: var(--font-color-caption);\n          }\n\n          label {\n            display: flex;\n            align-items: center;\n            margin-right: 3px;\n\n            //&::after {\n            //  content: \"\";\n            //  width: 2px;\n            //  border-radius: 2px;\n            //  height: 20px;\n            //  background: var(--ion-color-primary);\n            //  margin-left: 1px;\n            //  display: none;\n            //  animation: focus 0.5s infinite ease alternate;\n            //  animation-play-state: paused;\n            //\n            //  @keyframes focus {\n            //    0% {opacity: 0;}\n            //    10% {opacity: 0;}\n            //    70% {opacity: 1;}\n            //    100% {opacity: 1;}\n            //  }\n            //}\n          }\n        }\n      }\n\n      .left_symbol {\n        --padding-start: 14px;\n      }\n\n      //.has-focus {\n      //  div {\n      //    label {\n      //      margin-right: 0;\n      //      &::after {\n      //        display: inline-block;\n      //        animation-play-state: running;\n      //      }\n      //    }\n      //  }\n      //}\n\n      .zeroValue {\n        //color: var(--font-color-caption);\n\n        div {\n          color: var(--font-color-caption);\n          span {\n            color: var(--font-color-caption);\n          }\n        }\n      }\n    }\n  }\n\n  //.swiper {\n  //  width: 100%;\n  //  padding: 24px 24px;\n  //\n  //  ion-card {\n  //    min-width: 80px;\n  //    width: 80px;\n  //    max-width: 80px;\n  //    min-height: 80px;\n  //    height: 80px;\n  //    max-height: 80px;\n  //    margin: 0 !important;\n  //    display: flex;\n  //    flex-direction: column;\n  //    justify-content: space-between;\n  //\n  //    .icon {\n  //      border-radius: 50px;\n  //      overflow: hidden;\n  //      width: 24px;\n  //      height: 24px;\n  //      margin: 8px;\n  //      img {\n  //        width: 24px;\n  //        height: 24px;\n  //      }\n  //    }\n  //\n  //    .description {\n  //      margin: 8px;\n  //      max-width: calc(100% - 16px);\n  //      overflow: hidden;\n  //      display: -webkit-box;\n  //      -webkit-line-clamp: 1;\n  //      -webkit-box-orient: vertical;\n  //      white-space: pre-line;\n  //    }\n  //  }\n  //}\n\n  .gateways {\n    white-space: nowrap;\n    overflow: auto;\n    display: flex;\n    padding: 24px 24px;\n\n    .enumeration {\n      &:last-child {\n        ion-card {\n          margin: 0 !important;\n        }\n      }\n      ion-card {\n        min-width: 80px;\n        width: 80px;\n        max-width: 80px;\n        min-height: 80px;\n        height: 80px;\n        max-height: 80px;\n        margin: 0 8px 0 0 !important;\n        display: flex;\n        flex-direction: column;\n        justify-content: space-between;\n        overflow: visible;\n        contain: none;\n\n        .icon {\n          border-radius: 50px;\n          overflow: hidden;\n          width: 24px;\n          height: 24px;\n          margin: 8px;\n          img {\n            width: 24px;\n            height: 24px;\n          }\n        }\n\n        .description {\n          margin: 8px;\n          max-width: calc(100% - 16px);\n          overflow: hidden;\n          display: -webkit-box;\n          -webkit-line-clamp: 1;\n          -webkit-box-orient: vertical;\n          white-space: pre-line;\n        }\n\n        ion-item {\n          position: absolute;\n          top: 0;\n          left: 0;\n          right: 0;\n          bottom: 0;\n          overflow: visible;\n\n          ion-radio {\n            width: 80px;\n            height: 80px;\n            margin: 0;\n            opacity: 0;\n          }\n        }\n\n        .item-radio-checked {\n          &:after {\n            content: \"\";\n            display: block;\n            position: absolute;\n            top: -4px;\n            left: -4px;\n            right: -4px;\n            bottom: -4px;\n            border: 2px solid var(--ion-color-primary);\n            border-radius: 12px;\n          }\n        }\n      }\n    }\n    //}\n  }\n\n  .commission {\n    padding: 0 24px;\n    display: flex;\n    justify-content: space-between;\n    font-size: 14px;\n\n    .name {\n      color: var(--font-color-secondary);\n    }\n  }\n\n  .payBtn {\n    margin: 0 24px 24px 24px;\n\n    ion-button {\n      ion-icon {\n        width: 40px;\n        height: 40px;\n        position: absolute;\n        left: 0;\n      }\n    }\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 72823:
/*!****************************************************************************!*\
  !*** ./src/app/pages/technical-works/technical-works.page.scss?ngResource ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
.content-page {
  padding: 0 0 calc(24px + var(--ion-safe-area-bottom)) 0 !important;
}

.subHeader, .message {
  text-align: center;
}

.message {
  color: var(--font-color-secondary);
}

.btn {
  display: flex;
  gap: 12px;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/technical-works/technical-works.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,kEAAA;AACF;;AAEA;EACE,kBAAA;AACF;;AAEA;EACE,kCAAA;AACF;;AAEA;EACE,aAAA;EACA,SAAA;AACF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\n.content-page {\n  padding: 0 0 calc(24px + var(--ion-safe-area-bottom)) 0 !important;\n}\n\n.subHeader, .message {\n  text-align: center;\n}\n\n.message {\n  color: var(--font-color-secondary);\n}\n\n.btn {\n  display: flex;\n  gap: 12px;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 37187:
/*!******************************************************************!*\
  !*** ./src/app/pages/update-app/update-app.page.scss?ngResource ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ``, "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 61584:
/*!***********************************************!*\
  !*** ./src/app/app.component.html?ngResource ***!
  \***********************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-app [ngClass]=\"!getNetworkStatus() ? 'disconnected' : ''\">\n  <ion-router-outlet\n    [ngStyle]=\"{\n      pointerEvents: (helper.swipe !== undefined && helper.swipe.routerOutletBlock) ? 'none' : 'auto'\n    }\"\n  ></ion-router-outlet>\n\n  <div class=\"custom-action-sheet-block\">\n    <ion-backdrop></ion-backdrop>\n\n    <div #select\n         class=\"custom-action-sheet\"\n         (mousemove)=\"helper.swipe.mouseMove($event)\"\n         (mouseup)=\"helper.swipe.mouseUp($event)\"\n         (mouseleave)=\"helper.swipe.mouseUp($event)\">\n      <div class=\"custom-action-sheet-wrapper\">\n        <div class=\"custom-action-sheet-back\" (click)=\"helper.close()\"></div>\n        <div class=\"custom-action-sheet-container\"\n             (touchstart)=\"helper.swipe.touchStart($event)\"\n             (touchend)=\"helper.swipe.touchEnd($event)\"\n             (touchmove)=\"helper.swipe.touchMove($event)\"\n             (mousedown)=\"helper.swipe.mouseDown($event)\"\n             [ngStyle]=\"helper.swipe\">\n          @if (helper.selectData.value.data) {\n            <div class=\"custom-action-sheet-container-inside\">\n              <div class=\"custom-action-sheet-title\">\n                {{ helper.selectData.value.data.title }}\n              </div>\n              @if (helper.selectData.value.data.type === 'select') {\n                <div class=\"custom-action-sheet-group\">\n                  @for (btn of helper.selectData.value.data.buttons; let i = $index; track i) {\n                    <div class=\"custom-action-sheet-button el-anim-tap\" (click)=\"helper.close($event, i)\">\n                      <ion-item lines=\"none\">\n                        <div class=\"elem-content\">\n                          <div class=\"elem-content-item\">\n                            @if (!!btn.icon) {\n                              <div class=\"elem-content-item-icon\">\n                                <ion-icon src=\"{{ btn.icon }}\"/>\n                              </div>\n                            }\n                            <div class=\"elem-content-item-text\" [innerHTML]=\"btn.title\"></div>\n                          </div>\n                          <!--                <ion-checkbox disabled=\"true\" [checked]=\"helper.selectData.value.value === btn.value\"></ion-checkbox>-->\n                          @if (!helper.selectData.value.data.result) {\n                            <div class=\"checkbox-icon\">\n                              @if (helper.selectData.value.data.value === btn.value) {\n                                <ion-icon src=\"assets/icons/Check_Circle_Filled.svg\"/>\n                              }\n                            </div>\n                          } @else {\n                            <div class=\"checkbox-icon\">\n                              @if (helper.selectData.value.data.result.value === btn.value) {\n                                <ion-icon src=\"assets/icons/Check_Circle_Filled.svg\"/>\n                              }\n                            </div>\n                          }\n                        </div>\n                      </ion-item>\n                    </div>\n                  }\n                </div>\n              } @else if (helper.selectData.value.data.type === 'choice') {\n                <div class=\"custom-action-sheet-group\">\n                  @for (btn of helper.selectData.value.data.buttons; let i = $index; track i) {\n                    <div class=\"custom-action-sheet-button el-anim-tap\"\n                         (click)=\"helper.changeChoice(btn.value)\">\n                      <ion-item lines=\"none\">\n                        <div class=\"elem-content\">\n                          <div class=\"elem-content-item\">\n                            @if (!!btn.icon) {\n                              <div class=\"elem-content-item-icon\">\n                                <ion-icon src=\"{{ btn.icon }}\"></ion-icon>\n                              </div>\n                            }\n                            <div class=\"elem-content-item-text\" [innerHTML]=\"btn.title\"></div>\n                          </div>\n                          <!--                <ion-checkbox disabled=\"true\" [checked]=\"helper.selectData.value.value === btn.value\"></ion-checkbox>-->\n                          @if (!helper.selectData.value.data.result) {\n                            <div class=\"checkbox-icon\">\n                              @if (helper.selectData.value.data.value.includes(btn.value)) {\n                                <ion-icon src=\"assets/icons/Check_Circle_Filled.svg\"/>\n                              }\n                            </div>\n                          } @else {\n                            <div class=\"checkbox-icon\">\n                              @if (helper.selectData.value.data.result.value.includes(btn.value)) {\n                                <ion-icon src=\"assets/icons/Check_Circle_Filled.svg\"/>\n                              }\n                            </div>\n                          }\n                        </div>\n                      </ion-item>\n                    </div>\n                  }\n                </div>\n              }\n\n              <div class=\"custom-action-sheet-group\">\n                <ion-button class=\"btn-big custom-action-sheet-cancel\"\n                            (click)=\"helper.close()\"\n                            type=\"button\"\n                            expand=\"block\"\n                            fill=\"solid\"\n                            color=\"tertiary\">\n                  @if (helper.selectData.value.data.closeBtnText) {\n                    {{ helper.selectData.value.data.closeBtnText }}\n                  } @else {\n                    {{ 'BUTTONS.CLOSE' | translate }}\n                  }\n                </ion-button>\n              </div>\n            </div>\n          }\n        </div>\n      </div>\n    </div>\n  </div>\n\n<!--  <div class=\"update-window\" *ngIf=\"updateWindow\">-->\n<!--    <div class=\"update-window-content\">-->\n<!--      <div class=\"update-window-content-title\"><b>Обновление</b></div>-->\n<!--      <div class=\"update-window-content-progress\">-->\n<!--        <ion-progress-bar type=\"indeterminate\" color=\"primary\"></ion-progress-bar>-->\n<!--      </div>-->\n<!--      <div class=\"update-window-content-message\">{{ updateMessage }}</div>-->\n<!--    </div>-->\n<!--  </div>-->\n</ion-app>\n";

/***/ }),

/***/ 84469:
/*!****************************************************************************!*\
  !*** ./src/app/components/card-block/card-block.component.html?ngResource ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<div class=\"card-block\">\n  <div class=\"name\">{{ title }}</div>\n\n  <ion-card>\n    <ng-content></ng-content>\n  </ion-card>\n</div>\n";

/***/ }),

/***/ 77207:
/*!******************************************************************************!*\
  !*** ./src/app/components/custom-item/custom-item.component.html?ngResource ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-item\n    lines=\"{{ lines }}\"\n    class=\"{{ class }}\"\n    [disabled]=\"disabled\"\n>\n  <ng-content></ng-content>\n</ion-item>\n";

/***/ }),

/***/ 17719:
/*!******************************************************************************************!*\
  !*** ./src/app/components/date-button-field/date-button-field.component.html?ngResource ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-title>\n      @if(presentation == 'date') {\n        {{ 'BUTTONS.SELECT_DATE' | translate }}\n      } @else {\n        {{ 'BUTTONS.SELECT_MONTH' | translate }}\n      }\n    </ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button type=\"button\" fill=\"clear\" (click)=\"close(false)\">\n        <ion-icon src=\"/assets/icons/Close.svg\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <div class=\"content-page\">\n    <app-custom-item [class]=\"''\" lines=\"none\">\n      <div class=\"datepicker\" [class]=\"presentation == 'date' ? 'fullDate' : ''\">\n        <ion-datetime\n            id=\"{{ id }}\"\n            #datetime\n            presentation=\"{{ presentation }}\"\n            [firstDayOfWeek]=\"1\"\n            [preferWheel]=\"preferWheel\"\n            [showDefaultButtons]=\"showDefaultButtons\"\n            [multiple]=\"period || multiple\"\n            [highlightedDates]=\"undefined\"\n            [value]=\"value\"\n            locale=\"{{ this.translate.currentLang }}\"\n            (ionChange)=\"handle($event)\"\n            [ngClass]=\"period ? 'period' : ''\"\n        >\n        </ion-datetime>\n      </div>\n    </app-custom-item>\n\n    <div class=\"input-block\">\n      <ion-button color=\"primary\" (click)=\"close(true)\">\n        @if (presentation == 'date') {\n          {{ 'BUTTONS.SELECT_DATE' | translate }}\n        } @else {\n          {{ 'BUTTONS.SELECT_MONTH' | translate }}\n        }\n      </ion-button>\n    </div>\n  </div>\n</ion-content>";

/***/ }),

/***/ 22579:
/*!**************************************************************************************************!*\
  !*** ./src/app/components/datetime-button-field/datetime-button-field.component.html?ngResource ***!
  \**************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<app-custom-item [class]=\"''\">\n  <ion-label>\n      @if (!!header) {\n          <ion-text>\n              {{ header }}\n              @if (required) {\n                  <span class=\"color-danger\">*</span>\n              }\n          </ion-text>\n      }\n    <ion-datetime-button datetime=\"{{ id }}\">\n<!--      <div slot=\"date-target\" *ngIf=\"!!value\">-->\n<!--        {{ value }}-->\n<!--      </div>-->\n<!--      <div slot=\"time-target\" *ngIf=\"!!value\">-->\n<!--        {{ value }}-->\n<!--      </div>-->\n        @if (!value.value) {\n            <div slot=\"date-target\">\n                {{ placeholder }}\n            </div>\n        }\n\n        @if (!value.value) {\n            <div slot=\"time-target\">\n                {{ 'COMPONENTS.DATETIME_BUTTON_FIELD.PLACEHOLDER_TIME_DEFAULT' | translate }}\n            </div>\n        }\n    </ion-datetime-button>\n  </ion-label>\n</app-custom-item>\n\n<ion-modal #modal [keepContentsMounted]=\"true\" [breakpoints]=\"[0, 1]\" [initialBreakpoint]=\"1\">\n  <ng-template>\n    <div class=\"wrapper\">\n      <ion-datetime\n          id=\"{{ id }}\"\n          #datetime\n          presentation=\"{{ presentation }}\"\n          [firstDayOfWeek]=\"1\"\n          [preferWheel]=\"preferWheel\"\n          [showDefaultButtons]=\"showDefaultButtons\"\n          [multiple]=\"period || multiple\"\n          [highlightedDates]=\"handlePeriod\"\n          [value]=\"value.value\"\n          locale=\"{{ this.translate.currentLang }}\"\n          (ionChange)=\"handle($event)\"\n          [ngClass]=\"period ? 'period' : ''\"\n      >\n        <ion-buttons slot=\"buttons\">\n          <ion-button color=\"primary\" (click)=\"close(false)\">{{ 'BUTTONS.CANCEL' | translate }}</ion-button>\n          <ion-button color=\"primary\" strong=\"true\" (click)=\"close(true)\">{{ 'BUTTONS.DONE' | translate }}</ion-button>\n        </ion-buttons>\n      </ion-datetime>\n<!--      <ion-range-calendar-->\n<!--          id=\"{{ 'datetime2'+id }}\"-->\n<!--          [(ngModel)]=\"value\"-->\n<!--          [options]=\"options\"-->\n<!--          [type]=\"'string'\"-->\n<!--          [format]=\"'yyyy-MM-dd'\"-->\n<!--      ></ion-range-calendar>-->\n    </div>\n  </ng-template>\n</ion-modal>";

/***/ }),

/***/ 2267:
/*!****************************************************************************!*\
  !*** ./src/app/components/file-field/file-field.component.html?ngResource ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-item-sliding [disabled]=\"!value.value\">\n  <app-custom-item [ngClass]=\"!!value.value ? 'selected' : ''\" [class]=\"''\" (click)=\"openAddFile()\">\n    <ion-label>\n      <ion-text>\n        {{ header }}\n          @if (required) {\n              <span class=\"color-danger\">*</span>\n          }\n      </ion-text>\n      <ion-label>\n        <ng-content select=\"start\"></ng-content>\n<!--        <div class=\"appeal-files-cat-block-arr-preview\" [hidden]=\"file.preview != 'img'\">-->\n<!--          <img [src]=\"file.base64\" (error)=\"previewError(file)\"/>-->\n<!--        </div>-->\n<!--        <div class=\"appeal-files-cat-block-arr-preview-bg\" [hidden]=\"file.preview == 'img'\">-->\n<!--          <ion-icon src=\"assets/icons/File.svg\"></ion-icon>-->\n<!--        </div>-->\n          @if (!!value.value && value.value.preview == 'img') {\n              <img [src]=\"value.value.base64\"  (error)=\"previewError()\"/>\n          }\n\n          @if (!value.value || (!!value.value && value.value.preview != 'img')) {\n              <ion-icon src=\"{{ iconLeft }}\" />\n          }\n\n          @if (!value.value) {\n              <ion-note>{{ placeholder }}</ion-note>\n          }\n\n          @if (!!value.value) {\n              <ion-note>{{ helper.shortFileName(value.value.name, 30) }}</ion-note>\n          }\n      </ion-label>\n    </ion-label>\n    <div class=\"icon-wrapper\" slot=\"end\">\n      <ng-content select=\"end\"></ng-content>\n      <ion-icon src=\"{{ iconRight }}\"></ion-icon>\n    </div>\n    <input\n      #inputFile\n      class=\"add-file\"\n      hidden\n      type=\"file\"\n      accept=\"{{ allowedExtFiles }}\"\n      (change)=\"fileEvent($event)\"\n    />\n    <input\n      #inputImage\n      class=\"add-image\"\n      hidden\n      type=\"file\"\n      accept=\"image/*\"\n      (change)=\"fileEvent($event)\"\n    />\n  </app-custom-item>\n\n  <ion-item-options>\n    <ion-item-option color=\"danger\" (click)=\"removeFile($event)\">\n      <ion-icon slot=\"icon-only\" src=\"/assets/icons/Close.svg\"></ion-icon>\n    </ion-item-option>\n  </ion-item-options>\n</ion-item-sliding>\n";

/***/ }),

/***/ 57315:
/*!******************************************************************************!*\
  !*** ./src/app/components/input-field/input-field.component.html?ngResource ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<app-custom-item [lines]=\"'none'\" [class]=\"''\">\n  <div class=\"custom-card-content\">\n    <ion-input\n        labelPlacement=\"floating\"\n        class=\"custom-input\"\n        placeholder=\"{{ placeholder }}\"\n        [value]=\"value.value\"\n        errorText=\"{{ errorText }}\"\n        required=\"{{ required }}\"\n        [disabled]=\"disabled\"\n        type=\"{{ type }}\"\n        #input\n        [maskito]=\"maskitoOptions\"\n        [maskitoElement]=\"maskPredicate\"\n        (ionBlur)=\"validateHandler()\"\n        (ionChange)=\"validateHandler()\"\n        (ionInput)=\"setValue($event)\"\n        (beforeinput)=\"handlerInput($event, value)\"\n    >\n      <div slot=\"label\" class=\"custom-card-content-item\">\n        <div class=\"custom-card-content-item-title\">\n          {{ header }}\n            @if (required) {\n                <span class=\"color-danger\">*</span>\n            }\n        </div>\n      </div>\n    </ion-input>\n  </div>\n</app-custom-item>\n";

/***/ }),

/***/ 42711:
/*!**************************************************************************!*\
  !*** ./src/app/components/menu-item/menu-item.component.html?ngResource ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-item [ngClass]=\"anim ? 'el-anim-tap' : ''\" [disabled]=\"disabled\">\n  <div class=\"custom-card-content\">\n    <div class=\"custom-card-content-item\">\n      <div class=\"custom-card-content-item-title\" [ngClass]=\"color ? 'color-'+color : ''\">\n        @if (!!title) {\n          {{ title }}\n        } @else {\n          <ng-content select=\"[title]\"></ng-content>\n        }\n      </div>\n      <div  class=\"custom-card-content-item-value\">\n        @if (!!value) {\n          {{ value }}\n        } @else {\n          <ng-content></ng-content>\n        }\n      </div>\n      @if (icon) {\n        <ion-icon src=\"assets/icons/{{ icon }}.svg\"></ion-icon>\n      } @else {\n        <ng-content select=\"[icon]\"></ng-content>\n      }\n    </div>\n    @if (description && description.length > 0) {\n      <ion-note>{{ description }}</ion-note>\n    }\n  </div>\n</ion-item>\n";

/***/ }),

/***/ 20211:
/*!********************************************************************************!*\
  !*** ./src/app/components/select-field/select-field.component.html?ngResource ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<app-custom-item [disabled]=\"disabled\" (click)=\"openSelect()\">\n<!--  <ion-icon src=\"/assets/icons/File.svg\" slot=\"start\"></ion-icon>-->\n<!--  <ion-label>{{ params.nazvanie }}</ion-label>-->\n  <ion-label>\n    <ion-text>\n      {{ header }}\n        @if (required) {\n            <span class=\"color-danger\">*</span>\n        }\n    </ion-text>\n      @if (!value.value || (!!customValue ? !value.value[displayField] && !customValue : !value.value[displayField])) {\n          <ion-note>{{ placeholder }}</ion-note>\n      }\n\n      @if (!!value.value) {\n          <ion-note class=\"selected\">\n              {{ value.value[displayField] }}{{ !!customValue ? !!value.value[displayField] ? '; '+customValue : customValue : '' }}\n          </ion-note>\n      }\n  </ion-label>\n    @if (!!iconRight) {\n        <div class=\"icon-wrapper\" slot=\"end\">\n            @if (!loading.value) {\n                <ion-icon src=\"{{ iconRight }}\" />\n            } @else {\n                <ion-spinner style=\"height: 24px\" />\n            }\n        </div>\n    }\n</app-custom-item>\n";

/***/ }),

/***/ 93565:
/*!****************************************************************************!*\
  !*** ./src/app/components/text-field/text-field.component.html?ngResource ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<app-custom-item [lines]=\"'none'\" [class]=\"''\">\n  <div class=\"custom-card-content\">\n    <ion-textarea\n        labelPlacement=\"floating\"\n        placeholder=\"{{ placeholder }}\"\n        [value]=\"value.value\"\n        errorText=\"{{ errorText }}\"\n        required=\"{{ required }}\"\n        auto-grow=\"true\"\n        [disabled]=\"disabled\"\n        #textarea\n        (ionBlur)=\"validateHandler()\"\n        (ionChange)=\"validateHandler()\"\n        (ionInput)=\"setValue($event)\"\n    >\n      <div slot=\"label\" class=\"custom-card-content-item\">\n        <div class=\"custom-card-content-item-title\">\n          {{ header }}\n            @if (required) {\n                <span class=\"color-danger\">*</span>\n            }\n        </div>\n      </div>\n    </ion-textarea>\n  </div>\n</app-custom-item>\n";

/***/ }),

/***/ 78247:
/*!********************************************************************************!*\
  !*** ./src/app/components/toggle-field/toggle-field.component.html?ngResource ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<app-custom-item #item (click)=\"value.next(!value.value)\">\n  <ion-toggle [disabled]=\"disabled\" [ngModel]=\"value.value\" (ionChange)=\"validateHandler()\">\n    <ion-label>{{ header }}</ion-label>\n      @if (placeholder != '') {\n          <ion-note>{{ placeholder }}</ion-note>\n      }\n  </ion-toggle>\n</app-custom-item>\n";

/***/ }),

/***/ 56793:
/*!******************************************************************************!*\
  !*** ./src/app/pages/account-verified/account-verified.page.html?ngResource ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-content forceOverscroll=\"false\">\n\n  <div class=\"content-page modal\">\n    <div class=\"content-center\">\n        @if (loginType === 'email') {\n            <div class=\"icon\">\n                <ion-icon class=\"icon-img\" src=\"/assets/imgs/Email.svg\"/>\n            </div>\n            <div class=\"header\">{{ 'MODAL_PAGES.ACCOUNT_VERIFIED.HEADER.EMAIL' | translate }}</div>\n        } @else if (loginType === 'tel') {\n            <div class=\"icon\">\n                <ion-icon class=\"icon-img\" src=\"/assets/imgs/PhoneConfirmed.svg\"/>\n            </div>\n            <div class=\"header\">{{ 'MODAL_PAGES.ACCOUNT_VERIFIED.HEADER.PHONE' | translate }}</div>\n        }\n      <div class=\"description\">\n        {{ 'MODAL_PAGES.ACCOUNT_VERIFIED.DESCRIPTION' | translate }}\n      </div>\n    </div>\n\n    <div class=\"btn\">\n      <ion-button type=\"button\" expand=\"block\" fill=\"solid\" (click)=\"auth()\">{{ 'MODAL_PAGES.ACCOUNT_VERIFIED.BUTTON' | translate }}</ion-button>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ }),

/***/ 24283:
/*!**************************************************************************!*\
  !*** ./src/app/pages/add-code-modal/add-code-modal.page.html?ngResource ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"end\">\n      <ion-button (click)=\"back()\"><ion-icon src=\"/assets/icons/Close.svg\"></ion-icon></ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content forceOverscroll=\"false\">\n\n  <div class=\"content-page modal\">\n    <div class=\"content-center\">\n      <div class=\"icon\">\n        <ion-icon class=\"icon-img\" src=\"/assets/imgs/Code.svg\"></ion-icon>\n      </div>\n\n      <div class=\"header\">{{ 'MODAL_PAGES.ADD_CODE.HEADER' | translate }}</div>\n\n      <div class=\"description\">\n        {{ 'MODAL_PAGES.ADD_CODE.DESCRIPTION' | translate }}\n      </div>\n    </div>\n    <div class=\"btn\">\n      <ion-button type=\"button\" expand=\"block\" fill=\"solid\" (click)=\"codeInit()\">{{ 'MODAL_PAGES.ADD_CODE.BUTTON' | translate }}</ion-button>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ }),

/***/ 80394:
/*!*************************************************************************************!*\
  !*** ./src/app/pages/auth/recovery-password/recovery-password.page.html?ngResource ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button text=\"\" icon=\"../../assets/icons/Chevron_Left.svg\"></ion-back-button>\n    </ion-buttons>\n    <ion-title>{{ 'PAGES.RECOVERY_PASSWORD.TITLE' | translate }}</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content forceOverscroll=\"false\">\n\n  <div class=\"content-page\">\n    <form class=\"register\" (ngSubmit)=\"recoveryPass()\" [formGroup]=\"credentials\">\n\n      <div class=\"subtitle\">\n        {{ 'PAGES.RECOVERY_PASSWORD.SUBTITLE' | translate:{value: 6} }}\n      </div>\n\n      <div class=\"input-group\">\n        <ion-item class=\"password\">\n          <ion-label position=\"floating\">{{ 'PAGES.RECOVERY_PASSWORD.PASSWORD' | translate }}</ion-label>\n          <ion-input type=\"password\" enterkeyhint=\"next\" formControlName=\"password\"></ion-input>\n        </ion-item>\n        <ion-item class=\"password\">\n          <ion-label position=\"floating\">{{ 'PAGES.RECOVERY_PASSWORD.PASSWORD_CONFIRM' | translate }}</ion-label>\n          <ion-input type=\"password\" enterkeyhint=\"go\" formControlName=\"passwordConfirm\"></ion-input>\n        </ion-item>\n      </div>\n\n      <ion-button class=\"btn-big\" type=\"submit\" expand=\"block\" fill=\"solid\">{{ 'PAGES.RECOVERY_PASSWORD.BUTTON' | translate }}</ion-button>\n    </form>\n\n      @if (!credentials.valid) {\n          <div>\n              {{credentials.errors}}\n          </div>\n      }\n  </div>\n\n</ion-content>\n";

/***/ }),

/***/ 3723:
/*!****************************************************************!*\
  !*** ./src/app/pages/bio-modal/bio-modal.page.html?ngResource ***!
  \****************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"end\">\n      <ion-button (click)=\"back()\"><ion-icon src=\"/assets/icons/Close.svg\"></ion-icon></ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content forceOverscroll=\"false\">\n\n  <div class=\"content-page modal\">\n    <div class=\"content-center\">\n        @if (faioType === 'finger' || faioType === 'biometric') {\n            <div class=\"icon\">\n                <ion-icon class=\"icon-img\" src=\"/assets/imgs/TouchID.svg\"/>\n            </div>\n        }\n\n        @if (faioType === 'face') {\n            <div class=\"icon\">\n                <ion-icon class=\"icon-img\" src=\"/assets/imgs/FaceID.svg\"/>\n            </div>\n        }\n\n\n        @switch (faioType) {\n            @case ('finger') {\n                <div class=\"header\">{{ 'MODAL_PAGES.BIO.HEADER.TOUCHID' | translate }}</div>\n            }\n            @case ('face') {\n                <div class=\"header\">{{ 'MODAL_PAGES.BIO.HEADER.FACEID' | translate }}</div>\n            }\n            @case ('biometric') {\n                <div class=\"header\">{{ 'MODAL_PAGES.BIO.HEADER.BIOMETRIC' | translate }}</div>\n            }\n        }\n      <div class=\"description\">\n        {{ 'MODAL_PAGES.BIO.DESCRIPTION' | translate }}\n      </div>\n    </div>\n    <div class=\"btn\">\n      <ion-button type=\"button\" expand=\"block\" fill=\"solid\" (click)=\"faioInit()\">{{ 'MODAL_PAGES.BIO.BUTTON' | translate }}</ion-button>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ }),

/***/ 66643:
/*!********************************************************************************!*\
  !*** ./src/app/pages/change-data-modal/change-data-modal.page.html?ngResource ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-title>{{ title }}</ion-title>\n    <ion-buttons slot=\"end\">\n      <ion-button type=\"button\" fill=\"clear\" (click)=\"dismiss()\">\n        <ion-icon src=\"/assets/icons/Close.svg\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n\n  <div class=\"content-page modal\">\n    @if (inputType !== 'checkbox') {\n      <form (ngSubmit)=\"submit()\" [formGroup]=\"credentials\">\n        @if (inputType !== 'password') {\n          <div class=\"input-block\">\n            @if (inputType === 'text') {\n              <ion-item>\n                <ion-input #input formControlName=\"input\" autofocus=\"false\" enterkeyhint=\"enter\"\n                           clear-input=\"true\"></ion-input>\n              </ion-item>\n            }\n            @if (inputType === 'email') {\n              <ion-item>\n                <ion-label position=\"floating\">Email</ion-label>\n                <ion-input\n                    #input\n                    formControlName=\"input\"\n                    autofocus=\"false\"\n                    inputmode=\"email\"\n                    enterkeyhint=\"enter\"\n                    maxlength=\"30\"\n                    clear-input=\"true\"\n                />\n              </ion-item>\n                @if (isEmailLogin()) {\n                    <p class=\"helper-text\">{{ 'MORE.SETTINGS_PAGE.ACCOUNT.HELPER_TEXT_EMAIL' | translate }}</p>\n                }\n            }\n            @if (inputType === 'tel') {\n              <ion-item>\n                <ion-input\n                    #input\n                    (keyup.enter)=\"submit()\"\n                    [maskito]=\"maskPhone\"\n                    [maskitoElement]=\"maskPredicate\"\n                    type=\"tel\"\n                    placeholder=\"+7\"\n                    inputmode=\"tel\"\n                    autocomplete=\"tel\"\n                    enterkeyhint=\"enter\"\n                    formControlName=\"input\"\n                    clear-input=\"true\"\n                />\n              </ion-item>\n                @if (isPhoneLogin()) {\n                    <p class=\"helper-text\">{{ 'MORE.SETTINGS_PAGE.ACCOUNT.HELPER_TEXT_PHONE' | translate }}</p>\n                }\n            }\n            @if (inputType === 'password') {\n              <ion-item>\n                <ion-input\n                    #input\n                    [maskito]=\"maskPhone\"\n                    [maskitoElement]=\"maskPredicate\"\n                    (keyup.enter)=\"submit()\"\n                    type=\"tel\"\n                    placeholder=\"+7\"\