(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_auth_auth_module_ts"],{

/***/ 369:
/*!***************************************************!*\
  !*** ./src/app/pages/auth/auth-routing.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthPageRoutingModule: () => (/* binding */ AuthPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _auth_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./auth.page */ 87059);
/* harmony import */ var _guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../guards/forbidden.guard */ 55887);
/* harmony import */ var _guards_auto_login_guard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../guards/auto-login.guard */ 32869);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */






const routes = [{
  path: '',
  component: _auth_page__WEBPACK_IMPORTED_MODULE_0__.AuthPage
}, {
  path: 'recovery-password',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./recovery-password/recovery-password.module */ 22521)).then(m => m.RecoveryPasswordPageModule),
  canLoad: [_guards_forbidden_guard__WEBPACK_IMPORTED_MODULE_1__.ForbiddenGuard, _guards_auto_login_guard__WEBPACK_IMPORTED_MODULE_2__.AutoLoginGuard]
}];
let AuthPageRoutingModule = class AuthPageRoutingModule {};
AuthPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_5__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_5__.RouterModule]
})], AuthPageRoutingModule);


/***/ }),

/***/ 18472:
/*!*******************************************!*\
  !*** ./src/app/pages/auth/auth.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthPageModule: () => (/* binding */ AuthPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _auth_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./auth-routing.module */ 369);
/* harmony import */ var _auth_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./auth.page */ 87059);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */








let AuthPageModule = class AuthPageModule {};
AuthPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule, _auth_routing_module__WEBPACK_IMPORTED_MODULE_0__.AuthPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_5__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_7__.TranslateModule],
  declarations: [_auth_page__WEBPACK_IMPORTED_MODULE_1__.AuthPage]
})], AuthPageModule);


/***/ }),

/***/ 87059:
/*!*****************************************!*\
  !*** ./src/app/pages/auth/auth.page.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthPage: () => (/* binding */ AuthPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _auth_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./auth.page.html?ngResource */ 58269);
/* harmony import */ var _auth_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./auth.page.scss?ngResource */ 66329);
/* harmony import */ var _auth_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_auth_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var ts_md5__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ts-md5 */ 96466);
/* harmony import */ var _services_global_loading_service_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/global-loading-service.service */ 81854);
/* harmony import */ var _services_authentication_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/authentication.service */ 9214);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @awesome-cordova-plugins/device/ngx */ 90735);
/* harmony import */ var _code_verification_code_verification_page__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../code-verification/code-verification.page */ 79769);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../services/modal.service */ 5455);
/* harmony import */ var _account_verified_account_verified_page__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../account-verified/account-verified.page */ 4439);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../environments/settings */ 79308);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _services_debug_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../services/debug.service */ 33925);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




















let AuthPage = class AuthPage {
  constructor(activeRoute, fb, globalLoadingService, authService, navCtrl, alertCtrl, device, modalCtrl, request, modalService, router, translate, debug) {
    this.activeRoute = activeRoute;
    this.fb = fb;
    this.globalLoadingService = globalLoadingService;
    this.authService = authService;
    this.navCtrl = navCtrl;
    this.alertCtrl = alertCtrl;
    this.device = device;
    this.modalCtrl = modalCtrl;
    this.request = request;
    this.modalService = modalService;
    this.router = router;
    this.translate = translate;
    this.debug = debug;
    this.inputPasswordType = 'password';
    this.method = this.activeRoute.snapshot.paramMap.get('method') || 'register';
    this.login = this.activeRoute.snapshot.paramMap.get('login') || '';
    this.loginType = this.activeRoute.snapshot.paramMap.get('loginType') || '';
  }
  ngOnInit() {
    this.credentials = this.fb.group({
      login: this.login,
      password: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_13__.Validators.minLength(_environments_settings__WEBPACK_IMPORTED_MODULE_11__.MIN_PASSWORD_LENGTH)]]
    });
    if (_environments_settings__WEBPACK_IMPORTED_MODULE_11__.DEMO) {
      this.credentials.get('password').setValue(_environments_settings__WEBPACK_IMPORTED_MODULE_11__.DEMO_PASS);
    }
  }
  ionViewDidEnter() {
    this.input.setFocus();
  }
  get password() {
    return this.credentials.get('password').value;
  }
  togglePassword() {
    if (this.inputPasswordType === 'password') {
      this.inputPasswordType = 'text';
    } else {
      this.inputPasswordType = 'password';
    }
  }
  auth() {
    if (this.password != null) {
      if (this.method === 'register') {
        return this.registration();
      }
      const credentials = {
        login: this.credentials.value.login,
        loginType: this.loginType,
        password: ts_md5__WEBPACK_IMPORTED_MODULE_3__.Md5.hashStr(this.password),
        // eslint-disable-next-line @typescript-eslint/naming-convention
        device_uuid: this.device.uuid || this.debug.deviceUUID
      };
      this.authService.login(credentials).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.filter)(data => data != null)).subscribe();
    }
  }
  registration() {
    var _this = this;
    const credentials = {
      login: this.credentials.value.login,
      loginType: this.loginType,
      password: ts_md5__WEBPACK_IMPORTED_MODULE_3__.Md5.hashStr(this.password),
      device_uuid: this.device.uuid || this.debug.deviceUUID
    };
    this.request.postRequest(this.request.uri.registrationPost(), credentials, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (data.result) {
          yield _this.modalService.openModal({
            component: _code_verification_code_verification_page__WEBPACK_IMPORTED_MODULE_7__.CodeVerificationPage,
            componentProps: {
              loginType: _this.loginType,
              login: _this.login,
              password: ts_md5__WEBPACK_IMPORTED_MODULE_3__.Md5.hashStr(_this.password),
              device_uuid: _this.device.uuid || _this.debug.deviceUUID,
              authData: data
            }
          }).then(modal => {
            modal.onDidDismiss().then(/*#__PURE__*/function () {
              var _ref2 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
                if (result.data) {
                  yield _this.modalService.openModal({
                    component: _account_verified_account_verified_page__WEBPACK_IMPORTED_MODULE_10__.AccountVerifiedPage,
                    componentProps: {
                      loginType: _this.loginType,
                      authData: data
                    }
                  }).then(modal => {
                    modal.onWillDismiss().then(() => {
                      _this.authService.login(credentials).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.filter)(data => data != null)).subscribe();
                    });
                  });
                }
              });
              return function (_x2) {
                return _ref2.apply(this, arguments);
              };
            }());
          });
        } else {
          const alert = yield _this.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this.translate.get("TEXT_STRING.AUTH_FAILED_TITLE")),
            message: data.data.message,
            buttons: ['ОК']
          });
          yield alert.present();
        }
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  openRecoveryPage() {
    var _this2 = this;
    const credentials = {
      login: this.login,
      loginType: this.loginType
    };
    this.request.postRequest(this.request.uri.resetLinkPost(), credentials, {
      useCache: false
    }).subscribe(/*#__PURE__*/function () {
      var _ref3 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (data) {
        if (data.result) {
          yield _this2.modalService.openModal({
            component: _code_verification_code_verification_page__WEBPACK_IMPORTED_MODULE_7__.CodeVerificationPage,
            componentProps: {
              loginType: _this2.loginType,
              login: _this2.login,
              recovery: true,
              authData: data
            }
          }).then(modal => {
            modal.onDidDismiss().then(/*#__PURE__*/function () {
              var _ref4 = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
                if (result.data) {
                  setTimeout(/*#__PURE__*/(0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
                    _this2.navCtrl.navigateForward('/auth/recovery-password', {
                      queryParams: {
                        login: _this2.login,
                        loginType: _this2.loginType
                      }
                    }).then(() => {});
                  }), 200);
                }
              });
              return function (_x4) {
                return _ref4.apply(this, arguments);
              };
            }());
          });
        } else {
          const alert = yield _this2.alertCtrl.create({
            header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this2.translate.get("TEXT_STRING.AUTH_FAILED_TITLE")),
            message: data.message,
            buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_15__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
          });
          yield alert.present();
        }
      });
      return function (_x3) {
        return _ref3.apply(this, arguments);
      };
    }());
  }
  static {
    this.ctorParameters = () => [{
      type: _angular_router__WEBPACK_IMPORTED_MODULE_16__.ActivatedRoute
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_13__.UntypedFormBuilder
    }, {
      type: _services_global_loading_service_service__WEBPACK_IMPORTED_MODULE_4__.GlobalLoadingService
    }, {
      type: _services_authentication_service__WEBPACK_IMPORTED_MODULE_5__.AuthenticationService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_17__.NavController
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_18__.AlertController
    }, {
      type: _awesome_cordova_plugins_device_ngx__WEBPACK_IMPORTED_MODULE_6__.Device
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_18__.ModalController
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_8__.RequestService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_9__.ModalService
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_16__.Router
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_19__.TranslateService
    }, {
      type: _services_debug_service__WEBPACK_IMPORTED_MODULE_12__.DebugService
    }];
  }
  static {
    this.propDecorators = {
      input: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_20__.ViewChild,
        args: ['input']
      }]
    };
  }
};
AuthPage = (0,tslib__WEBPACK_IMPORTED_MODULE_21__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_20__.Component)({
  selector: 'app-auth',
  template: _auth_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_auth_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AuthPage);


/***/ }),

/***/ 66329:
/*!******************************************************!*\
  !*** ./src/app/pages/auth/auth.page.scss?ngResource ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-content .content-page {
  padding: 0 24px 24px 24px;
}
ion-content .content-page .input-group {
  margin-top: 40px;
  margin-bottom: 24px;
}
ion-content .content-page .input-group span {
  font-size: 12px;
  margin-top: 8px;
  display: block;
}
ion-content .content-page .center {
  text-align: center;
  margin-top: 20px;
}
ion-content .content-page .recovery-pass {
  color: var(--ion-color-primary);
  display: inline-block !important;
}
ion-content .content-page .policy {
  font-size: 14px;
  margin-top: 16px;
}
ion-content .content-page .policy ::ng-deep span {
  color: var(--ion-color-primary);
}`, "",{"version":3,"sources":["webpack://./src/app/pages/auth/auth.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAKE;EACE,yBAAA;AAAJ;AAEI;EACE,gBAAA;EACA,mBAAA;AAAN;AAEM;EACE,eAAA;EACA,eAAA;EACA,cAAA;AAAR;AAII;EACE,kBAAA;EACA,gBAAA;AAFN;AAKI;EACE,+BAAA;EACA,gCAAA;AAHN;AAMI;EACE,eAAA;EACA,gBAAA;AAJN;AAMM;EACE,+BAAA;AAJR","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-content {\n  .content-page {\n    padding: 0 24px 24px 24px;\n\n    .input-group {\n      margin-top: 40px;\n      margin-bottom: 24px;\n\n      span {\n        font-size: 12px;\n        margin-top: 8px;\n        display: block;\n      }\n    }\n\n    .center {\n      text-align: center;\n      margin-top: 20px;\n    }\n\n    .recovery-pass {\n      color: var(--ion-color-primary);\n      display: inline-block !important;\n    }\n\n    .policy {\n      font-size: 14px;\n      margin-top: 16px;\n\n      ::ng-deep span {\n        color: var(--ion-color-primary);\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 58269:
/*!******************************************************!*\
  !*** ./src/app/pages/auth/auth.page.html?ngResource ***!
  \******************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n  <ion-toolbar>\n    <ion-buttons slot=\"start\">\n      <ion-back-button text=\"\" icon=\"../../assets/icons/Chevron_Left.svg\"></ion-back-button>\n    </ion-buttons>\n      @if (method === 'login') {\n          <ion-title>{{ 'PAGES.AUTH.TITLE.LOGIN' | translate }}</ion-title>\n      } @else {\n          <ion-title>{{ 'PAGES.AUTH.TITLE.REGISTRATION' | translate }}</ion-title>\n      }\n  </ion-toolbar>\n</ion-header>\n\n<ion-content forceOverscroll=\"false\" scrollX=\"false\">\n\n  <div class=\"content-page\">\n    <form (ngSubmit)=\"auth()\" [formGroup]=\"credentials\">\n\n        @if (method === 'register' && loginType === 'email') {\n            <div\n                class=\"subtitle\"\n                [innerHTML]=\"'PAGES.AUTH.SUBTITLE.EMAIL' | translate:{login}\"\n            ></div>\n        }\n\n        @if (method === 'register' && loginType === 'tel') {\n            <div\n                class=\"subtitle\"\n                [innerHTML]=\"'PAGES.AUTH.SUBTITLE.PHONE' | translate:{login}\"\n            ></div>\n        }\n\n        @if (method === 'login') {\n            <div class=\"subtitle center\">{{login}}</div>\n        }\n\n      <div class=\"input-group\">\n        <ion-item class=\"password\">\n          <ion-input label=\"{{ 'PAGES.AUTH.PASSWORD.TITLE' | translate }}\"\n                     label-placement=\"floating\"\n                     #input\n                     type=\"{{inputPasswordType}}\"\n                     [color]=\"!credentials.valid ? 'danger' : ''\"\n                     autocomplete=\"current-password\"\n                     enterkeyhint=\"go\"\n                     formControlName=\"password\">\n            <ion-button expand=\"block\" fill=\"clear\" (click)=\"togglePassword()\">\n                @if (inputPasswordType === 'password') {\n                    <ion-icon src=\"assets/icons/Eye.svg\"></ion-icon>\n                } @else {\n                    <ion-icon src=\"assets/icons/Eye_Off.svg\"></ion-icon>\n                }\n            </ion-button>\n          </ion-input>\n        </ion-item>\n          @if (method === 'register') {\n              <span>{{ 'PAGES.AUTH.PASSWORD.LABEL' | translate:{value: 6} }}</span>\n          } @else {\n              <span class=\"recovery-pass\" (click)=\"openRecoveryPage()\">{{ 'PAGES.AUTH.PASSWORD.BUTTON' | translate }}</span>\n          }\n      </div>\n\n        @if (method === 'login') {\n            <ion-button\n                class=\"btn-big\"\n                type=\"submit\"\n                expand=\"block\"\n                fill=\"solid\"\n                [disabled]=\"!credentials.valid\"\n            >\n                {{ 'PAGES.AUTH.SUBMIT.LOGIN' | translate }}\n            </ion-button>\n        } @else {\n            <ion-button\n                class=\"btn-big\"\n                type=\"submit\"\n                expand=\"block\"\n                fill=\"solid\"\n                [disabled]=\"!credentials.valid\"\n            >\n                {{ 'PAGES.AUTH.SUBMIT.REGISTRATION' | translate }}\n            </ion-button>\n\n            <div\n                class=\"policy\"\n                [innerHTML]=\"'PAGES.AUTH.POLICY' | translate\"\n            ></div>\n        }\n    </form>\n  </div>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_auth_auth_module_ts.js.map