(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_login_login_module_ts"],{

/***/ 24987:
/*!*****************************************************!*\
  !*** ./src/app/pages/login/login-routing.module.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoginPageRoutingModule: () => (/* binding */ LoginPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _login_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login.page */ 70413);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _login_page__WEBPACK_IMPORTED_MODULE_0__.LoginPage
}];
let LoginPageRoutingModule = class LoginPageRoutingModule {};
LoginPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], LoginPageRoutingModule);


/***/ }),

/***/ 29370:
/*!*********************************************!*\
  !*** ./src/app/pages/login/login.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoginPageModule: () => (/* binding */ LoginPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _login_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login-routing.module */ 24987);
/* harmony import */ var _login_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./login.page */ 70413);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _maskito_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @maskito/angular */ 54483);
/* harmony import */ var _services_login_page_api_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./services/login-page-api.service */ 7657);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */










let LoginPageModule = class LoginPageModule {};
LoginPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _login_routing_module__WEBPACK_IMPORTED_MODULE_0__.LoginPageRoutingModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.ReactiveFormsModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__.TranslateModule, _maskito_angular__WEBPACK_IMPORTED_MODULE_9__.MaskitoModule],
  declarations: [_login_page__WEBPACK_IMPORTED_MODULE_1__.LoginPage],
  providers: [_services_login_page_api_service__WEBPACK_IMPORTED_MODULE_2__.LoginPageApiService]
})], LoginPageModule);


/***/ }),

/***/ 70413:
/*!*******************************************!*\
  !*** ./src/app/pages/login/login.page.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoginPage: () => (/* binding */ LoginPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _login_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login.page.html?ngResource */ 8951);
/* harmony import */ var _login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./login.page.scss?ngResource */ 48267);
/* harmony import */ var _login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @capacitor/preferences */ 46493);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/helper.service */ 54102);
/* harmony import */ var _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/phone-mask.service */ 10449);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../environments/storage */ 12960);
/* harmony import */ var _environments_settings__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../environments/settings */ 79308);
/* harmony import */ var _services_login_page_api_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./services/login-page-api.service */ 7657);
/* harmony import */ var _environments_connection__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../environments/connection */ 48129);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */














let LoginPage = class LoginPage {
  constructor(request, helper, translate, fb, apiService) {
    this.request = request;
    this.helper = helper;
    this.translate = translate;
    this.fb = fb;
    this.apiService = apiService;
    this.loginType = 'email';
    this.org = {
      name: ''
    };
    this.divo = _environments_settings__WEBPACK_IMPORTED_MODULE_7__.DIVO;
    this.isDisabled$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_10__.signal)(true);
    this.maskPhone = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__.maskPhone;
    this.maskPredicate = _services_phone_mask_service__WEBPACK_IMPORTED_MODULE_5__.maskPredicate;
  }
  ngOnInit() {
    this.initCredentialsForm();
    this.setOrgData();
    this.checkFormValid(this.loginType);
  }
  loginTypeChanged(_event) {
    this.loginType = _event.detail.value;
    if (this.loginType === 'email') {
      this.inputEmail.setFocus();
    } else if (this.loginType === 'tel') {
      this.inputTel.setFocus();
    } else {
      this.inputEmail.blur();
      this.inputTel.blur();
    }
    this.checkFormValid(this.loginType);
  }
  checkLogin() {
    const payload = {
      ...this.credentialsFrom.value,
      loginType: this.loginType
    };
    this.apiService.checkLogin(payload);
  }
  checkFormValid(loginType) {
    const mask = this.maskPhone.mask;
    const value = this.credentialsFrom.value[loginType];
    const status = loginType === 'email' ? value.length > 0 : value.length === mask.length;
    this.isDisabled$.set(!status);
  }
  openDoc() {
    const docUrl = (0,_environments_connection__WEBPACK_IMPORTED_MODULE_9__.GET_URL)(false);
    this.helper.openIAP(docUrl);
  }
  initCredentialsForm() {
    this.credentialsFrom = this.fb.group({
      email: [_environments_settings__WEBPACK_IMPORTED_MODULE_7__.DEMO ? _environments_settings__WEBPACK_IMPORTED_MODULE_7__.DEMO_LOGIN : ''],
      tel: ['']
    });
  }
  setOrgData() {
    _capacitor_preferences__WEBPACK_IMPORTED_MODULE_2__.Preferences.get({
      key: _environments_storage__WEBPACK_IMPORTED_MODULE_6__.DIVO_SELECTED_ORG
    }).then(data => {
      this.org = JSON.parse(data.value);
    });
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_11__.TranslateService
    }, {
      type: _angular_forms__WEBPACK_IMPORTED_MODULE_12__.UntypedFormBuilder
    }, {
      type: _services_login_page_api_service__WEBPACK_IMPORTED_MODULE_8__.LoginPageApiService
    }];
  }
  static {
    this.propDecorators = {
      inputEmail: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ViewChild,
        args: ['inputEmail']
      }],
      inputTel: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_10__.ViewChild,
        args: ['inputTel']
      }]
    };
  }
};
LoginPage = (0,tslib__WEBPACK_IMPORTED_MODULE_13__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_10__.Component)({
  selector: 'app-login',
  template: _login_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
  styles: [(_login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1___default())]
})], LoginPage);


/***/ }),

/***/ 7657:
/*!****************************************************************!*\
  !*** ./src/app/pages/login/services/login-page-api.service.ts ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoginPageApiService: () => (/* binding */ LoginPageApiService)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../services/request.service */ 80931);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ngx-translate/core */ 597);









let LoginPageApiService = class LoginPageApiService {
  constructor(alertCtrl, router, request, translate) {
    this.alertCtrl = alertCtrl;
    this.router = router;
    this.request = request;
    this.translate = translate;
  }
  checkLogin(payload) {
    const login = payload[payload.loginType];
    this.request.postRequest(this.request.uri.authCheckLoginPost(), payload, {
      useCache: false
    }).subscribe({
      next: response => {
        const {
          result,
          data
        } = response;
        result ? this.handleCheckLoginOk(login, payload.loginType, data) : this.handleCheckLoginError(data);
      }
    });
  }
  handleCheckLoginOk(login, loginType, data) {
    if (data) {
      this.handleCheckLoginNextPage(login, loginType, 'login');
    } else {
      this.handleCheckLoginNotFound(login, loginType, 'register');
    }
  }
  handleCheckLoginNotFound(login, loginType, method) {
    const control = new _angular_forms__WEBPACK_IMPORTED_MODULE_2__.FormControl(login, _angular_forms__WEBPACK_IMPORTED_MODULE_2__.Validators.email);
    if (loginType === 'email' && control.invalid) {
      this.handleCheckLoginNotEmail();
    } else {
      this.handleCheckLoginNextPage(login, loginType, method);
    }
  }
  handleCheckLoginNextPage(login, loginType, method) {
    this.router.navigate(['/auth', {
      method,
      login,
      loginType
    }]);
  }
  handleCheckLoginNotEmail() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const alert = yield _this.alertCtrl.create({
        header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.lastValueFrom)(_this.translate.get("TEXT_STRING.AUTH_FAILED_TITLE")),
        message: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.lastValueFrom)(_this.translate.get("PAGES.LOGIN.LOGIN_INVALID")),
        buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.lastValueFrom)(_this.translate.get("BUTTONS.OK"))]
      });
      yield alert.present();
    })();
  }
  handleCheckLoginError(data) {
    var _this2 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const {
        message
      } = data;
      if (message) {
        const alert = yield _this2.alertCtrl.create({
          header: yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.lastValueFrom)(_this2.translate.get("TEXT_STRING.AUTH_FAILED_TITLE")),
          message: message,
          buttons: [yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.lastValueFrom)(_this2.translate.get("BUTTONS.OK"))]
        });
        yield alert.present();
      }
    })();
  }
  static {
    this.ctorParameters = () => [{
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AlertController
    }, {
      type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.Router
    }, {
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_1__.RequestService
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__.TranslateService
    }];
  }
};
LoginPageApiService = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Injectable)()], LoginPageApiService);


/***/ }),

/***/ 48267:
/*!********************************************************!*\
  !*** ./src/app/pages/login/login.page.scss?ngResource ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-content {
  --keyboard-offset: 0;
  background-color: var(--ion-background-color);
}
@media (prefers-color-scheme: dark) {
  ion-content {
    background-color: var(--ion-background-color);
  }
}
ion-content ion-input {
  --padding-end: 30px;
}
ion-content ion-input:not(.iconClose) {
  --padding-end: 0px;
}
ion-content ion-input ion-button {
  position: absolute;
  right: 0;
  bottom: 0;
  height: 37px;
  z-index: 99;
}

ion-toolbar ion-buttons {
  max-width: calc(100% - 4px);
}
ion-toolbar ion-buttons ion-back-button {
  max-width: 100%;
  padding: 0;
}
ion-toolbar ion-buttons ion-back-button::part(text) {
  font-size: 16px;
  text-overflow: ellipsis;
  overflow: hidden;
}
ion-toolbar ion-segment {
  width: 100%;
  min-height: 48px;
}

.segment {
  padding: 0 24px;
  max-width: 562px;
  margin: 0 auto;
  width: 100%;
}

.content-page {
  padding: 45px 24px 24px 24px;
}
.content-page .helper-message {
  font-size: 14px;
}
.content-page .helper-message p {
  margin: 0;
}
.content-page .input-group {
  margin-bottom: 24px;
}
.content-page form {
  max-width: 514px;
  width: 100%;
  min-width: 150px;
  margin: 0 auto;
  height: auto;
}
.content-page form .help-btn {
  width: 100%;
  display: flex;
  flex-direction: row;
  justify-content: center;
  padding: 10px 0;
  font-weight: 500;
}
.content-page .background {
  position: fixed;
  bottom: 0;
  right: 0;
  max-height: 50vh;
  z-index: -1;
}
.content-page .background .home-standard {
  display: contents;
}
.content-page .background .home-landscape {
  display: none;
}
@media screen and (min-width: 600px) {
  .content-page .background {
    min-width: 820px;
    left: 0;
  }
  .content-page .background .home-standard {
    display: none;
  }
  .content-page .background .home-landscape {
    display: contents;
  }
}`, "",{"version":3,"sources":["webpack://./src/app/pages/login/login.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,oBAAA;EAGA,6CAAA;AADF;AAGE;EANF;IAQI,6CAAA;EADF;AACF;AAGE;EACE,mBAAA;AADJ;AAGI;EACE,kBAAA;AADN;AAII;EACE,kBAAA;EACA,QAAA;EACA,SAAA;EACA,YAAA;EACA,WAAA;AAFN;;AAaE;EACE,2BAAA;AAVJ;AAYI;EACE,eAAA;EACA,UAAA;AAVN;AAYM;EACE,eAAA;EACA,uBAAA;EACA,gBAAA;AAVR;AAeE;EAEE,WAAA;EACA,gBAAA;AAdJ;;AAsBA;EACE,eAAA;EACA,gBAAA;EACA,cAAA;EACA,WAAA;AAnBF;;AAsBA;EACE,4BAAA;AAnBF;AAqBE;EACE,eAAA;AAnBJ;AAqBI;EACE,SAAA;AAnBN;AAuBE;EACE,mBAAA;AArBJ;AAwBE;EACE,gBAAA;EACA,WAAA;EACA,gBAAA;EACA,cAAA;EACA,YAAA;AAtBJ;AAwBI;EACE,WAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,eAAA;EACA,gBAAA;AAtBN;AA0BE;EACE,eAAA;EACA,SAAA;EACA,QAAA;EACA,gBAAA;EACA,WAAA;AAxBJ;AA0BI;EACE,iBAAA;AAxBN;AA2BI;EACE,aAAA;AAzBN;AA4BI;EAfF;IAgBI,gBAAA;IACA,OAAA;EAzBJ;EA2BI;IACE,aAAA;EAzBN;EA4BI;IACE,iBAAA;EA1BN;AACF","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-content {\n  --keyboard-offset: 0;\n\n  //--background: bottom / contain no-repeat url('../../../assets/imgs/Home_Light.svg');\n  background-color: var(--ion-background-color);\n\n  @media (prefers-color-scheme: dark) {\n    //--background: bottom / contain no-repeat url('../../../assets/imgs/Home_Dark.svg');\n    background-color: var(--ion-background-color);\n  }\n\n  ion-input {\n    --padding-end: 30px;\n\n    &:not(.iconClose) {\n      --padding-end: 0px;\n    }\n\n    ion-button {\n      position: absolute;\n      right: 0;\n      bottom: 0;\n      height: 37px;\n      z-index: 99;\n    }\n  }\n}\n\nion-toolbar {\n  ion-title {\n    //padding-left: 24px;\n    //padding-right: 24px;\n  }\n\n  ion-buttons {\n    max-width: calc(100% - 4px);\n\n    ion-back-button {\n      max-width: 100%;\n      padding: 0;\n\n      &::part(text) {\n        font-size: 16px;\n        text-overflow: ellipsis;\n        overflow: hidden;\n      }\n    }\n  }\n\n  ion-segment {\n    //--background: var(--segment-background);\n    width: 100%;\n    min-height: 48px;\n\n    //font-size: var(--font-size-subtitle-2);\n    //font-weight: var(--font-weight-subtitle-2);\n    //color: var(--font-color-primary);\n  }\n}\n\n.segment {\n  padding: 0 24px;\n  max-width: 562px;\n  margin: 0 auto;\n  width: 100%;\n}\n\n.content-page {\n  padding: 45px 24px 24px 24px;\n\n  .helper-message {\n    font-size: 14px;\n\n    p {\n      margin: 0;\n    }\n  }\n\n  .input-group {\n    margin-bottom: 24px;\n  }\n\n  form {\n    max-width: 514px;\n    width: 100%;\n    min-width: 150px;\n    margin: 0 auto;\n    height: auto;\n\n    .help-btn {\n      width: 100%;\n      display: flex;\n      flex-direction: row;\n      justify-content: center;\n      padding: 10px 0;\n      font-weight: 500;\n    }\n  }\n\n  .background {\n    position: fixed;\n    bottom: 0;\n    right: 0;\n    max-height: 50vh;\n    z-index: -1;\n\n    .home-standard {\n      display: contents;\n    }\n\n    .home-landscape {\n      display: none;\n    }\n\n    @media screen and (min-width: 600px) {\n      min-width: 820px;\n      left: 0;\n\n      .home-standard {\n        display: none;\n      }\n\n      .home-landscape {\n        display: contents;\n      }\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 8951:
/*!********************************************************!*\
  !*** ./src/app/pages/login/login.page.html?ngResource ***!
  \********************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n    @if (divo) {\n        <ion-toolbar>\n            <ion-buttons slot=\"start\">\n                <ion-back-button defaultHref=\"/select-org\" text=\"{{ 'PAGES.LOGIN.BUTTON_SELECT_ORG' | translate:{value: org.name} }}\"></ion-back-button>\n            </ion-buttons>\n        </ion-toolbar>\n    }\n  <ion-toolbar>\n    <ion-title>{{ 'PAGES.LOGIN.TITLE' | translate }}</ion-title>\n  </ion-toolbar>\n  <ion-toolbar>\n      @if (helper.authByPhone.value) {\n          <div class=\"segment\">\n              <ion-segment value=\"email\" (ionChange)=\"loginTypeChanged($event)\">\n                  <ion-segment-button value=\"email\">\n                      <ion-label>{{ 'PAGES.LOGIN.SEGMENT_EMAIL' | translate }}</ion-label>\n                  </ion-segment-button>\n                  <ion-segment-button value=\"tel\">\n                      <ion-label>{{ 'PAGES.LOGIN.SEGMENT_PHONE' | translate }}</ion-label>\n                  </ion-segment-button>\n              </ion-segment>\n          </div>\n      }\n  </ion-toolbar>\n</ion-header>\n\n<ion-content forceOverscroll=\"false\">\n\n  <div class=\"content-page\">\n    <form (ngSubmit)=\"checkLogin()\" [formGroup]=\"credentialsFrom\">\n        <div class=\"helper-message\">\n            <p [innerHtml]=\"translate.instant('PAGES.LOGIN.HELPERS.' + loginType.toUpperCase())\"></p>\n        </div>\n      <div class=\"input-group\">\n        <ion-item class=\"login\" [hidden]=\"loginType !== 'email'\">\n          <ion-input label=\"{{ 'PAGES.LOGIN.LABEL_EMAIL' | translate }}\"\n                     label-placement=\"floating\"\n                     #inputEmail\n                     (keyup.enter)=\"checkLogin()\"\n                     (ionInput)=\"checkFormValid(loginType)\"\n                     type=\"email\"\n                     inputmode=\"email\"\n                     autocomplete=\"email\"\n                     enterkeyhint=\"enter\"\n                     formControlName=\"email\"\n                     class=\"iconClose\">\n              @if (credentialsFrom.get('email').value != '') {\n                  <ion-button\n                      expand=\"block\"\n                      fill=\"clear\"\n                      (click)=\"credentialsFrom.get('email').setValue('')\"\n                  >\n                      <ion-icon src=\"assets/icons/Close_Circle.svg\" />\n                  </ion-button>\n              }\n           </ion-input>\n        </ion-item>\n        <ion-item class=\"login\" [hidden]=\"loginType !== 'tel'\">\n          <ion-input\n                  label=\"{{ 'PAGES.LOGIN.LABEL_PHONE' | translate }}\"\n                  label-placement=\"floating\"\n                  #inputTel\n                  (keyup.enter)=\"checkLogin()\"\n                  [maskito]=\"maskPhone\"\n                  [maskitoElement]=\"maskPredicate\"\n                  (ionInput)=\"checkFormValid(loginType)\"\n                  placeholder=\"+7\"\n                  type=\"tel\"\n                  inputmode=\"tel\"\n                  autocomplete=\"tel\"\n                  enterkeyhint=\"enter\"\n                  formControlName=\"tel\"\n                  class=\"iconClose\"\n          >\n              @if (credentialsFrom.get('tel').value != '') {\n                  <ion-button\n                          expand=\"block\"\n                          fill=\"clear\"\n                          (click)=\"credentialsFrom.get('tel').setValue('')\"\n                  >\n                      <ion-icon src=\"assets/icons/Close_Circle.svg\"/>\n                  </ion-button>\n              }\n          </ion-input>\n        </ion-item>\n      </div>\n\n      <ion-button [disabled]=\"isDisabled$()\" class=\"btn-big\" type=\"submit\" expand=\"block\" fill=\"solid\">{{ 'PAGES.LOGIN.BUTTON' | translate }}</ion-button>\n\n        <div class=\"help-btn\">\n            <a (click)=\"openDoc()\">{{ 'MORE.HELP' | translate }}</a>\n        </div>\n\n\n    </form>\n\n    <div class=\"background\">\n      <ion-icon class=\"icon-img home-standard\" src=\"/assets/imgs/Home.svg\"></ion-icon>\n      <ion-icon class=\"icon-img home-landscape\" src=\"/assets/imgs/Home_Landscape.svg\"></ion-icon>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_login_login_module_ts.js.map