(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_tabs_payment_payment_module_ts"],{

/***/ 3122:
/*!**************************************************************!*\
  !*** ./src/app/pages/tabs/payment/payment-routing.module.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaymentPageRoutingModule: () => (/* binding */ PaymentPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 95072);
/* harmony import */ var _payment_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./payment.page */ 91156);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */




const routes = [{
  path: '',
  component: _payment_page__WEBPACK_IMPORTED_MODULE_0__.PaymentPage
}, {
  path: 'help',
  loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./help/help.module */ 93608)).then(m => m.HelpPageModule)
}, {
  path: 'history-and-kvit',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_tabs_payment_history-and-kvit_history-and-kvit_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./history-and-kvit/history-and-kvit.module */ 65192)).then(m => m.HistoryAndKvitPageModule)
}, {
  path: 'pay-receipt',
  loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("common"), __webpack_require__.e("src_app_pages_tabs_payment_pay-receipt_pay-receipt_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pay-receipt/pay-receipt.module */ 16960)).then(m => m.PayReceiptPageModule)
}];
let PaymentPageRoutingModule = class PaymentPageRoutingModule {};
PaymentPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], PaymentPageRoutingModule);


/***/ }),

/***/ 37595:
/*!******************************************************!*\
  !*** ./src/app/pages/tabs/payment/payment.module.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaymentPageModule: () => (/* binding */ PaymentPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 60316);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 34456);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 21507);
/* harmony import */ var _payment_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./payment-routing.module */ 3122);
/* harmony import */ var _payment_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./payment.page */ 91156);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../pipes/active-ls/active-ls */ 61863);
/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */









let PaymentPageModule = class PaymentPageModule {};
PaymentPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule, _payment_routing_module__WEBPACK_IMPORTED_MODULE_0__.PaymentPageRoutingModule, _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__.TranslateModule, _pipes_active_ls_active_ls__WEBPACK_IMPORTED_MODULE_2__.ActiveLsPipe],
  declarations: [_payment_page__WEBPACK_IMPORTED_MODULE_1__.PaymentPage]
})], PaymentPageModule);


/***/ }),

/***/ 91156:
/*!****************************************************!*\
  !*** ./src/app/pages/tabs/payment/payment.page.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaymentPage: () => (/* binding */ PaymentPage)
/* harmony export */ });
/* harmony import */ var D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 89204);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! tslib */ 24398);
/* harmony import */ var _payment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./payment.page.html?ngResource */ 8708);
/* harmony import */ var _payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./payment.page.scss?ngResource */ 5458);
/* harmony import */ var _payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 37580);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! rxjs */ 5342);
/* harmony import */ var _services_request_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../services/request.service */ 80931);
/* harmony import */ var _services_helper_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../services/helper.service */ 54102);
/* harmony import */ var _services_modal_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../services/modal.service */ 5455);
/* harmony import */ var _help_help_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./help/help.page */ 39955);
/* harmony import */ var _services_app_theme_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../services/app-theme.service */ 43017);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ionic/angular */ 4059);
/* harmony import */ var _environments_storage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../environments/storage */ 12960);
/* harmony import */ var _pay_receipt_pay_modal_pay_modal_page__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./pay-receipt/pay-modal/pay-modal.page */ 39279);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs/operators */ 51567);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs/operators */ 89475);
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @ngx-translate/core */ 597);
/* harmony import */ var _types_livePaysType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../types/livePaysType */ 54455);

/*
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
















let PaymentPage = class PaymentPage {
  constructor(request, helper, appTheme, modalService, navCtrl, translate) {
    this.request = request;
    this.helper = helper;
    this.appTheme = appTheme;
    this.modalService = modalService;
    this.navCtrl = navCtrl;
    this.translate = translate;
    this.loading$ = (0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.signal)(false);
    this.refresher = null;
    this.enablePayment = {
      status: true,
      title: '',
      message: ''
    };
    this.livePay = true;
    this.totalAmount = 0;
  }
  ngOnInit() {
    this.request.getStorageWithLS(_environments_storage__WEBPACK_IMPORTED_MODULE_8__.PAYMENTS, this.request.payments).then(() => {
      if (this.request.payments.value[this.request.activeLs.value]) {
        this.selectGateway = Object.keys(this.request.payments.value[this.request.activeLs.value].gateway)[0];
        this.calculate();
      }
      this.timerLoad = setTimeout(() => {
        this.loading$.set(true);
      }, 100);
      this.loadData(true).then(() => {
        clearTimeout(this.timerLoad);
        this.loading$.set(false);
      });
    });
  }
  ionViewWillEnter() {
    var _this = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.enablePayment.title = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_12__.lastValueFrom)(_this.translate.get('PAYMENT.PAY_DISABLED.TITLE'));
      _this.enablePayment.message = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_12__.lastValueFrom)(_this.translate.get('PAYMENT.PAY_DISABLED.MESSAGE'));
      if (_this.request.payments.value[_this.request.activeLs.value] && _this.request.payments.value[_this.request.activeLs.value].type_pay === 4) {
        _this.changeLivePays(!(_this.request.nachislenieZaTekMesiac.value[_this.request.activeLs.value] == _types_livePaysType__WEBPACK_IMPORTED_MODULE_10__.LivePaysEnum.PAYS));
      }
    })();
  }
  ionViewDidEnter() {
    if (this.helper.availablePayment.value) {
      if (this.request.payments.value[this.request.activeLs.value]) {
        if (this.request.payments.value[this.request.activeLs.value].type_pay === 1) {
          setTimeout(() => {
            document.querySelector('body').classList.add('tab-bar-alternative-color');
          }, 0);
        }
        this.calculate();
      } else {
        this.subForTabStyle = this.request.payments.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_13__.filter)(value => !!value[this.request.activeLs.value])).subscribe(value => {
          this.calculate();
          if (value[this.request.activeLs.value].type_pay === 1) {
            setTimeout(() => {
              document.querySelector('body').classList.add('tab-bar-alternative-color');
            }, 0);
          }
          try {
            this.subForTabStyle.unsubscribe();
          } catch (e) {}
        });
      }
      setTimeout(() => {
        if (!this.request.payments.value[this.request.activeLs.value] && !this.loading$()) {
          this.loading$.set(true);
          this.loadData().finally(() => {
            clearTimeout(this.timerLoad);
            this.loading$.set(false);
          });
        }
      }, 100);
    }
  }
  ionViewWillLeave() {
    document.querySelector('body').classList.remove('tab-bar-alternative-color');
    try {
      this.subForTabStyle.unsubscribe();
    } catch (e) {}
  }
  scroll(event) {
    if (event.detail.scrollTop >= 0 && this.appTheme.prefers === 'light') {
      this.toolbar.el.setAttribute('style', 'box-shadow: 0 0 40px rgba(104, 122, 147, min(' + event.detail.scrollTop / 100 + ', .48))');
    } else if (event.detail.scrollTop < 0 && this.appTheme.prefers === 'light') {
      this.toolbar.el.setAttribute('style', 'box-shadow: 0 0 40px rgba(104, 122, 147, min(' + 0 / 100 + ', .48))');
    }
  }
  doRefresh(_event) {
    this.loadData(_event.target).finally(() => {
      this.refresher = null;
      _event.target.complete();
    });
    this.refresher = _event.target;
  }
  loadData(refresher) {
    var _this2 = this;
    return new Promise(resolve => {
      if (this.refresher) {
        this.refresher.complete();
        this.refresher = null;
      }
      // Выполняем запрос
      this.request.getRequest(this.request.uri.paymentsGet(), {
        preloader: false,
        forceUpdateCache: refresher
      }).pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_14__.finalize)(() => {
        resolve(true);
      })).subscribe(/*#__PURE__*/function () {
        var _ref = (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (result) {
          try {
            if (result.result) {
              // Вызываем функцию коллбэк
              yield _this2.request.loadPaymentsCallback()(result);
              _this2.gateway = result.gateway;
              _this2.selectGateway = Object.keys(result.gateway)[0];
              _this2.enablePayment.status = true;
              _this2.calculate();
            } else {
              // Вызываем функцию коллбэк
              yield _this2.request.loadPaymentsCallback()(result);
              _this2.enablePayment = {
                status: false,
                title: result.title || _this2.enablePayment.title,
                message: result.message || _this2.enablePayment.message
              };
              _this2.request.payments.next({});
            }
          } catch (e) {}
        });
        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
    });
  }
  calculate() {
    if (!!this.request.payments.value && this.request.payments.value[this.request.activeLs.value] && this.request.payments.value[this.request.activeLs.value].type_pay === 1) {
      this.totalAmount = this.helper.paySumRound(this.request.payments.value[this.request.activeLs.value].summ + this.request.payments.value[this.request.activeLs.value].peni);
    }
  }
  openHelpPage() {
    var _this3 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this3.modalService.openModal({
        component: _help_help_page__WEBPACK_IMPORTED_MODULE_6__.HelpPage,
        componentProps: {
          gateway: _this3.gateway[_this3.selectGateway]
        }
      });
    })();
  }
  goToMainPage() {
    var _this4 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this4.navCtrl.navigateRoot('/tabs/main', {
        replaceUrl: true
      });
    })();
  }
  object() {
    return Object;
  }
  openPayHistory() {
    var _this5 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this5.navCtrl.navigateForward('/tabs/payment/history-and-kvit');
    })();
  }
  openPayReceiptPage(payment) {
    var _this6 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this6.navCtrl.navigateForward('/tabs/payment/pay-receipt', {
        queryParams: {
          payment
        }
      });
    })();
  }
  openPayModal() {
    var _this7 = this;
    return (0,D_progr_mobileappv3_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const payment = _this7.request.payments.value[_this7.request.activeLs.value];
      yield _this7.modalService.openModal({
        component: _pay_receipt_pay_modal_pay_modal_page__WEBPACK_IMPORTED_MODULE_9__.PayModalPage,
        componentProps: {
          payType: 1,
          sum: payment.summ,
          peni: payment.peni,
          availableGateway: Object.keys(payment.gateway),
          payment
        }
      });
    })();
  }
  changeLivePays(value) {
    let nachislenieZaTekMesiac = this.request.nachislenieZaTekMesiac.value;
    if (value) {
      nachislenieZaTekMesiac[this.request.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_10__.LivePaysEnum.PAYS_ACCRUALS;
      this.livePay = true;
    } else {
      nachislenieZaTekMesiac[this.request.activeLs.value] = _types_livePaysType__WEBPACK_IMPORTED_MODULE_10__.LivePaysEnum.PAYS;
      this.livePay = false;
    }
    this.request.nachislenieZaTekMesiac.next(nachislenieZaTekMesiac);
  }
  static {
    this.ctorParameters = () => [{
      type: _services_request_service__WEBPACK_IMPORTED_MODULE_3__.RequestService
    }, {
      type: _services_helper_service__WEBPACK_IMPORTED_MODULE_4__.HelperService
    }, {
      type: _services_app_theme_service__WEBPACK_IMPORTED_MODULE_7__.AppThemeService
    }, {
      type: _services_modal_service__WEBPACK_IMPORTED_MODULE_5__.ModalService
    }, {
      type: _ionic_angular__WEBPACK_IMPORTED_MODULE_15__.NavController
    }, {
      type: _ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__.TranslateService
    }];
  }
  static {
    this.propDecorators = {
      toolbar: [{
        type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild,
        args: ['toolbar']
      }]
    };
  }
};
PaymentPage = (0,tslib__WEBPACK_IMPORTED_MODULE_17__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
  selector: 'app-payment',
  template: _payment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], PaymentPage);


/***/ }),

/***/ 5458:
/*!*****************************************************************!*\
  !*** ./src/app/pages/tabs/payment/payment.page.scss?ngResource ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 53142);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ 35950);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `@charset "UTF-8";
/*!
 * Copyright (c) 2022. Группа компаний "СТЕК". Все права защищены. Разработчик: Чуриков Антон Алексеевич
 */
ion-toolbar {
  box-shadow: 0 0 40px rgba(104, 122, 147, 0);
}
ion-toolbar:not(.toolbar-loading) ion-title {
  padding-inline: 24px 50px !important;
}

ion-content .content-page .description {
  padding: 0 24px 8px 24px;
  font-size: 16px;
}
ion-content .content-page .ls-number {
  color: var(--font-color-secondary);
  font-size: 12px;
  margin: 16px 24px 0 24px;
}
ion-content .content-page .no-content {
  margin-top: 16px;
}
ion-content .content-page .disabled-payment {
  padding: 0 24px;
  display: flex;
  flex-direction: column;
  flex-grow: 1;
  justify-content: center;
}
ion-content .content-page .disabled-payment .header {
  font-size: 28px;
  font-weight: 500;
  text-align: center;
  margin-bottom: 24px;
}
ion-content .content-page .disabled-payment .text {
  font-size: 16px;
  color: var(--font-color-secondary);
  line-height: 24px;
  margin: 0;
  text-align: center;
  width: 100%;
}
ion-content .content-page .disabled-payment ion-button {
  margin-bottom: 24px;
}
ion-content .content-page ion-card ion-card-header ion-card-title {
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-weight: normal;
}
ion-content .content-page ion-card .reading-card-header {
  display: flex;
  align-items: stretch;
}
ion-content .content-page ion-card .reading-card-header .reading-card-icon {
  border-radius: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  background: var(--ion-color-primary-lighten-4);
  margin: 16px 0 16px 16px;
}
ion-content .content-page ion-card .reading-card-header .reading-card-icon .icon-block {
  width: 48px !important;
  height: 48px !important;
}
ion-content .content-page ion-card .reading-card-header ion-card-header {
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  flex-grow: 1;
}
ion-content .content-page ion-card .reading-card-header ion-card-header ion-card-title {
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-weight: normal;
}
ion-content .content-page ion-card .reading-card-header ion-card-header ion-card-title ion-icon {
  width: 24px;
  height: 24px;
  color: var(--ion-color-success);
}
ion-content .content-page ion-card .reading-card-header ion-card-header ion-card-subtitle {
  font-size: 12px;
}
ion-content .content-page .ion-card-type1 .header {
  font-size: 20px;
  font-weight: 400;
  color: var(--font-color-primary);
  display: flex;
  justify-content: space-between;
  padding: 16px;
}
ion-content .content-page .ion-card-type1 .header .sum {
  white-space: nowrap;
}
ion-content .content-page .ion-card-type1 .list {
  color: var(--font-color-secondary);
  display: flex;
  justify-content: space-between;
  padding: 8px 16px;
}
ion-content .content-page .ion-card-type1 .list .sum {
  color: var(--font-color-primary);
  white-space: nowrap;
}
ion-content .content-page .ion-card-type1 hr {
  margin: 0;
  margin-top: 8px;
  height: 0;
  border: none;
  border-top: 2px dashed var(--color-separate);
  background: none;
}
ion-content .content-page .ion-card-type1 .total {
  font-size: 20px;
  font-weight: 500;
  color: var(--font-color-primary);
  display: flex;
  justify-content: space-between;
  padding: 16px;
}
ion-content .content-page .ion-card-type1 .total .sum {
  white-space: nowrap;
}
ion-content .content-page .paymentEnabled {
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}
ion-content .content-page .paymentEnabled .paymentLoad {
  flex-grow: 1;
  display: flex;
  flex-direction: column;
}
ion-content .content-page .paymentEnabled .paymentLoad .paymentType1 {
  flex-grow: 1;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}
ion-content .includePayBtn {
  padding-bottom: calc(var(--ion-safe-area-bottom) + 143px);
}
ion-content .payBtn {
  bottom: 0;
  left: 0;
  right: 0;
  backdrop-filter: saturate(210%) blur(20px);
  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);
  padding: 24px calc(max((100% - 562px) / 2, 0px) + 24px) calc(74px + var(--ion-safe-area-bottom)) calc(max((100% - 562px) / 2, 0px) + 24px);
  border-radius: 16px 16px 0 0;
}
ion-content .payBtn .payment {
  margin: 0;
}`, "",{"version":3,"sources":["webpack://./src/app/pages/tabs/payment/payment.page.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAAhB;;EAAA;AAIA;EACE,2CAAA;AACF;AAEI;EACE,oCAAA;AAAN;;AAQI;EACE,wBAAA;EACA,eAAA;AALN;AAQI;EACE,kCAAA;EACA,eAAA;EACA,wBAAA;AANN;AASI;EACE,gBAAA;AAPN;AAUI;EACE,eAAA;EACA,aAAA;EACA,sBAAA;EACA,YAAA;EACA,uBAAA;AARN;AAUM;EACE,eAAA;EACA,gBAAA;EACA,kBAAA;EACA,mBAAA;AARR;AAWM;EACE,eAAA;EAEA,kCAAA;EACA,iBAAA;EACA,SAAA;EACA,kBAAA;EACA,WAAA;AAVR;AAaM;EACE,mBAAA;AAXR;AAiBQ;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;AAfV;AAsBM;EACE,aAAA;EACA,oBAAA;AApBR;AAqBQ;EACE,kBAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,8CAAA;EACA,wBAAA;AAnBV;AAoBU;EACE,sBAAA;EACA,uBAAA;AAlBZ;AAqBQ;EACE,aAAA;EACA,sBAAA;EACA,8BAAA;EACA,YAAA;AAnBV;AAoBU;EACE,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,mBAAA;AAlBZ;AAmBY;EACE,WAAA;EACA,YAAA;EACA,+BAAA;AAjBd;AAoBU;EACE,eAAA;AAlBZ;AAyBM;EACE,eAAA;EACA,gBAAA;EACA,gCAAA;EACA,aAAA;EACA,8BAAA;EACA,aAAA;AAvBR;AA2BQ;EACE,mBAAA;AAzBV;AA4BM;EACE,kCAAA;EACA,aAAA;EACA,8BAAA;EACA,iBAAA;AA1BR;AA8BQ;EACE,gCAAA;EACA,mBAAA;AA5BV;AA+BM;EACE,SAAA;EACA,eAAA;EACA,SAAA;EACA,YAAA;EACA,4CAAA;EACA,gBAAA;AA7BR;AA+BM;EACE,eAAA;EACA,gBAAA;EACA,gCAAA;EACA,aAAA;EACA,8BAAA;EACA,aAAA;AA7BR;AAiCQ;EACE,mBAAA;AA/BV;AAoCI;EACE,YAAA;EACA,aAAA;EACA,sBAAA;AAlCN;AAmCM;EACE,YAAA;EACA,aAAA;EACA,sBAAA;AAjCR;AAkCQ;EACE,YAAA;EACA,aAAA;EACA,sBAAA;EACA,8BAAA;AAhCV;AA+CE;EACE,yDAAA;AA7CJ;AAgDE;EACE,SAAA;EACA,OAAA;EACA,QAAA;EACA,0CAAA;EACA,8CAAA;EACA,0IAAA;EACA,4BAAA;AA9CJ;AAgDI;EACE,SAAA;AA9CN","sourcesContent":["/*!\n * Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n */\n\nion-toolbar {\n  box-shadow: 0 0 40px rgba(104, 122, 147, 0);\n\n  &:not(.toolbar-loading) {\n    ion-title {\n      padding-inline: 24px 50px !important;\n    }\n  }\n}\n\nion-content {\n  .content-page {\n    //padding: 0 24px;\n    .description {\n      padding: 0 24px 8px 24px;\n      font-size: 16px;\n    }\n\n    .ls-number {\n      color: var(--font-color-secondary);\n      font-size: 12px;\n      margin: 16px 24px 0 24px;\n    }\n\n    .no-content {\n      margin-top: 16px;\n    }\n\n    .disabled-payment {\n      padding: 0 24px;\n      display: flex;\n      flex-direction: column;\n      flex-grow: 1;\n      justify-content: center;\n\n      .header {\n        font-size: 28px;\n        font-weight: 500;\n        text-align: center;\n        margin-bottom: 24px;\n      }\n\n      .text {\n        font-size: 16px;\n        //flex-grow: 1;\n        color: var(--font-color-secondary);\n        line-height: 24px;\n        margin: 0;\n        text-align: center;\n        width: 100%;\n      }\n\n      ion-button {\n        margin-bottom: 24px;\n      }\n    }\n\n    ion-card {\n      ion-card-header {\n        ion-card-title {\n          display: flex;\n          justify-content: space-between;\n          align-items: center;\n          font-weight: normal;\n        }\n      }\n    }\n\n    ion-card {\n      //padding: 16px;\n      .reading-card-header {\n        display: flex;\n        align-items: stretch;\n        .reading-card-icon {\n          border-radius: 8px;\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          background: var(--ion-color-primary-lighten-4);\n          margin: 16px 0 16px 16px;\n          .icon-block {\n            width: 48px !important;\n            height: 48px !important;\n          }\n        }\n        ion-card-header {\n          display: flex;\n          flex-direction: column;\n          justify-content: space-between;\n          flex-grow: 1;\n          ion-card-title {\n            display: flex;\n            justify-content: space-between;\n            align-items: center;\n            font-weight: normal;\n            ion-icon {\n              width: 24px;\n              height: 24px;\n              color: var(--ion-color-success);\n            }\n          }\n          ion-card-subtitle {\n            font-size: 12px;\n          }\n        }\n      }\n    }\n\n    .ion-card-type1 {\n      .header {\n        font-size: 20px;\n        font-weight: 400;\n        color: var(--font-color-primary);\n        display: flex;\n        justify-content: space-between;\n        padding: 16px;\n        .name {\n\n        }\n        .sum {\n          white-space: nowrap;\n        }\n      }\n      .list {\n        color: var(--font-color-secondary);\n        display: flex;\n        justify-content: space-between;\n        padding: 8px 16px;\n        .name {\n\n        }\n        .sum {\n          color: var(--font-color-primary);\n          white-space: nowrap;\n        }\n      }\n      hr {\n        margin: 0;\n        margin-top: 8px;\n        height: 0;\n        border: none;\n        border-top: 2px dashed var(--color-separate);\n        background: none;\n      }\n      .total {\n        font-size: 20px;\n        font-weight: 500;\n        color: var(--font-color-primary);\n        display: flex;\n        justify-content: space-between;\n        padding: 16px;\n        .name {\n\n        }\n        .sum {\n          white-space: nowrap;\n        }\n      }\n    }\n\n    .paymentEnabled {\n      flex-grow: 1;\n      display: flex;\n      flex-direction: column;\n      .paymentLoad {\n        flex-grow: 1;\n        display: flex;\n        flex-direction: column;\n        .paymentType1 {\n          flex-grow: 1;\n          display: flex;\n          flex-direction: column;\n          justify-content: space-between;\n          //.payBtn {\n          //  background: var(--ion-card-background);\n          //  box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);\n          //  padding: 24px;\n          //  border-radius: 16px 16px 0 0;\n          //  .payment {\n          //    margin: 0;\n          //  }\n          //}\n        }\n      }\n    }\n  }\n\n  .includePayBtn {\n    padding-bottom: calc(var(--ion-safe-area-bottom) + 143px);\n  }\n\n  .payBtn {\n    bottom: 0;\n    left: 0;\n    right: 0;\n    backdrop-filter: saturate(210%) blur(20px);\n    box-shadow: 0 0 24px rgba(104, 122, 147, 0.16);\n    padding: 24px calc(max(((100% - 562px)/2), 0px) + 24px) calc(24px + 50px + var(--ion-safe-area-bottom)) calc(max(((100% - 562px)/2), 0px) + 24px);\n    border-radius: 16px 16px 0 0;\n\n    .payment {\n      margin: 0;\n    }\n  }\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 8708:
/*!*****************************************************************!*\
  !*** ./src/app/pages/tabs/payment/payment.page.html?ngResource ***!
  \*****************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!--\n  ~ Copyright (c) 2022. Группа компаний \"СТЕК\". Все права защищены. Разработчик: Чуриков Антон Алексеевич\n  -->\n\n<ion-header class=\"ion-no-border\">\n    @if (loading$()) {\n        <ion-toolbar class=\"toolbar-loading\" #toolbar>\n            <ion-title>\n                <div class=\"header-fullscreen\">\n                    <div class=\"title\">\n                        <ion-spinner></ion-spinner> {{ 'UPDATING' | translate }}\n                    </div>\n                </div>\n            </ion-title>\n        </ion-toolbar>\n    } @else {\n        <ion-toolbar #toolbar>\n            <ion-title class=\"fullscreen\">\n                <div class=\"header-fullscreen\">\n                    <div class=\"title\">\n                        {{ 'PAYMENT.HEADER' | translate }}\n                    </div>\n                </div>\n            </ion-title>\n\n            <ion-buttons slot=\"end\" [hidden]=\"!enablePayment.status\">\n                <ion-button (click)=\"openHelpPage()\">\n                    <ion-icon src=\"/assets/icons/Help.svg\"></ion-icon>\n                </ion-button>\n            </ion-buttons>\n        </ion-toolbar>\n    }\n</ion-header>\n\n<ion-content scroll-events=\"true\" (ionScroll)=\"scroll($event)\">\n\n  <ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n    @if (!helper.availablePayment.value) {\n        <div class=\"content-page\">\n            <ion-card>\n                <div class=\"reading-card-header\">\n                    <ion-card-header>\n                        <ion-card-title>{{ 'PAYMENT.DISABLED' | translate }}</ion-card-title>\n                    </ion-card-header>\n                </div>\n            </ion-card>\n        </div>\n    } @else {\n        <div\n            class=\"content-page\"\n            [ngClass]=\"enablePayment.status && request.payments.value[request.activeLs.value] && request.payments.value[request.activeLs.value].type_pay === 1 ? 'includePayBtn' : ''\"\n        >\n            @if (request.payments.value[request.activeLs.value] && enablePayment.status) {\n                <div class=\"description\">{{ helper.availablePayText.value }}</div>\n            } @else if (request.payments.value[request.activeLs.value] && enablePayment.status) {\n                <div class=\"description\"><div class=\"skeleton-text\" style=\"width: 130px; height: 19px; margin: 0\"></div></div>\n            }\n\n            @if (\n                    enablePayment.status &&\n                    request.payments.value[request.activeLs.value] &&\n                    request.payments.value[request.activeLs.value].type_pay === 1\n                ) {\n                <div class=\"ls-number\">{{ 'PAYMENT.LS' | translate:{value: request.activeLs.value | guardLsNumber} }}</div>\n            }\n\n            <ion-card class=\"el-anim-tap\" (click)=\"openPayHistory()\">\n                <ion-card-header>\n                    <ion-card-title>\n                        {{ 'PAYMENT.HISTORY' | translate }} <ion-icon name=\"chevron-forward-outline\"></ion-icon>\n                    </ion-card-title>\n                </ion-card-header>\n            </ion-card>\n\n            <div class=\"disabled-payment\" [hidden]=\"enablePayment.status\">\n                <div class=\"icon\">\n                    <ion-icon class=\"icon-img\" src=\"/assets/imgs/Slider1.svg\"></ion-icon>\n                </div>\n                <div class=\"header\">{{ enablePayment.title }}</div>\n                <div class=\"text\" [innerHTML]=\"enablePayment.message\"></div>\n                <ion-button\n                        class=\"el-anim-tap\"\n                        type=\"button\"\n                        expand=\"block\"\n                        fill=\"solid\"\n                        (click)=\"goToMainPage()\"\n                >\n                    {{ 'PAYMENT.BACK_TO_MAIN' | translate }}\n                </ion-button>\n            </div>\n\n            <div class=\"paymentEnabled\" [hidden]=\"!enablePayment.status\">\n                @if (\n                        request.payments.value[request.activeLs.value] &&\n                        ((request.payments.value[request.activeLs.value].type_pay === 1 && object().keys(request.payments.value[request.activeLs.value]).length <= 0) ||\n                        (request.payments.value[request.activeLs.value].type_pay === 3 && object().keys(request.payments.value[request.activeLs.value].kvts).length <= 0) ||\n                        (request.payments.value[request.activeLs.value].type_pay === 4 && object().keys(request.payments.value[request.activeLs.value].pays).length <= 0))\n                    )\n                {\n                    <ion-card>\n                        <div class=\"reading-card-header\">\n                            <ion-card-header>\n                                <ion-card-title>{{ 'PAYMENT.NO_PAY' | translate }}</ion-card-title>\n                            </ion-card-header>\n                        </div>\n                    </ion-card>\n                }\n\n                @if (request.payments.value[request.activeLs.value]) {\n                    <div class=\"paymentLoad\">\n                        @if (request.payments.value[request.activeLs.value].type_pay === 1) {\n                        <!-- Первый тип оплаты -->\n                            <div class=\"paymentType1\">\n                                <ion-card class=\"ion-card-type1\">\n                                    <div class=\"header\">\n                                        <div class=\"name\">{{ 'PAYMENT.AMOUNT' | translate }}</div>\n                                        <div class=\"sum\">{{ helper.paySumFormate(request.payments.value[request.activeLs.value].summ) }}</div>\n                                    </div>\n\n                                    <div>\n                                        <div class=\"list\">\n                                            <div class=\"name\">{{ 'PAYMENT.PENALTIES' | translate }}</div>\n                                            <div class=\"sum\">{{ helper.paySumFormate(request.payments.value[request.activeLs.value].peni) }}</div>\n                                        </div>\n                                        <!--              <div class=\"list\">-->\n                                        <!--                <div class=\"name\">{{ 'PAYMENT.COMMISSIONS' | translate }}-->\n                                        <!--                  <span *ngIf=\"request.payments.value[request.activeLs.value].gateway[selectGateway]\">-->\n                                        <!--                    {{ request.payments.value[request.activeLs.value].gateway[selectGateway].commission.toString().split('.').join(',') }}%-->\n                                        <!--                  </span>-->\n                                        <!--                </div>-->\n                                        <!--                <div class=\"sum\">{{ helper.paySumFormate(commissionSum) }}</div>-->\n                                        <!--              </div>-->\n                                        <hr />\n                                        <div class=\"total\">\n                                            <div class=\"name\">{{ 'PAYMENT.TOTAL' | translate }}</div>\n                                            <div class=\"sum\">{{ helper.paySumFormate(totalAmount) }}</div>\n                                        </div>\n                                    </div>\n                                </ion-card>\n                            </div>\n                        } @else if (request.payments.value[request.activeLs.value].type_pay === 3) {\n                            <!-- Третий тип оплаты -->\n                            <div >\n                                @for (payment of object().values(request.payments.value[request.activeLs.value].kvts); let i = $index; track payment) {\n                                    <ion-card class=\"el-anim-tap\" (click)=\"openPayReceiptPage(i)\">\n                                        <div class=\"reading-card-header\">\n                                            <ion-card-header>\n                                                <ion-card-title>\n                                                    {{payment.isp_name}}\n                                                    @if (payment.summ + payment.peni <= 0) {\n                                                        <ion-icon src=\"/assets/icons/Check_Circle_Filled.svg\"/>\n                                                    }\n                                                </ion-card-title>\n                                                <ion-card-subtitle>{{ helper.paySumFormate(payment.summ + payment.peni) }}</ion-card-subtitle>\n                                            </ion-card-header>\n                                        </div>\n                                    </ion-card>\n                                }\n                            </div>\n                        } @else if (request.payments.value[request.activeLs.value].type_pay === 4) {\n                            <!-- Четвертый тип оплаты -->\n                            <div>\n                                <ion-card>\n                                    <div class=\"toggle-block\" (click)=\"changeLivePays(!livePay)\">\n                                        <ion-item>\n                                            <div class=\"custom-card-content\">\n                                                <div class=\"custom-card-content-item\">\n                                                    <div class=\"custom-card-content-item-title\">\n                                                        {{ 'PAYMENT.LIVE_PAY' | translate }}\n                                                    </div>\n                                                    <ion-toggle color=\"success\" [ngModel]=\"livePay\"></ion-toggle>\n                                                </div>\n                                            </div>\n                                        </ion-item>\n                                    </div>\n                                </ion-card>\n\n                                @for (payment of object().values(request.payments.value[request.activeLs.value]![request.nachislenieZaTekMesiac.value[request.activeLs.value]]); let i = $index; track payment) {\n                                    <ion-card class=\"el-anim-tap\" (click)=\"openPayReceiptPage(i)\">\n                                        <div class=\"reading-card-header\">\n                                            <ion-card-header>\n                                                <ion-card-title>\n                                                    {{payment.isp_name}}\n                                                    @if (payment.summ + payment.peni <= 0) {\n                                                        <ion-icon src=\"/assets/icons/Check_Circle_Filled.svg\"/>\n                                                    }\n                                                </ion-card-title>\n                                                <ion-card-subtitle>{{ helper.paySumFormate(payment.summ + payment.peni) }}</ion-card-subtitle>\n                                            </ion-card-header>\n                                        </div>\n                                    </ion-card>\n                                }\n                            </div>\n                        }\n                    </div>\n                }\n            </div>\n\n        </div>\n    }\n\n\n    @if (\n            helper.availablePayment.value &&\n            enablePayment.status &&\n            request.payments.value[request.activeLs.value] &&\n            request.payments.value[request.activeLs.value].type_pay === 1\n        )\n    {\n        <div class=\"payBtn action-btn\" slot=\"fixed\">\n            <ion-button class=\"payment\" type=\"button\" expand=\"block\" fill=\"solid\" (click)=\"openPayModal()\">{{ 'PAYMENT.BUTTON' | translate }}</ion-button>\n        </div>\n    }\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_tabs_payment_payment_module_ts.js.map